/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.internal;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.login.LoginException;
import javax.security.jacc.EJBMethodPermission;
import javax.security.jacc.EJBRoleRefPermission;
import javax.security.jacc.PolicyConfiguration;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.SecurityRole;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.ejb.container.EJBDebugService;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.compliance.EJBComplianceTextFormatter;
import weblogic.ejb.container.interfaces.DeploymentInfo;
import weblogic.ejb.container.interfaces.MethodInfo;
import weblogic.ejb.container.interfaces.NoSuchRoleException;
import weblogic.ejb.container.interfaces.SecurityRoleMapping;
import weblogic.ejb.container.internal.CallerSubjectStack;
import weblogic.ejb.container.internal.MethodDescriptor;
import weblogic.ejb.container.internal.SecurityHelperJACC;
import weblogic.ejb.container.internal.SecurityHelperWLS;
import weblogic.ejb.spi.WLDeploymentException;
import weblogic.ejb20.interfaces.PrincipalNotFoundException;
import weblogic.logging.Loggable;
import weblogic.security.SubjectUtils;
import weblogic.security.WLSPrincipals;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.jacc.RoleMapper;
import weblogic.security.service.ContextHandler;
import weblogic.security.service.EJBResource;
import weblogic.security.service.PrincipalAuthenticator;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityApplicationInfo;
import weblogic.security.service.SecurityService;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.service.SupplementalPolicyObject;
import weblogic.utils.AssertionError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SecurityHelper {
    private static final DebugLogger debugLogger = EJBDebugService.securityLogger;
    static final int SYSTEM_REALM = 0;
    static final int APP_REALM = 1;
    private static final AuthenticatedSubject subject = SecurityHelper.obtainSubject();
    private boolean jaccEnabled = false;
    private SecurityHelperWLS wlsHelper;
    private SecurityHelperJACC jaccHelper;
    private String sysRealmName;
    private String appRealmName;
    private PrincipalAuthenticator appPrincipalAuth;
    private PrincipalAuthenticator sysPrincipalAuth;
    private Map<String, List<MethodDescriptor>> checkedMethodDescriptors = new HashMap<String, List<MethodDescriptor>>();
    private Map<String, List<MethodDescriptor>> uncheckedMethodDescriptors = new HashMap<String, List<MethodDescriptor>>();
    private Map<String, List<MethodDescriptor>> excludedMethodDescriptors = new HashMap<String, List<MethodDescriptor>>();

    public SecurityHelper(String string, PolicyConfiguration policyConfiguration, String string2, String string3, RoleMapper roleMapper) throws WLDeploymentException {
        this.appRealmName = string;
        if (string2 != null) {
            this.jaccHelper = new SecurityHelperJACC(policyConfiguration, string2, string3, roleMapper);
            this.jaccEnabled = true;
        } else {
            this.sysRealmName = SecurityHelper.getSysRealmName();
            this.wlsHelper = new SecurityHelperWLS(string, this.sysRealmName);
            this.jaccEnabled = false;
        }
    }

    void setupApplicationInfo(ApplicationContextInternal applicationContextInternal, DeploymentInfo deploymentInfo, SecurityApplicationInfo securityApplicationInfo) {
        if (this.jaccEnabled) {
            this.jaccHelper.setupApplicationInfo(applicationContextInternal, deploymentInfo);
        } else {
            this.wlsHelper.setupApplicationInfo(applicationContextInternal, deploymentInfo, securityApplicationInfo);
        }
    }

    protected AuthenticatedSubject getSubject() {
        return subject;
    }

    public AuthenticatedSubject getSubjectForPrincipal(String string) throws PrincipalNotFoundException {
        return this.getSubjectForPrincipal(string, 1);
    }

    AuthenticatedSubject getSubjectForPrincipal(String string, int n) throws PrincipalNotFoundException {
        PrincipalAuthenticator principalAuthenticator = this.obtainPA(n);
        try {
            AuthenticatedSubject authenticatedSubject = principalAuthenticator.impersonateIdentity(string, null);
            if (debugLogger.isDebugEnabled()) {
                SecurityHelper.debug(" getSubjectForPrincipal: for Principal: '" + string + "', Subject is: '" + authenticatedSubject.toString() + "'");
            }
            return authenticatedSubject;
        }
        catch (LoginException loginException) {
            throw new PrincipalNotFoundException(loginException.getMessage());
        }
    }

    void deployRoles(DeploymentInfo deploymentInfo, SecurityRoleMapping securityRoleMapping, ApplicationContextInternal applicationContextInternal, int n) throws Exception {
        this.deployRoles(deploymentInfo, securityRoleMapping, applicationContextInternal, n, 1);
    }

    void deployRoles(DeploymentInfo deploymentInfo, SecurityRoleMapping securityRoleMapping, ApplicationContextInternal applicationContextInternal, int n, int n2) throws Exception {
        if (this.jaccEnabled) {
            this.jaccHelper.deployRoles(deploymentInfo, securityRoleMapping);
        } else {
            Map map = this.getDeployableSecurityRoleMapping(securityRoleMapping, applicationContextInternal, n);
            this.wlsHelper.deployRoles(deploymentInfo, map, n2);
        }
    }

    void unDeployRoles(DeploymentInfo deploymentInfo, SecurityRoleMapping securityRoleMapping) {
        this.unDeployRoles(deploymentInfo, securityRoleMapping, 1);
    }

    void unDeployRoles(DeploymentInfo deploymentInfo, SecurityRoleMapping securityRoleMapping, int n) {
        if (this.jaccEnabled) {
            this.jaccHelper.unDeployRoles();
        } else {
            this.wlsHelper.unDeployRoles(deploymentInfo, securityRoleMapping, n);
        }
    }

    void registerRoleRefs(String string, Map map) throws WLDeploymentException {
        if (this.jaccEnabled) {
            this.jaccHelper.registerRoleRefs(string, map);
        }
    }

    void deployAllPolicies() throws Exception {
        this.deployAllPolicies(1);
    }

    void deployAllPolicies(int n) throws Exception {
        if (!this.jaccEnabled) {
            this.wlsHelper.beginPolicyRegistration();
        }
        Set<String> set = this.getEjbNames();
        for (String string : set) {
            List<MethodDescriptor> list;
            List<MethodDescriptor> list2;
            List<MethodDescriptor> list3;
            if (debugLogger.isDebugEnabled()) {
                SecurityHelper.debug("registering policies for EJB: " + string);
            }
            if ((list3 = this.getCheckedMethodDescriptors(string)) != null && debugLogger.isDebugEnabled()) {
                SecurityHelper.debug("registering policies for all " + list3.size() + " checked methods");
            }
            if ((list2 = this.getUncheckedMethodDescriptors(string)) != null && debugLogger.isDebugEnabled()) {
                SecurityHelper.debug("registering policies for all " + list2.size() + " unchecked methods");
            }
            if ((list = this.getExcludedMethodDescriptors(string)) != null && debugLogger.isDebugEnabled()) {
                SecurityHelper.debug("registering policies for all " + list.size() + " excluded methods");
            }
            this.deployPolicies(list3, list2, list, n);
        }
        if (!this.jaccEnabled) {
            this.wlsHelper.endPolicyRegistration();
        }
    }

    private void deployPolicies(List<MethodDescriptor> list, List<MethodDescriptor> list2, List<MethodDescriptor> list3, int n) throws Exception {
        if (this.jaccEnabled) {
            this.jaccHelper.deployPolicies(list, list2, list3, this);
        } else {
            this.wlsHelper.deployPolicies(list, list2, list3, this, n);
        }
    }

    void unDeployAllPolicies() {
        if (!this.jaccEnabled) {
            this.wlsHelper.unDeployAllPolicies();
        }
    }

    public boolean processUncheckedExcludedMethod(MethodDescriptor methodDescriptor) throws WLDeploymentException {
        MethodInfo methodInfo = methodDescriptor.getMethodInfo();
        if (methodInfo.getUnchecked()) {
            this.addUncheckedMethod(methodDescriptor);
            SecurityHelper.createEJBResource(methodDescriptor);
            if (this.jaccEnabled) {
                this.jaccHelper.processUncheckedExcludedMethod(methodDescriptor);
            }
            return true;
        }
        if (methodInfo.getIsExcluded()) {
            this.addExcludedMethod(methodDescriptor);
            SecurityHelper.createEJBResource(methodDescriptor);
            if (this.jaccEnabled) {
                this.jaccHelper.processUncheckedExcludedMethod(methodDescriptor);
            }
            return true;
        }
        this.addCheckedMethod(methodDescriptor);
        return false;
    }

    void activate() {
        if (this.jaccEnabled) {
            this.jaccHelper.activate();
        }
    }

    void deactivate() {
        if (this.jaccEnabled) {
            this.jaccHelper.deactivate();
        } else {
            this.wlsHelper.unDeployAllPolicies();
        }
    }

    boolean fullyDelegateSecurityCheck() {
        return this.fullyDelegateSecurityCheck(this.appRealmName);
    }

    boolean fullyDelegateSecurityCheck(String string) {
        if (this.jaccEnabled) {
            return true;
        }
        return this.wlsHelper.fullyDelegateSecurityCheck(string);
    }

    public void setContext(ContextHandler contextHandler) {
        if (this.jaccEnabled) {
            this.jaccHelper.setContext(contextHandler);
        }
    }

    public void resetContext() {
        if (this.jaccEnabled) {
            this.jaccHelper.resetContext();
        }
    }

    boolean isAccessAllowed(EJBResource eJBResource, EJBMethodPermission eJBMethodPermission, ContextHandler contextHandler) {
        return this.isAccessAllowed(eJBResource, eJBMethodPermission, contextHandler, 1);
    }

    boolean isAccessAllowed(EJBResource eJBResource, EJBMethodPermission eJBMethodPermission, ContextHandler contextHandler, int n) {
        if (this.jaccEnabled) {
            return this.jaccHelper.isAccessAllowed(eJBMethodPermission, contextHandler);
        }
        return this.wlsHelper.isAccessAllowed(eJBResource, contextHandler, n);
    }

    boolean isCallerInRole(String string, EJBResource eJBResource, String string2, String string3) {
        return this.isCallerInRole(eJBResource, string, string2, string3, 1);
    }

    boolean isCallerInRole(EJBResource eJBResource, String string, String string2, String string3, int n) {
        AuthenticatedSubject authenticatedSubject = SecurityHelper.getCallerSubject();
        if (authenticatedSubject == null) {
            if (debugLogger.isDebugEnabled()) {
                SecurityHelper.debug(" isCallerInRole: Caller subject is null. isCallerInRole returns false");
            }
            return false;
        }
        if (this.jaccEnabled) {
            return this.jaccHelper.isCallerInRole(string, authenticatedSubject, string2);
        }
        return this.wlsHelper.isCallerInRole(eJBResource, authenticatedSubject, string3, n);
    }

    private void addCheckedMethod(MethodDescriptor methodDescriptor) {
        List<MethodDescriptor> list = this.checkedMethodDescriptors.get(methodDescriptor.getEjbName());
        if (list == null) {
            list = new ArrayList<MethodDescriptor>();
            this.checkedMethodDescriptors.put(methodDescriptor.getEjbName(), list);
        }
        list.add(methodDescriptor);
    }

    private void addUncheckedMethod(MethodDescriptor methodDescriptor) {
        List<MethodDescriptor> list = this.uncheckedMethodDescriptors.get(methodDescriptor.getEjbName());
        if (list == null) {
            list = new ArrayList<MethodDescriptor>();
            this.uncheckedMethodDescriptors.put(methodDescriptor.getEjbName(), list);
        }
        list.add(methodDescriptor);
    }

    private void addExcludedMethod(MethodDescriptor methodDescriptor) {
        List<MethodDescriptor> list = this.excludedMethodDescriptors.get(methodDescriptor.getEjbName());
        if (list == null) {
            list = new ArrayList<MethodDescriptor>();
            this.excludedMethodDescriptors.put(methodDescriptor.getEjbName(), list);
        }
        list.add(methodDescriptor);
    }

    private Set<String> getEjbNames() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(this.checkedMethodDescriptors.keySet());
        hashSet.addAll(this.uncheckedMethodDescriptors.keySet());
        hashSet.addAll(this.excludedMethodDescriptors.keySet());
        return hashSet;
    }

    private List<MethodDescriptor> getCheckedMethodDescriptors(String string) {
        return this.checkedMethodDescriptors.get(string);
    }

    private List<MethodDescriptor> getUncheckedMethodDescriptors(String string) {
        return this.uncheckedMethodDescriptors.get(string);
    }

    private List<MethodDescriptor> getExcludedMethodDescriptors(String string) {
        return this.excludedMethodDescriptors.get(string);
    }

    private PrincipalAuthenticator obtainPA(int n) {
        switch (n) {
            case 1: {
                if (this.appPrincipalAuth != null) {
                    return this.appPrincipalAuth;
                }
                this.appPrincipalAuth = (PrincipalAuthenticator)SecurityServiceManager.getSecurityService((AuthenticatedSubject)subject, (String)this.appRealmName, (SecurityService.ServiceType)SecurityService.ServiceType.AUTHENTICATION);
                return this.appPrincipalAuth;
            }
            case 0: {
                if (this.sysPrincipalAuth != null) {
                    return this.sysPrincipalAuth;
                }
                this.sysPrincipalAuth = (PrincipalAuthenticator)SecurityServiceManager.getSecurityService((AuthenticatedSubject)subject, (String)this.sysRealmName, (SecurityService.ServiceType)SecurityService.ServiceType.AUTHENTICATION);
                return this.sysPrincipalAuth;
            }
        }
        throw new AssertionError("  weblogic.ejb.internal.SecurityHelper.obtainPA, unknown realm type: " + n);
    }

    public static AuthenticatedSubject getAnonymousUser() {
        return SubjectUtils.getAnonymousSubject();
    }

    static Principal getAnonymousUserPrincipal() {
        return WLSPrincipals.getAnonymousUserPrincipal();
    }

    static Principal getPrincipalFromSubject(AuthenticatedSubject authenticatedSubject) {
        if (authenticatedSubject == null) {
            return SecurityHelper.getAnonymousUserPrincipal();
        }
        Principal principal = SubjectUtils.getUserPrincipal((AuthenticatedSubject)authenticatedSubject);
        if (principal != null) {
            return principal;
        }
        return SecurityHelper.getAnonymousUserPrincipal();
    }

    static Principal getCurrentPrincipal() {
        AuthenticatedSubject authenticatedSubject = SecurityHelper.getCurrentSubject();
        return SecurityHelper.getPrincipalFromSubject(authenticatedSubject);
    }

    static AuthenticatedSubject getCurrentSubject() {
        return SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)subject);
    }

    public static void pushRunAsSubject(AuthenticatedSubject authenticatedSubject) {
        if (debugLogger.isDebugEnabled()) {
            SecurityHelper.debug("pushRunAsSubject to push: '" + authenticatedSubject.toString() + "', currentSubject is: '" + SecurityHelper.getCurrentSubject() + "' ");
        }
        SecurityServiceManager.pushSubject((AuthenticatedSubject)subject, (AuthenticatedSubject)authenticatedSubject);
    }

    public static void popRunAsSubject() {
        if (debugLogger.isDebugEnabled()) {
            SecurityHelper.debug("\n popRunAsSubject,  subject before pop is: '" + SecurityHelper.getCurrentSubject() + "'");
        }
        SecurityServiceManager.popSubject((AuthenticatedSubject)subject);
        if (debugLogger.isDebugEnabled()) {
            SecurityHelper.debug("\n popRunAsSubject,  subject after  pop is: '" + SecurityHelper.getCurrentSubject() + "'");
        }
    }

    static boolean pushSpecificRunAsMaybe(AuthenticatedSubject authenticatedSubject, AuthenticatedSubject authenticatedSubject2) {
        if (authenticatedSubject != null) {
            SecurityHelper.pushRunAsSubject(authenticatedSubject);
            return true;
        }
        if (authenticatedSubject2 != null) {
            SecurityHelper.pushRunAsSubject(authenticatedSubject2);
            return true;
        }
        if (SecurityServiceManager.isKernelIdentity((AuthenticatedSubject)SecurityHelper.getCurrentSubject())) {
            SecurityHelper.pushRunAsSubject(SecurityHelper.getAnonymousUser());
            return true;
        }
        return false;
    }

    static Principal getCallerPrincipal() throws PrincipalNotFoundException {
        AuthenticatedSubject authenticatedSubject = SecurityHelper.getCallerSubject();
        Principal principal = SecurityHelper.getPrincipalFromSubject(authenticatedSubject);
        if (principal == null) {
            String string = "getCallerPrincipal";
            Loggable loggable = EJBLogger.logmissingCallerPrincipalLoggable((String)string);
            throw new PrincipalNotFoundException(loggable.getMessage());
        }
        return principal;
    }

    static AuthenticatedSubject getCallerSubject() {
        AuthenticatedSubject authenticatedSubject = CallerSubjectStack.getCurrentSubject();
        return authenticatedSubject;
    }

    public static void pushCallerPrincipal() {
        AuthenticatedSubject authenticatedSubject = SecurityHelper.getCurrentSubject();
        if (debugLogger.isDebugEnabled()) {
            SecurityHelper.debug("\n pushCallerPrincipal to push Subject: '" + authenticatedSubject + "' " + " from which we get principal '" + SecurityHelper.getPrincipalFromSubject(authenticatedSubject) + "'");
        }
        CallerSubjectStack.pushSubject(authenticatedSubject);
    }

    public static void popCallerPrincipal() throws PrincipalNotFoundException {
        AuthenticatedSubject authenticatedSubject;
        if (debugLogger.isDebugEnabled()) {
            SecurityHelper.debug("\n popCallerPrincipal, CallerSubject before pop is: '" + SecurityHelper.getCallerSubject() + "'");
        }
        if ((authenticatedSubject = CallerSubjectStack.popSubject()) == null) {
            String string = "popCallerPrincipal";
            Loggable loggable = EJBLogger.logmissingCallerPrincipalLoggable((String)string);
            throw new PrincipalNotFoundException(loggable.getMessage());
        }
    }

    static String getDefaultRealmName() {
        return "weblogicDEFAULT";
    }

    static String getSysRealmName() {
        String string = SecurityServiceManager.getDefaultRealmName();
        if (string == null) {
            throw new RuntimeException(" Could not get System Realm Name. ");
        }
        return string;
    }

    static void registerSupplementalPolicyObject(String[] stringArray, String string) {
        SupplementalPolicyObject.setPoliciesFromGrantStatement((AuthenticatedSubject)subject, (String[])stringArray, (String)string, (String)"EJB");
    }

    static void removeSupplementalPolicyObject(String[] stringArray) {
        SupplementalPolicyObject.removePolicies((AuthenticatedSubject)subject, (String[])stringArray);
    }

    static EJBResource createEJBResource(DeploymentInfo deploymentInfo) {
        return new EJBResource(deploymentInfo.getApplicationName(), deploymentInfo.getEJBComponentName(), null, null, null, null);
    }

    static EJBResource createEJBResource(String string, String string2, String string3) {
        if (debugLogger.isDebugEnabled()) {
            SecurityHelper.debug("\n\n ++++++++++  creating EJBResource: appName: '" + string + "' moduleName: '" + string2 + "' ejbName: '" + string3 + "' methodName: 'null" + "' interfaceType: 'null" + "' methodParams:     'null");
        }
        return new EJBResource(string, string2, string3, null, null, null);
    }

    static EJBResource createEJBResource(MethodDescriptor methodDescriptor) {
        String string = methodDescriptor.getApplicationName();
        String string2 = methodDescriptor.getEjbComponentName();
        String string3 = methodDescriptor.getEjbName();
        MethodInfo methodInfo = methodDescriptor.getMethodInfo();
        String[] stringArray = SecurityHelper.getCanonicalMethodParamNames(methodDescriptor.getMethod());
        if (debugLogger.isDebugEnabled()) {
            StringBuilder stringBuilder = new StringBuilder();
            if (stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuilder.append(stringArray[i]).append(", ");
                }
            } else {
                stringBuilder.append(" NONE ");
            }
            SecurityHelper.debug("\n\n ++++++++++  creating EJBResource: appName: '" + string + "' moduleName: '" + string2 + "' ejbName: '" + string3 + "' methodName: '" + methodInfo.getMethodName() + "' interfaceType: '" + methodInfo.getMethodInterfaceType() + "' methodParams:     '" + stringBuilder.toString() + "'");
        }
        return new EJBResource(string, string2, string3, methodInfo.getMethodName(), methodInfo.getMethodInterfaceType(), stringArray);
    }

    private static String[] getCanonicalMethodParamNames(Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        String[] stringArray = new String[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            stringArray[i] = classArray[i].getCanonicalName();
        }
        return stringArray;
    }

    static EJBMethodPermission createEJBMethodPermission(MethodDescriptor methodDescriptor) {
        short s;
        String string = methodDescriptor.getEjbName();
        MethodInfo methodInfo = methodDescriptor.getMethodInfo();
        String[] stringArray = SecurityHelper.getCanonicalMethodParamNames(methodDescriptor.getMethod());
        if (debugLogger.isDebugEnabled()) {
            StringBuilder stringBuilder = new StringBuilder();
            if (stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuilder.append(stringArray[i]).append(", ");
                }
            } else {
                stringBuilder.append("");
            }
            SecurityHelper.debug("\n\n ++++++++++  creating EJBMethodPermission: ejbName: '" + string + "' methodName: '" + methodInfo.getMethodName() + "' interfaceType: '" + methodInfo.getMethodInterfaceType() + "' methodParams: '" + stringBuilder.toString() + "'");
        }
        if ((s = methodInfo.getMethodDescriptorMethodType()) == 1) {
            return new EJBMethodPermission(string, "");
        }
        StringBuilder stringBuilder = new StringBuilder(methodInfo.getMethodName());
        stringBuilder.append(",");
        stringBuilder.append(methodInfo.getMethodInterfaceType());
        if (s == 2) {
            return new EJBMethodPermission(string, stringBuilder.toString());
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (i == 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(stringArray[i]);
        }
        return new EJBMethodPermission(string, stringBuilder.toString());
    }

    static EJBRoleRefPermission createEJBRoleRefPermission(String string, String string2) {
        return new EJBRoleRefPermission(string, string2);
    }

    private static AuthenticatedSubject obtainSubject() {
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        return authenticatedSubject;
    }

    public Map getDeployableSecurityRoleMapping(SecurityRoleMapping securityRoleMapping, ApplicationContextInternal applicationContextInternal, int n) throws WLDeploymentException {
        try {
            switch (n) {
                case 0: {
                    if (debugLogger.isDebugEnabled()) {
                        SecurityHelper.debug("deployable role map calculated for Compatibility mode");
                    }
                    return this.getCompatibilitySecurityRoleMapping(securityRoleMapping);
                }
                case 1: {
                    if (debugLogger.isDebugEnabled()) {
                        SecurityHelper.debug("deployable role map calculated for Application mode");
                    }
                    return this.getApplicationSecurityRoleMapping(securityRoleMapping, applicationContextInternal, n);
                }
                case 2: {
                    if (debugLogger.isDebugEnabled()) {
                        SecurityHelper.debug("deployable role map calculated for Externally Defined mode");
                    }
                    return this.getApplicationSecurityRoleMapping(securityRoleMapping, applicationContextInternal, n);
                }
            }
            throw new AssertionError("Unexpected role mapping behavior: " + n);
        }
        catch (NoSuchRoleException noSuchRoleException) {
            throw new AssertionError("Unexpected exception: ", (Throwable)((Object)noSuchRoleException));
        }
    }

    private Map getCompatibilitySecurityRoleMapping(SecurityRoleMapping securityRoleMapping) throws NoSuchRoleException, WLDeploymentException {
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        Collection collection = securityRoleMapping.getSecurityRoleNames();
        for (String string : collection) {
            Object object;
            if (securityRoleMapping.isExternallyDefinedRole(string)) {
                if (!debugLogger.isDebugEnabled()) continue;
                SecurityHelper.debug("role '" + string + "' is externally defined; skipping deployment");
                continue;
            }
            if (!securityRoleMapping.isRoleMappedToPrincipals(string)) {
                object = new EJBComplianceTextFormatter();
                throw new WLDeploymentException(object.ROLE_NOT_MAPPED_TO_PRINCIPALS(string));
            }
            object = securityRoleMapping.getSecurityRolePrincipalNames(string);
            String[] stringArray = object.toArray(new String[0]);
            hashMap.put(string, stringArray);
        }
        return hashMap;
    }

    private Map getApplicationSecurityRoleMapping(SecurityRoleMapping securityRoleMapping, ApplicationContextInternal applicationContextInternal, int n) throws NoSuchRoleException {
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        Collection collection = securityRoleMapping.getSecurityRoleNames();
        for (String string : collection) {
            String[] stringArray;
            HashSet<String> hashSet;
            if (securityRoleMapping.isExternallyDefinedRole(string)) {
                if (!debugLogger.isDebugEnabled()) continue;
                SecurityHelper.debug("role '" + string + "' is externally defined at module level;" + " skipping deployment");
                continue;
            }
            SecurityRole securityRole = applicationContextInternal.getSecurityRole(string);
            if (!securityRoleMapping.isRoleMappedToPrincipals(string)) {
                if (securityRole != null && securityRole.isExternallyDefined()) {
                    if (!debugLogger.isDebugEnabled()) continue;
                    SecurityHelper.debug("role '" + string + "' is externally defined at app level " + "and no module principals defined; skipping deployment");
                    continue;
                }
                if (securityRole == null || securityRole.getPrincipalNames() == null || securityRole.getPrincipalNames().length == 0) {
                    if (n == 1) {
                        hashMap.put(string, new String[0]);
                        continue;
                    }
                    if (!debugLogger.isDebugEnabled()) continue;
                    SecurityHelper.debug("role '" + string + "' has no principals defined at app level " + "or module level; skipping deployment");
                    continue;
                }
                hashMap.put(string, securityRole.getPrincipalNames());
                continue;
            }
            if (securityRole != null && securityRole.isExternallyDefined()) {
                hashSet = securityRoleMapping.getSecurityRolePrincipalNames(string);
                stringArray = hashSet.toArray(new String[0]);
                hashMap.put(string, stringArray);
            }
            if (securityRole == null || securityRole.getPrincipalNames() == null || securityRole.getPrincipalNames().length == 0) {
                hashSet = securityRoleMapping.getSecurityRolePrincipalNames(string);
                stringArray = hashSet.toArray(new String[0]);
                hashMap.put(string, stringArray);
                continue;
            }
            hashSet = new HashSet<String>();
            hashSet.addAll(securityRoleMapping.getSecurityRolePrincipalNames(string));
            hashSet.addAll(Arrays.asList(securityRole.getPrincipalNames()));
            stringArray = hashSet.toArray(new String[0]);
            hashMap.put(string, stringArray);
        }
        return hashMap;
    }

    private static void debug(String string) {
        debugLogger.debug("[SecurityHelper] " + string);
    }
}

