/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.internal;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.jacc.EJBMethodPermission;
import javax.security.jacc.EJBRoleRefPermission;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.PolicyContextHandler;
import weblogic.application.ApplicationContext;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.ejb.container.EJBDebugService;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.interfaces.DeploymentInfo;
import weblogic.ejb.container.interfaces.MethodInfo;
import weblogic.ejb.container.interfaces.NoSuchRoleException;
import weblogic.ejb.container.interfaces.SecurityRoleMapping;
import weblogic.ejb.container.interfaces.SecurityRoleReference;
import weblogic.ejb.container.internal.EJBContextHandler;
import weblogic.ejb.container.internal.MethodDescriptor;
import weblogic.ejb.container.internal.SecurityHelper;
import weblogic.ejb.spi.WLDeploymentException;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.jacc.CommonPolicyContextHandler;
import weblogic.security.jacc.DelegatingPolicyContextHandler;
import weblogic.security.jacc.RoleMapper;
import weblogic.security.service.ContextHandler;
import weblogic.utils.AssertionError;
import weblogic.utils.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SecurityHelperJACC {
    private static final String DONT_REGISTER_UNCOVERED_METHODS = "weblogic.ejb.container.internal.SecurityHelperJACC.dont_register_uncovered_methods";
    private static final boolean dont_register_uncovered_methods = System.getProperty("weblogic.ejb.container.internal.SecurityHelperJACC.dont_register_uncovered_methods") != null;
    private static final DebugLogger debugLogger = EJBDebugService.securityLogger;
    private String jaccPolicyContextId;
    private String jaccCodeSourceLocation;
    private CodeSource jaccCodeSource;
    private PolicyConfiguration jaccPolicyConfig;
    private RoleMapper jaccRoleMapper;

    SecurityHelperJACC(PolicyConfiguration policyConfiguration, String string, String string2, RoleMapper roleMapper) throws WLDeploymentException {
        this.jaccPolicyConfig = policyConfiguration;
        this.jaccPolicyContextId = string;
        this.jaccCodeSourceLocation = string2;
        this.jaccRoleMapper = roleMapper;
        try {
            URI uRI = new URI("file:///" + string2.replace('\\', '/'));
            URL uRL = new URL(uRI.toString());
            this.jaccCodeSource = new CodeSource(uRL, (Certificate[])null);
        }
        catch (MalformedURLException malformedURLException) {
            throw new WLDeploymentException(malformedURLException.getMessage(), malformedURLException);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new WLDeploymentException(uRISyntaxException.getMessage(), uRISyntaxException);
        }
    }

    void deployRoles(DeploymentInfo deploymentInfo, SecurityRoleMapping securityRoleMapping) {
        String string = deploymentInfo.getApplicationName();
        String string2 = deploymentInfo.getEJBComponentName();
        Collection collection = securityRoleMapping.getSecurityRoleNames();
        if (debugLogger.isDebugEnabled()) {
            SecurityHelperJACC.debug("deployRoles(...), appName: '" + string + "', ejbComponentName: '" + string2 + "'  there are: '" + collection.size() + "' roles in this jar.");
        }
        if (collection.isEmpty()) {
            return;
        }
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        for (String string3 : collection) {
            try {
                if (securityRoleMapping.isExternallyDefinedRole(string3)) {
                    if (!debugLogger.isDebugEnabled()) continue;
                    SecurityHelperJACC.debug("skipping deployment of role: " + string3 + " because it's externally defined");
                    continue;
                }
                if (!securityRoleMapping.isRoleMappedToPrincipals(string3)) {
                    if (!debugLogger.isDebugEnabled()) continue;
                    SecurityHelperJACC.debug("skipping deployment of role: " + string3 + " because it's not mapped to any principals");
                    continue;
                }
                Collection collection2 = securityRoleMapping.getSecurityRolePrincipalNames(string3);
                String[] stringArray = collection2.toArray(new String[0]);
                if (debugLogger.isDebugEnabled()) {
                    SecurityHelperJACC.debug("deploying role: " + string3 + " with principals: " + StringUtils.join((String[])stringArray, (String)", "));
                }
                hashMap.put(string3, stringArray);
            }
            catch (NoSuchRoleException noSuchRoleException) {
                throw new AssertionError("Unexpected exception: ", (Throwable)((Object)noSuchRoleException));
            }
        }
        if (!hashMap.isEmpty()) {
            this.jaccRoleMapper.addAppRolesToPrincipalMap(hashMap);
            if (debugLogger.isDebugEnabled()) {
                SecurityHelperJACC.debug("Role mapping to add to the RoleMapper for appName: '" + string + "', ejbComponentName: '" + string2 + "'");
            }
        } else if (debugLogger.isDebugEnabled()) {
            SecurityHelperJACC.debug("No Role mapping to add to the RoleMapper for appName: '" + string + "', ejbComponentName: '" + string2 + "'");
        }
    }

    void setupApplicationInfo(ApplicationContext applicationContext, DeploymentInfo deploymentInfo) {
        applicationContext.addJACCPolicyConfiguration(this.jaccPolicyConfig);
    }

    void unDeployRoles() {
    }

    void deployPolicies(List<MethodDescriptor> list, List<MethodDescriptor> list2, List<MethodDescriptor> list3, SecurityHelper securityHelper) throws Exception {
        if (list != null) {
            for (MethodDescriptor methodDescriptor : list) {
                this.deployPolicy(methodDescriptor, securityHelper);
            }
        }
        if (list2 != null) {
            for (MethodDescriptor methodDescriptor : list2) {
                this.deployPolicy(methodDescriptor, securityHelper);
            }
        }
        if (list3 != null) {
            for (MethodDescriptor methodDescriptor : list3) {
                this.deployPolicy(methodDescriptor, securityHelper);
            }
        }
    }

    boolean deployPolicy(MethodDescriptor methodDescriptor, SecurityHelper securityHelper) throws Exception {
        MethodInfo methodInfo = methodDescriptor.getMethodInfo();
        Set<String> set = methodInfo.getSecurityRoleNames();
        EJBMethodPermission eJBMethodPermission = SecurityHelper.createEJBMethodPermission(methodDescriptor);
        methodDescriptor.setSecurityHelper(securityHelper);
        methodDescriptor.setEJBMethodPermission(eJBMethodPermission);
        if (!methodInfo.needsSecurityCheck()) {
            return false;
        }
        if (set.isEmpty()) {
            if (debugLogger.isDebugEnabled()) {
                SecurityHelperJACC.debug(" no policy for " + eJBMethodPermission);
            }
            if (!dont_register_uncovered_methods && !methodInfo.getIsExcluded()) {
                if (debugLogger.isDebugEnabled()) {
                    SecurityHelperJACC.debug("  deploying uncovered method as 'unchecked': '" + eJBMethodPermission + "'");
                }
                this.jaccPolicyConfig.addToUncheckedPolicy((Permission)eJBMethodPermission);
            }
        } else {
            for (String string : set) {
                if (debugLogger.isDebugEnabled()) {
                    SecurityHelperJACC.debug("  next roleName is: '" + string + "'");
                }
                if (debugLogger.isDebugEnabled()) {
                    SecurityHelperJACC.debug("registerRolesWithMethod, jaccPolicyConfig.addToRole " + string + ", " + eJBMethodPermission);
                }
                this.jaccPolicyConfig.addToRole(string, (Permission)eJBMethodPermission);
            }
        }
        if (methodInfo.getUnchecked()) {
            this.jaccPolicyConfig.addToUncheckedPolicy((Permission)eJBMethodPermission);
        }
        if (methodInfo.getIsExcluded()) {
            this.jaccPolicyConfig.addToExcludedPolicy((Permission)eJBMethodPermission);
        }
        return true;
    }

    void processUncheckedExcludedMethod(MethodDescriptor methodDescriptor) throws WLDeploymentException {
        MethodInfo methodInfo = methodDescriptor.getMethodInfo();
        if (methodInfo.getUnchecked()) {
            EJBMethodPermission eJBMethodPermission = SecurityHelper.createEJBMethodPermission(methodDescriptor);
            try {
                this.jaccPolicyConfig.addToUncheckedPolicy((Permission)eJBMethodPermission);
            }
            catch (PolicyContextException policyContextException) {
                throw new WLDeploymentException(policyContextException.getMessage(), policyContextException);
            }
            return;
        }
        if (methodInfo.getIsExcluded()) {
            EJBMethodPermission eJBMethodPermission = SecurityHelper.createEJBMethodPermission(methodDescriptor);
            try {
                this.jaccPolicyConfig.addToExcludedPolicy((Permission)eJBMethodPermission);
            }
            catch (PolicyContextException policyContextException) {
                throw new WLDeploymentException(policyContextException.getMessage(), policyContextException);
            }
            return;
        }
    }

    void registerRoleRefs(String string, Map map) throws WLDeploymentException {
        Set set = map.keySet();
        if (set.size() <= 0) {
            return;
        }
        try {
            for (String string2 : set) {
                SecurityRoleReference securityRoleReference = (SecurityRoleReference)map.get(string2);
                String string3 = securityRoleReference.getReferencedRole();
                EJBRoleRefPermission eJBRoleRefPermission = SecurityHelper.createEJBRoleRefPermission(string, string2);
                this.jaccPolicyConfig.addToRole(string3, (Permission)eJBRoleRefPermission);
            }
        }
        catch (PolicyContextException policyContextException) {
            throw new WLDeploymentException(policyContextException.getMessage(), policyContextException);
        }
    }

    void activate() {
    }

    void deactivate() {
        try {
            this.jaccPolicyConfig.delete();
        }
        catch (PolicyContextException policyContextException) {
            // empty catch block
        }
    }

    public void setContext(ContextHandler contextHandler) {
        PolicyContext.setHandlerData((Object)contextHandler);
    }

    public void resetContext() {
        PolicyContext.setHandlerData(null);
    }

    boolean isAccessAllowed(EJBMethodPermission eJBMethodPermission, ContextHandler contextHandler) {
        Principal[] principalArray;
        AuthenticatedSubject authenticatedSubject = SecurityHelper.getCurrentSubject();
        if (authenticatedSubject != null) {
            principalArray = new Principal[authenticatedSubject.getPrincipals().size()];
            authenticatedSubject.getPrincipals().toArray(principalArray);
        } else {
            principalArray = new Principal[]{};
        }
        ProtectionDomain protectionDomain = new ProtectionDomain(this.jaccCodeSource, null, null, principalArray);
        boolean bl = false;
        try {
            bl = this.implies((Permission)eJBMethodPermission, protectionDomain);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
            bl = false;
        }
        return bl;
    }

    boolean isCallerInRole(String string, AuthenticatedSubject authenticatedSubject, String string2) {
        ProtectionDomain protectionDomain = this.getProtectionDomainForSubject(authenticatedSubject);
        EJBRoleRefPermission eJBRoleRefPermission = new EJBRoleRefPermission(string, string2);
        boolean bl = false;
        try {
            bl = this.implies((Permission)eJBRoleRefPermission, protectionDomain);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
            return false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean implies(Permission permission, ProtectionDomain protectionDomain) {
        String string = PolicyContext.getContextID();
        this.setPolicyContext(this.jaccPolicyContextId);
        if (debugLogger.isDebugEnabled()) {
            SecurityHelperJACC.debug("about to call Policy.getPolicy().implies on ProtectionDomain: " + protectionDomain + ", permission: " + permission);
        }
        boolean bl = Policy.getPolicy().implies(protectionDomain, permission);
        Object var6_6 = null;
        try {
            this.setPolicyContext(string);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bl;
        catch (Throwable throwable) {
            try {
                throwable.printStackTrace();
                Object var6_7 = null;
            }
            catch (Throwable throwable2) {
                Object var6_8 = null;
                try {
                    this.setPolicyContext(string);
                }
                catch (Throwable throwable3) {
                    // empty catch block
                }
                throw throwable2;
            }
            try {
                this.setPolicyContext(string);
            }
            catch (Throwable throwable4) {}
        }
        return false;
    }

    private void setPolicyContext(final String string) throws Throwable {
        String string2 = PolicyContext.getContextID();
        if (!(string2 == string || string2 != null && string != null && string2.equals(string))) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        PolicyContext.setContextID((String)string);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw privilegedActionException.getCause();
            }
        } else if (debugLogger.isDebugEnabled()) {
            SecurityHelperJACC.debug("#### setPolicyContext(): Policy Context ID was the same: " + string2);
        }
    }

    private ProtectionDomain getProtectionDomainForSubject(AuthenticatedSubject authenticatedSubject) {
        Principal[] principalArray;
        if (authenticatedSubject != null) {
            principalArray = new Principal[authenticatedSubject.getPrincipals().size()];
            authenticatedSubject.getPrincipals().toArray(principalArray);
        } else {
            principalArray = new Principal[]{};
        }
        return new ProtectionDomain(this.jaccCodeSource, null, null, principalArray);
    }

    private static void debug(String string) {
        debugLogger.debug("[SecurityHelperJACC] " + string);
    }

    static {
        CommonPolicyContextHandler commonPolicyContextHandler = new CommonPolicyContextHandler();
        String[] stringArray = EJBContextHandler.getKeys();
        DelegatingPolicyContextHandler delegatingPolicyContextHandler = new DelegatingPolicyContextHandler(stringArray);
        try {
            PolicyContext.registerHandler((String)"javax.security.auth.Subject.container", (PolicyContextHandler)commonPolicyContextHandler, (boolean)true);
            for (int i = 0; i < stringArray.length; ++i) {
                PolicyContext.registerHandler((String)stringArray[i], (PolicyContextHandler)delegatingPolicyContextHandler, (boolean)true);
            }
        }
        catch (PolicyContextException policyContextException) {
            EJBLogger.logFailedToRegisterPolicyContextHandlers((Exception)((Object)policyContextException));
        }
    }
}

