/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.internal;

import java.security.AccessController;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import weblogic.application.ApplicationContext;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.ejb.container.EJBDebugService;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.interfaces.DeploymentInfo;
import weblogic.ejb.container.interfaces.MethodInfo;
import weblogic.ejb.container.interfaces.NoSuchRoleException;
import weblogic.ejb.container.interfaces.SecurityRoleMapping;
import weblogic.ejb.container.internal.MethodDescriptor;
import weblogic.ejb.container.internal.SecurityHelper;
import weblogic.ejb.spi.BusinessObject;
import weblogic.ejb.spi.WLDeploymentException;
import weblogic.ejb20.interfaces.PrincipalNotFoundException;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.AuthorizationManager;
import weblogic.security.service.AuthorizationManagerDeployHandle;
import weblogic.security.service.ContextHandler;
import weblogic.security.service.DeployHandleCreationException;
import weblogic.security.service.EJBResource;
import weblogic.security.service.PrincipalAuthenticator;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.ResourceCreationException;
import weblogic.security.service.ResourceRemovalException;
import weblogic.security.service.RoleCreationException;
import weblogic.security.service.RoleManager;
import weblogic.security.service.RoleManagerDeployHandle;
import weblogic.security.service.RoleRemovalException;
import weblogic.security.service.SecurityApplicationInfo;
import weblogic.security.service.SecurityService;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.spi.Resource;
import weblogic.utils.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SecurityHelperWLS {
    private static final DebugLogger debugLogger = EJBDebugService.securityLogger;
    static final int SYSTEM_REALM = 0;
    static final int APP_REALM = 1;
    private static final AuthenticatedSubject subject = SecurityHelperWLS.obtainSubject();
    private SecurityApplicationInfo securityAppInfo;
    private PrincipalAuthenticator appPrincipalAuth;
    private RoleManager appRoleManager;
    private AuthorizationManager appAuthManager;
    private PrincipalAuthenticator sysPrincipalAuth;
    private RoleManager sysRoleManager;
    private AuthorizationManager sysAuthManager;
    private RoleManagerDeployHandle roleMgrHandle = null;
    private AuthorizationManagerDeployHandle authMgrHandle = null;
    private boolean fullDelegation;
    private boolean customRoles;
    private ApplicationContext appContext;
    private String sysRealmName;
    private String appRealmName;
    private EJBResource ejbRoleResource;

    SecurityHelperWLS(String string, String string2) {
        this.appRealmName = string;
        this.sysRealmName = string2;
    }

    void setupApplicationInfo(ApplicationContext applicationContext, DeploymentInfo deploymentInfo, SecurityApplicationInfo securityApplicationInfo) {
        assert (applicationContext != null) : "Passed in ApplicationContext is unexpectedly null !";
        this.appContext = applicationContext;
        this.securityAppInfo = securityApplicationInfo;
        String string = securityApplicationInfo.getSecurityDDModel();
        this.customRoles = string.equals("CustomRoles") || string.equals("CustomRolesAndPolicies");
        this.fullDelegation = SecurityServiceManager.isFullAuthorizationDelegationRequired((String)(this.appRealmName != null ? this.appRealmName : this.sysRealmName), (SecurityApplicationInfo)securityApplicationInfo);
        if (debugLogger.isDebugEnabled()) {
            SecurityHelperWLS.debug(" using 9.x+ WLS Security APIs.   Full Delegation = '" + this.fullDelegation + "'");
        }
    }

    void deployRoles(DeploymentInfo deploymentInfo, Map map, int n) throws WLDeploymentException, NoSuchRoleException {
        String string = deploymentInfo.getApplicationName();
        String string2 = deploymentInfo.getEJBComponentName();
        if (debugLogger.isDebugEnabled()) {
            SecurityHelperWLS.debug("deployRoles(...), appName: '" + string + "', ejbComponentName: '" + string2 + "'  there are: '" + map.size() + "' roles in this jar.");
        }
        RoleManager roleManager = this.obtainRM(n);
        try {
            this.roleMgrHandle = roleManager.startDeployRoles(this.securityAppInfo);
        }
        catch (DeployHandleCreationException deployHandleCreationException) {
            throw new WLDeploymentException("", deployHandleCreationException);
        }
        if (map.isEmpty()) {
            return;
        }
        this.ejbRoleResource = SecurityHelper.createEJBResource(deploymentInfo);
        for (String string3 : map.keySet()) {
            String[] stringArray = (String[])map.get(string3);
            if (debugLogger.isDebugEnabled()) {
                SecurityHelperWLS.debug("deploying role: " + string3 + " with principals: " + StringUtils.join((String[])stringArray, (String)", "));
            }
            try {
                roleManager.deployRole(this.roleMgrHandle, (Resource)this.ejbRoleResource, string3, stringArray);
            }
            catch (RoleCreationException roleCreationException) {
                throw new NoSuchRoleException("registerEjbRolesAndUsers: Exception while attempting to deploy Security Role: " + roleCreationException.toString());
            }
        }
        try {
            roleManager.endDeployRoles(this.roleMgrHandle);
        }
        catch (RoleCreationException roleCreationException) {
            throw new WLDeploymentException("", roleCreationException);
        }
        if (debugLogger.isDebugEnabled()) {
            SecurityHelperWLS.debug("done with role deployment for appName: '" + string + "', ejbComponentName: '" + string2 + "'");
        }
    }

    void unDeployRoles(DeploymentInfo deploymentInfo, SecurityRoleMapping securityRoleMapping) {
        this.unDeployRoles(deploymentInfo, securityRoleMapping, 1);
    }

    void unDeployRoles(DeploymentInfo deploymentInfo, SecurityRoleMapping securityRoleMapping, int n) {
        String string = deploymentInfo.getApplicationName();
        String string2 = deploymentInfo.getEJBComponentName();
        EJBResource eJBResource = SecurityHelper.createEJBResource(deploymentInfo);
        RoleManager roleManager = this.obtainRM(n);
        if (this.roleMgrHandle == null) {
            return;
        }
        try {
            roleManager.undeployAllRoles(this.roleMgrHandle);
        }
        catch (RoleRemovalException roleRemovalException) {
            EJBLogger.logFailedToUndeploySecurityRole((String)(string + " - " + string2), (Throwable)roleRemovalException);
        }
    }

    void beginPolicyRegistration() throws WLDeploymentException {
        this.beginPolicyRegistration(1);
    }

    void beginPolicyRegistration(int n) throws WLDeploymentException {
        AuthorizationManager authorizationManager = this.obtainAM(n);
        try {
            this.authMgrHandle = authorizationManager.startDeployPolicies(this.securityAppInfo);
        }
        catch (DeployHandleCreationException deployHandleCreationException) {
            throw new WLDeploymentException("", deployHandleCreationException);
        }
    }

    void endPolicyRegistration() throws WLDeploymentException {
        this.endPolicyRegistration(1);
    }

    void endPolicyRegistration(int n) throws WLDeploymentException {
        AuthorizationManager authorizationManager = this.obtainAM(n);
        try {
            authorizationManager.endDeployPolicies(this.authMgrHandle);
        }
        catch (ResourceCreationException resourceCreationException) {
            throw new WLDeploymentException("", resourceCreationException);
        }
    }

    void deployPolicies(List<MethodDescriptor> list, List<MethodDescriptor> list2, List<MethodDescriptor> list3, SecurityHelper securityHelper, int n) throws PrincipalNotFoundException {
        boolean bl;
        AuthorizationManager authorizationManager = this.obtainAM(n);
        if (list != null && !(bl = this.deployOptimizedPolicy(list, securityHelper, authorizationManager))) {
            for (MethodDescriptor methodDescriptor : list) {
                this.deployPolicy(methodDescriptor, securityHelper, authorizationManager);
            }
        }
        if (list2 != null) {
            for (MethodDescriptor methodDescriptor : list2) {
                this.deployPolicy(methodDescriptor, securityHelper, authorizationManager);
            }
        }
        if (list3 != null) {
            for (MethodDescriptor methodDescriptor : list3) {
                this.deployPolicy(methodDescriptor, securityHelper, authorizationManager);
            }
        }
    }

    private boolean deployOptimizedPolicy(List<MethodDescriptor> list, SecurityHelper securityHelper, AuthorizationManager authorizationManager) throws PrincipalNotFoundException {
        Object object;
        Set<String> set;
        if (list == null) {
            return false;
        }
        if (list.isEmpty()) {
            return false;
        }
        ArrayList<MethodDescriptor> arrayList = new ArrayList<MethodDescriptor>();
        MethodDescriptor object3 = null;
        for (MethodDescriptor object22 : list) {
            if (object3 == null) {
                object3 = object22;
                continue;
            }
            if (!object3.getEjbName().equals(object22.getEjbName())) {
                return false;
            }
            set = object3.getMethodInfo().getSecurityRoleNames();
            if (((Object)set).equals(object = object22.getMethodInfo().getSecurityRoleNames())) continue;
            if (object3.getMethod().getDeclaringClass() == BusinessObject.class) {
                arrayList.add(object3);
                object3 = object22;
                continue;
            }
            if (object22.getMethod().getDeclaringClass() == BusinessObject.class) {
                arrayList.add(object22);
                continue;
            }
            return false;
        }
        String string = object3.getApplicationName();
        String string2 = object3.getEjbComponentName();
        set = object3.getEjbName();
        object = SecurityHelper.createEJBResource(string, string2, (String)((Object)set));
        for (MethodDescriptor methodDescriptor : list) {
            methodDescriptor.setSecurityHelper(securityHelper);
            methodDescriptor.setEJBResource(SecurityHelper.createEJBResource(methodDescriptor));
        }
        if (debugLogger.isDebugEnabled()) {
            SecurityHelperWLS.debug("deployPolicy:  register optimized EJB Role restrictions for appName: '" + (String)string + "', ejbComponentName: '" + string2 + "', ejbName: '" + (String)((Object)set));
        }
        MethodInfo methodInfo = object3.getMethodInfo();
        this.deployPolicy((EJBResource)object, methodInfo.getSecurityRoleNames(), methodInfo.needsSecurityCheck(), methodInfo.getUnchecked(), methodInfo.getIsExcluded(), authorizationManager);
        for (MethodDescriptor methodDescriptor : arrayList) {
            this.deployPolicy(methodDescriptor, securityHelper, authorizationManager);
        }
        return true;
    }

    private boolean deployPolicy(MethodDescriptor methodDescriptor, SecurityHelper securityHelper, AuthorizationManager authorizationManager) throws PrincipalNotFoundException {
        methodDescriptor.setSecurityHelper(securityHelper);
        EJBResource eJBResource = SecurityHelper.createEJBResource(methodDescriptor);
        methodDescriptor.setEJBResource(eJBResource);
        MethodInfo methodInfo = methodDescriptor.getMethodInfo();
        if (debugLogger.isDebugEnabled()) {
            SecurityHelperWLS.debug("deployPolicy:  register EJB Role restrictions for appName: '" + methodDescriptor.getApplicationName() + "', ejbComponentName: '" + methodDescriptor.getEjbComponentName() + "', ejbName: '" + methodDescriptor.getEjbName() + "', methodName: '" + methodInfo.getMethodName() + "', methodInterface: '" + methodInfo.getMethodInterfaceType());
        }
        return this.deployPolicy(eJBResource, methodInfo.getSecurityRoleNames(), methodInfo.needsSecurityCheck(), methodInfo.getUnchecked(), methodInfo.getIsExcluded(), authorizationManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean deployPolicy(EJBResource eJBResource, Set<String> set, boolean bl, boolean bl2, boolean bl3, AuthorizationManager authorizationManager) throws PrincipalNotFoundException {
        block31: {
            boolean bl4;
            block30: {
                boolean bl5;
                block29: {
                    try {
                        if (!bl) {
                            bl5 = false;
                            Object var10_9 = null;
                            break block29;
                        }
                        if (debugLogger.isDebugEnabled()) {
                            for (String string : set) {
                                SecurityHelperWLS.debug("  next roleName is: '" + string + "'");
                            }
                        }
                        String[] stringArray = set.toArray(new String[set.size()]);
                        try {
                            if (set.isEmpty()) {
                                if (debugLogger.isDebugEnabled()) {
                                    SecurityHelperWLS.debug(" count of restrictable roles in policy = " + set.size() + ", so skipping authManager.deployPolicy. ");
                                }
                                bl4 = true;
                                break block30;
                            }
                        }
                        catch (ResourceCreationException resourceCreationException) {
                            throw new PrincipalNotFoundException("Exception while attempting to deploy Security Policy:  " + resourceCreationException.toString());
                        }
                        {
                            authorizationManager.deployPolicy(this.authMgrHandle, (Resource)eJBResource, stringArray);
                            break block31;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var10_12 = null;
                        try {
                            if (bl2) {
                                if (debugLogger.isDebugEnabled()) {
                                    SecurityHelperWLS.debug(" deploying unchecked policy");
                                }
                                authorizationManager.deployUncheckedPolicy(this.authMgrHandle, (Resource)eJBResource);
                                throw throwable;
                            }
                            if (!bl3) throw throwable;
                            if (debugLogger.isDebugEnabled()) {
                                SecurityHelperWLS.debug(" deploying excluded policy ");
                            }
                            authorizationManager.deployExcludedPolicy(this.authMgrHandle, (Resource)eJBResource);
                            throw throwable;
                        }
                        catch (ResourceCreationException resourceCreationException) {
                            throw new PrincipalNotFoundException("Exception while attempting to deploy Unchecked or Excluded Security Policy:  " + resourceCreationException.toString());
                        }
                    }
                }
                try {}
                catch (ResourceCreationException resourceCreationException) {
                    throw new PrincipalNotFoundException("Exception while attempting to deploy Unchecked or Excluded Security Policy:  " + resourceCreationException.toString());
                }
                if (bl2) {
                    if (debugLogger.isDebugEnabled()) {
                        SecurityHelperWLS.debug(" deploying unchecked policy");
                    }
                    authorizationManager.deployUncheckedPolicy(this.authMgrHandle, (Resource)eJBResource);
                    return bl5;
                }
                if (!bl3) return bl5;
                if (debugLogger.isDebugEnabled()) {
                    SecurityHelperWLS.debug(" deploying excluded policy ");
                }
                authorizationManager.deployExcludedPolicy(this.authMgrHandle, (Resource)eJBResource);
                return bl5;
            }
            Object var10_10 = null;
            try {}
            catch (ResourceCreationException resourceCreationException) {
                throw new PrincipalNotFoundException("Exception while attempting to deploy Unchecked or Excluded Security Policy:  " + resourceCreationException.toString());
            }
            if (bl2) {
                if (debugLogger.isDebugEnabled()) {
                    SecurityHelperWLS.debug(" deploying unchecked policy");
                }
                authorizationManager.deployUncheckedPolicy(this.authMgrHandle, (Resource)eJBResource);
                return bl4;
            }
            if (!bl3) return bl4;
            if (debugLogger.isDebugEnabled()) {
                SecurityHelperWLS.debug(" deploying excluded policy ");
            }
            authorizationManager.deployExcludedPolicy(this.authMgrHandle, (Resource)eJBResource);
            return bl4;
        }
        Object var10_11 = null;
        try {}
        catch (ResourceCreationException resourceCreationException) {
            throw new PrincipalNotFoundException("Exception while attempting to deploy Unchecked or Excluded Security Policy:  " + resourceCreationException.toString());
        }
        if (bl2) {
            if (debugLogger.isDebugEnabled()) {
                SecurityHelperWLS.debug(" deploying unchecked policy");
            }
            authorizationManager.deployUncheckedPolicy(this.authMgrHandle, (Resource)eJBResource);
        } else if (bl3) {
            if (debugLogger.isDebugEnabled()) {
                SecurityHelperWLS.debug(" deploying excluded policy ");
            }
            authorizationManager.deployExcludedPolicy(this.authMgrHandle, (Resource)eJBResource);
        }
        if (!debugLogger.isDebugEnabled()) return true;
        SecurityHelperWLS.debug("authManager.deployPolicy: registered  EJB Role restrictions with Policy Manager");
        return true;
    }

    void unDeployAllPolicies() {
        this.unDeployAllPolicies(1);
    }

    void unDeployAllPolicies(int n) {
        if (this.authMgrHandle == null) {
            return;
        }
        AuthorizationManager authorizationManager = this.obtainAM(n);
        try {
            authorizationManager.undeployAllPolicies(this.authMgrHandle);
        }
        catch (ResourceRemovalException resourceRemovalException) {
            EJBLogger.logFailedToUndeploySecurityPolicy((String)"All EJBs in Application", (Throwable)resourceRemovalException);
        }
    }

    boolean isAccessAllowed(EJBResource eJBResource, ContextHandler contextHandler) {
        return this.isAccessAllowed(eJBResource, contextHandler, 1);
    }

    boolean isAccessAllowed(EJBResource eJBResource, ContextHandler contextHandler, int n) {
        AuthorizationManager authorizationManager = this.obtainAM(n);
        AuthenticatedSubject authenticatedSubject = SecurityHelper.getCurrentSubject();
        if (debugLogger.isDebugEnabled()) {
            SecurityHelperWLS.debug(" isAccessAllowed:  checking Method Permission for ejb: '" + eJBResource + "' with Subject: " + authenticatedSubject);
        }
        return authorizationManager.isAccessAllowed(authenticatedSubject, (Resource)eJBResource, contextHandler);
    }

    boolean isCallerInRole(EJBResource eJBResource, AuthenticatedSubject authenticatedSubject, String string) {
        return this.isCallerInRole(eJBResource, authenticatedSubject, string, 1);
    }

    boolean isCallerInRole(EJBResource eJBResource, AuthenticatedSubject authenticatedSubject, String string, int n) {
        RoleManager roleManager = this.obtainRM(n);
        Map map = roleManager.getRoles(authenticatedSubject, (Resource)eJBResource, null);
        if (map == null || map.size() < 1) {
            if (debugLogger.isDebugEnabled()) {
                SecurityHelperWLS.debug(" isCallerInRole:  securityRoles for resource; '" + eJBResource + "',\n Caller subject: '" + authenticatedSubject + ", role name '" + string + "' there are no roles mapped to this subject." + "'  isCallerInRole returns false");
            }
            return false;
        }
        if (debugLogger.isDebugEnabled()) {
            StringBuilder stringBuilder = new StringBuilder();
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                stringBuilder.append((String)iterator.next()).append(", ");
            }
            SecurityHelperWLS.debug(" isCallerInRole:  check securityRoles for resource; '" + eJBResource + "',\n subject: '" + authenticatedSubject + ", candidate role name '" + string + "'roles mapped to this subject are: '" + stringBuilder.toString() + "'" + "'  isCallerInRole returns " + SecurityServiceManager.isUserInRole((AuthenticatedSubject)authenticatedSubject, (String)string, (Map)map));
        }
        return SecurityServiceManager.isUserInRole((AuthenticatedSubject)authenticatedSubject, (String)string, (Map)map);
    }

    boolean fullyDelegateSecurityCheck(String string) {
        return this.fullDelegation;
    }

    private PrincipalAuthenticator obtainPA(int n) {
        switch (n) {
            case 1: {
                if (this.appPrincipalAuth != null) {
                    return this.appPrincipalAuth;
                }
                this.appPrincipalAuth = (PrincipalAuthenticator)SecurityServiceManager.getSecurityService((AuthenticatedSubject)subject, (String)this.appRealmName, (SecurityService.ServiceType)SecurityService.ServiceType.AUTHENTICATION);
                return this.appPrincipalAuth;
            }
            case 0: {
                if (this.sysPrincipalAuth != null) {
                    return this.sysPrincipalAuth;
                }
                this.sysPrincipalAuth = (PrincipalAuthenticator)SecurityServiceManager.getSecurityService((AuthenticatedSubject)subject, (String)this.sysRealmName, (SecurityService.ServiceType)SecurityService.ServiceType.AUTHENTICATION);
                return this.sysPrincipalAuth;
            }
        }
        throw new AssertionError((Object)("  weblogic.ejb.internal.SecurityHelper.obtainPA, unknown realm type: " + n));
    }

    private RoleManager obtainRM(int n) {
        switch (n) {
            case 1: {
                if (this.appRoleManager != null) {
                    return this.appRoleManager;
                }
                this.appRoleManager = (RoleManager)SecurityServiceManager.getSecurityService((AuthenticatedSubject)subject, (String)this.appRealmName, (SecurityService.ServiceType)SecurityService.ServiceType.ROLE);
                return this.appRoleManager;
            }
            case 0: {
                if (this.sysRoleManager != null) {
                    return this.sysRoleManager;
                }
                this.sysRoleManager = (RoleManager)SecurityServiceManager.getSecurityService((AuthenticatedSubject)subject, (String)this.sysRealmName, (SecurityService.ServiceType)SecurityService.ServiceType.ROLE);
                return this.sysRoleManager;
            }
        }
        throw new AssertionError((Object)("  weblogic.ejb.internal.SecurityHelper.obtainRM, unknown realm type: " + n));
    }

    private AuthorizationManager obtainAM(int n) {
        switch (n) {
            case 1: {
                if (this.appAuthManager != null) {
                    return this.appAuthManager;
                }
                this.appAuthManager = (AuthorizationManager)SecurityServiceManager.getSecurityService((AuthenticatedSubject)subject, (String)this.appRealmName, (SecurityService.ServiceType)SecurityService.ServiceType.AUTHORIZE);
                return this.appAuthManager;
            }
            case 0: {
                if (this.sysAuthManager != null) {
                    return this.sysAuthManager;
                }
                this.sysAuthManager = (AuthorizationManager)SecurityServiceManager.getSecurityService((AuthenticatedSubject)subject, (String)this.sysRealmName, (SecurityService.ServiceType)SecurityService.ServiceType.AUTHORIZE);
                return this.sysAuthManager;
            }
        }
        throw new AssertionError((Object)("  weblogic.ejb.internal.SecurityHelper.obtainAM, unknown realm type: " + n));
    }

    private static AuthenticatedSubject obtainSubject() {
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        return authenticatedSubject;
    }

    private static void debug(String string) {
        debugLogger.debug("[SecurityHelperWLS] " + string);
    }
}

