/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.internal;

import java.rmi.RemoteException;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.EnterpriseBean;
import javax.ejb.SessionContext;
import javax.xml.rpc.handler.MessageContext;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.interfaces.BeanManager;
import weblogic.ejb.container.interfaces.Ejb3LocalHome;
import weblogic.ejb.container.interfaces.Ejb3RemoteHome;
import weblogic.ejb.container.interfaces.SessionBeanInfo;
import weblogic.ejb.container.interfaces.WLSessionEJBContext;
import weblogic.ejb.container.internal.BaseEJBContext;
import weblogic.ejb.container.internal.BaseEJBHome;
import weblogic.ejb.container.internal.BaseEJBLocalHome;
import weblogic.logging.Loggable;
import weblogic.utils.AssertionError;

public final class SessionEJBContextImpl
extends BaseEJBContext
implements SessionContext,
WLSessionEJBContext {
    private MessageContext messageContext;
    private Class businessInterfaceClass = null;
    private Object primaryKey = null;

    public SessionEJBContextImpl(EnterpriseBean enterpriseBean, BeanManager beanManager, BaseEJBHome baseEJBHome, BaseEJBLocalHome baseEJBLocalHome, EJBObject eJBObject, EJBLocalObject eJBLocalObject) {
        super(enterpriseBean, beanManager, baseEJBHome, baseEJBLocalHome, eJBObject, eJBLocalObject);
    }

    public void setBusinessInterfaceClass(Class clazz) {
        this.businessInterfaceClass = clazz;
    }

    public void setPrimaryKey(Object object) {
        this.primaryKey = object;
    }

    public MessageContext getMessageContext() {
        this.checkAllowedToGetMessageContext();
        return this.messageContext;
    }

    public void setMessageContext(MessageContext messageContext) {
        this.messageContext = messageContext;
    }

    public EJBHome getEJBHome() throws IllegalStateException {
        if (this.ejbObject == null) {
            Loggable loggable = EJBLogger.logEjbBeanWithoutHomeInterfaceLoggable((String)this.ejbHome.getDisplayName(), (String)"");
            throw new IllegalStateException(loggable.getMessage());
        }
        return super.getEJBHome();
    }

    public EJBLocalHome getEJBLocalHome() throws IllegalStateException {
        if (this.ejbLocalObject == null) {
            Loggable loggable = EJBLogger.logEjbBeanWithoutHomeInterfaceLoggable((String)this.ejbHome.getDisplayName(), (String)"local");
            throw new IllegalStateException(loggable.getMessage());
        }
        return super.getEJBLocalHome();
    }

    private boolean needConsiderReplicationService() throws IllegalStateException {
        if (this.remoteHome instanceof Ejb3RemoteHome) {
            try {
                return ((Ejb3RemoteHome)this.remoteHome).needToConsiderReplicationService();
            }
            catch (RemoteException remoteException) {
                throw new IllegalStateException(remoteException);
            }
        }
        return false;
    }

    public EJBObject getEJBObject() throws IllegalStateException {
        if (this.needConsiderReplicationService()) {
            try {
                return (EJBObject)((Ejb3RemoteHome)this.remoteHome).getComponentImpl(this.primaryKey);
            }
            catch (RemoteException remoteException) {
                throw new IllegalStateException(remoteException);
            }
        }
        if (this.ejbObject == null) {
            Loggable loggable = EJBLogger.logEjbBeanWithoutHomeInterfaceLoggable((String)this.ejbHome.getDisplayName(), (String)"");
            throw new IllegalStateException(loggable.getMessage());
        }
        return super.getEJBObject();
    }

    public EJBLocalObject getEJBLocalObject() throws IllegalStateException {
        if (this.ejbLocalObject == null) {
            Loggable loggable = EJBLogger.logEjbBeanWithoutHomeInterfaceLoggable((String)this.ejbHome.getDisplayName(), (String)"local");
            throw new IllegalStateException(loggable.getMessage());
        }
        return super.getEJBLocalObject();
    }

    public Object getBusinessObject(Class clazz) throws IllegalStateException {
        if (!(this.remoteHome instanceof Ejb3RemoteHome) && !(this.localHome instanceof Ejb3LocalHome)) {
            Loggable loggable = EJBLogger.logBeanIsNotEJB3BeanLoggable((String)this.ejbHome.getDisplayName());
            throw new IllegalStateException(loggable.getMessage());
        }
        Object object = null;
        if (this.remoteHome instanceof Ejb3RemoteHome) {
            try {
                object = ((Ejb3RemoteHome)this.remoteHome).getBusinessImpl(this.primaryKey, clazz);
                if (object != null) {
                    return object;
                }
            }
            catch (RemoteException remoteException) {
                throw new AssertionError("A remote exception is gotten when trying to get the business object for " + clazz);
            }
        }
        if (this.localHome instanceof Ejb3LocalHome && (object = ((Ejb3LocalHome)((Object)this.localHome)).getBusinessImpl(this.primaryKey, clazz)) != null) {
            return object;
        }
        if (object == null) {
            String string = clazz == null ? "null" : clazz.toString();
            Loggable loggable = EJBLogger.logEjbNoImplementBusinessInterfaceLoggable((String)this.ejbHome.getDisplayName(), (String)string);
            throw new IllegalStateException(loggable.getMessage());
        }
        return object;
    }

    public Class getInvokedBusinessInterface() throws IllegalStateException {
        if (this.businessInterfaceClass == null) {
            Loggable loggable = EJBLogger.logBeanNotInvokedThroughBusinessInterfaceLoggable();
            throw new IllegalStateException(loggable.getMessage());
        }
        return this.businessInterfaceClass;
    }

    protected void checkAllowedToGetTimerService() {
        SessionBeanInfo sessionBeanInfo = (SessionBeanInfo)this.beanManager.getBeanInfo();
        if (sessionBeanInfo.isStateful()) {
            Loggable loggable = EJBLogger.logStatefulSessionBeanAttemptToAccessTimerServiceLoggable();
            throw new IllegalStateException(loggable.getMessage());
        }
        super.checkAllowedToGetTimerService();
    }

    public void checkAllowedToGetMessageContext() {
        SessionBeanInfo sessionBeanInfo = (SessionBeanInfo)this.beanManager.getBeanInfo();
        if (sessionBeanInfo.isStateful()) {
            Loggable loggable = EJBLogger.logIllegalCallEJBContextMethodLoggable();
            throw new IllegalStateException(loggable.getMessage());
        }
        super.checkAllowedToGetMessageContext();
    }
}

