/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.internal;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.ejb.ConcurrentAccessException;
import javax.ejb.EJBMetaData;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.ejb.NoSuchEJBException;
import javax.ejb.RemoveException;
import weblogic.diagnostics.instrumentation.DelegatingMonitor;
import weblogic.diagnostics.instrumentation.DiagnosticAction;
import weblogic.diagnostics.instrumentation.DiagnosticActionState;
import weblogic.diagnostics.instrumentation.DiagnosticMonitor;
import weblogic.diagnostics.instrumentation.DynamicJoinPoint;
import weblogic.diagnostics.instrumentation.InstrumentationSupport;
import weblogic.diagnostics.instrumentation.JoinPoint;
import weblogic.diagnostics.instrumentation.PointcutHandlingInfo;
import weblogic.diagnostics.instrumentation.ValueHandlingInfo;
import weblogic.ejb.container.InternalException;
import weblogic.ejb.container.interfaces.BaseEJBHomeIntf;
import weblogic.ejb.container.interfaces.BeanInfo;
import weblogic.ejb.container.interfaces.BeanManager;
import weblogic.ejb.container.interfaces.SessionBeanInfo;
import weblogic.ejb.container.interfaces.StatefulEJBObjectIntf;
import weblogic.ejb.container.internal.BaseEJBHome;
import weblogic.ejb.container.internal.EJBActivator;
import weblogic.ejb.container.internal.EJBContextHandler;
import weblogic.ejb.container.internal.EJBRuntimeUtils;
import weblogic.ejb.container.internal.InvocationWrapper;
import weblogic.ejb.container.internal.MethodDescriptor;
import weblogic.ejb.container.internal.StatefulEJBHomeImpl;
import weblogic.ejb.container.internal.StatefulEJBObject;
import weblogic.ejb.container.replication.ReplicatedBeanManager;
import weblogic.ejb.container.replication.ReplicatedHome;
import weblogic.ejb.spi.WLDeploymentException;
import weblogic.ejb20.internal.EJBMetaDataImpl;
import weblogic.rmi.extensions.PortableRemoteObject;
import weblogic.rmi.extensions.activation.Activatable;
import weblogic.utils.AssertionError;
import weblogic.utils.StackTraceUtils;
import weblogic.utils.collections.SoftHashMap;

public abstract class StatefulEJBHome
extends BaseEJBHome
implements ReplicatedHome {
    private boolean isInMemoryReplication = false;
    private boolean isNoObjectActivation = false;
    private boolean usesBeanManagedTx = false;
    private EJBActivator ejbActivator;
    private Map eoMap = Collections.synchronizedMap(new SoftHashMap());
    static final long serialVersionUID = 3228386374483738647L;
    public static final String _WLDF$INST_VERSION = "9.0.0";
    static /* synthetic */ Class _WLDF$INST_FLD_class;
    public static final DelegatingMonitor _WLDF$INST_FLD_EJB_Diagnostic_Home_Remove_Around_Medium;
    public static final JoinPoint _WLDF$INST_JPFLD_0;
    public static final JoinPoint _WLDF$INST_JPFLD_1;

    public StatefulEJBHome(Class clazz) {
        super(clazz);
        this.ejbActivator = new EJBActivator(this);
    }

    public void setup(BeanInfo beanInfo, BaseEJBHomeIntf baseEJBHomeIntf, BeanManager beanManager) throws WLDeploymentException {
        super.setup(beanInfo, baseEJBHomeIntf, beanManager);
        SessionBeanInfo sessionBeanInfo = (SessionBeanInfo)beanInfo;
        this.usesBeanManagedTx = sessionBeanInfo.usesBeanManagedTx();
        boolean bl = this.isInMemoryReplication = sessionBeanInfo.getReplicationType() == 2;
        if (this.eoClass != null) {
            this.isNoObjectActivation = !Activatable.class.isAssignableFrom(this.eoClass);
        }
    }

    protected EJBMetaData getEJBMetaDataInstance() {
        return new EJBMetaDataImpl(this, this.beanInfo.getHomeInterfaceClass(), this.beanInfo.getRemoteInterfaceClass(), null, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EJBObject create(MethodDescriptor methodDescriptor, Method method, Object[] objectArray) throws Exception {
        EJBObject eJBObject = null;
        try {
            this.pushEnvironment();
            if (debugLogger.isDebugEnabled()) {
                StatefulEJBHome.debug("[StatefulEJBHome] Creating a bean from md: " + methodDescriptor);
            }
            InvocationWrapper invocationWrapper = this.preHomeInvoke(methodDescriptor, new EJBContextHandler(methodDescriptor, objectArray));
            Throwable throwable = null;
            try {
                try {
                    assert (invocationWrapper.getInvokeTx() == null);
                    BeanManager beanManager = this.getBeanManager();
                    eJBObject = beanManager.remoteCreate(invocationWrapper, method, null, objectArray);
                }
                catch (InternalException internalException) {
                    throwable = internalException.detail;
                    if (debugLogger.isDebugEnabled()) {
                        StatefulEJBHome.debug("Got exception back from manager: " + internalException.getClass().getName());
                    }
                    if (EJBRuntimeUtils.isAppException(this.beanInfo, method, throwable)) {
                        throw (Exception)throwable;
                    }
                    this.handleSystemException(invocationWrapper, internalException);
                    throw new AssertionError("Should never have reached here");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    this.handleSystemException(invocationWrapper, throwable2);
                    throw new AssertionError("Should never reach here");
                }
                Object var9_10 = null;
            }
            catch (Throwable throwable3) {
                Object var9_11 = null;
                this.postHomeInvoke(invocationWrapper, throwable);
                throw throwable3;
            }
            this.postHomeInvoke(invocationWrapper, throwable);
            Object var11_13 = null;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            this.popEnvironment();
            throw throwable;
        }
        this.popEnvironment();
        return eJBObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove(MethodDescriptor methodDescriptor, Handle handle) throws RemoteException, RemoveException {
        boolean bl = _WLDF$INST_FLD_EJB_Diagnostic_Home_Remove_Around_Medium.isEnabledAndNotDyeFiltered();
        DiagnosticAction[] diagnosticActionArray = null;
        DiagnosticActionState[] diagnosticActionStateArray = null;
        Object var18_6 = null;
        if (bl) {
            Object[] objectArray = null;
            if (_WLDF$INST_FLD_EJB_Diagnostic_Home_Remove_Around_Medium.isArgumentsCaptureNeeded()) {
                objectArray = new Object[]{this, methodDescriptor, handle};
            }
            DynamicJoinPoint dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, (Object[])objectArray, null);
            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_EJB_Diagnostic_Home_Remove_Around_Medium;
            diagnosticActionArray = delegatingMonitor.getActions();
            diagnosticActionStateArray = InstrumentationSupport.getActionStates((DiagnosticAction[])diagnosticActionArray);
            InstrumentationSupport.preProcess((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
        }
        try {
            try {
                Throwable throwable;
                InvocationWrapper invocationWrapper;
                block17: {
                    this.pushEnvironment();
                    this.validateHandleFromHome(handle);
                    StatefulEJBObjectIntf statefulEJBObjectIntf = (StatefulEJBObjectIntf)PortableRemoteObject.narrow((Object)handle.getEJBObject(), StatefulEJBObjectIntf.class);
                    Object object = statefulEJBObjectIntf.getPK();
                    invocationWrapper = this.preHomeInvoke(methodDescriptor, new EJBContextHandler(methodDescriptor, new Object[]{handle}));
                    throwable = null;
                    try {
                        try {
                            invocationWrapper.setPrimaryKey(object);
                            Object var7_14 = null;
                            try {
                                this.getBeanManager().remove(invocationWrapper);
                            }
                            catch (InternalException internalException) {
                                if (internalException.getCause() instanceof NoSuchEJBException) throw new InternalException(internalException.getMessage(), internalException.getCause().getCause());
                                if (!(internalException.getCause() instanceof ConcurrentAccessException)) throw internalException;
                                throw new InternalException(internalException.getMessage(), internalException.getCause().getCause());
                            }
                            Object var10_18 = null;
                            if (!this.getIsNoObjectActivation() && !this.getIsInMemoryReplication()) break block17;
                            this.releaseEO(object);
                        }
                        catch (InternalException internalException) {
                            throwable = internalException.detail;
                            if (EJBRuntimeUtils.isAppException(this.beanInfo, methodDescriptor.getMethod(), throwable)) {
                                if (!(throwable instanceof RemoveException)) throw new AssertionError("Invalid Exception thrown from remove: " + StackTraceUtils.throwable2StackTrace((Throwable)throwable));
                                throw (RemoveException)throwable;
                            }
                            this.handleSystemException(invocationWrapper, internalException);
                            throw new AssertionError("Should never have reached here");
                        }
                        catch (Throwable throwable3) {
                            throwable = throwable3;
                            this.handleSystemException(invocationWrapper, throwable3);
                            throw new AssertionError("Should never reach here");
                        }
                    }
                    catch (Throwable throwable2) {
                        Object var10_19 = null;
                        if (this.getIsNoObjectActivation() || this.getIsInMemoryReplication()) {
                            this.releaseEO(object);
                            if (this instanceof StatefulEJBHomeImpl) {
                                ((StatefulEJBHomeImpl)this).releaseBOs(object);
                            }
                        }
                        this.postHomeInvoke(invocationWrapper, throwable);
                        throw throwable2;
                    }
                    if (this instanceof StatefulEJBHomeImpl) {
                        ((StatefulEJBHomeImpl)this).releaseBOs(object);
                    }
                }
                this.postHomeInvoke(invocationWrapper, throwable);
                Object var12_21 = null;
            }
            catch (Throwable throwable) {
                Object var12_22 = null;
                this.popEnvironment();
                throw throwable;
            }
            this.popEnvironment();
            Object var16_24 = null;
            if (!bl) return;
        }
        catch (Throwable throwable) {
            Object var16_25 = null;
            if (!bl) throw throwable;
            InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)_WLDF$INST_FLD_EJB_Diagnostic_Home_Remove_Around_Medium, diagnosticActionArray, diagnosticActionStateArray);
            throw throwable;
        }
        InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)_WLDF$INST_FLD_EJB_Diagnostic_Home_Remove_Around_Medium, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
    }

    public void remove(MethodDescriptor methodDescriptor, Object object) throws RemoveException {
        boolean bl = _WLDF$INST_FLD_EJB_Diagnostic_Home_Remove_Around_Medium.isEnabledAndNotDyeFiltered();
        DiagnosticAction[] diagnosticActionArray = null;
        DiagnosticActionState[] diagnosticActionStateArray = null;
        Object var8_6 = null;
        if (bl) {
            Object[] objectArray = null;
            if (_WLDF$INST_FLD_EJB_Diagnostic_Home_Remove_Around_Medium.isArgumentsCaptureNeeded()) {
                objectArray = new Object[]{this, methodDescriptor, object};
            }
            DynamicJoinPoint dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_1, (Object[])objectArray, null);
            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_EJB_Diagnostic_Home_Remove_Around_Medium;
            diagnosticActionArray = delegatingMonitor.getActions();
            diagnosticActionStateArray = InstrumentationSupport.getActionStates((DiagnosticAction[])diagnosticActionArray);
            InstrumentationSupport.preProcess((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
        }
        try {
            throw new RemoveException("Cannot remove stateful session beans using EJBHome.remove(Object primaryKey)");
        }
        catch (Throwable throwable) {
            block4: {
                Object var6_10 = null;
                if (!bl) break block4;
                InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_1, (DiagnosticMonitor)_WLDF$INST_FLD_EJB_Diagnostic_Home_Remove_Around_Medium, diagnosticActionArray, diagnosticActionStateArray);
            }
            throw throwable;
        }
    }

    public EJBObject allocateEO() {
        StatefulEJBObject statefulEJBObject = null;
        try {
            statefulEJBObject = (StatefulEJBObject)this.eoClass.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new AssertionError((Throwable)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Throwable)illegalAccessException);
        }
        statefulEJBObject.setEJBHome(this);
        statefulEJBObject.setBeanManager(this.getBeanManager());
        statefulEJBObject.setBeanInfo(this.getBeanInfo());
        return statefulEJBObject;
    }

    public EJBObject getEJBObject(Object object) {
        return (StatefulEJBObject)this.eoMap.get(object);
    }

    public EJBObject allocateEO(Object object) {
        if (this.getIsNoObjectActivation() || this.getIsInMemoryReplication()) {
            StatefulEJBObject statefulEJBObject = (StatefulEJBObject)this.eoMap.get(object);
            if (statefulEJBObject == null) {
                statefulEJBObject = (StatefulEJBObject)this.allocateEO();
                statefulEJBObject.setPrimaryKey(object);
                statefulEJBObject.setBeanManager(this.getBeanManager());
                statefulEJBObject.setBeanInfo(this.getBeanInfo());
                this.eoMap.put(object, statefulEJBObject);
            }
            return statefulEJBObject;
        }
        StatefulEJBObject statefulEJBObject = (StatefulEJBObject)this.allocateEO();
        statefulEJBObject.setPrimaryKey(object);
        statefulEJBObject.setBeanManager(this.getBeanManager());
        statefulEJBObject.setBeanInfo(this.getBeanInfo());
        statefulEJBObject.setActivator(this.ejbActivator);
        return statefulEJBObject;
    }

    public void releaseEO(Object object) {
        this.eoMap.remove(object);
    }

    public void cleanup() {
        if (this.getIsNoObjectActivation() || this.getIsInMemoryReplication()) {
            Collection collection = this.eoMap.values();
            for (EJBObject eJBObject : collection) {
                this.unexportEO(eJBObject);
            }
        }
        if (this.beanInfo.hasDeclaredRemoteHome()) {
            this.unexportEJBActivator(this.ejbActivator, this.eoClass);
        }
    }

    public boolean usesBeanManagedTx() {
        return this.usesBeanManagedTx;
    }

    public boolean getIsInMemoryReplication() {
        return this.isInMemoryReplication;
    }

    public boolean getIsNoObjectActivation() {
        return this.isNoObjectActivation;
    }

    public void becomePrimary(Object object) throws RemoteException {
        ((ReplicatedBeanManager)((Object)this.beanManager)).becomePrimary(object);
    }

    public Object createSecondary(Object object) throws RemoteException {
        return ((ReplicatedBeanManager)((Object)this.beanManager)).createSecondary(object);
    }

    public Object createSecondaryForBI(Object object, String string) throws RemoteException {
        throw new AssertionError("this method should not be invoked");
    }

    public void removeSecondary(Object object) throws RemoteException {
        ((ReplicatedBeanManager)((Object)this.beanManager)).removeSecondary(object);
        StatefulEJBObject statefulEJBObject = (StatefulEJBObject)this.eoMap.remove(object);
        if (statefulEJBObject != null) {
            this.unexportEO(statefulEJBObject, false);
        }
    }

    public void updateSecondary(Object object, Serializable serializable) throws RemoteException {
        ((ReplicatedBeanManager)((Object)this.beanManager)).updateSecondary(object, serializable);
    }

    private static void debug(String string) {
        debugLogger.debug("[StatefulEJBHome] " + string);
    }

    static {
        _WLDF$INST_FLD_class = Class.forName("weblogic.ejb.container.internal.StatefulEJBHome");
        _WLDF$INST_FLD_EJB_Diagnostic_Home_Remove_Around_Medium = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"EJB_Diagnostic_Home_Remove_Around_Medium");
        _WLDF$INST_JPFLD_0 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"StatefulEJBHome.java", (String)"weblogic.ejb.container.internal.StatefulEJBHome", (String)"remove", (String)"(Lweblogic/ejb/container/internal/MethodDescriptor;Ljavax/ejb/Handle;)V", (int)165, (Map)InstrumentationSupport.makeMap((String[])new String[]{"EJB_Diagnostic_Home_Remove_Around_Medium"}, (PointcutHandlingInfo[])new PointcutHandlingInfo[]{InstrumentationSupport.createPointcutHandlingInfo(null, null, (ValueHandlingInfo[])new ValueHandlingInfo[]{InstrumentationSupport.createValueHandlingInfo((String)"md", (String)"weblogic.diagnostics.instrumentation.gathering.EJBMethodDescriptorRenderer", (boolean)false, (boolean)true), null})}), (boolean)false);
        _WLDF$INST_JPFLD_1 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"StatefulEJBHome.java", (String)"weblogic.ejb.container.internal.StatefulEJBHome", (String)"remove", (String)"(Lweblogic/ejb/container/internal/MethodDescriptor;Ljava/lang/Object;)V", (int)231, (Map)InstrumentationSupport.makeMap((String[])new String[]{"EJB_Diagnostic_Home_Remove_Around_Medium"}, (PointcutHandlingInfo[])new PointcutHandlingInfo[]{InstrumentationSupport.createPointcutHandlingInfo(null, null, (ValueHandlingInfo[])new ValueHandlingInfo[]{InstrumentationSupport.createValueHandlingInfo((String)"md", (String)"weblogic.diagnostics.instrumentation.gathering.EJBMethodDescriptorRenderer", (boolean)false, (boolean)true), null})}), (boolean)false);
    }
}

