/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.internal;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.ejb.EJBException;
import javax.ejb.EJBMetaData;
import javax.ejb.Handle;
import javax.ejb.HomeHandle;
import javax.ejb.RemoveException;
import weblogic.ejb.container.InternalException;
import weblogic.ejb.container.interfaces.BeanManager;
import weblogic.ejb.container.interfaces.Ejb3RemoteHome;
import weblogic.ejb.container.interfaces.Ejb3SessionBeanInfo;
import weblogic.ejb.container.interfaces.Ejb3StatefulHome;
import weblogic.ejb.container.internal.EJBBusinessActivator;
import weblogic.ejb.container.internal.OpaqueReferenceImpl;
import weblogic.ejb.container.internal.RemoteBusinessIntfProxy;
import weblogic.ejb.container.internal.StatefulEJBHome;
import weblogic.ejb.container.internal.StatefulRemoteObject;
import weblogic.ejb.container.internal.URLDelegateProvider;
import weblogic.ejb.container.manager.ReplicatedStatefulSessionManager;
import weblogic.ejb.container.manager.StatefulSessionManager;
import weblogic.ejb.container.replication.ReplicatedBeanManager;
import weblogic.ejb.spi.BusinessObject;
import weblogic.ejb20.internal.HomeHandleImpl;
import weblogic.rmi.extensions.activation.Activator;
import weblogic.rmi.extensions.server.ServerHelper;
import weblogic.utils.collections.SoftHashMap;

public class StatefulEJBHomeImpl
extends StatefulEJBHome
implements Ejb3StatefulHome,
Ejb3RemoteHome {
    private final Map opaqueReferenceMap = new HashMap();
    private final Map ifaceNameToIface = new HashMap();
    private Map bosMap = Collections.synchronizedMap(new SoftHashMap());

    public StatefulEJBHomeImpl() {
        super(null);
    }

    public StatefulEJBHomeImpl(Class clazz) {
        super(clazz);
    }

    public EJBMetaData getEJBMetaData() throws RemoteException {
        throw new IllegalStateException();
    }

    public HomeHandle getHomeHandle() throws RemoteException {
        return new HomeHandleImpl(this, this.getJNDIName(), URLDelegateProvider.getURLDelegate(this.isHomeClusterable()));
    }

    public void remove(Object object) throws RemoteException, RemoveException {
        throw new IllegalStateException();
    }

    public void remove(Handle handle) throws RemoteException, RemoveException {
        throw new IllegalStateException();
    }

    public void prepare() {
        Ejb3SessionBeanInfo ejb3SessionBeanInfo = (Ejb3SessionBeanInfo)this.beanInfo;
        for (Class clazz : ejb3SessionBeanInfo.getBusinessRemotes()) {
            Class clazz2 = ejb3SessionBeanInfo.getGeneratedRemoteBusinessImplClass(clazz);
            Class clazz3 = ejb3SessionBeanInfo.getGeneratedRemoteBusinessIntfClass(clazz);
            EJBBusinessActivator eJBBusinessActivator = new EJBBusinessActivator(this, clazz2, clazz);
            OpaqueReferenceImpl opaqueReferenceImpl = new OpaqueReferenceImpl(this, clazz2, eJBBusinessActivator, clazz, clazz3);
            this.opaqueReferenceMap.put(clazz.getName(), opaqueReferenceImpl);
            this.ifaceNameToIface.put(clazz.getName(), clazz);
        }
    }

    public Object getBindableImpl(Class clazz) {
        return this.opaqueReferenceMap.get(clazz.getName());
    }

    public Object getComponentImpl(Object object) throws RemoteException {
        if (this.beanManager instanceof ReplicatedStatefulSessionManager) {
            try {
                return ((ReplicatedStatefulSessionManager)this.beanManager).registerReplicatedObject(object);
            }
            catch (InternalException internalException) {
                throw new RemoteException("Remote Exception: ", internalException);
            }
        }
        return null;
    }

    public boolean needToConsiderReplicationService() throws RemoteException {
        boolean bl;
        Ejb3SessionBeanInfo ejb3SessionBeanInfo = (Ejb3SessionBeanInfo)this.getBeanInfo();
        BeanManager beanManager = this.getBeanManager();
        return beanManager instanceof ReplicatedStatefulSessionManager && (bl = ((ReplicatedStatefulSessionManager)beanManager).isInCluster()) && ejb3SessionBeanInfo.hasDeclaredRemoteHome();
    }

    public Object getBusinessImpl(Object object, String string) throws RemoteException {
        Class clazz = (Class)this.ifaceNameToIface.get(string);
        return this.getBusinessImpl(object, clazz);
    }

    public Object getBusinessImpl(Object object, Class clazz) throws RemoteException {
        Ejb3SessionBeanInfo ejb3SessionBeanInfo = (Ejb3SessionBeanInfo)this.beanInfo;
        Class clazz2 = ejb3SessionBeanInfo.getGeneratedRemoteBusinessImplClass(clazz);
        if (clazz2 == null) {
            return null;
        }
        OpaqueReferenceImpl opaqueReferenceImpl = (OpaqueReferenceImpl)this.opaqueReferenceMap.get(clazz.getName());
        EJBBusinessActivator eJBBusinessActivator = (EJBBusinessActivator)opaqueReferenceImpl.getActivator();
        try {
            Remote remote = (Remote)((Object)((StatefulSessionManager)this.beanManager).remoteCreateForBI(object, clazz2, eJBBusinessActivator, clazz));
            return this.getProxyForRemoteBO((StatefulRemoteObject)((Object)remote), clazz, opaqueReferenceImpl.getGeneratedRemoteInterface());
        }
        catch (InternalException internalException) {
            throw new RemoteException("Remote Exception: ", internalException);
        }
    }

    public Object getBusinessImpl(String string) throws RemoteException {
        OpaqueReferenceImpl opaqueReferenceImpl = (OpaqueReferenceImpl)this.opaqueReferenceMap.get(string);
        return this.getBusinessImpl(opaqueReferenceImpl.getBusinessImplClass(), opaqueReferenceImpl.getActivator(), opaqueReferenceImpl.getBusinessIntfClass(), opaqueReferenceImpl.getGeneratedRemoteInterface());
    }

    public Object getBusinessImpl(Class clazz, Activator activator, Class clazz2, Class clazz3) throws RemoteException {
        try {
            Remote remote = (Remote)((Object)((StatefulSessionManager)this.beanManager).remoteCreateForBI(null, clazz, activator, clazz2));
            return this.getProxyForRemoteBO((StatefulRemoteObject)((Object)remote), clazz2, clazz3);
        }
        catch (InternalException internalException) {
            RemoteException remoteException = new RemoteException("Remote Exception: ", internalException.detail);
            throw remoteException;
        }
    }

    public Remote allocateBI(Object object, Class clazz, Class clazz2, Activator activator) {
        if (this.getIsInMemoryReplication()) {
            StatefulRemoteObject statefulRemoteObject;
            HashMap<String, StatefulRemoteObject> hashMap = (HashMap<String, StatefulRemoteObject>)this.bosMap.get(object);
            if (hashMap == null) {
                hashMap = new HashMap<String, StatefulRemoteObject>();
                this.bosMap.put(object, hashMap);
            }
            if ((statefulRemoteObject = (StatefulRemoteObject)hashMap.get(clazz2.getName())) == null) {
                statefulRemoteObject = this.createNewBO(object, clazz);
                try {
                    ServerHelper.exportObject((Remote)((Remote)((Object)statefulRemoteObject)), (String)"");
                }
                catch (RemoteException remoteException) {
                    throw new EJBException((Exception)remoteException);
                }
                hashMap.put(clazz2.getName(), statefulRemoteObject);
            }
            return (Remote)((Object)statefulRemoteObject);
        }
        StatefulRemoteObject statefulRemoteObject = this.createNewBO(object, clazz);
        statefulRemoteObject.setActivator(activator);
        return (Remote)((Object)statefulRemoteObject);
    }

    private StatefulRemoteObject createNewBO(Object object, Class clazz) {
        StatefulRemoteObject statefulRemoteObject;
        try {
            statefulRemoteObject = (StatefulRemoteObject)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new AssertionError((Object)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
        statefulRemoteObject.setEJBHome(this);
        statefulRemoteObject.setBeanManager(this.getBeanManager());
        statefulRemoteObject.setBeanInfo(this.getBeanInfo());
        statefulRemoteObject.setPrimaryKey(object);
        return statefulRemoteObject;
    }

    public void cleanup() {
        for (OpaqueReferenceImpl opaqueReferenceImpl : this.opaqueReferenceMap.values()) {
            this.unexportEJBActivator(opaqueReferenceImpl.getActivator(), opaqueReferenceImpl.getBusinessImplClass());
        }
    }

    private Object getProxyForRemoteBO(StatefulRemoteObject statefulRemoteObject, Class clazz, Class clazz2) {
        if (Remote.class.isAssignableFrom(clazz)) {
            return statefulRemoteObject;
        }
        if (clazz2 == null) {
            throw new AssertionError();
        }
        statefulRemoteObject.setIsImplementsRemote(false);
        RemoteBusinessIntfProxy remoteBusinessIntfProxy = new RemoteBusinessIntfProxy(statefulRemoteObject, this.deploymentInfo.getApplicationName(), clazz.getName(), clazz2.getName());
        return Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz, BusinessObject.class}, (InvocationHandler)remoteBusinessIntfProxy);
    }

    public Object createSecondaryForBI(Object object, String string) throws RemoteException {
        try {
            Class clazz = this.loadClassForBI(string);
            return ((ReplicatedBeanManager)((Object)this.beanManager)).createSecondaryForBI(object, clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RemoteException("encounter a remote exception, the nested exception is: ", classNotFoundException);
        }
    }

    private Class loadClassForBI(String string) throws ClassNotFoundException {
        Ejb3SessionBeanInfo ejb3SessionBeanInfo = (Ejb3SessionBeanInfo)this.beanInfo;
        Class<?> clazz = ejb3SessionBeanInfo.getBeanClass().getClassLoader().loadClass(string);
        return clazz;
    }

    public void removeSecondary(Object object) throws RemoteException {
        super.removeSecondary(object);
        Map map = (Map)this.bosMap.remove(object);
        if (map != null) {
            for (String string : map.keySet()) {
                StatefulRemoteObject statefulRemoteObject = (StatefulRemoteObject)map.get(string);
                if (statefulRemoteObject == null) continue;
                this.unexportBO(statefulRemoteObject, false);
            }
        }
    }

    private void unexportBO(StatefulRemoteObject statefulRemoteObject, boolean bl) {
        try {
            ServerHelper.unexportObject((Object)statefulRemoteObject, (boolean)true, (boolean)bl);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
    }

    public void releaseBOs(Object object) {
        Map map = (Map)this.bosMap.remove(object);
        if (this.getIsInMemoryReplication() && map != null) {
            for (String string : map.keySet()) {
                StatefulRemoteObject statefulRemoteObject = (StatefulRemoteObject)map.get(string);
                if (statefulRemoteObject == null) continue;
                this.unexportBO(statefulRemoteObject, false);
            }
        }
    }
}

