/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.internal;

import javax.ejb.ConcurrentAccessException;
import javax.ejb.EJBException;
import javax.ejb.EJBLocalObject;
import javax.ejb.NoSuchEJBException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.RemoveException;
import javax.transaction.Transaction;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.InternalException;
import weblogic.ejb.container.interfaces.BaseEJBLocalObjectIntf;
import weblogic.ejb.container.internal.BaseEJBLocalHome;
import weblogic.ejb.container.internal.EJBContextHandler;
import weblogic.ejb.container.internal.EJBRuntimeUtils;
import weblogic.ejb.container.internal.InvocationWrapper;
import weblogic.ejb.container.internal.MethodDescriptor;
import weblogic.ejb.container.internal.SecurityHelper;
import weblogic.ejb.container.internal.StatefulLocalObject;
import weblogic.ejb20.interfaces.LocalHandle;
import weblogic.ejb20.interfaces.PrincipalNotFoundException;
import weblogic.ejb20.internal.LocalHandleImpl;
import weblogic.j2ee.MethodInvocationHelper;
import weblogic.utils.AssertionError;

public abstract class StatefulEJBLocalObject
extends StatefulLocalObject
implements BaseEJBLocalObjectIntf {
    protected boolean isIdentical(MethodDescriptor methodDescriptor, EJBLocalObject eJBLocalObject) throws EJBException {
        if (super.isIdentical(methodDescriptor, eJBLocalObject)) {
            if (!(eJBLocalObject instanceof StatefulEJBLocalObject)) {
                return false;
            }
            StatefulEJBLocalObject statefulEJBLocalObject = (StatefulEJBLocalObject)eJBLocalObject;
            return this.primaryKey.equals(statefulEJBLocalObject.getPK());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void remove(MethodDescriptor methodDescriptor) throws RemoveException, EJBException {
        BaseEJBLocalHome baseEJBLocalHome = (BaseEJBLocalHome)this.getEJBLocalHome();
        Transaction transaction = null;
        InvocationWrapper invocationWrapper = null;
        try {
            block18: {
                baseEJBLocalHome.pushEnvironment();
                this.checkMethodPermissions(methodDescriptor, EJBContextHandler.EMPTY);
                MethodInvocationHelper.pushMethodObject(baseEJBLocalHome.getBeanInfo());
                SecurityHelper.pushCallerPrincipal();
                methodDescriptor.pushRunAsIdentity();
                invocationWrapper = this.isEJB30ClientView() ? EJBRuntimeUtils.createWrapWithTxsForBus(methodDescriptor, this.primaryKey) : EJBRuntimeUtils.createWrapWithTxs(methodDescriptor, this.primaryKey);
                transaction = invocationWrapper.getCallerTx();
                try {
                    baseEJBLocalHome.getBeanManager().remove(invocationWrapper);
                }
                catch (InternalException internalException) {
                    if (!this.isEJB30ClientView()) {
                        if (internalException.detail instanceof NoSuchEJBException) {
                            NoSuchObjectLocalException noSuchObjectLocalException = new NoSuchObjectLocalException(internalException.getMessage());
                            EJBRuntimeUtils.throwInternalException(internalException.getMessage(), (Throwable)noSuchObjectLocalException);
                        }
                        if (internalException.detail instanceof ConcurrentAccessException) {
                            throw new InternalException(internalException.getMessage());
                        }
                    }
                    throw internalException;
                }
                Object var8_8 = null;
                methodDescriptor.popRunAsIdentity();
                try {
                    SecurityHelper.popCallerPrincipal();
                    break block18;
                }
                catch (PrincipalNotFoundException principalNotFoundException) {
                    EJBLogger.logErrorPoppingCallerPrincipal((Exception)((Object)principalNotFoundException));
                }
                {
                    break block18;
                    catch (InternalException internalException) {
                        if (internalException.detail instanceof RemoveException) {
                            throw (RemoveException)internalException.detail;
                        }
                        baseEJBLocalHome.handleSystemException(invocationWrapper, internalException);
                        throw new AssertionError("should not reach");
                    }
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    methodDescriptor.popRunAsIdentity();
                    try {
                        SecurityHelper.popCallerPrincipal();
                    }
                    catch (PrincipalNotFoundException principalNotFoundException) {
                        EJBLogger.logErrorPoppingCallerPrincipal((Exception)((Object)principalNotFoundException));
                    }
                    MethodInvocationHelper.popMethodObject(baseEJBLocalHome.getBeanInfo());
                    throw throwable;
                }
            }
            MethodInvocationHelper.popMethodObject(baseEJBLocalHome.getBeanInfo());
            Object var11_13 = null;
            baseEJBLocalHome.popEnvironment();
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            baseEJBLocalHome.popEnvironment();
            try {
                EJBRuntimeUtils.resumeCallersTransaction(transaction, null);
            }
            catch (InternalException internalException) {
                EJBRuntimeUtils.throwEJBException(internalException);
            }
            throw throwable;
        }
        try {
            EJBRuntimeUtils.resumeCallersTransaction(transaction, null);
        }
        catch (InternalException internalException) {
            EJBRuntimeUtils.throwEJBException(internalException);
        }
    }

    public void remove() throws RemoveException {
        throw new Error("NYI");
    }

    public LocalHandle getLocalHandleObject() {
        if (debugLogger.isDebugEnabled()) {
            StatefulEJBLocalObject.debug("Getting handle in eo:" + this);
        }
        return new LocalHandleImpl(this, this.primaryKey);
    }

    private static void debug(String string) {
        debugLogger.debug("[StatefulEJBLocalObject] " + string);
    }
}

