/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.internal;

import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import javax.ejb.ConcurrentAccessException;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.ejb.NoSuchEJBException;
import javax.ejb.RemoveException;
import javax.transaction.Transaction;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.InternalException;
import weblogic.ejb.container.interfaces.StatefulEJBObjectIntf;
import weblogic.ejb.container.internal.BaseEJBHome;
import weblogic.ejb.container.internal.EJBContextHandler;
import weblogic.ejb.container.internal.EJBRuntimeUtils;
import weblogic.ejb.container.internal.InvocationWrapper;
import weblogic.ejb.container.internal.MethodDescriptor;
import weblogic.ejb.container.internal.SecurityHelper;
import weblogic.ejb.container.internal.StatefulEJBHome;
import weblogic.ejb.container.internal.StatefulRemoteObject;
import weblogic.ejb20.interfaces.PrincipalNotFoundException;
import weblogic.ejb20.internal.HandleImpl;
import weblogic.j2ee.MethodInvocationHelper;
import weblogic.logging.Loggable;
import weblogic.utils.AssertionError;

public abstract class StatefulEJBObject
extends StatefulRemoteObject
implements StatefulEJBObjectIntf {
    protected Handle getHandleObject() throws RemoteException {
        if (debugLogger.isDebugEnabled()) {
            StatefulEJBObject.debug("Getting handle in eo:" + this);
        }
        return new HandleImpl(this, this.primaryKey);
    }

    protected final Object getPrimaryKeyObject() throws RemoteException {
        Loggable loggable = EJBLogger.logsessionBeanCannotCallGetPrimaryKeyLoggable();
        throw new RemoteException(loggable.getMessage());
    }

    public boolean isIdentical(MethodDescriptor methodDescriptor, EJBObject eJBObject) throws RemoteException {
        if (super.isIdentical(methodDescriptor, eJBObject)) {
            StatefulEJBObjectIntf statefulEJBObjectIntf = (StatefulEJBObjectIntf)eJBObject;
            return this.primaryKey.equals(statefulEJBObjectIntf.getPK());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void remove(MethodDescriptor methodDescriptor) throws RemoteException, RemoveException {
        Transaction transaction = null;
        InvocationWrapper invocationWrapper = null;
        BaseEJBHome baseEJBHome = (BaseEJBHome)this.getEJBHome();
        try {
            block21: {
                baseEJBHome.pushEnvironment();
                this.checkMethodPermissions(methodDescriptor, EJBContextHandler.EMPTY);
                MethodInvocationHelper.pushMethodObject(baseEJBHome.getBeanInfo());
                SecurityHelper.pushCallerPrincipal();
                methodDescriptor.pushRunAsIdentity();
                invocationWrapper = !this.isImplementsRemote() ? EJBRuntimeUtils.createWrapWithTxsForBus(methodDescriptor, this.primaryKey) : EJBRuntimeUtils.createWrapWithTxs(methodDescriptor, this.primaryKey);
                transaction = invocationWrapper.getCallerTx();
                try {
                    baseEJBHome.getBeanManager().remove(invocationWrapper);
                }
                catch (InternalException internalException) {
                    if (this.isImplementsRemote()) {
                        Throwable throwable;
                        if (internalException.detail instanceof NoSuchEJBException) {
                            throwable = new NoSuchObjectException(internalException.getMessage());
                            EJBRuntimeUtils.throwInternalException(internalException.getMessage(), throwable);
                        }
                        if (internalException.detail instanceof ConcurrentAccessException) {
                            throwable = internalException.detail.getCause();
                            EJBRuntimeUtils.throwInternalException(internalException.getMessage(), throwable);
                        }
                    }
                    throw internalException;
                }
                Object var8_8 = null;
                StatefulEJBHome statefulEJBHome = (StatefulEJBHome)baseEJBHome;
                if (statefulEJBHome.getIsNoObjectActivation() || statefulEJBHome.getIsInMemoryReplication()) {
                    statefulEJBHome.releaseEO(this.primaryKey);
                    baseEJBHome.unexportEO(this, false);
                }
                methodDescriptor.popRunAsIdentity();
                try {
                    SecurityHelper.popCallerPrincipal();
                    break block21;
                }
                catch (PrincipalNotFoundException principalNotFoundException) {
                    EJBLogger.logErrorPoppingCallerPrincipal((Exception)((Object)principalNotFoundException));
                }
                {
                    break block21;
                    catch (InternalException internalException) {
                        if (internalException.detail instanceof RemoveException) {
                            throw (RemoveException)internalException.detail;
                        }
                        if (internalException.detail instanceof RemoteException) {
                            throw (RemoteException)internalException.detail;
                        }
                        baseEJBHome.handleSystemException(invocationWrapper, internalException);
                        throw new AssertionError("should not reach");
                    }
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    StatefulEJBHome statefulEJBHome2 = (StatefulEJBHome)baseEJBHome;
                    if (statefulEJBHome2.getIsNoObjectActivation() || statefulEJBHome2.getIsInMemoryReplication()) {
                        statefulEJBHome2.releaseEO(this.primaryKey);
                        baseEJBHome.unexportEO(this, false);
                    }
                    methodDescriptor.popRunAsIdentity();
                    try {
                        SecurityHelper.popCallerPrincipal();
                    }
                    catch (PrincipalNotFoundException principalNotFoundException) {
                        EJBLogger.logErrorPoppingCallerPrincipal((Exception)((Object)principalNotFoundException));
                    }
                    MethodInvocationHelper.popMethodObject(baseEJBHome.getBeanInfo());
                    throw throwable;
                }
            }
            MethodInvocationHelper.popMethodObject(baseEJBHome.getBeanInfo());
            Object var12_15 = null;
            baseEJBHome.popEnvironment();
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            baseEJBHome.popEnvironment();
            try {
                EJBRuntimeUtils.resumeCallersTransaction(transaction, null);
            }
            catch (InternalException internalException) {
                EJBRuntimeUtils.throwRemoteException(internalException);
            }
            throw throwable;
        }
        try {
            EJBRuntimeUtils.resumeCallersTransaction(transaction, null);
        }
        catch (InternalException internalException) {
            EJBRuntimeUtils.throwRemoteException(internalException);
        }
    }

    public void remove() throws RemoveException, RemoteException {
        throw new Error("NYI");
    }

    private static void debug(String string) {
        debugLogger.debug("[StatefulEJBObject] " + string);
    }
}

