/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.internal;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import weblogic.ejb.WLTimerInfo;
import weblogic.ejb.WLTimerService;
import weblogic.ejb.container.interfaces.TimerManager;
import weblogic.ejb.container.internal.BaseEJBContext;
import weblogic.ejb.container.internal.EntityEJBContextImpl;
import weblogic.utils.Debug;

public final class TimerServiceImpl
implements TimerService,
WLTimerService {
    private final TimerManager timerManager;
    private final BaseEJBContext ejbCtx;
    private final boolean isClustered;

    public TimerServiceImpl(TimerManager timerManager, BaseEJBContext baseEJBContext, boolean bl) {
        Debug.assertion((timerManager != null ? 1 : 0) != 0);
        this.timerManager = timerManager;
        this.ejbCtx = baseEJBContext;
        this.isClustered = bl;
    }

    public Timer createTimer(Date date, long l, Serializable serializable) {
        return this.createTimer(date, l, serializable, null);
    }

    public Timer createTimer(Date date, Serializable serializable) {
        return this.createTimer(date, serializable, null);
    }

    public Timer createTimer(long l, long l2, Serializable serializable) {
        return this.createTimer(l, l2, serializable, null);
    }

    public Timer createTimer(long l, Serializable serializable) {
        return this.createTimer(l, serializable, null);
    }

    public Timer createTimer(Date date, long l, Serializable serializable, WLTimerInfo wLTimerInfo) {
        this.ejbCtx.checkAllowedToUseTimerService();
        this.ensureWLTimerServiceSupport(wLTimerInfo);
        if (l <= 0L) {
            throw new IllegalArgumentException("The intervalDuration argument must be positive.  The value specified was: " + l);
        }
        if (date == null) {
            throw new IllegalArgumentException("The initialExpiration argument cannot be null.");
        }
        if (date.getTime() < 0L) {
            throw new IllegalArgumentException("The value of initialExpiration.getTime() cannot be negative.  The value specified was: " + date.getTime());
        }
        return this.timerManager.createTimer(this.getPK(), date, l, serializable, wLTimerInfo);
    }

    public Timer createTimer(Date date, Serializable serializable, WLTimerInfo wLTimerInfo) {
        this.ejbCtx.checkAllowedToUseTimerService();
        this.ensureWLTimerServiceSupport(wLTimerInfo);
        if (date == null) {
            throw new IllegalArgumentException("The expiration argument cannot be null.");
        }
        if (date.getTime() < 0L) {
            throw new IllegalArgumentException("The value of initialExpiration.getTime() cannot be negative.  The value specified was: " + date.getTime());
        }
        if (wLTimerInfo != null) {
            if (wLTimerInfo.getMaxTimeouts() > 0) {
                throw new IllegalArgumentException("The maxTimeouts property on the WLTimerInfo object can only be set for interval timers.  You are attempting to create a single-event timer.");
            }
            if (wLTimerInfo.getTimeoutFailureAction() == 3) {
                throw new IllegalArgumentException("The ejbTimeout failure action, 'SKIP_TIMEOUT_ACTION', can only be set for interval timers.  You are attempting to create a single-event timer.  Please reconfigure the ejbTimeout failure action on your WLTimerInfo object.");
            }
        }
        return this.timerManager.createTimer(this.getPK(), date, serializable, wLTimerInfo);
    }

    public Timer createTimer(long l, long l2, Serializable serializable, WLTimerInfo wLTimerInfo) {
        this.ejbCtx.checkAllowedToUseTimerService();
        this.ensureWLTimerServiceSupport(wLTimerInfo);
        if (l < 0L) {
            throw new IllegalArgumentException("The initialDuration argument must be positive.  The value specified was: " + l);
        }
        if (l2 <= 0L) {
            throw new IllegalArgumentException("The intervalDuration argument must be positive.  The value specified was: " + l2);
        }
        return this.timerManager.createTimer(this.getPK(), l, l2, serializable, wLTimerInfo);
    }

    public Timer createTimer(long l, Serializable serializable, WLTimerInfo wLTimerInfo) {
        this.ejbCtx.checkAllowedToUseTimerService();
        this.ensureWLTimerServiceSupport(wLTimerInfo);
        if (l < 0L) {
            throw new IllegalArgumentException("The duration argument must be positive.  The value specified was: " + l);
        }
        if (wLTimerInfo != null) {
            if (wLTimerInfo.getMaxTimeouts() > 0) {
                throw new IllegalArgumentException("The maxTimeouts property on the WLTimerInfo object can only be set for interval timers.  You are attempting to create a single-event timer.");
            }
            if (wLTimerInfo.getTimeoutFailureAction() == 3) {
                throw new IllegalArgumentException("The ejbTimeout failure action, 'SKIP_TIMEOUT_ACTION', can only be set for interval timers.  You are attempting to create a single-event timer.  Please reconfigure the ejbTimeout failure action on your WLTimerInfo object.");
            }
        }
        return this.timerManager.createTimer(this.getPK(), l, serializable, wLTimerInfo);
    }

    public Collection getTimers() {
        this.ejbCtx.checkAllowedToUseTimerService();
        return this.timerManager.getTimers(this.getPK());
    }

    private Object getPK() {
        if (this.ejbCtx instanceof EntityEJBContextImpl) {
            return ((EntityEJBContextImpl)this.ejbCtx).__WL_getPrimaryKey();
        }
        return new Integer(1);
    }

    private void ensureWLTimerServiceSupport(WLTimerInfo wLTimerInfo) {
        if (this.isClustered && wLTimerInfo != null) {
            throw new IllegalArgumentException("Error: the clustered EJB timer service does not support the methods of the WLTimerService interface.  Only methods declared on the javax.ejb.TimerService interface may be invoked.");
        }
    }
}

