/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.internal;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import weblogic.dbeans.ConversationImpl;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.InternalException;
import weblogic.ejb.container.cache.EntityCache;
import weblogic.ejb.container.cache.TxPk;
import weblogic.ejb.container.interfaces.BaseEJBHomeIntf;
import weblogic.ejb.container.interfaces.BeanInfo;
import weblogic.ejb.container.interfaces.BeanManager;
import weblogic.ejb.container.interfaces.EntityBeanInfo;
import weblogic.ejb.container.interfaces.InvalidationBeanManager;
import weblogic.ejb.container.internal.EJBRuntimeUtils;
import weblogic.ejb.container.manager.BaseEJBManager;
import weblogic.ejb.container.manager.BaseEntityManager;
import weblogic.ejb.container.manager.StatelessManager;
import weblogic.ejb.container.monitoring.EJBTransactionRuntimeMBeanImpl;
import weblogic.ejb.container.utils.PartialOrderSet;
import weblogic.utils.StackTraceUtils;
import weblogic.utils.collections.ArrayMap;

public final class TxManager {
    private final ConcurrentHashMap listeners = new ConcurrentHashMap();
    private final BaseEJBHomeIntf ejbHome;
    private final BaseEJBManager beanManager;
    private BeanInfo beanInfo;
    private boolean isBMP = false;
    private boolean isDead = false;
    private final EJBTransactionRuntimeMBeanImpl rtMBean;
    private InvalidationBeanManager invalidationTargetBeanManager = null;
    private boolean doOptimisticInvalidation = false;
    private int instanceLockOrder = 100;

    public TxManager(BeanManager beanManager) {
        this.beanManager = (BaseEJBManager)beanManager;
        this.ejbHome = this.beanManager.getEJBHome();
        this.beanInfo = this.beanManager.getBeanInfo();
        if (beanManager instanceof BaseEntityManager) {
            BaseEntityManager baseEntityManager = (BaseEntityManager)beanManager;
            EntityBeanInfo entityBeanInfo = (EntityBeanInfo)baseEntityManager.getBeanInfo();
            if (entityBeanInfo.isOptimistic() && entityBeanInfo.getCacheBetweenTransactions()) {
                this.doOptimisticInvalidation = true;
            }
            this.invalidationTargetBeanManager = entityBeanInfo.getInvalidationTargetBeanManager();
            this.instanceLockOrder = entityBeanInfo.getInstanceLockOrder();
            this.isBMP = baseEntityManager.isBeanManagedPersistence();
        }
        this.rtMBean = (EJBTransactionRuntimeMBeanImpl)beanManager.getEJBRuntimeMBean().getTransactionRuntime();
    }

    public void registerSynchronization(Object object, Transaction transaction) throws InternalException {
        try {
            if (this.handleRollback(transaction)) {
                return;
            }
            TxListener txListener = this.getListener(transaction);
            if (!(this.beanManager instanceof StatelessManager)) {
                txListener.addPrimaryKey(object);
            }
            if (this.isBMP) {
                txListener.addModifiedKey(object);
            }
        }
        catch (Exception exception) {
            EJBRuntimeUtils.throwInternalException("EJB Exception: ", exception);
        }
    }

    public boolean hasListener(Transaction transaction) {
        return this.listeners.get(transaction) != null;
    }

    private TxListener getListener(Transaction transaction) throws RollbackException, SystemException {
        TxListener txListener;
        TxListener txListener2 = (TxListener)this.listeners.get(transaction);
        if (txListener2 != null) {
            if (txListener2.beforeCompletionInvoked) {
                transaction.registerSynchronization((Synchronization)txListener2);
                txListener2.beforeCompletionInvoked = false;
            }
            return txListener2;
        }
        if (this.isDead) {
            transaction.rollback();
        }
        if ((txListener2 = this.listeners.putIfAbsent(transaction, txListener = new TxListener(transaction))) != null) {
            return txListener2;
        }
        transaction.registerSynchronization((Synchronization)txListener);
        return txListener;
    }

    public EntityCache getCache(Transaction transaction) {
        TxListener txListener = (TxListener)this.listeners.get(transaction);
        if (txListener == null) {
            return null;
        }
        ConversationImpl conversationImpl = txListener.getConversation();
        if (conversationImpl == null) {
            return null;
        }
        EntityCache entityCache = null;
        return entityCache;
    }

    public void setConversation(Transaction transaction, ConversationImpl conversationImpl) throws RollbackException, SystemException {
        TxListener txListener = this.getListener(transaction);
        txListener.setConversation(conversationImpl);
    }

    public PartialOrderSet getEnrolledKeys(Transaction transaction) {
        if (!this.hasListener(transaction)) {
            return null;
        }
        try {
            return this.getListener(transaction).getPrimaryKeys();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public ArrayList getNotModifiedOtherTxKeys(Transaction transaction) {
        ArrayList arrayList = new ArrayList();
        for (Transaction transaction2 : this.listeners.keySet()) {
            TxListener txListener;
            if (transaction2 == null || transaction2 == transaction || (txListener = (TxListener)this.listeners.get(transaction2)) == null) continue;
            arrayList.addAll(txListener.getNotModifiedKeys());
        }
        return arrayList;
    }

    public boolean isFlushPending(Transaction transaction, Object object) {
        if (!this.hasListener(transaction)) {
            return false;
        }
        try {
            return this.getListener(transaction).isFlushPending(object);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean needsToBeInserted(Transaction transaction, Object object) throws SystemException, RollbackException {
        TxListener txListener = this.getListener(transaction);
        return txListener.needsToBeInserted(object);
    }

    public ArrayList getFlushedKeys(Transaction transaction) {
        if (!this.hasListener(transaction)) {
            return null;
        }
        try {
            return this.getListener(transaction).getFlushedKeys();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private boolean handleRollback(Transaction transaction) throws SystemException {
        if (this.isDead) {
            transaction.rollback();
        }
        return this.isDead;
    }

    private TxListener getExistingListener(Transaction transaction) throws InternalException {
        try {
            if (this.handleRollback(transaction)) {
                return null;
            }
            return (TxListener)this.listeners.get(transaction);
        }
        catch (SystemException systemException) {
            EJBRuntimeUtils.throwInternalException("EJB Exception: ", systemException);
            throw new AssertionError();
        }
    }

    public void executeUpdateOperations(Transaction transaction, Set set, boolean bl, boolean bl2) throws InternalException {
        TxListener txListener = this.getExistingListener(transaction);
        if (txListener == null) {
            return;
        }
        txListener.executeUpdate(set, bl, bl2);
    }

    public void executeDeleteOperations(Transaction transaction, Set set, boolean bl, boolean bl2) throws InternalException {
        TxListener txListener = this.getExistingListener(transaction);
        if (txListener == null) {
            return;
        }
        txListener.executeDelete(set, bl, bl2);
    }

    public void executeInsertOperations(Transaction transaction, Set set, boolean bl, boolean bl2) throws InternalException {
        TxListener txListener = this.getExistingListener(transaction);
        if (txListener == null) {
            return;
        }
        txListener.executeInsert(set, bl, bl2);
    }

    public void registerInsertBean(Object object, Transaction transaction) throws InternalException {
        try {
            if (this.handleRollback(transaction)) {
                return;
            }
            TxListener txListener = this.getListener(transaction);
            txListener.addPrimaryKey(object);
            txListener.addInsertKey(object);
        }
        catch (Exception exception) {
            EJBRuntimeUtils.throwInternalException("EJB Exception: ", exception);
        }
    }

    public boolean registerDeleteBean(Object object, Transaction transaction) throws InternalException {
        try {
            if (this.handleRollback(transaction)) {
                return false;
            }
            return this.getListener(transaction).addDeleteKey(object);
        }
        catch (Exception exception) {
            EJBRuntimeUtils.throwInternalException("EJB Exception: ", exception);
            return false;
        }
    }

    public void registerInsertDeletedBean(Object object, Transaction transaction) throws InternalException {
        try {
            if (this.handleRollback(transaction)) {
                return;
            }
            this.getListener(transaction).addInsertDeletedKey(object);
        }
        catch (Exception exception) {
            EJBRuntimeUtils.throwInternalException("EJB Exception: ", exception);
        }
    }

    public void registerM2NJoinTableInsert(Object object, String string, Transaction transaction) throws InternalException {
        try {
            if (this.handleRollback(transaction)) {
                return;
            }
            this.getListener(transaction).addM2NJoinTableInsertMap(object, string);
        }
        catch (Exception exception) {
            EJBRuntimeUtils.throwInternalException("EJB Exception: ", exception);
        }
    }

    public void registerModifiedBean(Object object, Transaction transaction) throws InternalException {
        try {
            if (this.handleRollback(transaction)) {
                return;
            }
            this.getListener(transaction).addModifiedKey(object);
        }
        catch (Exception exception) {
            EJBRuntimeUtils.throwInternalException("EJB Exception: ", exception);
        }
    }

    public void registerInvalidatedBean(Object object, Transaction transaction) throws InternalException {
        try {
            if (this.handleRollback(transaction)) {
                return;
            }
            this.getListener(transaction).addInvalidationKey(object);
        }
        catch (Exception exception) {
            EJBRuntimeUtils.throwInternalException("EJB Exception: ", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterModifiedBean(Object object, Transaction transaction) throws InternalException {
        try {
            if (this.handleRollback(transaction)) {
                return;
            }
        }
        catch (Exception exception) {
            EJBRuntimeUtils.throwInternalException("EJB Exception: ", exception);
        }
        TxListener txListener = (TxListener)this.listeners.get(transaction);
        if (txListener == null) {
            ConcurrentHashMap concurrentHashMap = this.listeners;
            synchronized (concurrentHashMap) {
                txListener = (TxListener)this.listeners.get(transaction);
                if (txListener == null) {
                    throw new AssertionError((Object)"Fatal error: attempted to unregister an EJB 2.0 CMP bean that was not registered with a transaction.");
                }
            }
        }
        txListener.removeModifiedKey(object);
    }

    public void flushModifiedBeans(Transaction transaction) throws InternalException {
        this.flushModifiedBeans(transaction, false);
    }

    public void flushModifiedBeans(Transaction transaction, boolean bl) throws InternalException {
        weblogic.transaction.Transaction transaction2 = (weblogic.transaction.Transaction)transaction;
        Set set = (HashSet)transaction2.getLocalProperty("modifiedListeners");
        HashSet<Object> hashSet = (HashSet<Object>)transaction2.getLocalProperty("modifiedBMPListeners");
        Boolean bl2 = (Boolean)transaction2.getLocalProperty("alreadyOwned");
        boolean bl3 = false;
        if (bl2 == null) {
            transaction2.setLocalProperty("alreadyOwned", (Object)new Boolean(true));
            bl3 = true;
        } else {
            Set set2 = (Set)transaction2.getLocalProperty("currentIterationListeners");
            if (set != null) {
                Object object = new HashSet();
                ((AbstractCollection)object).addAll(set2);
                ((AbstractCollection)object).addAll(set);
                set = object;
            } else {
                set = set2;
            }
        }
        while (set != null) {
            transaction2.setLocalProperty("modifiedListeners", null);
            transaction2.setLocalProperty("currentIterationListeners", (Object)set);
            if (bl) {
                this.initializeFlushHistory(set);
            }
            for (Object object : set) {
                ((TxListener)object).flushModifiedKeys(bl);
                if (!((TxListener)object).isBMPListener()) continue;
                if (hashSet == null) {
                    hashSet = new HashSet<Object>();
                    transaction2.setLocalProperty("modifiedBMPListeners", hashSet);
                }
                hashSet.add(object);
            }
            set = (Set)transaction2.getLocalProperty("modifiedListeners");
        }
        if (bl3) {
            transaction2.setLocalProperty("alreadyOwned", null);
            transaction2.setLocalProperty("modifiedListeners", (Object)hashSet);
            transaction2.setLocalProperty("modifiedBMPListeners", null);
            transaction2.setLocalProperty("currentIterationListeners", null);
            bl3 = false;
        }
    }

    private void initializeFlushHistory(Set set) {
        if (set != null) {
            for (TxListener txListener : set) {
                txListener.initializeFlushHistory();
            }
        }
    }

    public void undeploy() {
        this.isDead = true;
        for (TxListener txListener : this.listeners.values()) {
            try {
                txListener.tx.rollback();
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (SystemException systemException) {
                EJBLogger.logIgnoreExcepOnRollback((String)this.beanInfo.getDisplayName(), (Exception)((Object)systemException));
            }
        }
    }

    private final class TxListener
    implements Synchronization {
        private static final boolean debug = false;
        private final Transaction tx;
        private final weblogic.transaction.Transaction wtx;
        private PartialOrderSet primaryKeys;
        private List modifiedKeys;
        private final List insertKeys;
        private final List deleteKeys;
        private final LinkedList invalidationKeys;
        private ArrayList flushedModifiedKeys = new ArrayList();
        private ArrayList flushedInsertKeys = null;
        private ArrayList flushedDeleteKeys = null;
        private ArrayList flushedKeys = null;
        private ArrayMap m2nJoinTableInsertMap;
        private ConversationImpl conversation = null;
        private EntityCache entityCache = null;
        private final ClassLoader cl;
        private boolean beforeCompletionInvoked;
        private boolean needsFlushModified;
        private boolean isJtaCallback;
        public static final String MODIFIED_LISTENERS = "modifiedListeners";
        public static final String MODIFIED_BMP_LISTENERS = "modifiedBMPListeners";
        public static final String CURRENT_ITERATION_LISTENERS = "currentIterationListeners";
        public static final String ALREADY_OWNED = "alreadyOwned";

        TxListener(Transaction transaction) {
            this.tx = transaction;
            this.wtx = (weblogic.transaction.Transaction)this.tx;
            this.primaryKeys = new PartialOrderSet(TxManager.this.instanceLockOrder);
            this.modifiedKeys = Collections.synchronizedList(new LinkedList());
            this.insertKeys = Collections.synchronizedList(new LinkedList());
            this.deleteKeys = Collections.synchronizedList(new LinkedList());
            this.m2nJoinTableInsertMap = null;
            this.beforeCompletionInvoked = false;
            this.needsFlushModified = false;
            this.isJtaCallback = true;
            this.invalidationKeys = TxManager.this.invalidationTargetBeanManager != null || TxManager.this.doOptimisticInvalidation ? new LinkedList() : null;
            this.cl = TxManager.this.beanInfo.getModuleClassLoader();
        }

        public void setConversation(ConversationImpl conversationImpl) {
            this.conversation = conversationImpl;
        }

        public ConversationImpl getConversation() {
            return this.conversation;
        }

        public boolean isBMPListener() {
            return TxManager.this.isBMP;
        }

        public void addPrimaryKey(Object object) {
            this.primaryKeys.add(object);
        }

        PartialOrderSet getPrimaryKeys() {
            return this.primaryKeys;
        }

        public ArrayList getNotModifiedKeys() {
            ArrayList<TxPk> arrayList = new ArrayList<TxPk>();
            for (Object e : this.primaryKeys) {
                if (this.isFlushPending(e)) continue;
                arrayList.add(new TxPk(this.tx, e));
            }
            return arrayList;
        }

        private void enrollAsModifiedListener() {
            this.needsFlushModified = false;
            HashSet<TxListener> hashSet = (HashSet<TxListener>)this.wtx.getLocalProperty(MODIFIED_LISTENERS);
            if (hashSet == null) {
                hashSet = new HashSet<TxListener>();
                this.wtx.setLocalProperty(MODIFIED_LISTENERS, hashSet);
            }
            hashSet.add(this);
        }

        public boolean isFlushPending(Object object) {
            if (this.modifiedKeys.contains(object)) {
                return true;
            }
            if (this.insertKeys.contains(object)) {
                return true;
            }
            return this.deleteKeys.contains(object);
        }

        public void addModifiedKey(Object object) {
            if (this.modifiedKeys.isEmpty()) {
                this.enrollAsModifiedListener();
            }
            this.modifiedKeys.add(object);
            if (this.invalidationKeys != null) {
                this.invalidationKeys.add(object);
            }
        }

        public void addInvalidationKey(Object object) {
            if (this.invalidationKeys != null) {
                this.invalidationKeys.add(object);
            }
        }

        public void removeModifiedKey(Object object) {
            this.modifiedKeys.remove(object);
            if (this.modifiedKeys.isEmpty() && this.insertKeys.isEmpty() && this.deleteKeys.isEmpty()) {
                this.needsFlushModified = true;
                Set set = (Set)this.wtx.getLocalProperty(MODIFIED_LISTENERS);
                if (set != null) {
                    set.remove(this);
                }
            }
        }

        public void addInsertKey(Object object) {
            if (this.insertKeys.isEmpty()) {
                this.enrollAsModifiedListener();
            }
            this.insertKeys.add(object);
        }

        public boolean needsToBeInserted(Object object) {
            return this.insertKeys.contains(object);
        }

        public boolean addDeleteKey(Object object) {
            if (this.insertKeys.remove(object)) {
                this.removeModifiedKey(object);
                return false;
            }
            if (this.deleteKeys.isEmpty()) {
                this.enrollAsModifiedListener();
            }
            this.deleteKeys.add(object);
            if (this.invalidationKeys != null) {
                this.invalidationKeys.add(object);
            }
            return true;
        }

        public void addInsertDeletedKey(Object object) {
            if (this.deleteKeys.remove(object) && !this.modifiedKeys.contains(object)) {
                this.addModifiedKey(object);
            }
        }

        public void addM2NJoinTableInsertMap(Object object, String string) {
            ArrayList<Object> arrayList;
            if (this.m2nJoinTableInsertMap == null) {
                this.m2nJoinTableInsertMap = new ArrayMap();
            }
            if ((arrayList = (ArrayList<Object>)this.m2nJoinTableInsertMap.get((Object)string)) == null) {
                arrayList = new ArrayList<Object>();
                this.m2nJoinTableInsertMap.put((Object)string, arrayList);
            }
            if (!arrayList.contains(object)) {
                arrayList.add(object);
            }
        }

        private ArrayList getFlushedKeys() {
            if (this.flushedModifiedKeys == null && this.flushedInsertKeys == null && this.flushedDeleteKeys == null) {
                return null;
            }
            if (this.flushedKeys == null) {
                this.flushedKeys = new ArrayList();
            } else {
                this.flushedKeys.clear();
            }
            if (this.flushedModifiedKeys != null) {
                this.flushedKeys.addAll(this.flushedModifiedKeys);
            }
            if (this.flushedInsertKeys != null) {
                this.flushedKeys.addAll(this.flushedInsertKeys);
            }
            if (this.flushedDeleteKeys != null) {
                this.flushedKeys.addAll(this.flushedDeleteKeys);
            }
            return this.flushedKeys;
        }

        public void executeDBOperations(boolean bl, boolean bl2) throws InternalException {
            HashSet hashSet = new HashSet();
            this.executeInsert(hashSet, bl, bl2);
            hashSet.clear();
            this.executeUpdate(hashSet, bl, bl2);
            hashSet.clear();
            this.executeDelete(hashSet, bl, bl2);
            this.executeM2NJoinTableInserts(bl2);
        }

        private void executeDelete(Set set, boolean bl, boolean bl2) throws InternalException {
            Set set2;
            ((BaseEntityManager)TxManager.this.beanManager).executeDeleteStmt(this.deleteKeys, this.tx, set, bl, bl2, this.flushedDeleteKeys);
            this.deleteKeys.clear();
            if (!bl && (set2 = (Set)this.wtx.getLocalProperty(MODIFIED_LISTENERS)) != null) {
                set2.remove(this);
            }
        }

        private void executeUpdate(Set set, boolean bl, boolean bl2) throws InternalException {
            ((BaseEntityManager)TxManager.this.beanManager).executeUpdateStmt(this.modifiedKeys, this.tx, set, bl, bl2, this.flushedModifiedKeys);
            this.modifiedKeys.clear();
        }

        private void executeInsert(Set set, boolean bl, boolean bl2) throws InternalException {
            if (bl) {
                this.flushModifiedKeys(bl2);
            } else {
                this.isJtaCallback = false;
                this.beforeCompletion();
            }
            this.isJtaCallback = true;
            ((BaseEntityManager)TxManager.this.beanManager).executeInsertStmt(this.insertKeys, this.tx, set, bl, bl2, this.flushedInsertKeys);
            this.insertKeys.clear();
        }

        public void executeM2NJoinTableInserts(boolean bl) throws InternalException {
            if (this.m2nJoinTableInsertMap == null) {
                return;
            }
            ((BaseEntityManager)TxManager.this.beanManager).executeM2NJoinTableInserts((Map)this.m2nJoinTableInsertMap, this.tx, bl);
            this.m2nJoinTableInsertMap.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void afterCompletion(int n) {
            Object object;
            if (n == 3) {
                TxManager.this.rtMBean.incrementTransactionsCommitted();
            } else {
                TxManager.this.rtMBean.incrementTransactionsRolledBack();
                object = (weblogic.transaction.Transaction)this.tx;
                if (object.isTimedOut()) {
                    TxManager.this.rtMBean.incrementTransactionsTimedOut();
                }
            }
            if (TxManager.this.beanManager instanceof StatelessManager) {
                TxManager.this.listeners.remove(this.tx);
                return;
            }
            object = Thread.currentThread();
            ClassLoader classLoader = ((Thread)object).getContextClassLoader();
            try {
                block14: {
                    block15: {
                        ((Thread)object).setContextClassLoader(this.cl);
                        TxManager.this.ejbHome.pushEnvironment();
                        if (this.invalidationKeys == null || this.invalidationKeys.isEmpty() || n != 3) break block15;
                        if (TxManager.this.doOptimisticInvalidation) {
                            try {
                                try {
                                    ((InvalidationBeanManager)((Object)TxManager.this.beanManager)).invalidate((Object)this.tx, this.invalidationKeys);
                                }
                                catch (InternalException internalException) {
                                    EJBLogger.logExceptionDuringROInvalidation((String)TxManager.this.beanInfo.getDisplayName(), (String)StackTraceUtils.throwable2StackTrace((Throwable)internalException));
                                    Object var6_5 = null;
                                    TxManager.this.beanManager.afterCompletion(this.primaryKeys, this.tx, n, this.entityCache);
                                    break block14;
                                }
                                Object var6_4 = null;
                            }
                            catch (Throwable throwable) {
                                Object var6_6 = null;
                                TxManager.this.beanManager.afterCompletion(this.primaryKeys, this.tx, n, this.entityCache);
                                throw throwable;
                            }
                            TxManager.this.beanManager.afterCompletion(this.primaryKeys, this.tx, n, this.entityCache);
                            break block14;
                        } else {
                            TxManager.this.beanManager.afterCompletion(this.primaryKeys, this.tx, n, this.entityCache);
                            try {
                                TxManager.this.invalidationTargetBeanManager.invalidate(null, this.invalidationKeys);
                            }
                            catch (InternalException internalException) {
                                EJBLogger.logExceptionDuringROInvalidation((String)TxManager.this.beanInfo.getDisplayName(), (String)StackTraceUtils.throwable2StackTrace((Throwable)internalException));
                            }
                        }
                        break block14;
                    }
                    TxManager.this.beanManager.afterCompletion(this.primaryKeys, this.tx, n, this.entityCache);
                }
                Object var8_10 = null;
                ((Thread)object).setContextClassLoader(classLoader);
                TxManager.this.listeners.remove(this.tx);
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                ((Thread)object).setContextClassLoader(classLoader);
                TxManager.this.listeners.remove(this.tx);
                TxManager.this.ejbHome.popEnvironment();
                throw throwable;
            }
            TxManager.this.ejbHome.popEnvironment();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void beforeCompletion() {
            if (TxManager.this.beanManager instanceof StatelessManager) {
                return;
            }
            Thread thread2 = Thread.currentThread();
            ClassLoader classLoader = thread2.getContextClassLoader();
            try {
                block10: {
                    try {
                        thread2.setContextClassLoader(this.cl);
                        TxManager.this.ejbHome.pushEnvironment();
                        if (!this.beforeCompletionInvoked) {
                            boolean bl = false;
                            PartialOrderSet partialOrderSet = this.primaryKeys;
                            try {
                                while (!this.primaryKeys.isEmpty()) {
                                    if (bl) {
                                        this.addToPartialOrderSet(partialOrderSet, this.primaryKeys);
                                    }
                                    PartialOrderSet partialOrderSet2 = this.primaryKeys;
                                    this.primaryKeys = new PartialOrderSet(TxManager.this.instanceLockOrder);
                                    TxManager.this.beanManager.beforeCompletion(partialOrderSet2, this.tx);
                                    bl = true;
                                }
                                Object var7_7 = null;
                                this.primaryKeys = partialOrderSet;
                                this.beforeCompletionInvoked = true;
                            }
                            catch (Throwable throwable) {
                                Object var7_8 = null;
                                this.primaryKeys = partialOrderSet;
                                this.beforeCompletionInvoked = true;
                                throw throwable;
                            }
                        }
                        if (!(TxManager.this.beanManager instanceof BaseEntityManager) || !((BaseEntityManager)TxManager.this.beanManager).getOrderDatabaseOperations() || !this.isJtaCallback) break block10;
                        this.executeDBOperations(false, false);
                    }
                    catch (InternalException internalException) {
                        EJBRuntimeUtils.throwRuntimeException("Error in beforeCompletion", internalException);
                        Object var9_11 = null;
                        thread2.setContextClassLoader(classLoader);
                        TxManager.this.ejbHome.popEnvironment();
                    }
                }
                Object var9_10 = null;
                thread2.setContextClassLoader(classLoader);
                TxManager.this.ejbHome.popEnvironment();
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                thread2.setContextClassLoader(classLoader);
                TxManager.this.ejbHome.popEnvironment();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flushModifiedKeys(boolean bl) throws InternalException {
            if (this.needsFlushModified) {
                return;
            }
            this.needsFlushModified = true;
            try {
                TxManager.this.ejbHome.pushEnvironment();
                List list = this.modifiedKeys;
                boolean bl2 = false;
                while (!this.modifiedKeys.isEmpty()) {
                    if (bl2) {
                        list.addAll(this.modifiedKeys);
                    }
                    ArrayList arrayList = new ArrayList();
                    ArrayList arrayList2 = this.modifiedKeys;
                    synchronized (arrayList2) {
                        for (Object object : this.modifiedKeys) {
                            if (object == null) continue;
                            arrayList.add(object);
                        }
                    }
                    this.modifiedKeys = Collections.synchronizedList(new LinkedList());
                    arrayList2 = new ArrayList();
                    ArrayList arrayList3 = this.flushedModifiedKeys;
                    synchronized (arrayList3) {
                        Object object;
                        object = this.flushedModifiedKeys.iterator();
                        while (object.hasNext()) {
                            Object e = object.next();
                            if (e == null) continue;
                            arrayList2.add(e);
                        }
                    }
                    ((BaseEntityManager)TxManager.this.beanManager).flushModified(arrayList, this.tx, bl, arrayList2);
                    bl2 = true;
                }
                this.modifiedKeys = list;
                this.needsFlushModified = true;
                if (((BaseEntityManager)TxManager.this.beanManager).getOrderDatabaseOperations()) {
                    if (this.isJtaCallback) {
                        this.executeDBOperations(true, bl);
                    }
                } else if (TxManager.this.isBMP) {
                    this.needsFlushModified = false;
                } else {
                    this.modifiedKeys.clear();
                }
                Object var11_11 = null;
                TxManager.this.ejbHome.popEnvironment();
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                TxManager.this.ejbHome.popEnvironment();
                throw throwable;
            }
        }

        private void addToPartialOrderSet(Collection collection, Collection collection2) {
            for (Object e : collection2) {
                if (e == null) continue;
                collection.add(e);
            }
        }

        protected void initializeFlushHistory() {
            if (this.flushedModifiedKeys != null) {
                this.flushedModifiedKeys.clear();
            } else {
                this.flushedModifiedKeys = new ArrayList();
            }
            if (this.flushedInsertKeys != null) {
                this.flushedInsertKeys.clear();
            } else {
                this.flushedInsertKeys = new ArrayList();
            }
            if (this.flushedDeleteKeys != null) {
                this.flushedDeleteKeys.clear();
            } else {
                this.flushedDeleteKeys = new ArrayList();
            }
            if (this.flushedKeys != null) {
                this.flushedKeys.clear();
            } else {
                this.flushedKeys = new ArrayList();
            }
        }
    }
}

