/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.internal;

import weblogic.ejb.container.interfaces.BeanManager;
import weblogic.ejb.container.interfaces.ClientDrivenBeanInfo;
import weblogic.ejb.container.internal.BaseWSLocalObject;
import weblogic.ejb.spi.BaseWSObjectIntf;
import weblogic.ejb.spi.WSObjectFactory;
import weblogic.utils.Debug;

public class WSObjectFactoryImpl
implements WSObjectFactory {
    private final Class wsoClass;
    private final BeanManager beanManager;
    private final ClientDrivenBeanInfo cdBeanInfo;

    public WSObjectFactoryImpl(BeanManager beanManager, ClientDrivenBeanInfo clientDrivenBeanInfo) {
        this.beanManager = beanManager;
        this.cdBeanInfo = clientDrivenBeanInfo;
        this.wsoClass = this.cdBeanInfo.getWebserviceObjectClass();
    }

    public BaseWSObjectIntf create() {
        Debug.assertion((this.wsoClass != null ? 1 : 0) != 0, (String)"webservice object class is NULL !");
        BaseWSLocalObject baseWSLocalObject = null;
        try {
            baseWSLocalObject = (BaseWSLocalObject)this.wsoClass.newInstance();
        }
        catch (Exception exception) {
            throw new AssertionError((Object)("Exception attempting to create new webservice object class '" + this.wsoClass.getName() + "'  " + exception.getMessage()));
        }
        baseWSLocalObject.setBeanManager(this.beanManager);
        baseWSLocalObject.setBeanInfo(this.cdBeanInfo);
        return baseWSLocalObject;
    }
}

