/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.internal.usertransactioncheck;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;

public class BaseUserTransactionProxy
implements UserTransaction {
    private boolean isEntityBean;
    private UserTransaction delegate;

    public BaseUserTransactionProxy(boolean bl, UserTransaction userTransaction) {
        this.isEntityBean = bl;
        this.delegate = userTransaction;
    }

    public void begin() throws NotSupportedException, SystemException {
        this.checkAllowedInvoke();
        this.delegate.begin();
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        this.checkAllowedInvoke();
        this.delegate.commit();
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        this.checkAllowedInvoke();
        this.delegate.rollback();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.checkAllowedInvoke();
        this.delegate.setRollbackOnly();
    }

    public int getStatus() throws SystemException {
        this.checkAllowedInvoke();
        return this.delegate.getStatus();
    }

    public void setTransactionTimeout(int n) throws SystemException {
        this.checkAllowedInvoke();
        this.delegate.setTransactionTimeout(n);
    }

    protected void checkAllowedInvoke() {
        if (this.isEntityBean) {
            throw new IllegalStateException("It is illegal to invoke UserTransaction methods in entity bean.");
        }
    }
}

