/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.locks;

import javax.ejb.EJBException;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.ejb.container.EJBDebugService;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.interfaces.BeanInfo;
import weblogic.ejb.container.locks.LockManager;
import weblogic.ejb.container.monitoring.EJBLockingRuntimeMBeanImpl;
import weblogic.ejb20.locks.LockTimedOutException;
import weblogic.logging.Loggable;
import weblogic.management.runtime.EJBLockingRuntimeMBean;

public final class ExclusiveLockManager
implements LockManager {
    private static final DebugLogger debugLogger = EJBDebugService.lockingLogger;
    private BeanInfo bi;
    private LockBucket[] buckets;
    private int bucketCount;
    private final EJBLockingRuntimeMBeanImpl mBean;

    private static int getBucketForPk(Object object, int n) {
        return Math.abs(object.hashCode() % n);
    }

    private int getBucketForPk(Object object) {
        return ExclusiveLockManager.getBucketForPk(object, this.bucketCount);
    }

    public ExclusiveLockManager(EJBLockingRuntimeMBean eJBLockingRuntimeMBean) {
        this.mBean = (EJBLockingRuntimeMBeanImpl)eJBLockingRuntimeMBean;
    }

    public void setup(BeanInfo beanInfo) {
        this.bi = beanInfo;
        int n = beanInfo.getCachingDescriptor().getMaxBeansInCache();
        this.setup(n, this.bi.getEJBName());
    }

    private void setup(int n, String string) {
        this.bucketCount = n / 10 + 1;
        if (this.bucketCount < 11) {
            this.bucketCount = 11;
        }
        this.buckets = new LockBucket[this.bucketCount];
        for (int i = 0; i < this.bucketCount; ++i) {
            this.buckets[i] = new LockBucket(string, this.mBean);
        }
    }

    public Object getOwner(Object object) {
        int n = this.getBucketForPk(object);
        return this.buckets[n].getOwner(object);
    }

    public boolean lock(Object object, Object object2, int n) throws LockTimedOutException {
        int n2 = this.getBucketForPk(object);
        return this.buckets[n2].lock(object, object2, n);
    }

    public void unlock(Object object, Object object2) {
        int n = this.getBucketForPk(object);
        this.buckets[n].unlock(object, object2);
    }

    private static void debug(String string) {
        debugLogger.debug("[ExclusiveLockManager] " + string);
    }

    private static final class LockWaiter {
        private final long waitMS;
        private final Object lockClient;
        private volatile boolean youThaMan;
        private boolean isTimedOut = false;
        public LockWaiter next;

        public LockWaiter(long l, Object object) {
            this.waitMS = l;
            this.lockClient = object;
            this.youThaMan = false;
            this.next = null;
        }
    }

    private static final class LockEntry
    implements Cloneable {
        private final Object pk;
        private volatile Object owner;
        private LockWaiter waiters;
        public LockEntry next;

        public LockEntry(Object object, Object object2, LockEntry lockEntry) {
            this.pk = object;
            this.owner = object2;
            this.next = lockEntry;
        }

        public void addWaiter(LockWaiter lockWaiter) {
            if (this.waiters == null) {
                this.waiters = lockWaiter;
            } else {
                LockWaiter lockWaiter2 = this.waiters;
                while (lockWaiter2.next != null) {
                    lockWaiter2 = lockWaiter2.next;
                }
                lockWaiter2.next = lockWaiter;
            }
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        public LockWaiter getNextValidWaiter() {
            while (this.waiters != null) {
                if (!this.waiters.isTimedOut) {
                    LockWaiter lockWaiter = this.waiters.next;
                    LockWaiter lockWaiter2 = this.waiters;
                    this.waiters = lockWaiter;
                    if (debugLogger.isDebugEnabled()) {
                        ExclusiveLockManager.debug("Returning Valid Waiter : " + lockWaiter2.lockClient);
                    }
                    return lockWaiter2;
                }
                if (debugLogger.isDebugEnabled()) {
                    ExclusiveLockManager.debug("Client : " + this.waiters.lockClient + " timedout ... after " + this.waiters.waitMS);
                }
                this.waiters = this.waiters.next;
            }
            return null;
        }
    }

    private static final class LockBucket {
        private LockEntry lockEntries;
        private final String ejbName;
        private final EJBLockingRuntimeMBeanImpl mBean;

        LockBucket(String string, EJBLockingRuntimeMBeanImpl eJBLockingRuntimeMBeanImpl) {
            this.ejbName = string;
            this.mBean = eJBLockingRuntimeMBeanImpl;
            this.lockEntries = null;
        }

        private static boolean eq(Object object, Object object2) {
            return object == object2 || object.equals(object2);
        }

        private LockEntry findEntryForPK(Object object) {
            LockEntry lockEntry = this.lockEntries;
            while (lockEntry != null) {
                if (LockBucket.eq(object, lockEntry.pk)) {
                    return lockEntry;
                }
                lockEntry = lockEntry.next;
            }
            return null;
        }

        public synchronized Object getOwner(Object object) {
            LockEntry lockEntry = this.findEntryForPK(object);
            if (lockEntry == null) {
                return null;
            }
            return lockEntry.owner;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean lock(Object object, Object object2, int n) throws LockTimedOutException {
            LockWaiter lockWaiter;
            this.mBean.incrementLockManagerAccessCount();
            Object object3 = this;
            synchronized (object3) {
                LockEntry lockEntry = this.findEntryForPK(object);
                assert (lockEntry == null || lockEntry.owner != null) : "Lock Entry for pk: " + object + " with lockClient: " + object2 + " was unowned.";
                if (lockEntry == null) {
                    this.lockEntries = lockEntry = new LockEntry(object, object2, this.lockEntries);
                    this.mBean.incrementLockEntriesCurrentCount();
                    if (debugLogger.isDebugEnabled()) {
                        ExclusiveLockManager.debug("** LOCK ACQUIRE --> SUCCESSFUL -- ejb-name: " + this.ejbName + " primary key: " + object + " lockClient: " + object2 + " wait (MS): " + n);
                    }
                    return false;
                }
                if (LockBucket.eq(object2, lockEntry.owner)) {
                    if (debugLogger.isDebugEnabled()) {
                        ExclusiveLockManager.debug("** LOCK ACQUIRE --> SUCCESSFUL (ALREADY OWNED) -- ejb-name: " + this.ejbName + " primary key: " + object + " lockClient: " + object2 + " wait (MS): " + n);
                    }
                    return true;
                }
                if (n == 0) {
                    if (debugLogger.isDebugEnabled()) {
                        ExclusiveLockManager.debug("** LOCK ACQUIRE --> FAILED (NO_WAIT) -- ejb-name: " + this.ejbName + " primary key: " + object + " lockClient: " + object2 + " wait (MS): " + n);
                    }
                    this.mBean.incrementTimeoutTotalCount();
                    Loggable loggable = EJBLogger.loglockRequestTimeOutLoggable((String)this.ejbName, (Object)object, (Object)object2, (long)0L);
                    throw new LockTimedOutException(loggable.getMessage());
                }
                lockWaiter = new LockWaiter(n, object2);
                lockEntry.addWaiter(lockWaiter);
                if (debugLogger.isDebugEnabled()) {
                    ExclusiveLockManager.debug("** LOCK ACQUIRE --> WAITING -- ejb-name: " + this.ejbName + " primary key: " + object + " lockClient: " + object2 + " wait (MS): " + n);
                }
            }
            assert (lockWaiter != null);
            object3 = lockWaiter;
            synchronized (object3) {
                if (!lockWaiter.youThaMan) {
                    this.mBean.incrementWaiterTotalCount();
                    this.mBean.incrementWaiterCurrentCount();
                    try {
                        lockWaiter.wait(lockWaiter.waitMS);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.mBean.decrementWaiterCurrentCount();
                }
                if (!lockWaiter.youThaMan) {
                    this.mBean.incrementTimeoutTotalCount();
                    if (debugLogger.isDebugEnabled()) {
                        ExclusiveLockManager.debug("** LOCK TIME OUT AFTER WAITING -- ejb-name: " + this.ejbName + " primary key: " + object + " lockClient: " + object2 + " wait (MS): " + n);
                    }
                    lockWaiter.isTimedOut = true;
                    Loggable loggable = EJBLogger.loglockRequestTimeOutLoggable((String)this.ejbName, (Object)object, (Object)object2, (long)n);
                    throw new LockTimedOutException(loggable.getMessage());
                }
                if (debugLogger.isDebugEnabled()) {
                    ExclusiveLockManager.debug("** LOCK ACQUIRE (AFTER WAITING) -- ejb-name: " + this.ejbName + " primary key: " + object + " lockClient: " + object2 + " wait (MS): " + n);
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void unlock(Object object, Object object2) {
            LockEntry lockEntry = null;
            LockEntry lockEntry2 = this.lockEntries;
            while (lockEntry2 != null && lockEntry2.pk != object && !lockEntry2.pk.equals(object)) {
                lockEntry = lockEntry2;
                lockEntry2 = lockEntry2.next;
            }
            if (lockEntry2 == null) {
                Loggable loggable = EJBLogger.logunlockCouldNotFindPkLoggable((String)this.ejbName, (Object)object, (Object)object.getClass().getName());
                throw new EJBException(loggable.getMessage());
            }
            if (lockEntry2.waiters == null) {
                this.removeEntry(lockEntry2, lockEntry);
                if (debugLogger.isDebugEnabled()) {
                    ExclusiveLockManager.debug("** LOCK UNLOCK -- ejb-name: " + this.ejbName + " primary key: " + object + " lockClient: " + object2 + " waiters: NONE");
                }
            } else {
                LockWaiter lockWaiter = lockEntry2.getNextValidWaiter();
                if (lockWaiter == null) {
                    this.removeEntry(lockEntry2, lockEntry);
                    if (debugLogger.isDebugEnabled()) {
                        ExclusiveLockManager.debug("** LOCK UNLOCK -- ejb-name: " + this.ejbName + " primary key: " + object + " lockClient: " + object2 + " waiters: NONE");
                    }
                } else {
                    lockEntry2.owner = lockWaiter.lockClient;
                    LockWaiter lockWaiter2 = lockWaiter;
                    synchronized (lockWaiter2) {
                        lockWaiter.youThaMan = true;
                        lockWaiter.notify();
                    }
                    if (debugLogger.isDebugEnabled()) {
                        ExclusiveLockManager.debug("** LOCK UNLOCK -- ejb-name: " + this.ejbName + " primary key: " + object + " lockClient: " + object2 + " waiters: YES" + " new owner: " + lockWaiter.lockClient);
                    }
                }
            }
        }

        private void removeEntry(LockEntry lockEntry, LockEntry lockEntry2) {
            this.mBean.decrementLockEntriesCurrentCount();
            if (lockEntry2 == null) {
                this.lockEntries = lockEntry.next;
            } else {
                lockEntry2.next = lockEntry.next;
            }
        }
    }
}

