/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.manager;

import java.lang.reflect.Method;
import java.rmi.NoSuchObjectException;
import java.util.Collection;
import java.util.Enumeration;
import javax.ejb.EJBContext;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.EnterpriseBean;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.ejb.NoSuchEJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.Context;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.ejb.container.EJBDebugService;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.InternalException;
import weblogic.ejb.container.interfaces.BaseEJBHomeIntf;
import weblogic.ejb.container.interfaces.BaseEJBLocalHomeIntf;
import weblogic.ejb.container.interfaces.BaseEJBRemoteHomeIntf;
import weblogic.ejb.container.interfaces.BeanInfo;
import weblogic.ejb.container.interfaces.BeanManager;
import weblogic.ejb.container.interfaces.EjbComponentCreator;
import weblogic.ejb.container.interfaces.SecurityRoleReference;
import weblogic.ejb.container.interfaces.TimerManager;
import weblogic.ejb.container.interfaces.WLEnterpriseBean;
import weblogic.ejb.container.internal.AllowedMethodsHelper;
import weblogic.ejb.container.internal.BaseEJBContext;
import weblogic.ejb.container.internal.EJBComponentRuntimeMBeanImpl;
import weblogic.ejb.container.internal.EJBContextManager;
import weblogic.ejb.container.internal.EJBRuntimeUtils;
import weblogic.ejb.container.internal.InvocationWrapper;
import weblogic.ejb.container.internal.ManagerHelper;
import weblogic.ejb.container.internal.TxManager;
import weblogic.ejb.container.timer.EJBTimerManagerFactory;
import weblogic.ejb.spi.WLDeploymentException;
import weblogic.management.runtime.EJBRuntimeMBean;
import weblogic.management.runtime.EJBTimerRuntimeMBean;
import weblogic.security.service.EJBResource;
import weblogic.utils.Debug;

public abstract class BaseEJBManager
implements BeanManager {
    protected static final DebugLogger debugLogger = EJBDebugService.invokeLogger;
    private EJBRuntimeMBean runtimeMBean;
    private EJBComponentRuntimeMBeanImpl componentRuntime;
    private ManagerHelper helper;
    private EJBResource ejbResource;
    private boolean writableInitialized = false;
    protected BaseEJBHomeIntf ejbHome;
    protected BaseEJBRemoteHomeIntf remoteHome;
    protected BaseEJBLocalHomeIntf localHome;
    protected Class beanClass;
    protected Context environmentContext;
    protected boolean usesBeanManagedTx;
    protected BeanInfo beanInfo;
    protected EjbComponentCreator ejbComponentCreator;
    protected TimerManager timerManager;
    protected TxManager txManager;
    boolean isDeployed = false;

    public BaseEJBManager(EJBComponentRuntimeMBeanImpl eJBComponentRuntimeMBeanImpl) {
        this.componentRuntime = eJBComponentRuntimeMBeanImpl;
    }

    public void setup(BaseEJBRemoteHomeIntf baseEJBRemoteHomeIntf, BaseEJBLocalHomeIntf baseEJBLocalHomeIntf, BeanInfo beanInfo, Context context) throws WLDeploymentException {
        this.beanInfo = beanInfo;
        this.remoteHome = baseEJBRemoteHomeIntf;
        this.localHome = baseEJBLocalHomeIntf;
        if (baseEJBRemoteHomeIntf != null) {
            this.ejbHome = baseEJBRemoteHomeIntf;
        } else if (baseEJBLocalHomeIntf != null) {
            this.ejbHome = baseEJBLocalHomeIntf;
        }
        assert (context != null);
        this.environmentContext = context;
        this.createEJBTimerManager();
        this.usesBeanManagedTx = beanInfo.usesBeanManagedTx();
        this.ejbComponentCreator = beanInfo.getEjbComponentCreator();
    }

    public void setIsDeployed(boolean bl) {
        this.isDeployed = bl;
    }

    protected void createEJBTimerManager() {
        if (this.beanInfo.isTimerDriven()) {
            this.timerManager = EJBTimerManagerFactory.createEJBTimerManager(this);
        }
    }

    public boolean getIsDeployed() {
        return this.isDeployed;
    }

    public BaseEJBHomeIntf getEJBHome() {
        return this.ejbHome;
    }

    public TxManager getTxManager() {
        return this.txManager;
    }

    public void preInvoke() throws InternalException {
        if (!this.isDeployed) {
            EJBRuntimeUtils.throwInternalException("Exception during invoke.", (Throwable)new NoSuchEJBException("Bean is already undeployed."));
        }
    }

    public void businessReady(InvocationWrapper invocationWrapper) {
    }

    public void setEJBRuntimeMBean(EJBRuntimeMBean eJBRuntimeMBean) {
        this.runtimeMBean = eJBRuntimeMBean;
    }

    public EJBRuntimeMBean getEJBRuntimeMBean() {
        return this.runtimeMBean;
    }

    public Context getEnvironmentContext() {
        return this.environmentContext;
    }

    public BeanInfo getBeanInfo() {
        return this.beanInfo;
    }

    protected void perhapsSetupTimerManager(EJBTimerRuntimeMBean eJBTimerRuntimeMBean) throws WLDeploymentException {
        assert (this.runtimeMBean != null);
        if (this.timerManager != null) {
            this.timerManager.setup(eJBTimerRuntimeMBean);
        }
    }

    public TimerManager getTimerManager() {
        return this.timerManager;
    }

    public boolean usesBeanManagedTx() {
        return this.usesBeanManagedTx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EnterpriseBean createNewBeanInstance() throws IllegalAccessException, InstantiationException {
        Object object;
        if (this.beanInfo.isEJB30()) {
            ClassLoader classLoader = this.beanInfo.getClassLoader();
            Thread thread2 = Thread.currentThread();
            ClassLoader classLoader2 = thread2.getContextClassLoader();
            try {
                thread2.setContextClassLoader(classLoader);
                object = this.ejbComponentCreator.getBean(this.beanInfo.getEJBName(), this.beanClass, true);
                Object var6_5 = null;
                thread2.setContextClassLoader(classLoader2);
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                thread2.setContextClassLoader(classLoader2);
                throw throwable;
            }
        } else {
            object = this.beanClass.newInstance();
        }
        return (EnterpriseBean)object;
    }

    public final EnterpriseBean allocateBean() throws InternalException {
        try {
            return this.createNewBeanInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new InternalException("Error calling bean's constructor: ", instantiationException);
        }
    }

    public abstract EJBContext allocateContext(EnterpriseBean var1, EJBObject var2, EJBLocalObject var3);

    public abstract EJBContext allocateContext(EnterpriseBean var1, Object var2);

    public EnterpriseBean createBean(EJBObject eJBObject, EJBLocalObject eJBLocalObject) throws InternalException {
        return this.createBean(eJBObject, eJBLocalObject, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnterpriseBean createBean(EJBObject eJBObject, EJBLocalObject eJBLocalObject, EnterpriseBean enterpriseBean) throws InternalException {
        try {
            EJBContext eJBContext;
            block10: {
                this.ejbHome.pushEnvironment();
                eJBContext = this.allocateContext(enterpriseBean, eJBObject, eJBLocalObject);
                try {
                    EJBContextManager.pushEjbContext(eJBContext);
                    AllowedMethodsHelper.pushMethodInvocationState(new Integer(1));
                    if (enterpriseBean == null) {
                        enterpriseBean = this.allocateBean();
                    }
                    Object var6_5 = null;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    EJBContextManager.popEjbContext();
                    AllowedMethodsHelper.popMethodInvocationState();
                    throw throwable;
                }
                EJBContextManager.popEjbContext();
                AllowedMethodsHelper.popMethodInvocationState();
                ((BaseEJBContext)eJBContext).setBean(enterpriseBean);
                try {
                    if (enterpriseBean instanceof EntityBean) {
                        ((EntityBean)enterpriseBean).setEntityContext((EntityContext)eJBContext);
                        break block10;
                    }
                    if (enterpriseBean instanceof SessionBean) {
                        ((SessionBean)enterpriseBean).setSessionContext((SessionContext)eJBContext);
                        break block10;
                    }
                    if (enterpriseBean instanceof MessageDrivenBean) {
                        ((MessageDrivenBean)enterpriseBean).setMessageDrivenContext((MessageDrivenContext)eJBContext);
                        break block10;
                    }
                    throw new AssertionError((Object)("Unknown bean type:" + enterpriseBean.getClass()));
                }
                catch (Exception exception) {
                    throw new InternalException("Error during setXXXContext: ", exception);
                }
            }
            ((WLEnterpriseBean)enterpriseBean).__WL_setEJBContext(eJBContext);
            EnterpriseBean enterpriseBean2 = enterpriseBean;
            Object var8_10 = null;
            this.ejbHome.popEnvironment();
            return enterpriseBean2;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            this.ejbHome.popEnvironment();
            throw throwable;
        }
    }

    public void setupTxListener(InvocationWrapper invocationWrapper) throws InternalException {
        Transaction transaction = invocationWrapper.getInvokeTx();
        assert (transaction != null);
        try {
            if (debugLogger.isDebugEnabled()) {
                BaseEJBManager.debug("Setting up tx listener for tx: " + transaction);
            }
            if (transaction != invocationWrapper.getCallerTx() && transaction.getStatus() == 1) {
                return;
            }
            this.getTxManager().registerSynchronization(invocationWrapper.getPrimaryKey(), transaction);
        }
        catch (Exception exception) {
            this.handleSystemException(invocationWrapper, exception);
            throw new AssertionError((Object)"Should never reach here");
        }
    }

    public void setupTxListener(Object object, Object object2) throws InternalException {
        Transaction transaction = null;
        if (!(object2 instanceof Transaction)) {
            return;
        }
        transaction = (Transaction)object2;
        if (debugLogger.isDebugEnabled()) {
            BaseEJBManager.debug("Setting up tx listener for tx: " + transaction);
        }
        this.getTxManager().registerSynchronization(object, transaction);
    }

    void handleSystemException(InvocationWrapper invocationWrapper, Throwable throwable) throws InternalException {
        Transaction transaction = invocationWrapper.getInvokeTx();
        if (transaction == null) {
            EJBRuntimeUtils.throwInternalException("EJB Exception: ", throwable);
        } else if (EJBRuntimeUtils.runningInOurTx(invocationWrapper)) {
            try {
                transaction.rollback();
            }
            catch (Exception exception) {
                EJBLogger.logStackTraceAndMessage((String)exception.getMessage(), (Throwable)exception);
                EJBLogger.logErrorOnRollback((Exception)exception);
            }
            EJBRuntimeUtils.throwInternalException("EJB Exception: ", throwable);
        } else {
            int n = 0;
            try {
                n = transaction.getStatus();
            }
            catch (SystemException systemException) {
                // empty catch block
            }
            if (n == 0 || n == 5) {
                try {
                    transaction.setRollbackOnly();
                }
                catch (Exception exception) {
                    EJBLogger.logErrorMarkingRollback((Exception)exception);
                }
            }
            if (throwable instanceof NoSuchObjectException || throwable instanceof NoSuchEJBException) {
                EJBRuntimeUtils.throwInternalException("EJB Exception: ", throwable);
            } else if (invocationWrapper.isLocal()) {
                EJBRuntimeUtils.throwWrappedTransactionRolledbackLocal("EJB Exception: ", throwable);
            } else {
                EJBRuntimeUtils.throwWrappedTransactionRolledback("EJB Exception: ", throwable);
            }
        }
    }

    protected void handleMethodException(Method method, Class[] classArray, Throwable throwable) throws InternalException {
        boolean bl = this.beanInfo.isEJB30() ? EJBRuntimeUtils.isAppException(this.beanInfo, method, throwable) : EJBRuntimeUtils.isAppException(method, classArray, throwable);
        if (debugLogger.isDebugEnabled()) {
            BaseEJBManager.debug("Got an exception: " + throwable);
        }
        if (bl) {
            if (debugLogger.isDebugEnabled()) {
                BaseEJBManager.debug("Throwing app exception");
            }
            EJBRuntimeUtils.throwInternalException("EJB Exception:", throwable);
        } else {
            if (debugLogger.isDebugEnabled()) {
                BaseEJBManager.debug("We think it's a system exception");
            }
            EJBLogger.logExcepInMethod1((String)method.getName(), (Throwable)throwable);
            EJBRuntimeUtils.throwInternalException("EJB Exception:", throwable);
        }
    }

    protected EJBComponentRuntimeMBeanImpl getEJBComponentRuntime() {
        return this.componentRuntime;
    }

    protected void addEJBRuntimeMBean(EJBRuntimeMBean eJBRuntimeMBean) {
        EJBComponentRuntimeMBeanImpl eJBComponentRuntimeMBeanImpl = this.getEJBComponentRuntime();
        eJBComponentRuntimeMBeanImpl.addEJBRuntimeMBean(eJBRuntimeMBean);
    }

    protected String getEJBRuntimeMBeanName() {
        return this.beanInfo.getEJBName();
    }

    public abstract EJBObject remoteFindByPrimaryKey(InvocationWrapper var1, Object var2) throws InternalException;

    public abstract Object localFindByPrimaryKey(InvocationWrapper var1, Object var2) throws InternalException;

    public abstract EJBObject remoteScalarFinder(InvocationWrapper var1, Method var2, Object[] var3) throws InternalException;

    public abstract EJBLocalObject localScalarFinder(InvocationWrapper var1, Method var2, Object[] var3) throws InternalException;

    public abstract Enumeration enumFinder(InvocationWrapper var1, Method var2, Object[] var3) throws InternalException;

    public abstract Collection collectionFinder(InvocationWrapper var1, Method var2, Object[] var3) throws InternalException;

    public void undeploy() {
        TxManager txManager;
        if (this.localHome != null) {
            this.localHome.undeploy();
        }
        if (this.remoteHome != null) {
            this.remoteHome.undeploy();
        }
        this.undeployTimerManager();
        if (this.beanInfo != null) {
            this.beanInfo.onUndeploy();
        }
        if ((txManager = this.getTxManager()) != null) {
            txManager.undeploy();
        }
    }

    protected void undeployTimerManager() {
        if (this.timerManager != null) {
            this.timerManager.undeploy();
        }
    }

    public void remove() {
    }

    public void handleUncommittedLocalTransaction(InvocationWrapper invocationWrapper) throws InternalException {
        Debug.assertion((boolean)false, (String)"handleUncommitedLocalTransaction N/A on this bean");
    }

    public boolean checkWritable(String string) {
        this.initWritable();
        String string2 = string;
        String string3 = string;
        SecurityRoleReference securityRoleReference = this.beanInfo.getSecurityRoleReference(string);
        if (securityRoleReference != null) {
            String string4 = securityRoleReference.getReferencedRole();
            if (debugLogger.isDebugEnabled()) {
                BaseEJBManager.debug(" referenced role for roleName: '" + string + "', is '" + string4 + "'");
            }
            string3 = string4;
        }
        return this.helper.isResWritable(this.ejbResource, string2, string3);
    }

    private void initWritable() {
        if (!this.writableInitialized) {
            this.helper = new ManagerHelper(this.beanInfo.getDeploymentInfo().getSecurityRealmName(), this.beanInfo.getEJBName(), this.beanInfo.getJACCPolicyContextId(), this.beanInfo.getJACCCodeSource(), this.beanInfo.getJACCPolicyConfig(), this.beanInfo.getJACCRoleMapper());
            this.ejbResource = this.helper.createEJBResource(this.beanInfo.getDeploymentInfo());
            this.writableInitialized = true;
        }
    }

    private static void debug(String string) {
        debugLogger.debug("[BaseEJBManager] " + string);
    }
}

