/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.manager;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import javax.ejb.EntityBean;
import javax.transaction.Transaction;
import weblogic.ejb.container.InternalException;
import weblogic.ejb.container.interfaces.BeanManager;
import weblogic.ejb.container.internal.EJBRuntimeUtils;
import weblogic.ejb.container.manager.BaseEntityManager;
import weblogic.ejb.container.persistence.spi.PersistenceManager;
import weblogic.ejb.container.persistence.spi.RSInfo;
import weblogic.transaction.TxHelper;
import weblogic.utils.AssertionError;

public final class BeanManagedPersistenceManager
implements PersistenceManager {
    BaseEntityManager beanManager = null;

    public void setup(BeanManager beanManager) throws InternalException {
        this.beanManager = (BaseEntityManager)beanManager;
    }

    public Object findByPrimaryKey(EntityBean entityBean, Method method, Object object) throws InternalException {
        try {
            return method.invoke((Object)entityBean, object);
        }
        catch (IllegalAccessException illegalAccessException) {
            EJBRuntimeUtils.throwInternalException("Exception in ejbFindByPrimaryKey", illegalAccessException);
            throw new AssertionError("cannot reach");
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            EJBRuntimeUtils.throwInternalException("Exception in ejbFindByPrimaryKey", throwable);
            throw new AssertionError("cannot reach");
        }
    }

    public EntityBean findByPrimaryKeyLoadBean(EntityBean entityBean, Method method, Object object) throws InternalException {
        throw new InternalException("NYI");
    }

    public Object scalarFinder(EntityBean entityBean, Method method, Object[] objectArray) throws InternalException {
        try {
            Transaction transaction = TxHelper.getTransactionManager().getTransaction();
            this.beanManager.flushModifiedBeans(transaction);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new InternalException(exception.getMessage());
        }
        try {
            return method.invoke((Object)entityBean, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            EJBRuntimeUtils.throwInternalException("Exception in " + method.getName(), illegalAccessException);
            throw new AssertionError("cannot reach");
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            EJBRuntimeUtils.throwInternalException("Exception in " + method.getName(), throwable);
            throw new AssertionError("cannot reach");
        }
    }

    public Map scalarFinderLoadBean(EntityBean entityBean, Method method, Object[] objectArray) throws InternalException {
        throw new InternalException("NYI");
    }

    public Enumeration enumFinder(EntityBean entityBean, Method method, Object[] objectArray) throws InternalException {
        try {
            Transaction transaction = TxHelper.getTransactionManager().getTransaction();
            this.beanManager.flushModifiedBeans(transaction);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new InternalException(exception.getMessage());
        }
        try {
            return (Enumeration)method.invoke((Object)entityBean, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            EJBRuntimeUtils.throwInternalException("Exception in " + method.getName(), illegalAccessException);
            throw new AssertionError("cannot reach");
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            EJBRuntimeUtils.throwInternalException("Exception in " + method.getName(), throwable);
            throw new AssertionError("cannot reach");
        }
    }

    public Collection collectionFinder(EntityBean entityBean, Method method, Object[] objectArray) throws InternalException {
        try {
            Transaction transaction = TxHelper.getTransactionManager().getTransaction();
            this.beanManager.flushModifiedBeans(transaction);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new InternalException(exception.getMessage());
        }
        try {
            return (Collection)method.invoke((Object)entityBean, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            EJBRuntimeUtils.throwInternalException("Exception in " + method.getName(), illegalAccessException);
            throw new AssertionError("cannot reach");
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            EJBRuntimeUtils.throwInternalException("Exception in " + method.getName(), throwable);
            throw new AssertionError("cannot reach");
        }
    }

    public Map collectionFinderLoadBean(EntityBean entityBean, Method method, Object[] objectArray) throws InternalException {
        throw new InternalException("NYI");
    }

    public void loadBeanFromRS(EntityBean entityBean, RSInfo rSInfo) throws InternalException {
        throw new InternalException("NYI");
    }

    public void updateClassLoader(ClassLoader classLoader) {
    }
}

