/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.manager;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ejb.EJBContext;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.EnterpriseBean;
import javax.ejb.EntityBean;
import javax.ejb.ObjectNotFoundException;
import javax.naming.Context;
import javax.transaction.Transaction;
import weblogic.cluster.ClusterService;
import weblogic.cluster.GroupMessage;
import weblogic.cluster.MulticastSession;
import weblogic.cluster.RecoverListener;
import weblogic.diagnostics.instrumentation.DelegatingMonitor;
import weblogic.diagnostics.instrumentation.DiagnosticAction;
import weblogic.diagnostics.instrumentation.DiagnosticActionState;
import weblogic.diagnostics.instrumentation.DiagnosticMonitor;
import weblogic.diagnostics.instrumentation.DynamicJoinPoint;
import weblogic.diagnostics.instrumentation.InstrumentationSupport;
import weblogic.diagnostics.instrumentation.JoinPoint;
import weblogic.diagnostics.instrumentation.PointcutHandlingInfo;
import weblogic.diagnostics.instrumentation.ValueHandlingInfo;
import weblogic.ejb.OptimisticConcurrencyException;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.InternalException;
import weblogic.ejb.container.cache.CacheKey;
import weblogic.ejb.container.cache.EntityCache;
import weblogic.ejb.container.cmp.rdbms.RDBMSPersistenceManager;
import weblogic.ejb.container.interfaces.BaseEJBLocalHomeIntf;
import weblogic.ejb.container.interfaces.BaseEJBLocalObjectIntf;
import weblogic.ejb.container.interfaces.BaseEJBRemoteHomeIntf;
import weblogic.ejb.container.interfaces.BeanInfo;
import weblogic.ejb.container.interfaces.BeanManager;
import weblogic.ejb.container.interfaces.CachingManager;
import weblogic.ejb.container.interfaces.EntityBeanInfo;
import weblogic.ejb.container.interfaces.InvalidationBeanManager;
import weblogic.ejb.container.interfaces.WLEJBContext;
import weblogic.ejb.container.interfaces.WLEnterpriseBean;
import weblogic.ejb.container.interfaces.WLEntityBean;
import weblogic.ejb.container.internal.EJBComponentRuntimeMBeanImpl;
import weblogic.ejb.container.internal.EJBRuntimeUtils;
import weblogic.ejb.container.internal.EntityEJBContextImpl;
import weblogic.ejb.container.internal.EntityEJBLocalObject;
import weblogic.ejb.container.internal.EntityEJBObject;
import weblogic.ejb.container.internal.InvocationWrapper;
import weblogic.ejb.container.manager.BaseEntityManager;
import weblogic.ejb.container.persistence.spi.CMPBean;
import weblogic.ejb.container.persistence.spi.CMPBeanManager;
import weblogic.ejb.container.persistence.spi.RSInfo;
import weblogic.ejb.spi.EJBCache;
import weblogic.ejb.spi.InvalidationMessage;
import weblogic.ejb.spi.ScrubbedCache;
import weblogic.ejb.spi.WLDeploymentException;
import weblogic.ejb20.RuntimeCheckerException;
import weblogic.ejb20.cache.CacheFullException;
import weblogic.kernel.Kernel;
import weblogic.logging.Loggable;
import weblogic.management.configuration.ServerMBean;
import weblogic.transaction.TxHelper;
import weblogic.transaction.internal.TransactionImpl;
import weblogic.utils.AssertionError;
import weblogic.utils.Debug;
import weblogic.utils.StackTraceUtils;

public class DBManager
extends BaseEntityManager
implements BeanManager,
CMPBeanManager,
CachingManager,
InvalidationBeanManager,
RecoverListener {
    private boolean publicCacheOnly;
    protected EntityCache publicCache;
    private boolean scrubberStarted = false;
    private EntityBeanInfo info;
    private boolean delayUpdatesUntilEndOfTx = true;
    private int beanSize;
    private int idleTimeoutSeconds = 0;
    protected InvalidationBeanManager invalidationTargetBM = null;
    private boolean cacheBetweenTransactions;
    protected boolean clusterInvalidationDisabled;
    protected MulticastSession multicastSession;
    private boolean verifyReads = false;
    private static final Object DUMMY_PK;
    private static int VERIFY_THRESHHOLD;
    static final long serialVersionUID = 8801993973041449919L;
    public static final String _WLDF$INST_VERSION = "9.0.0";
    static /* synthetic */ Class _WLDF$INST_FLD_class;
    public static final DelegatingMonitor _WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Preinvoke_Entity_After_Medium;
    public static final DelegatingMonitor _WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Postinvoke_Entity_Before_Medium;
    public static final DelegatingMonitor _WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Create_Around_Medium;
    public static final JoinPoint _WLDF$INST_JPFLD_0;
    public static final JoinPoint _WLDF$INST_JPFLD_1;
    public static final JoinPoint _WLDF$INST_JPFLD_2;

    public DBManager(EJBComponentRuntimeMBeanImpl eJBComponentRuntimeMBeanImpl) {
        super(eJBComponentRuntimeMBeanImpl);
    }

    public void setup(BaseEJBRemoteHomeIntf baseEJBRemoteHomeIntf, BaseEJBLocalHomeIntf baseEJBLocalHomeIntf, BeanInfo beanInfo, Context context) throws WLDeploymentException {
        throw new AssertionError("BeanManager.setup() should never be called on DBManager.");
    }

    public void setup(BaseEJBRemoteHomeIntf baseEJBRemoteHomeIntf, BaseEJBLocalHomeIntf baseEJBLocalHomeIntf, BeanInfo beanInfo, Context context, EJBCache eJBCache) throws WLDeploymentException {
        boolean bl;
        super.setup(baseEJBRemoteHomeIntf, baseEJBLocalHomeIntf, beanInfo, context);
        this.info = (EntityBeanInfo)beanInfo;
        this.publicCacheOnly = true;
        if (eJBCache == null) {
            this.publicCache = new EntityCache(this.info.getEJBName(), this.info.getCachingDescriptor().getMaxBeansInCache());
            this.beanSize = 1;
            this.idleTimeoutSeconds = this.info.getCachingDescriptor().getIdleTimeoutSecondsCache();
            this.publicCache.setScrubInterval(this.idleTimeoutSeconds);
            this.publicCache.startScrubber();
            this.scrubberStarted = true;
        } else {
            if (!(eJBCache instanceof EntityCache)) {
                Loggable loggable = EJBLogger.lognotAMultiVersionCacheLoggable((String)this.info.getEJBName(), (String)this.info.getCacheName());
                throw new WLDeploymentException(loggable.getMessage());
            }
            this.publicCache = (EntityCache)eJBCache;
            this.beanSize = this.publicCache.usesMaxBeansInCache() ? 1 : this.info.getEstimatedBeanSize();
            this.idleTimeoutSeconds = this.info.getCachingDescriptor().getIdleTimeoutSecondsCache();
            this.publicCache.setScrubInterval(this.idleTimeoutSeconds);
        }
        this.publicCache.register(this);
        this.getEJBCacheRuntimeMBeanImpl().setReInitializableCache(this.publicCache);
        this.cacheBetweenTransactions = this.info.getCacheBetweenTransactions();
        String string = this.info.getCachingDescriptor().getConcurrencyStrategy();
        if (string == null || "Database".equalsIgnoreCase(string)) {
            this.cacheBetweenTransactions = false;
        }
        if (!(this.cacheBetweenTransactions || this.info.getConcurrencyStrategy() != 2 && this.info.getConcurrencyStrategy() != 6)) {
            this.publicCache.setDisableReadyCache(this.info.getDisableReadyInstances());
        }
        this.delayUpdatesUntilEndOfTx = this.info.getBoxCarUpdates();
        this.invalidationTargetBM = this.info.getInvalidationTargetBeanManager();
        boolean bl2 = bl = ((ServerMBean)Kernel.getConfig()).getCluster() != null;
        if (bl && string != null && (this.rdbmsPersistence == null || !this.rdbmsPersistence.getRDBMSBean().isClusterInvalidationDisabled())) {
            if (string.equalsIgnoreCase("Optimistic") && this.cacheBetweenTransactions || string.equalsIgnoreCase("ReadOnly")) {
                this.multicastSession = ClusterService.getServices().createMulticastSession(this, -1);
                this.clusterInvalidationDisabled = false;
            } else {
                this.clusterInvalidationDisabled = true;
            }
        } else {
            this.clusterInvalidationDisabled = true;
        }
        if (this.rdbmsPersistence != null) {
            this.verifyReads = this.rdbmsPersistence.getVerifyReads();
        }
    }

    protected EntityCache getCache() {
        return this.publicCache;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EnterpriseBean preInvoke(InvocationWrapper invocationWrapper) throws InternalException {
        EntityBean entityBean;
        try {
            super.preInvoke();
            Object object = invocationWrapper.getInvokeTxOrThread();
            Object object2 = invocationWrapper.getPrimaryKey();
            entityBean = this.getReadyBean(object, object2, true);
            this.checkForReentrant(entityBean, object2);
            ((WLEnterpriseBean)entityBean).__WL_setBusy(true);
            Object var8_5 = null;
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            if (!_WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Preinvoke_Entity_After_Medium.isEnabledAndNotDyeFiltered()) throw throwable;
            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Preinvoke_Entity_After_Medium;
            InstrumentationSupport.process((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
            throw throwable;
        }
        if (!_WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Preinvoke_Entity_After_Medium.isEnabledAndNotDyeFiltered()) return entityBean;
        DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Preinvoke_Entity_After_Medium;
        InstrumentationSupport.process((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
        return entityBean;
    }

    private EntityBean getReadyBean(Object object, Object object2, boolean bl) throws InternalException {
        EntityBean entityBean = null;
        assert (object != null);
        entityBean = this.getCache().get(object, new CacheKey(object2, this), bl);
        this.cacheRTMBean.incrementCacheAccessCount();
        if (entityBean != null) {
            if (object instanceof Thread) {
                try {
                    this.loadBean(object2, entityBean, null, false);
                }
                catch (Throwable throwable) {
                    EJBLogger.logErrorFromLoad((Throwable)throwable);
                    this.getCache().removeOnError(object, new CacheKey(object2, this));
                    EJBRuntimeUtils.throwInternalException("Exception in ejbLoad:", throwable);
                    throw new AssertionError("cannot reach");
                }
            }
            this.cacheRTMBean.incrementCacheHitCount();
            return entityBean;
        }
        entityBean = this.getBeanFromPool();
        assert (!((WLEnterpriseBean)entityBean).__WL_isBusy());
        EJBContext eJBContext = ((WLEnterpriseBean)entityBean).__WL_getEJBContext();
        ((EntityEJBContextImpl)eJBContext).__WL_setPrimaryKey(object2);
        EJBObject eJBObject = null;
        BaseEJBLocalObjectIntf baseEJBLocalObjectIntf = null;
        if (this.remoteHome != null) {
            eJBObject = this.remoteHome.allocateEO(object2);
        }
        ((WLEJBContext)eJBContext).setEJBObject(eJBObject);
        if (this.localHome != null) {
            baseEJBLocalObjectIntf = this.localHome.allocateELO(object2);
        }
        ((WLEJBContext)eJBContext).setEJBLocalObject(baseEJBLocalObjectIntf);
        try {
            entityBean.ejbActivate();
            this.cacheRTMBean.incrementActivationCount();
        }
        catch (Throwable throwable) {
            EJBLogger.logErrorDuringActivate((String)StackTraceUtils.throwable2StackTrace((Throwable)throwable));
            this.destroyPooledBean(entityBean);
            EJBRuntimeUtils.throwInternalException("Exception in ejbActivate", throwable);
            throw new AssertionError("will not reach");
        }
        assert (entityBean != null);
        if (this.supportsCopy()) {
            this.perhapsCopy(object2, entityBean);
        }
        try {
            this.loadBean(object2, entityBean, null, true);
        }
        catch (Throwable throwable) {
            EJBLogger.logErrorFromLoad((Throwable)throwable);
            this.destroyPooledBean(entityBean);
            EJBRuntimeUtils.throwInternalException("Exception in ejbLoad:", throwable);
            throw new AssertionError("cannot reach");
        }
        try {
            this.setupTxListenerAndTxUser(object2, object, (WLEnterpriseBean)entityBean);
            this.getCache().put(object, new CacheKey(object2, this), entityBean, this, bl);
            this.cacheRTMBean.incrementCachedBeansCurrentCount();
        }
        catch (Throwable throwable) {
            EJBLogger.logErrorFromLoad((Throwable)throwable);
            this.destroyPooledBean(entityBean);
            EJBRuntimeUtils.throwInternalException("Exception in ejbLoad:", throwable);
            throw new AssertionError("cannot reach");
        }
        return entityBean;
    }

    public int getBeanSize() {
        return this.beanSize;
    }

    public boolean isEntityManager() {
        return true;
    }

    public void enrollInTransaction(Transaction transaction, CacheKey cacheKey, EntityBean entityBean, RSInfo rSInfo) throws InternalException {
        try {
            Object object = cacheKey.getPrimaryKey();
            this.loadBean(object, entityBean, rSInfo, false);
            this.setupTxListenerAndTxUser(object, transaction, (WLEnterpriseBean)entityBean);
        }
        catch (Throwable throwable) {
            EJBLogger.logErrorFromLoad((Throwable)throwable);
            this.getCache().removeOnError(transaction, cacheKey);
            EJBRuntimeUtils.throwInternalException("Exception in ejbLoad:", throwable);
            throw new AssertionError("cannot reach");
        }
    }

    public int getIdleTimeoutSeconds() {
        return this.idleTimeoutSeconds;
    }

    public boolean getVerifyReads() {
        return this.verifyReads;
    }

    public void selectedForReplacement(CacheKey cacheKey, EntityBean entityBean) {
        this.passivateAndRelease(cacheKey, entityBean);
        this.cacheRTMBean.decrementCachedBeansCurrentCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void passivateAndRelease(CacheKey cacheKey, EntityBean entityBean) {
        try {
            try {
                entityBean.ejbPassivate();
                this.releaseBeanToPool(entityBean);
            }
            catch (Throwable throwable) {
                EJBLogger.logErrorPassivating((String)StackTraceUtils.throwable2StackTrace((Throwable)throwable));
                this.destroyPooledBean(entityBean);
                Object var5_4 = null;
                this.cacheRTMBean.incrementPassivationCount();
            }
            Object var5_3 = null;
            this.cacheRTMBean.incrementPassivationCount();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.cacheRTMBean.incrementPassivationCount();
            throw throwable;
        }
    }

    public void loadBeanFromRS(CacheKey cacheKey, EntityBean entityBean, RSInfo rSInfo) throws InternalException {
        if (this.uses20CMP) {
            ((RDBMSPersistenceManager)this.persistence).loadBeanFromRS(entityBean, rSInfo);
        }
    }

    public void removedOnError(CacheKey cacheKey, EnterpriseBean enterpriseBean) {
        this.cacheRTMBean.decrementCachedBeansCurrentCount();
        this.destroyPooledBean((EntityBean)enterpriseBean);
    }

    public void removedFromCache(CacheKey cacheKey, EnterpriseBean enterpriseBean) {
        ((WLEnterpriseBean)enterpriseBean).__WL_setBusy(false);
        this.releaseBeanToPool((EntityBean)enterpriseBean);
        this.cacheRTMBean.decrementCachedBeansCurrentCount();
    }

    public void swapIn(CacheKey cacheKey, EnterpriseBean enterpriseBean) {
        throw new AssertionError("method 'swapIn' not valid for DBManager");
    }

    public void swapOut(CacheKey cacheKey, EnterpriseBean enterpriseBean) {
        throw new AssertionError("method 'swapOut' not valid for DBManager");
    }

    public void replicate(CacheKey cacheKey, EnterpriseBean enterpriseBean) {
        throw new AssertionError("method 'replicate' not valid for DBManager");
    }

    protected void loadBean(Object object, EntityBean entityBean, RSInfo rSInfo, boolean bl) throws Throwable {
        if (rSInfo == null) {
            if (bl || !this.cacheBetweenTransactions || !((CMPBean)entityBean).__WL_isBeanStateValid()) {
                entityBean.ejbLoad();
                if (!this.isBeanManagedPersistence && this.uses20CMP) {
                    ((CMPBean)entityBean).__WL_setBeanStateValid(true);
                }
            }
        } else {
            CMPBean cMPBean = (CMPBean)entityBean;
            if (!this.cacheBetweenTransactions || !((CMPBean)entityBean).__WL_isBeanStateValid()) {
                cMPBean.__WL_initialize();
                if (!this.isBeanManagedPersistence && this.uses20CMP) {
                    cMPBean.__WL_setBeanStateValid(true);
                }
            }
            this.persistence.loadBeanFromRS(entityBean, rSInfo);
            cMPBean.__WL_superEjbLoad();
        }
    }

    protected void storeBean(EntityBean entityBean, Object object) throws Throwable {
        if (this.shouldStore(entityBean)) {
            entityBean.ejbStore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postInvoke(InvocationWrapper invocationWrapper) throws InternalException {
        if (_WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Postinvoke_Entity_Before_Medium.isEnabledAndNotDyeFiltered()) {
            Object[] objectArray = null;
            if (_WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Postinvoke_Entity_Before_Medium.isArgumentsCaptureNeeded()) {
                objectArray = new Object[]{this, invocationWrapper};
            }
            DynamicJoinPoint dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_1, (Object[])objectArray, null);
            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Postinvoke_Entity_Before_Medium;
            InstrumentationSupport.process((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
        }
        EntityBean entityBean = (EntityBean)invocationWrapper.getBean();
        WLEnterpriseBean wLEnterpriseBean = (WLEnterpriseBean)entityBean;
        Object object = invocationWrapper.getPrimaryKey();
        CacheKey cacheKey = new CacheKey(object, this);
        Throwable throwable = null;
        boolean bl = false;
        EntityBean entityBean2 = entityBean;
        synchronized (entityBean2) {
            wLEnterpriseBean.__WL_setBusy(false);
            if (wLEnterpriseBean.__WL_needsRemove()) {
                if (debugLogger.isDebugEnabled()) {
                    DBManager.debug("postInvoke: setNeedsRemove, txOrThread= " + invocationWrapper.getInvokeTxOrThread() + ", ejb- " + this.info.getEJBName() + ", pk- " + object);
                }
                wLEnterpriseBean.__WL_setLoadUser(null);
                if (this.cacheBetweenTransactions) {
                    try {
                        this.storeBean(entityBean, object);
                    }
                    catch (Throwable throwable2) {
                        EJBLogger.logErrorFromStore((Throwable)throwable2);
                        throwable = throwable2;
                    }
                    if (throwable == null) {
                        throw new AssertionError("storeBean was expected to fail!");
                    }
                } else if (this.remoteHome == null || !wLEnterpriseBean.__WL_isCreatorOfTx() || invocationWrapper.getInvokeTx() == null) {
                    bl = true;
                }
            } else if (!this.delayUpdatesUntilEndOfTx || invocationWrapper.getInvokeTx() == null) {
                try {
                    this.storeBean(entityBean, object);
                }
                catch (Throwable throwable3) {
                    EJBLogger.logErrorFromStore((Throwable)throwable3);
                    throwable = throwable3;
                }
            }
        }
        if (bl) {
            this.cacheReleaseBean(null, invocationWrapper.getInvokeTxOrThread(), cacheKey, this.getCache());
            return;
        }
        if (throwable != null) {
            this.getCache().removeOnError(invocationWrapper.getInvokeTxOrThread(), cacheKey);
            if (debugLogger.isDebugEnabled()) {
                DBManager.debug("postInvoke: ejbStore failed, txOrThread= " + invocationWrapper.getInvokeTxOrThread() + ", ejb- " + this.info.getEJBName() + ", pk- " + object);
            }
            EJBRuntimeUtils.throwInternalException("Exception in ejbStore:", throwable);
        }
        this.getCache().unpin(invocationWrapper.getInvokeTxOrThread(), cacheKey);
    }

    public EnterpriseBean preHomeInvoke(InvocationWrapper invocationWrapper) throws InternalException {
        EntityBean entityBean = this.getBeanFromPool();
        return entityBean;
    }

    public void postHomeInvoke(InvocationWrapper invocationWrapper) throws InternalException {
        EnterpriseBean enterpriseBean = invocationWrapper.getBean();
        if (invocationWrapper.hasSystemExceptionOccured()) {
            this.destroyPooledBean((EntityBean)enterpriseBean);
        } else {
            this.releaseBeanToPool((EntityBean)enterpriseBean);
        }
    }

    public void destroyInstance(InvocationWrapper invocationWrapper, Throwable throwable) {
        Object object = invocationWrapper.getInvokeTxOrThread();
        Object object2 = invocationWrapper.getPrimaryKey();
        if (object2 == null) {
            return;
        }
        assert (object != null);
        if (invocationWrapper.shouldLogException()) {
            EJBLogger.logErrorDuringBeanInvocation((String)this.ejbHome.getDisplayName(), (String)object2.toString(), (Throwable)throwable);
        }
        EntityBean entityBean = (EntityBean)invocationWrapper.getBean();
        assert (entityBean != null);
        assert (object2 != null);
        this.getCache().removeOnError(object, new CacheKey(object2, this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doVerificationForBatch(List list, StringBuffer[] stringBufferArray, int[] nArray, Transaction transaction, boolean bl) throws SQLException {
        Connection connection = null;
        Statement[] statementArray = null;
        ResultSet[] resultSetArray = null;
        try {
            connection = this.rdbmsPersistence.getConnection();
            statementArray = this.rdbmsPersistence.prepareStatement(connection, stringBufferArray, nArray, bl);
            if (debugLogger.isDebugEnabled()) {
                for (int i = 0; i < stringBufferArray.length; ++i) {
                    DBManager.debug("verifySql[" + i + "]: " + stringBufferArray[i]);
                }
            }
            int[] nArray2 = this.rdbmsPersistence.getVerifyCur();
            for (Object e : list) {
                CacheKey cacheKey = new CacheKey(e, this);
                CMPBean cMPBean = (CMPBean)this.getCache().getActive(transaction, new CacheKey(e, this), false);
                if (cMPBean == null) {
                    throw new AssertionError("no bean found for pk: " + e);
                }
                cMPBean.__WL_setVerifyParamsForBatch(connection, (PreparedStatement[])statementArray, nArray2);
            }
            resultSetArray = this.rdbmsPersistence.executeQuery((PreparedStatement[])statementArray);
            this.rdbmsPersistence.checkResults(resultSetArray, nArray);
            Object var15_15 = null;
            this.rdbmsPersistence.releaseArrayResources(connection, statementArray, resultSetArray);
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            this.rdbmsPersistence.releaseArrayResources(connection, statementArray, resultSetArray);
            throw throwable;
        }
    }

    protected void prepareVerificationForBatch(Collection collection, Transaction transaction) throws InternalException {
        if (this.rdbmsPersistence.needsBatchOperationsWorkaround()) {
            Iterator iterator;
            boolean bl;
            ArrayList arrayList = new ArrayList();
            StringBuffer[] stringBufferArray = null;
            Integer n = (Integer)((TransactionImpl)transaction).getProperty("ISOLATION LEVEL");
            boolean bl2 = bl = n == null || n != 4 && n != 8;
            if (debugLogger.isDebugEnabled()) {
                DBManager.debug("Require exclusive lock for batch? " + bl);
            }
            stringBufferArray = this.rdbmsPersistence.getVerifySql(bl);
            int[] nArray = this.rdbmsPersistence.getVerifyCount();
            int n2 = 0;
            if (debugLogger.isDebugEnabled()) {
                for (int i = 0; i < stringBufferArray.length; ++i) {
                    DBManager.debug("sql[" + i + "] = " + stringBufferArray[i]);
                    DBManager.debug("count[" + i + "] = " + nArray[i]);
                    DBManager.debug("verifyMax = " + n2);
                }
                iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    DBManager.debug("pk- " + iterator.next());
                }
                DBManager.debug("*************************************************");
            }
            iterator = collection.iterator();
            try {
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    CMPBean cMPBean = (CMPBean)this.getCache().getActive(transaction, new CacheKey(e, this), false);
                    if (cMPBean == null) continue;
                    n2 = cMPBean.__WL_appendVerifySqlForBatch(arrayList, stringBufferArray, nArray, n2);
                    if (debugLogger.isDebugEnabled()) {
                        for (int i = 0; i < stringBufferArray.length; ++i) {
                            DBManager.debug("sql[" + i + "] = " + stringBufferArray[i]);
                            DBManager.debug("count[" + i + "] = " + nArray[i]);
                            DBManager.debug("verifyMax = " + n2);
                        }
                        Iterator iterator2 = arrayList.iterator();
                        while (iterator2.hasNext()) {
                            DBManager.debug("pk- " + iterator2.next());
                        }
                        DBManager.debug("------------------------------------------");
                    }
                    if (n2 < VERIFY_THRESHHOLD) continue;
                    this.doVerificationForBatch(arrayList, stringBufferArray, nArray, transaction, bl);
                    arrayList.clear();
                    stringBufferArray = this.rdbmsPersistence.getVerifySql(bl);
                    nArray = this.rdbmsPersistence.getVerifyCount();
                    n2 = 0;
                }
                if (n2 > 0) {
                    this.doVerificationForBatch(arrayList, stringBufferArray, nArray, transaction, bl);
                }
            }
            catch (Throwable throwable) {
                if (!(throwable instanceof OptimisticConcurrencyException)) {
                    EJBLogger.logExcepInBeforeCompletion((String)StackTraceUtils.throwable2StackTrace((Throwable)throwable));
                }
                EJBRuntimeUtils.throwInternalException("Exception during before completion:", throwable);
                throw new AssertionError("cannot reach");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doVerification(List list, StringBuffer[] stringBufferArray, int[] nArray, Transaction transaction, boolean bl) throws SQLException {
        Connection connection = null;
        try {
            Object object2;
            connection = this.rdbmsPersistence.getConnection();
            PreparedStatement[] preparedStatementArray = null;
            preparedStatementArray = this.rdbmsPersistence.prepareStatement(connection, stringBufferArray, nArray, bl);
            if (debugLogger.isDebugEnabled()) {
                for (int i = 0; i < stringBufferArray.length; ++i) {
                    DBManager.debug("verifySql[" + i + "]: " + stringBufferArray[i]);
                }
            }
            int[] nArray2 = this.rdbmsPersistence.getVerifyCur();
            for (Object object2 : list) {
                CMPBean cMPBean = (CMPBean)this.getCache().getActive(transaction, new CacheKey(object2, this), false);
                if (cMPBean == null) {
                    throw new AssertionError("no bean found for pk: " + object2);
                }
                cMPBean.__WL_setVerifyParams(connection, preparedStatementArray, nArray2);
            }
            object2 = this.rdbmsPersistence.executeQuery(preparedStatementArray);
            this.rdbmsPersistence.checkResults((ResultSet[])object2, nArray);
            Object var13_13 = null;
            this.rdbmsPersistence.releaseResources(connection, null, null);
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            this.rdbmsPersistence.releaseResources(connection, null, null);
            throw throwable;
        }
    }

    protected List pkListToBeanList(Collection collection, Transaction transaction, boolean bl) {
        ArrayList<EntityBean> arrayList = new ArrayList<EntityBean>();
        for (Object e : collection) {
            CacheKey cacheKey = new CacheKey(e, this);
            EntityBean entityBean = this.getCache().getActive(transaction, cacheKey, false);
            if (bl) {
                if (entityBean == null) continue;
                arrayList.add(entityBean);
                continue;
            }
            if (entityBean == null || ((CMPBean)entityBean).__WL_getIsRemoved()) continue;
            arrayList.add(entityBean);
        }
        return arrayList;
    }

    protected Map pkListToPkBeanMap(Collection collection, Transaction transaction, boolean bl) {
        HashMap hashMap = new HashMap();
        for (Object e : collection) {
            CacheKey cacheKey = new CacheKey(e, this);
            EntityBean entityBean = this.getCache().getActive(transaction, cacheKey, false);
            if (bl) {
                if (entityBean == null) continue;
                hashMap.put(e, entityBean);
                continue;
            }
            if (entityBean == null || ((CMPBean)entityBean).__WL_getIsRemoved()) continue;
            hashMap.put(e, entityBean);
        }
        return hashMap;
    }

    public void beforeCompletion(Collection collection, Transaction transaction) throws InternalException {
        this.beforeCompletion(collection, (Object)transaction);
    }

    public void beforeCompletion(Collection collection, Object object) throws InternalException {
        Integer n;
        StringBuffer[] stringBufferArray;
        assert (object != null);
        assert (collection != null);
        if (this.verifyReads) {
            Iterator iterator;
            boolean bl;
            Transaction transaction = (Transaction)object;
            ArrayList arrayList = new ArrayList();
            stringBufferArray = null;
            n = (Integer)((TransactionImpl)transaction).getProperty("ISOLATION LEVEL");
            boolean bl2 = bl = n == null || n != 4 && n != 8;
            if (debugLogger.isDebugEnabled()) {
                DBManager.debug("require exclusive lock? " + bl);
            }
            stringBufferArray = this.rdbmsPersistence.getVerifySql(bl);
            int[] nArray = this.rdbmsPersistence.getVerifyCount();
            int n2 = 0;
            if (debugLogger.isDebugEnabled()) {
                for (int i = 0; i < stringBufferArray.length; ++i) {
                    DBManager.debug("sql[" + i + "] = " + stringBufferArray[i]);
                    DBManager.debug("count[" + i + "] = " + nArray[i]);
                    DBManager.debug("verifyMax = " + n2);
                }
                iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    DBManager.debug("pk- " + iterator.next());
                }
                DBManager.debug("************************************************");
            }
            iterator = collection.iterator();
            try {
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    CMPBean cMPBean = (CMPBean)this.getCache().getActive(transaction, new CacheKey(e, this), false);
                    if (cMPBean == null) continue;
                    n2 = cMPBean.__WL_appendVerifySql(arrayList, stringBufferArray, nArray, n2);
                    if (debugLogger.isDebugEnabled()) {
                        for (int i = 0; i < stringBufferArray.length; ++i) {
                            DBManager.debug("sql[" + i + "] = " + stringBufferArray[i]);
                            DBManager.debug("count[" + i + "] = " + nArray[i]);
                            DBManager.debug("verifyMax = " + n2);
                        }
                        Iterator iterator2 = arrayList.iterator();
                        while (iterator2.hasNext()) {
                            DBManager.debug("pk- " + iterator2.next());
                        }
                        DBManager.debug("------------------------------------------");
                    }
                    if (n2 < VERIFY_THRESHHOLD) continue;
                    this.doVerification(arrayList, stringBufferArray, nArray, transaction, bl);
                    arrayList.clear();
                    stringBufferArray = this.rdbmsPersistence.getVerifySql(bl);
                    nArray = this.rdbmsPersistence.getVerifyCount();
                    n2 = 0;
                }
                if (n2 > 0) {
                    this.doVerification(arrayList, stringBufferArray, nArray, transaction, bl);
                }
            }
            catch (Throwable throwable) {
                if (!(throwable instanceof OptimisticConcurrencyException)) {
                    EJBLogger.logExcepInBeforeCompletion((String)StackTraceUtils.throwable2StackTrace((Throwable)throwable));
                } else {
                    Iterator iterator3 = arrayList.iterator();
                    while (iterator3.hasNext()) {
                        CacheKey cacheKey = new CacheKey(iterator3.next(), this);
                        CMPBean cMPBean = (CMPBean)this.getCache().getActive(object, cacheKey, false);
                        cMPBean.__WL_setBeanStateValid(false);
                    }
                }
                EJBRuntimeUtils.throwInternalException("Exception during before completion:", throwable);
                throw new AssertionError("cannot reach");
            }
        }
        for (ArrayList arrayList : collection) {
            stringBufferArray = new CacheKey(arrayList, this);
            n = this.getCache().getActive(object, (CacheKey)stringBufferArray, true);
            try {
                if (n != null && this.shouldStore((EntityBean)n)) {
                    Transaction transaction = null;
                    if (object instanceof Transaction) {
                        transaction = (Transaction)object;
                    }
                    if (this.orderDatabaseOperations && transaction != null) {
                        ((CMPBean)((Object)n)).__WL_superEjbStore();
                    } else {
                        n.ejbStore();
                    }
                }
            }
            catch (Throwable throwable) {
                if (!(throwable instanceof OptimisticConcurrencyException)) {
                    EJBLogger.logExcepFromStore((Throwable)throwable);
                }
                this.getCache().removeOnError(object, new CacheKey(arrayList, this));
                EJBRuntimeUtils.throwInternalException("Exception from ejbStore:", throwable);
                throw new AssertionError("cannot reach");
            }
            this.getCache().unpin(object, (CacheKey)stringBufferArray);
        }
    }

    public void flushModified(Collection collection, Transaction transaction, boolean bl, Collection collection2) throws InternalException {
        assert (transaction != null);
        assert (collection != null);
        for (Object e : collection) {
            EntityBean entityBean = this.getCache().getActive(transaction, new CacheKey(e, this), false);
            if (this.isBeanManagedPersistence) {
                try {
                    if (entityBean == null || !this.shouldStore(entityBean)) continue;
                    entityBean.ejbStore();
                    if (!bl) continue;
                    collection2.add(e);
                }
                catch (Throwable throwable) {
                    this.getCache().removeOnError(transaction, new CacheKey(e, this));
                    EJBRuntimeUtils.throwInternalException("Error writing from flushModified", throwable);
                }
                continue;
            }
            try {
                if (entityBean == null || !this.shouldStore(entityBean)) continue;
                if (this.orderDatabaseOperations && transaction != null) {
                    ((CMPBean)entityBean).__WL_superEjbStore();
                    continue;
                }
                ((CMPBean)entityBean).__WL_store(false);
                if (!bl) continue;
                collection2.add(e);
            }
            catch (Throwable throwable) {
                EJBLogger.logExcepFromStore((Throwable)throwable);
                this.getCache().removeOnError(transaction, new CacheKey(e, this));
                EJBRuntimeUtils.throwInternalException("Error writing from flushModified", throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void passivateAndRemove(Transaction transaction, Object object, CacheKey cacheKey, EntityBean entityBean) {
        boolean bl = false;
        try {
            try {
                entityBean.ejbPassivate();
            }
            catch (Throwable throwable) {
                EJBLogger.logErrorPassivating((String)StackTraceUtils.throwable2StackTrace((Throwable)throwable));
                bl = true;
                Object var8_7 = null;
                this.cacheRTMBean.incrementPassivationCount();
            }
            Object var8_6 = null;
            this.cacheRTMBean.incrementPassivationCount();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.cacheRTMBean.incrementPassivationCount();
            throw throwable;
        }
        if (!bl) {
            if (debugLogger.isDebugEnabled()) {
                DBManager.debug("afterCompletion: tx- " + transaction + ", ejb- " + this.info.getEJBName() + ", pk- " + object + " removed from cache.");
            }
            this.getCache().remove(transaction, cacheKey);
        } else {
            if (debugLogger.isDebugEnabled()) {
                DBManager.debug("afterCompletion: tx- " + transaction + ", ejb- " + this.info.getEJBName() + ", pk- " + object + " removedOnError from cache.");
            }
            this.getCache().removeOnError(transaction, cacheKey);
        }
    }

    public void afterCompletion(Collection collection, Transaction transaction, int n, Object object) {
        this.afterCompletion(collection, (Object)transaction, n, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCompletion(Collection collection, Object object, int n, Object object2) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e;
            CacheKey cacheKey;
            EntityCache entityCache = object2 != null ? (EntityCache)object2 : this.publicCache;
            EntityBean entityBean = entityCache.getActive(object, cacheKey = new CacheKey(e = iterator.next(), this), true);
            if (entityBean == null) continue;
            boolean bl = false;
            EntityBean entityBean2 = entityBean;
            synchronized (entityBean2) {
                WLEntityBean wLEntityBean = (WLEntityBean)entityBean;
                if (!wLEntityBean.__WL_isBusy()) {
                    wLEntityBean.__WL_setLoadUser(null);
                    if (this.cacheBetweenTransactions && n != 3) {
                        if (!this.isBeanManagedPersistence && this.uses20CMP) {
                            CMPBean cMPBean = (CMPBean)entityBean;
                            if (!this.isOptimistic) {
                                cMPBean.__WL_setBeanStateValid(false);
                            } else if (cMPBean.__WL_isModified()) {
                                cMPBean.__WL_setBeanStateValid(false);
                            } else {
                                cMPBean.__WL_clearCMRFields();
                            }
                        }
                        bl = true;
                    } else if (this.remoteHome == null || !wLEntityBean.__WL_isCreatorOfTx()) {
                        bl = true;
                        if (debugLogger.isDebugEnabled()) {
                            DBManager.debug("afterCompletion: txOrThread- " + object + ", ejb- " + this.info.getEJBName() + ", pk- " + e + " released from cache.");
                        }
                    }
                } else {
                    if (debugLogger.isDebugEnabled()) {
                        DBManager.debug("afterCompletion: setNeedsRemove, txOrThread= " + object + ", ejb- " + this.info.getEJBName() + ", pk- " + e);
                    }
                    wLEntityBean.__WL_setNeedsRemove(true);
                }
            }
            if (bl) {
                this.cacheReleaseBean(entityBean, object, cacheKey, entityCache);
                continue;
            }
            entityCache.unpin(object, cacheKey);
        }
    }

    public EJBObject remoteCreate(InvocationWrapper invocationWrapper, Method method, Method method2, Object[] objectArray) throws InternalException {
        return (EJBObject)this.create(invocationWrapper, method, method2, objectArray);
    }

    public EJBLocalObject localCreate(InvocationWrapper invocationWrapper, Method method, Method method2, Object[] objectArray) throws InternalException {
        return (EJBLocalObject)this.create(invocationWrapper, method, method2, objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object create(InvocationWrapper invocationWrapper, Method method, Method method2, Object[] objectArray) throws InternalException {
        EJBObject eJBObject;
        DiagnosticActionState[] diagnosticActionStateArray;
        DiagnosticAction[] diagnosticActionArray;
        boolean bl;
        block41: {
            BaseEJBLocalObjectIntf baseEJBLocalObjectIntf;
            bl = _WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Create_Around_Medium.isEnabledAndNotDyeFiltered();
            diagnosticActionArray = null;
            diagnosticActionStateArray = null;
            Object var25_8 = null;
            if (bl) {
                Object[] objectArray2 = null;
                if (_WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Create_Around_Medium.isArgumentsCaptureNeeded()) {
                    objectArray2 = new Object[]{this, invocationWrapper, method, method2, objectArray};
                }
                DynamicJoinPoint dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_2, (Object[])objectArray2, null);
                DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Create_Around_Medium;
                diagnosticActionArray = delegatingMonitor.getActions();
                diagnosticActionStateArray = InstrumentationSupport.getActionStates((DiagnosticAction[])diagnosticActionArray);
                InstrumentationSupport.preProcess((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
            }
            try {
                CMPBean cMPBean;
                Object object;
                EntityBean entityBean = this.getBeanFromPool();
                ((WLEnterpriseBean)entityBean).__WL_setBusy(true);
                boolean bl2 = false;
                Object object2 = null;
                CacheKey cacheKey = null;
                eJBObject = null;
                baseEJBLocalObjectIntf = null;
                EJBContext eJBContext = ((WLEnterpriseBean)entityBean).__WL_getEJBContext();
                if (this.remoteHome != null) {
                    eJBObject = this.remoteHome.allocateEO(DUMMY_PK);
                }
                ((WLEJBContext)eJBContext).setEJBObject(eJBObject);
                if (this.localHome != null) {
                    baseEJBLocalObjectIntf = this.localHome.allocateELO(DUMMY_PK);
                }
                ((WLEJBContext)eJBContext).setEJBLocalObject(baseEJBLocalObjectIntf);
                try {
                    object2 = method.invoke((Object)entityBean, objectArray);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new AssertionError((Throwable)illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    object = invocationTargetException.getTargetException();
                    if (debugLogger.isDebugEnabled()) {
                        DBManager.debug("Error during create: ", (Throwable)object);
                    }
                    this.destroyPooledBean(entityBean);
                    this.handleMethodException(method, null, (Throwable)object);
                }
                try {
                    if (object2 == null) {
                        if (!(entityBean instanceof CMPBean)) {
                            throw new InternalException("Error during create.", new RuntimeCheckerException("Your BMP ejbCreate should not be returning null."));
                        }
                        method2.invoke((Object)entityBean, objectArray);
                        bl2 = true;
                        object2 = ((CMPBean)entityBean).__WL_getPrimaryKey();
                    }
                    if (this.remoteHome != null) {
                        eJBObject = ((EntityEJBContextImpl)eJBContext).__WL_getEJBObject();
                        ((EntityEJBObject)eJBObject).setPrimaryKey(object2);
                    }
                    if (this.localHome != null) {
                        baseEJBLocalObjectIntf = ((EntityEJBContextImpl)eJBContext).__WL_getEJBLocalObject();
                        ((EntityEJBLocalObject)baseEJBLocalObjectIntf).setPrimaryKey(object2);
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new AssertionError((Throwable)illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    object = invocationTargetException.getTargetException();
                    if (debugLogger.isDebugEnabled()) {
                        DBManager.debug("Error during postCreate: " + object);
                    }
                    this.destroyPooledBean(entityBean);
                    this.handleMethodException(method2, this.extraPostCreateExceptions, (Throwable)object);
                }
                EntityEJBContextImpl entityEJBContextImpl = (EntityEJBContextImpl)((WLEnterpriseBean)entityBean).__WL_getEJBContext();
                entityEJBContextImpl.__WL_setPrimaryKey(object2);
                cacheKey = new CacheKey(object2, this);
                object = invocationWrapper.getInvokeTxOrThread();
                assert (object != null);
                boolean bl3 = false;
                boolean bl4 = false;
                if (!this.isBeanManagedPersistence && (cMPBean = (CMPBean)this.getCache().getActive(object, cacheKey, true)) != null) {
                    bl4 = true;
                    if (this.orderDatabaseOperations && cMPBean.__WL_getIsRemoved()) {
                        bl3 = true;
                        cMPBean.__WL_setIsRemoved(false);
                    }
                    cMPBean.__WL_setBusy(true);
                    cMPBean.__WL_initialize(false);
                    if (debugLogger.isDebugEnabled()) {
                        DBManager.debug("collision occurred, __WL_copyFrom, pk=" + object2 + ", txOrThread=" + object);
                    }
                    cMPBean.__WL_copyFrom((CMPBean)entityBean, false);
                    ((WLEnterpriseBean)entityBean).__WL_setBusy(false);
                    this.releaseBeanToPool(entityBean);
                    entityBean = (EntityBean)cMPBean;
                    ((WLEntityBean)entityBean).__WL_setOperationsComplete(false);
                }
                if (!bl4) {
                    try {
                        this.getCache().put(object, cacheKey, entityBean, this, true);
                        this.cacheRTMBean.incrementCachedBeansCurrentCount();
                        this.initLastLoad(object2, entityBean);
                    }
                    catch (CacheFullException cacheFullException) {
                        this.destroyPooledBean(entityBean);
                        throw new InternalException("Error during create.", cacheFullException);
                    }
                }
                try {
                    if (bl3) {
                        this.registerInsertDeletedBeanAndTxUser(object2, invocationWrapper.getInvokeTx(), (WLEnterpriseBean)entityBean);
                    } else if (this.orderDatabaseOperations && invocationWrapper.getInvokeTx() != null) {
                        this.registerInsertBeanAndTxUser(object2, invocationWrapper.getInvokeTx(), (WLEnterpriseBean)entityBean);
                    } else {
                        this.setupTxListenerAndTxUser(object2, object, (WLEnterpriseBean)entityBean);
                    }
                }
                catch (InternalException internalException) {
                    this.getCache().removeOnError(object, new CacheKey(object2, this));
                    throw internalException;
                }
                if (!bl2) {
                    try {
                        try {
                            Debug.assertion((method2 != null ? 1 : 0) != 0);
                            Debug.assertion((entityBean != null ? 1 : 0) != 0);
                            Debug.assertion((objectArray != null ? 1 : 0) != 0);
                            if (bl3) {
                                ((CMPBean)entityBean).__WL_setCreateAfterRemove(true);
                            }
                            method2.invoke((Object)entityBean, objectArray);
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            throw new AssertionError((Throwable)illegalAccessException);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            Throwable throwable = invocationTargetException.getTargetException();
                            this.getCache().removeOnError(object, cacheKey);
                            this.handleMethodException(method2, this.extraPostCreateExceptions, throwable);
                            Object var19_33 = null;
                            if (bl3) {
                                ((CMPBean)entityBean).__WL_setCreateAfterRemove(false);
                            }
                        }
                        Object var19_32 = null;
                        if (bl3) {
                            ((CMPBean)entityBean).__WL_setCreateAfterRemove(false);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var19_34 = null;
                        if (!bl3) throw throwable;
                        ((CMPBean)entityBean).__WL_setCreateAfterRemove(false);
                        throw throwable;
                    }
                }
                ((WLEnterpriseBean)entityBean).__WL_setBusy(false);
                this.getCache().unpin(object, cacheKey);
                if (!invocationWrapper.isLocal()) break block41;
                Object var23_37 = null;
                if (!bl) return baseEJBLocalObjectIntf;
            }
            catch (Throwable throwable) {
                Object var23_39 = null;
                if (!bl) throw throwable;
                InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_2, (DiagnosticMonitor)_WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Create_Around_Medium, diagnosticActionArray, diagnosticActionStateArray);
                throw throwable;
            }
            InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_2, (DiagnosticMonitor)_WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Create_Around_Medium, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
            return baseEJBLocalObjectIntf;
        }
        Object var23_38 = null;
        if (!bl) return eJBObject;
        InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_2, (DiagnosticMonitor)_WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Create_Around_Medium, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
        return eJBObject;
    }

    public void remove(InvocationWrapper invocationWrapper) throws InternalException {
        EntityBean entityBean = (EntityBean)this.preInvoke(invocationWrapper);
        Object object = invocationWrapper.getInvokeTxOrThread();
        Object object2 = invocationWrapper.getPrimaryKey();
        Iterator iterator = null;
        try {
            iterator = this.cascadeDeleteRemove(invocationWrapper, entityBean);
            if (this.orderDatabaseOperations && invocationWrapper.getInvokeTx() != null) {
                ((CMPBean)entityBean).__WL_superEjbRemove(false);
                ((CMPBean)entityBean).__WL_setIsRemoved(true);
                if (!this.registerDeleteBean(object2, invocationWrapper.getInvokeTx())) {
                    if (((CMPBean)entityBean).__WL_getIsRemoved()) {
                        ((CMPBean)entityBean).__WL_initialize();
                        ((CMPBean)entityBean).__WL_setIsRemoved(false);
                    }
                    this.getCache().remove(object, new CacheKey(object2, this));
                }
            } else {
                entityBean.ejbRemove();
                this.getCache().remove(object, new CacheKey(object2, this));
            }
            if (this.timerManager != null) {
                this.timerManager.removeTimersForPK(object2);
            }
        }
        catch (Throwable throwable) {
            ((WLEnterpriseBean)entityBean).__WL_setBusy(false);
            this.getCache().removeOnError(object, new CacheKey(object2, this));
            this.handleMethodException(invocationWrapper.getMethodDescriptor().getMethod(), null, throwable);
        }
        this.cascadeDeleteRemove(invocationWrapper, entityBean, iterator);
    }

    public void remove(InvocationWrapper invocationWrapper, EntityBean entityBean, boolean bl) throws InternalException {
        Object object = invocationWrapper.getInvokeTxOrThread();
        CMPBean cMPBean = (CMPBean)entityBean;
        EntityEJBContextImpl entityEJBContextImpl = (EntityEJBContextImpl)cMPBean.__WL_getEntityContext();
        Object object2 = entityEJBContextImpl.__WL_getPrimaryKey();
        this.checkForReentrant(entityBean, object2);
        ((WLEnterpriseBean)entityBean).__WL_setBusy(true);
        try {
            if (bl) {
                ((CMPBean)entityBean).__WL_superEjbRemove(true);
                this.getCache().remove(object, new CacheKey(object2, this));
            } else if (this.orderDatabaseOperations && invocationWrapper.getInvokeTx() != null) {
                ((CMPBean)entityBean).__WL_superEjbRemove(false);
                ((CMPBean)entityBean).__WL_setIsRemoved(true);
                if (!this.registerDeleteBean(object2, invocationWrapper.getInvokeTx())) {
                    if (((CMPBean)entityBean).__WL_getIsRemoved()) {
                        ((CMPBean)entityBean).__WL_initialize();
                        ((CMPBean)entityBean).__WL_setIsRemoved(false);
                    }
                    this.getCache().remove(object, new CacheKey(object2, this));
                }
            } else {
                entityBean.ejbRemove();
                this.getCache().remove(object, new CacheKey(object2, this));
            }
            if (this.timerManager != null) {
                this.timerManager.removeTimersForPK(object2);
            }
        }
        catch (Throwable throwable) {
            this.getCache().removeOnError(object, new CacheKey(object2, this));
            this.handleMethodException(invocationWrapper.getMethodDescriptor().getMethod(), null, throwable);
        }
    }

    public EnterpriseBean lookup(Object object) throws InternalException {
        Object object2 = EJBRuntimeUtils.getInvokeTxOrThread();
        EntityBean entityBean = this.getReadyBean(object2, object, false);
        return entityBean;
    }

    public EntityBean getBeanFromRS(Object object, Object object2, RSInfo rSInfo) throws InternalException {
        EntityBean entityBean = null;
        assert (object != null);
        entityBean = this.getCache().get(object, new CacheKey(object2, this), rSInfo, true);
        this.cacheRTMBean.incrementCacheAccessCount();
        if (entityBean != null) {
            this.cacheRTMBean.incrementCacheHitCount();
        } else {
            entityBean = this.getBeanFromPool();
            ((CMPBean)entityBean).__WL_initialize();
            this.persistence.loadBeanFromRS(entityBean, rSInfo);
            if (!this.finderCacheInsert(entityBean)) {
                return null;
            }
        }
        return entityBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean finderCacheInsert(Object object, Object object2, EJBObject eJBObject, EJBLocalObject eJBLocalObject, EntityBean entityBean) throws InternalException {
        EJBContext eJBContext;
        assert (eJBObject != null || eJBLocalObject != null);
        if (debugLogger.isDebugEnabled()) {
            DBManager.debug("called finderCacheInsert...");
        }
        try {
            this.ejbHome.pushEnvironment();
            eJBContext = ((WLEnterpriseBean)entityBean).__WL_getEJBContext();
            ((WLEJBContext)eJBContext).setEJBObject(eJBObject);
            ((WLEJBContext)eJBContext).setEJBLocalObject(eJBLocalObject);
            try {
                entityBean.ejbActivate();
                this.cacheRTMBean.incrementActivationCount();
            }
            catch (Throwable throwable) {
                EJBLogger.logErrorDuringActivate((String)StackTraceUtils.throwable2StackTrace((Throwable)throwable));
                this.destroyPooledBean(entityBean);
                EJBRuntimeUtils.throwInternalException("Exception in ejbActivate", throwable);
                throw new AssertionError("will not reach");
            }
            try {
                ((CMPBean)entityBean).__WL_superEjbLoad();
            }
            catch (Throwable throwable) {
                EJBLogger.logExcepFromSuperLoad((Throwable)throwable);
                this.destroyPooledBean(entityBean);
                EJBRuntimeUtils.throwInternalException("Exception in superEjbLoad:", throwable);
                throw new AssertionError("cannot reach");
            }
            Object var9_11 = null;
            this.ejbHome.popEnvironment();
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            this.ejbHome.popEnvironment();
            throw throwable;
        }
        try {
            eJBContext = null;
            if (object instanceof Transaction) {
                eJBContext = (Transaction)object;
            }
            this.setupTxListenerAndTxUser(object2, eJBContext, (WLEnterpriseBean)entityBean);
        }
        catch (InternalException internalException) {
            this.destroyPooledBean(entityBean);
            throw internalException;
        }
        try {
            this.getCache().put(object, new CacheKey(object2, this), entityBean, this, true);
            this.cacheRTMBean.incrementCachedBeansCurrentCount();
            this.initLastLoad(object2, entityBean);
        }
        catch (CacheFullException cacheFullException) {
            this.passivateAndRelease(new CacheKey(object2, this), entityBean);
            return false;
        }
        return true;
    }

    public void postFinderCleanup(Object object, Collection collection, boolean bl, boolean bl2) {
        block20: {
            Object object22;
            Object object3;
            block19: {
                if (!this.findersLoadBean) {
                    return;
                }
                object3 = null;
                object3 = TxHelper.getTransaction();
                if (object3 == null) {
                    object3 = Thread.currentThread();
                }
                object22 = null;
                if (object == null) break block19;
                if (bl) {
                    object22 = object;
                } else if (bl2) {
                    object22 = ((EJBLocalObject)object).getPrimaryKey();
                } else {
                    try {
                        object22 = ((EJBObject)object).getPrimaryKey();
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
                if (object22 == null) break block20;
                this.getCache().unpin(object3, new CacheKey(object22, this));
                break block20;
            }
            if (collection != null) {
                if (bl) {
                    for (Object object22 : collection) {
                        if (object22 == null) continue;
                        this.getCache().unpin(object3, new CacheKey(object22, this));
                    }
                } else {
                    Iterator iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        EJBLocalObject eJBLocalObject;
                        object22 = null;
                        if (bl2) {
                            eJBLocalObject = (EJBLocalObject)iterator.next();
                            if (eJBLocalObject != null) {
                                object22 = eJBLocalObject.getPrimaryKey();
                            }
                        } else {
                            eJBLocalObject = (EJBObject)iterator.next();
                            if (eJBLocalObject != null) {
                                try {
                                    object22 = eJBLocalObject.getPrimaryKey();
                                }
                                catch (RemoteException remoteException) {
                                    // empty catch block
                                }
                            }
                        }
                        if (object22 == null) continue;
                        this.getCache().unpin(object3, new CacheKey(object22, this));
                    }
                }
            }
        }
    }

    public void unpin(Object object, Object object2) {
        this.getCache().unpin(object, new CacheKey(object2, this));
    }

    protected void initLastLoad(Object object, EntityBean entityBean) {
    }

    protected boolean supportsCopy() {
        return false;
    }

    protected void perhapsCopy(Object object, EntityBean entityBean) throws InternalException {
    }

    protected void cacheRemoveBean(Transaction transaction, Object object) {
        this.getCache().remove(transaction, new CacheKey(object, this));
    }

    protected void cacheRemoveBeanOnError(Transaction transaction, Object object) {
        this.getCache().removeOnError(transaction, new CacheKey(object, this));
    }

    protected EntityBean alreadyCached(Object object, Object object2) throws InternalException {
        EntityBean entityBean = null;
        entityBean = this.cacheBetweenTransactions ? this.getCache().getValid(object, new CacheKey(object2, this), false) : this.getCache().getActive(object, new CacheKey(object2, this), false);
        if (entityBean != null && !this.isBeanManagedPersistence && ((CMPBean)entityBean).__WL_getIsRemoved()) {
            Loggable loggable = EJBLogger.lognoSuchEntityExceptionLoggable((String)object2.toString());
            EJBRuntimeUtils.throwInternalException("EJB Exception: ", (Throwable)new ObjectNotFoundException(loggable.getMessage()));
            entityBean = null;
        }
        return entityBean;
    }

    public void setMaxBeansInCache(int n) {
        this.getCache().setMaxBeansInCache(n);
    }

    public GroupMessage createRecoverMessage() {
        return new InvalidationMessage(this.info.getDeploymentInfo().getApplicationName(), this.info.getDeploymentInfo().getEJBComponentName(), this.info.getEJBName());
    }

    protected void sendInvalidate(Object object) throws InternalException {
        InvalidationMessage invalidationMessage = object == null ? new InvalidationMessage(this.info.getDeploymentInfo().getApplicationName(), this.info.getDeploymentInfo().getEJBComponentName(), this.info.getEJBName()) : (object instanceof Collection ? new InvalidationMessage(this.info.getDeploymentInfo().getApplicationName(), this.info.getDeploymentInfo().getEJBComponentName(), this.info.getEJBName(), (Collection)object) : new InvalidationMessage(this.info.getDeploymentInfo().getApplicationName(), this.info.getDeploymentInfo().getEJBComponentName(), this.info.getEJBName(), object));
        try {
            this.multicastSession.send(invalidationMessage);
        }
        catch (IOException iOException) {
            Loggable loggable = EJBLogger.logErrorWhileMulticastingInvalidationLoggable((String)this.ejbHome.getDisplayName(), (Exception)iOException);
            throw new InternalException(loggable.getMessage(), iOException);
        }
    }

    public void invalidate(Object object, Object object2) throws InternalException {
        this.invalidateLocalServer(object, object2);
        if (!this.clusterInvalidationDisabled) {
            this.sendInvalidate(object2);
        }
    }

    public void invalidate(Object object, Collection collection) throws InternalException {
        this.invalidateLocalServer(object, collection);
        if (!this.clusterInvalidationDisabled) {
            this.sendInvalidate(collection);
        }
        this.resetInvalidationFlag(object, collection);
    }

    public void invalidateAll(Object object) throws InternalException {
        this.invalidateAllLocalServer(object);
        if (!this.clusterInvalidationDisabled) {
            this.sendInvalidate(null);
        }
    }

    public void invalidateLocalServer(Object object, Object object2) {
        this.getCache().invalidate(object, new CacheKey(object2, this));
        if (this.invalidationTargetBM != null) {
            this.invalidationTargetBM.invalidateLocalServer(object, object2);
        }
    }

    public void invalidateLocalServer(Object object, Collection collection) {
        ArrayList<CacheKey> arrayList = new ArrayList<CacheKey>();
        for (Object e : collection) {
            arrayList.add(new CacheKey(e, this));
        }
        this.getCache().invalidate(object, arrayList);
        if (this.invalidationTargetBM != null) {
            this.invalidationTargetBM.invalidateLocalServer(object, collection);
        }
    }

    private void resetInvalidationFlag(Object object, Collection collection) {
        if (object == null) {
            return;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            EntityBean entityBean = this.getCache().getActive(object, new CacheKey(iterator.next(), this), false);
            if (entityBean == null) continue;
            ((CMPBean)entityBean).__WL_setInvalidatedBeanIsRegistered(false);
        }
    }

    public void invalidateAllLocalServer(Object object) {
        this.getCache().invalidateAll(object);
        if (this.invalidationTargetBM != null) {
            this.invalidationTargetBM.invalidateAllLocalServer(object);
        }
    }

    public void beanImplClassChangeNotification() {
        super.beanImplClassChangeNotification();
        this.getCache().beanImplClassChangeNotification();
    }

    public void updateMaxBeansInCache(int n) {
        this.getCache().updateMaxBeansInCache(n);
    }

    public void releaseBean(InvocationWrapper invocationWrapper) {
        try {
            Object object = invocationWrapper.getInvokeTxOrThread();
            Object object2 = invocationWrapper.getPrimaryKey();
            CacheKey cacheKey = new CacheKey(object2, this);
            this.cacheReleaseBean(null, object, cacheKey, this.getCache());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void cacheReleaseBean(EntityBean entityBean, Object object, CacheKey cacheKey, EntityCache entityCache) {
        if (entityBean == null && (entityBean = entityCache.getActive(object, cacheKey, false)) == null) {
            return;
        }
        ((WLEntityBean)entityBean).__WL_setOperationsComplete(false);
        if (entityBean instanceof CMPBean) {
            ((CMPBean)entityBean).__WL_setNonFKHolderRelationChange(false);
            ((CMPBean)entityBean).__WL_setM2NInsert(false);
        }
        entityCache.release(object, cacheKey);
    }

    public void reInitializeCacheAndPool() {
        this.getCache().reInitializeCacheAndPools();
    }

    public int cachePassivateModifiedBean(Transaction transaction, Object object, boolean bl) {
        return this.getCache().passivateModifiedBean(transaction, new CacheKey(object, this), bl);
    }

    public int cachePassivateUnModifiedBean(Transaction transaction, Object object) {
        int n = this.getCache().passivateUnModifiedBean(transaction, new CacheKey(object, this));
        for (int i = 0; i < n; ++i) {
            this.cacheRTMBean.decrementCachedBeansCurrentCount();
        }
        return n;
    }

    public void operationsComplete(Transaction transaction, Object object) {
        EntityBean entityBean = this.getCache().getActive(transaction, new CacheKey(object, this), false);
        if (entityBean == null) {
            return;
        }
        ((WLEntityBean)entityBean).__WL_setOperationsComplete(true);
    }

    public boolean beanIsOpsComplete(Transaction transaction, Object object) {
        EntityBean entityBean = this.getCache().getActive(transaction, new CacheKey(object, this), false);
        if (entityBean == null) {
            return true;
        }
        return ((WLEntityBean)entityBean).__WL_getOperationsComplete();
    }

    private static void debug(String string) {
        debugLogger.debug("[DBManager] " + string);
    }

    private static void debug(String string, Throwable throwable) {
        debugLogger.debug("[DBManager] " + string, throwable);
    }

    public void updateIdleTimeoutSecondsCache(int n) {
        this.getCache().updateIdleTimeoutSeconds(n);
    }

    public void undeploy() {
        super.undeploy();
        if (this.scrubberStarted) {
            Debug.assertion((boolean)(this.publicCache instanceof ScrubbedCache), (String)"expected ScrubbedCache");
            this.publicCache.stopScrubber();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void passivateAndBacktoPool(CacheKey cacheKey, EntityBean entityBean) {
        try {
            try {
                entityBean.ejbPassivate();
                ((WLEnterpriseBean)entityBean).__WL_setBusy(false);
                this.releaseBeanToPool(entityBean);
            }
            catch (Throwable throwable) {
                EJBLogger.logErrorPassivating((String)StackTraceUtils.throwable2StackTrace((Throwable)throwable));
                this.destroyPooledBean(entityBean);
                Object var5_4 = null;
                this.cacheRTMBean.incrementPassivationCount();
                this.cacheRTMBean.decrementCachedBeansCurrentCount();
            }
            Object var5_3 = null;
            this.cacheRTMBean.incrementPassivationCount();
            this.cacheRTMBean.decrementCachedBeansCurrentCount();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.cacheRTMBean.incrementPassivationCount();
            this.cacheRTMBean.decrementCachedBeansCurrentCount();
            throw throwable;
        }
    }

    static {
        _WLDF$INST_FLD_class = Class.forName("weblogic.ejb.container.manager.DBManager");
        _WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Preinvoke_Entity_After_Medium = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"EJB_Diagnostic_Pool_Manager_Preinvoke_Entity_After_Medium");
        _WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Postinvoke_Entity_Before_Medium = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"EJB_Diagnostic_Pool_Manager_Postinvoke_Entity_Before_Medium");
        _WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Create_Around_Medium = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"EJB_Diagnostic_Pool_Manager_Create_Around_Medium");
        _WLDF$INST_JPFLD_0 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"DBManager.java", (String)"weblogic.ejb.container.manager.DBManager", (String)"preInvoke", (String)"(Lweblogic/ejb/container/internal/InvocationWrapper;)Ljavax/ejb/EnterpriseBean;", (int)303, (Map)InstrumentationSupport.makeMap((String[])new String[]{"EJB_Diagnostic_Pool_Manager_Preinvoke_Entity_After_Medium"}, (PointcutHandlingInfo[])new PointcutHandlingInfo[]{InstrumentationSupport.createPointcutHandlingInfo(null, null, (ValueHandlingInfo[])new ValueHandlingInfo[]{InstrumentationSupport.createValueHandlingInfo((String)"wrap", (String)"weblogic.diagnostics.instrumentation.gathering.EJBInvocationWrapperRenderer", (boolean)false, (boolean)true)})}), (boolean)false);
        _WLDF$INST_JPFLD_1 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"DBManager.java", (String)"weblogic.ejb.container.manager.DBManager", (String)"postInvoke", (String)"(Lweblogic/ejb/container/internal/InvocationWrapper;)V", (int)567, (Map)InstrumentationSupport.makeMap((String[])new String[]{"EJB_Diagnostic_Pool_Manager_Postinvoke_Entity_Before_Medium"}, (PointcutHandlingInfo[])new PointcutHandlingInfo[]{InstrumentationSupport.createPointcutHandlingInfo(null, null, (ValueHandlingInfo[])new ValueHandlingInfo[]{InstrumentationSupport.createValueHandlingInfo((String)"wrap", (String)"weblogic.diagnostics.instrumentation.gathering.EJBInvocationWrapperRenderer", (boolean)false, (boolean)true)})}), (boolean)false);
        _WLDF$INST_JPFLD_2 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"DBManager.java", (String)"weblogic.ejb.container.manager.DBManager", (String)"create", (String)"(Lweblogic/ejb/container/internal/InvocationWrapper;Ljava/lang/reflect/Method;Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/lang/Object;", (int)1408, (Map)InstrumentationSupport.makeMap((String[])new String[]{"EJB_Diagnostic_Pool_Manager_Create_Around_Medium"}, (PointcutHandlingInfo[])new PointcutHandlingInfo[]{InstrumentationSupport.createPointcutHandlingInfo(null, null, (ValueHandlingInfo[])new ValueHandlingInfo[]{InstrumentationSupport.createValueHandlingInfo((String)"wrap", (String)"weblogic.diagnostics.instrumentation.gathering.EJBInvocationWrapperRenderer", (boolean)false, (boolean)true), null, null, null})}), (boolean)false);
        DUMMY_PK = new Object();
        VERIFY_THRESHHOLD = 50;
    }
}

