/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.manager;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.NoSuchObjectException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ejb.EJBContext;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.EnterpriseBean;
import javax.ejb.EntityBean;
import javax.ejb.ObjectNotFoundException;
import javax.naming.Context;
import javax.transaction.Transaction;
import weblogic.diagnostics.instrumentation.DelegatingMonitor;
import weblogic.diagnostics.instrumentation.DiagnosticAction;
import weblogic.diagnostics.instrumentation.DiagnosticActionState;
import weblogic.diagnostics.instrumentation.DiagnosticMonitor;
import weblogic.diagnostics.instrumentation.DynamicJoinPoint;
import weblogic.diagnostics.instrumentation.InstrumentationSupport;
import weblogic.diagnostics.instrumentation.JoinPoint;
import weblogic.diagnostics.instrumentation.PointcutHandlingInfo;
import weblogic.diagnostics.instrumentation.ValueHandlingInfo;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.InternalException;
import weblogic.ejb.container.cache.CacheKey;
import weblogic.ejb.container.cache.NRUCache;
import weblogic.ejb.container.interfaces.BaseEJBLocalHomeIntf;
import weblogic.ejb.container.interfaces.BaseEJBLocalObjectIntf;
import weblogic.ejb.container.interfaces.BaseEJBRemoteHomeIntf;
import weblogic.ejb.container.interfaces.BeanInfo;
import weblogic.ejb.container.interfaces.BeanManager;
import weblogic.ejb.container.interfaces.CachingManager;
import weblogic.ejb.container.interfaces.EntityBeanInfo;
import weblogic.ejb.container.interfaces.WLEJBContext;
import weblogic.ejb.container.interfaces.WLEnterpriseBean;
import weblogic.ejb.container.interfaces.WLEntityBean;
import weblogic.ejb.container.internal.EJBComponentRuntimeMBeanImpl;
import weblogic.ejb.container.internal.EJBRuntimeUtils;
import weblogic.ejb.container.internal.EntityEJBContextImpl;
import weblogic.ejb.container.internal.InvocationWrapper;
import weblogic.ejb.container.locks.ExclusiveLockManager;
import weblogic.ejb.container.locks.LockManager;
import weblogic.ejb.container.manager.BaseEntityManager;
import weblogic.ejb.container.monitoring.EJBCacheRuntimeMBeanImpl;
import weblogic.ejb.container.persistence.spi.CMPBean;
import weblogic.ejb.container.persistence.spi.CMPBeanManager;
import weblogic.ejb.container.persistence.spi.RSInfo;
import weblogic.ejb.container.swap.EntitySwap;
import weblogic.ejb.container.utils.PartialOrderSet;
import weblogic.ejb.spi.EJBCache;
import weblogic.ejb.spi.ScrubbedCache;
import weblogic.ejb.spi.WLDeploymentException;
import weblogic.ejb20.RuntimeCheckerException;
import weblogic.ejb20.cache.CacheFullException;
import weblogic.ejb20.locks.LockTimedOutException;
import weblogic.logging.Loggable;
import weblogic.management.runtime.EntityEJBRuntimeMBean;
import weblogic.utils.AssertionError;
import weblogic.utils.Debug;
import weblogic.utils.PlatformConstants;
import weblogic.utils.StackTraceUtils;

public class ExclusiveEntityManager
extends BaseEntityManager
implements BeanManager,
CMPBeanManager,
CachingManager {
    private static boolean staticChecks;
    private boolean cacheBetweenTransactions = false;
    private boolean delayUpdatedUntilEndOfTx = true;
    private LockManager lockManager;
    protected NRUCache cache;
    protected EntityBeanInfo info;
    private EJBCacheRuntimeMBeanImpl cacheRTMBean;
    private int beanSize;
    EntitySwap swapper = null;
    private int idleTimeoutSeconds;
    boolean scrubberStarted = false;
    static final long serialVersionUID = 598785125594735472L;
    public static final String _WLDF$INST_VERSION = "9.0.0";
    static /* synthetic */ Class _WLDF$INST_FLD_class;
    public static final DelegatingMonitor _WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Preinvoke_Entity_After_Medium;
    public static final DelegatingMonitor _WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Postinvoke_Entity_Before_Medium;
    public static final DelegatingMonitor _WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Create_Around_Medium;
    public static final JoinPoint _WLDF$INST_JPFLD_0;
    public static final JoinPoint _WLDF$INST_JPFLD_1;
    public static final JoinPoint _WLDF$INST_JPFLD_2;

    public ExclusiveEntityManager(EJBComponentRuntimeMBeanImpl eJBComponentRuntimeMBeanImpl) {
        super(eJBComponentRuntimeMBeanImpl);
    }

    public void setup(BaseEJBRemoteHomeIntf baseEJBRemoteHomeIntf, BaseEJBLocalHomeIntf baseEJBLocalHomeIntf, BeanInfo beanInfo, Context context) throws WLDeploymentException {
        throw new AssertionError("BeanManager.setup() should never be called on ExclusiveEntityManager.");
    }

    public void setup(BaseEJBRemoteHomeIntf baseEJBRemoteHomeIntf, BaseEJBLocalHomeIntf baseEJBLocalHomeIntf, BeanInfo beanInfo, Context context, EJBCache eJBCache) throws WLDeploymentException {
        super.setup(baseEJBRemoteHomeIntf, baseEJBLocalHomeIntf, beanInfo, context);
        EntityEJBRuntimeMBean entityEJBRuntimeMBean = (EntityEJBRuntimeMBean)this.getEJBRuntimeMBean();
        this.cacheRTMBean = (EJBCacheRuntimeMBeanImpl)entityEJBRuntimeMBean.getCacheRuntime();
        this.info = (EntityBeanInfo)beanInfo;
        this.lockManager = new ExclusiveLockManager(entityEJBRuntimeMBean.getLockingRuntime());
        this.lockManager.setup(this.info);
        this.swapper = new EntitySwap();
        this.swapper.setup(this.info, this, this.info.getClassLoader());
        this.idleTimeoutSeconds = this.info.getCachingDescriptor().getIdleTimeoutSecondsCache();
        if (eJBCache == null) {
            this.cache = new NRUCache(this.ejbHome.getDisplayName(), this.info.getCachingDescriptor().getMaxBeansInCache());
            this.beanSize = 1;
            this.cache.setScrubInterval(this.idleTimeoutSeconds);
            this.cache.startScrubber();
            this.scrubberStarted = true;
        } else {
            if (!(eJBCache instanceof NRUCache)) {
                Loggable loggable = EJBLogger.lognotAnExclusiveCacheLoggable((String)this.info.getEJBName(), (String)this.info.getCacheName());
                throw new WLDeploymentException(loggable.getMessage());
            }
            this.cache = (NRUCache)eJBCache;
            this.beanSize = eJBCache.usesMaxBeansInCache() ? 1 : this.info.getEstimatedBeanSize();
            this.cache.setScrubInterval(this.idleTimeoutSeconds);
        }
        this.cache.register(this);
        this.cacheRTMBean.setReInitializableCache(this.cache);
        this.cacheBetweenTransactions = this.info.getCacheBetweenTransactions();
        this.delayUpdatedUntilEndOfTx = this.info.getBoxCarUpdates();
    }

    private boolean acquireLock(InvocationWrapper invocationWrapper, Object object) throws InternalException {
        int n = invocationWrapper.getMethodDescriptor().getTxTimeoutMS();
        Object object2 = invocationWrapper.getInvokeTxOrThread();
        return this.acquireLock(object, object2, n);
    }

    private boolean acquireLock(Object object, Object object2, int n) throws InternalException {
        try {
            return this.lockManager.lock(object, object2, n);
        }
        catch (LockTimedOutException lockTimedOutException) {
            throw new InternalException(lockTimedOutException.getMessage(), lockTimedOutException);
        }
    }

    protected boolean shouldLoad(Object object, boolean bl, boolean bl2) {
        return !bl && !bl2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EnterpriseBean preInvoke(InvocationWrapper invocationWrapper) throws InternalException {
        EntityBean entityBean;
        try {
            super.preInvoke();
            Object object = invocationWrapper.getPrimaryKey();
            Object object2 = invocationWrapper.getInvokeTxOrThread();
            int n = invocationWrapper.getMethodDescriptor().getTxTimeoutMS();
            entityBean = this.getReadyBean(object, object2, n);
            this.checkForReentrant(entityBean, object);
            ((WLEnterpriseBean)entityBean).__WL_setBusy(true);
            Object var9_6 = null;
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            if (!_WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Preinvoke_Entity_After_Medium.isEnabledAndNotDyeFiltered()) throw throwable;
            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Preinvoke_Entity_After_Medium;
            InstrumentationSupport.process((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
            throw throwable;
        }
        if (!_WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Preinvoke_Entity_After_Medium.isEnabledAndNotDyeFiltered()) return entityBean;
        DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Preinvoke_Entity_After_Medium;
        InstrumentationSupport.process((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
        return entityBean;
    }

    private EntityBean getReadyBean(Object object, Object object2, int n) throws InternalException {
        boolean bl = this.acquireLock(object, object2, n);
        boolean bl2 = false;
        EntityBean entityBean = null;
        assert (!bl || object2 != null);
        CacheKey cacheKey = new CacheKey(object, this);
        try {
            this.cacheRTMBean.incrementCacheAccessCount();
            entityBean = (EntityBean)this.cache.get(cacheKey);
            if (entityBean == null) {
                EJBObject eJBObject = null;
                BaseEJBLocalObjectIntf baseEJBLocalObjectIntf = null;
                if (this.remoteHome != null) {
                    eJBObject = this.remoteHome.allocateEO(object);
                }
                if (this.localHome != null) {
                    baseEJBLocalObjectIntf = this.localHome.allocateELO(object);
                }
                entityBean = this.getBeanFromPool();
                WLEJBContext wLEJBContext = (WLEJBContext)((WLEnterpriseBean)entityBean).__WL_getEJBContext();
                ((EntityEJBContextImpl)wLEJBContext).__WL_setPrimaryKey(object);
                wLEJBContext.setEJBObject(eJBObject);
                wLEJBContext.setEJBLocalObject(baseEJBLocalObjectIntf);
                this.cache.put(cacheKey, (EnterpriseBean)entityBean);
                this.cacheRTMBean.incrementCachedBeansCurrentCount();
                bl2 = true;
                try {
                    entityBean.ejbActivate();
                    this.cacheRTMBean.incrementActivationCount();
                }
                catch (Throwable throwable) {
                    EJBLogger.logErrorDuringActivate((String)StackTraceUtils.throwable2StackTrace((Throwable)throwable));
                    this.destroyPooledBean(entityBean);
                    EJBRuntimeUtils.throwInternalException("Exception in ejbActivate:", throwable);
                    throw new AssertionError("does not reach");
                }
            } else {
                this.cacheRTMBean.incrementCacheHitCount();
            }
            if (this.shouldLoad(object, this.cacheBetweenTransactions, bl) || bl2) {
                try {
                    entityBean.ejbLoad();
                }
                catch (Throwable throwable) {
                    EJBLogger.logErrorFromLoad((Throwable)throwable);
                    EJBRuntimeUtils.throwInternalException("Exception in ejbLoad:", throwable);
                    throw new AssertionError("does not reach");
                }
            }
            if (!bl) {
                this.setupTxListenerAndTxUser(object, object2, (WLEnterpriseBean)entityBean);
            }
        }
        catch (Throwable throwable) {
            this.cache.removeOnError(cacheKey);
            if (!bl) {
                this.lockManager.unlock(object, object2);
            }
            EJBRuntimeUtils.throwInternalException("Exception during transition from pooled to ready:", throwable);
            throw new AssertionError("does not reach");
        }
        return entityBean;
    }

    protected boolean shouldStoreAfterMethod(InvocationWrapper invocationWrapper) {
        return invocationWrapper.getInvokeTx() == null || !this.delayUpdatedUntilEndOfTx;
    }

    public int getBeanSize() {
        return this.beanSize;
    }

    public boolean isEntityManager() {
        return true;
    }

    public void enrollInTransaction(Transaction transaction, CacheKey cacheKey, EntityBean entityBean, RSInfo rSInfo) throws InternalException {
        throw new AssertionError("method 'enrollInTransaction' not valid for ExclusiveEntityManager");
    }

    public void selectedForReplacement(CacheKey cacheKey, EntityBean entityBean) {
        throw new AssertionError("method 'selectedForReplacement' not valid for ExclusiveEntityManager");
    }

    public void loadBeanFromRS(CacheKey cacheKey, EntityBean entityBean, RSInfo rSInfo) {
        throw new AssertionError("method 'copy' not valid for ExclusiveEntityManager");
    }

    public void removedFromCache(CacheKey cacheKey, EnterpriseBean enterpriseBean) {
        ((WLEnterpriseBean)enterpriseBean).__WL_setBusy(false);
        this.releaseBeanToPool((EntityBean)enterpriseBean);
        this.cacheRTMBean.decrementCachedBeansCurrentCount();
    }

    public void removedOnError(CacheKey cacheKey, EnterpriseBean enterpriseBean) {
        this.cacheRTMBean.decrementCachedBeansCurrentCount();
        this.destroyPooledBean((EntityBean)enterpriseBean);
    }

    public void swapIn(CacheKey cacheKey, EnterpriseBean enterpriseBean) {
        if (debugLogger.isDebugEnabled()) {
            ExclusiveEntityManager.debug("Activating key: " + cacheKey);
        }
        assert (enterpriseBean instanceof EntityBean);
        Object object = cacheKey.getPrimaryKey();
        this.swapper.remove(object);
        try {
            ((EntityBean)enterpriseBean).ejbActivate();
        }
        catch (Exception exception) {
            this.cache.removeOnError(cacheKey);
            this.cacheRTMBean.decrementCachedBeansCurrentCount();
            EJBLogger.logExceptionDuringEJBActivate((Exception)exception);
        }
    }

    public void swapOut(CacheKey cacheKey, EnterpriseBean enterpriseBean) {
        if (debugLogger.isDebugEnabled()) {
            ExclusiveEntityManager.debug("Passivating key: " + cacheKey);
        }
        assert (enterpriseBean instanceof EntityBean);
        Object object = cacheKey.getPrimaryKey();
        try {
            this.cacheRTMBean.incrementPassivationCount();
            ((EntityBean)enterpriseBean).ejbPassivate();
            this.swapper.write(object, enterpriseBean);
        }
        catch (Exception exception) {
            EJBLogger.logErrorDuringPassivation((String)StackTraceUtils.throwable2StackTrace((Throwable)exception));
        }
    }

    public void replicate(CacheKey cacheKey, EnterpriseBean enterpriseBean) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void postInvoke(InvocationWrapper invocationWrapper) throws InternalException {
        if (_WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Postinvoke_Entity_Before_Medium.isEnabledAndNotDyeFiltered()) {
            Object[] objectArray = null;
            if (_WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Postinvoke_Entity_Before_Medium.isArgumentsCaptureNeeded()) {
                objectArray = new Object[]{this, invocationWrapper};
            }
            DynamicJoinPoint dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_1, (Object[])objectArray, null);
            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Postinvoke_Entity_Before_Medium;
            InstrumentationSupport.process((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
        }
        Transaction transaction = invocationWrapper.getInvokeTx();
        Object object = invocationWrapper.getPrimaryKey();
        CacheKey cacheKey = new CacheKey(object, this);
        EntityBean entityBean = (EntityBean)this.cache.get(cacheKey);
        if (entityBean != null) {
            ((WLEnterpriseBean)entityBean).__WL_setBusy(false);
        }
        try {
            if (this.shouldStoreAfterMethod(invocationWrapper)) {
                try {
                    if (entityBean != null && this.shouldStore(entityBean)) {
                        entityBean.ejbStore();
                    }
                }
                catch (Throwable throwable) {
                    EJBLogger.logExcepInStore((Throwable)throwable);
                    this.cache.removeOnError(cacheKey);
                    EJBRuntimeUtils.throwInternalException("Exception in ejbStore:", throwable);
                }
            }
            Object var8_9 = null;
            if (entityBean == null || !((WLEnterpriseBean)entityBean).__WL_needsRemove()) return;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (entityBean == null || !((WLEnterpriseBean)entityBean).__WL_needsRemove()) throw throwable;
            if (debugLogger.isDebugEnabled()) {
                ExclusiveEntityManager.debug("releasing the bean inside postInvoke");
            }
            ((WLEnterpriseBean)entityBean).__WL_setNeedsRemove(false);
            this.lockManager.unlock(object, invocationWrapper.getInvokeTxOrThread());
            throw throwable;
        }
        if (debugLogger.isDebugEnabled()) {
            ExclusiveEntityManager.debug("releasing the bean inside postInvoke");
        }
        ((WLEnterpriseBean)entityBean).__WL_setNeedsRemove(false);
        this.lockManager.unlock(object, invocationWrapper.getInvokeTxOrThread());
    }

    public EnterpriseBean preHomeInvoke(InvocationWrapper invocationWrapper) throws InternalException {
        EntityBean entityBean = this.getBeanFromPool();
        return entityBean;
    }

    public void postHomeInvoke(InvocationWrapper invocationWrapper) throws InternalException {
        EnterpriseBean enterpriseBean = invocationWrapper.getBean();
        if (invocationWrapper.hasSystemExceptionOccured()) {
            this.destroyPooledBean((EntityBean)enterpriseBean);
        } else {
            this.releaseBeanToPool((EntityBean)enterpriseBean);
        }
    }

    public void destroyInstance(InvocationWrapper invocationWrapper, Throwable throwable) {
        Object object = invocationWrapper.getPrimaryKey();
        assert (object != null);
        this.cache.removeOnError(new CacheKey(object, this));
    }

    protected void prepareVerificationForBatch(Collection collection, Transaction transaction) throws InternalException {
    }

    protected List pkListToBeanList(Collection collection, Transaction transaction, boolean bl) {
        ArrayList<EntityBean> arrayList = new ArrayList<EntityBean>();
        for (Object e : collection) {
            CacheKey cacheKey = new CacheKey(e, this);
            EntityBean entityBean = (EntityBean)this.cache.get(cacheKey);
            if (bl) {
                if (entityBean == null) continue;
                arrayList.add(entityBean);
                continue;
            }
            if (entityBean == null || ((CMPBean)entityBean).__WL_getIsRemoved()) continue;
            arrayList.add(entityBean);
        }
        return arrayList;
    }

    protected Map pkListToPkBeanMap(Collection collection, Transaction transaction, boolean bl) {
        HashMap hashMap = new HashMap();
        for (Object e : collection) {
            CacheKey cacheKey = new CacheKey(e, this);
            EntityBean entityBean = (EntityBean)this.cache.get(cacheKey);
            if (bl) {
                if (entityBean == null) continue;
                hashMap.put(e, entityBean);
                continue;
            }
            if (entityBean == null || ((CMPBean)entityBean).__WL_getIsRemoved()) continue;
            hashMap.put(e, entityBean);
        }
        return hashMap;
    }

    public void beforeCompletion(Collection collection, Transaction transaction) throws InternalException {
        this.beforeCompletion(collection, (Object)transaction);
    }

    public void beforeCompletion(Collection collection, Object object) throws InternalException {
        assert (collection != null);
        for (Object e : collection) {
            CacheKey cacheKey = new CacheKey(e, this);
            EntityBean entityBean = (EntityBean)this.cache.get(cacheKey);
            try {
                if (entityBean == null || !this.shouldStore(entityBean)) continue;
                Transaction transaction = null;
                if (object instanceof Transaction) {
                    transaction = (Transaction)object;
                }
                if (this.orderDatabaseOperations && transaction != null) {
                    ((CMPBean)entityBean).__WL_superEjbStore();
                    continue;
                }
                entityBean.ejbStore();
            }
            catch (Throwable throwable) {
                EJBLogger.logExcepInStore1((Throwable)throwable);
                this.cache.removeOnError(cacheKey);
                EJBRuntimeUtils.throwInternalException("Exception in ejbStore:", throwable);
            }
        }
    }

    public void flushModified(Collection collection, Transaction transaction) throws InternalException {
        assert (collection != null);
        for (Object e : collection) {
            CacheKey cacheKey = new CacheKey(e, this);
            EntityBean entityBean = (EntityBean)this.cache.get(cacheKey);
            if (this.isBeanManagedPersistence) {
                try {
                    if (entityBean == null || !this.shouldStore(entityBean)) continue;
                    entityBean.ejbStore();
                }
                catch (Throwable throwable) {
                    this.cache.removeOnError(cacheKey);
                    EJBRuntimeUtils.throwInternalException("Error writing from flushModified", throwable);
                }
                continue;
            }
            try {
                if (entityBean == null || !this.shouldStore(entityBean)) continue;
                if (this.orderDatabaseOperations && transaction != null) {
                    ((CMPBean)entityBean).__WL_superEjbStore();
                    continue;
                }
                ((CMPBean)entityBean).__WL_store(false);
            }
            catch (Throwable throwable) {
                EJBLogger.logExcepInStore1((Throwable)throwable);
                this.cache.removeOnError(cacheKey);
                EJBRuntimeUtils.throwInternalException("Error calling ejbStore.", throwable);
            }
        }
    }

    public void afterCompletion(Collection collection, Transaction transaction, int n, Object object) {
        this.afterCompletion(collection, (Object)transaction, n, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCompletion(Collection collection, Object object, int n, Object object2) {
        assert (collection != null);
        assert (object != null);
        assert (n == 3 || n == 4);
        for (Object e : collection) {
            WLEnterpriseBean wLEnterpriseBean;
            block21: {
                Object var12_11;
                CacheKey cacheKey = new CacheKey(e, this);
                wLEnterpriseBean = (WLEnterpriseBean)this.cache.get(cacheKey);
                try {
                    Object object3;
                    if (this.cacheBetweenTransactions && n == 4) {
                        object3 = this.cache.get(cacheKey);
                        if (object3 != null) {
                            try {
                                this.cacheRTMBean.incrementPassivationCount();
                                ((EntityBean)object3).ejbPassivate();
                            }
                            catch (Exception exception) {
                                EJBLogger.logErrorDuringPassivation((String)StackTraceUtils.throwable2StackTrace((Throwable)exception));
                                this.cache.removeOnError(cacheKey);
                            }
                            this.cache.remove(cacheKey);
                        }
                    } else if (this.remoteHome == null || wLEnterpriseBean != null && !wLEnterpriseBean.__WL_isCreatorOfTx()) {
                        object3 = (WLEntityBean)this.cache.get(cacheKey);
                        if (object3 != null) {
                            object3.__WL_setOperationsComplete(false);
                        }
                        this.cache.release(cacheKey);
                    }
                    var12_11 = null;
                    if (wLEnterpriseBean == null) {
                        this.lockManager.unlock(e, object);
                        continue;
                    }
                    if (wLEnterpriseBean.__WL_isCreatorOfTx()) continue;
                    if (wLEnterpriseBean.__WL_isBusy()) break block21;
                    this.lockManager.unlock(e, object);
                    continue;
                }
                catch (Throwable throwable) {
                    var12_11 = null;
                    if (wLEnterpriseBean == null) {
                        this.lockManager.unlock(e, object);
                    } else if (!wLEnterpriseBean.__WL_isCreatorOfTx()) {
                        if (!wLEnterpriseBean.__WL_isBusy()) {
                            this.lockManager.unlock(e, object);
                        } else {
                            if (debugLogger.isDebugEnabled()) {
                                ExclusiveEntityManager.debug("afterCompletion called before postInvoke");
                            }
                            wLEnterpriseBean.__WL_setNeedsRemove(true);
                        }
                    }
                    throw throwable;
                }
            }
            if (debugLogger.isDebugEnabled()) {
                ExclusiveEntityManager.debug("afterCompletion called before postInvoke");
            }
            wLEnterpriseBean.__WL_setNeedsRemove(true);
            {
            }
        }
    }

    public EJBObject remoteCreate(InvocationWrapper invocationWrapper, Method method, Method method2, Object[] objectArray) throws InternalException {
        return (EJBObject)this.create(invocationWrapper, method, method2, objectArray);
    }

    public EJBLocalObject localCreate(InvocationWrapper invocationWrapper, Method method, Method method2, Object[] objectArray) throws InternalException {
        return (EJBLocalObject)this.create(invocationWrapper, method, method2, objectArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object create(InvocationWrapper invocationWrapper, Method method, Method method2, Object[] objectArray) throws InternalException {
        EJBObject eJBObject;
        DiagnosticActionState[] diagnosticActionStateArray;
        DiagnosticAction[] diagnosticActionArray;
        boolean bl;
        block31: {
            BaseEJBLocalObjectIntf baseEJBLocalObjectIntf;
            bl = _WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Create_Around_Medium.isEnabledAndNotDyeFiltered();
            diagnosticActionArray = null;
            diagnosticActionStateArray = null;
            Object var21_8 = null;
            if (bl) {
                Object[] objectArray2 = null;
                if (_WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Create_Around_Medium.isArgumentsCaptureNeeded()) {
                    objectArray2 = new Object[]{this, invocationWrapper, method, method2, objectArray};
                }
                DynamicJoinPoint dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_2, (Object[])objectArray2, null);
                DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Create_Around_Medium;
                diagnosticActionArray = delegatingMonitor.getActions();
                diagnosticActionStateArray = InstrumentationSupport.getActionStates((DiagnosticAction[])diagnosticActionArray);
                InstrumentationSupport.preProcess((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
            }
            try {
                CMPBean cMPBean;
                Object object;
                EntityBean entityBean = this.getBeanFromPool();
                ((WLEnterpriseBean)entityBean).__WL_setBusy(true);
                boolean bl2 = false;
                Object object2 = null;
                eJBObject = null;
                baseEJBLocalObjectIntf = null;
                try {
                    object2 = method.invoke((Object)entityBean, objectArray);
                }
                catch (InvocationTargetException invocationTargetException) {
                    this.destroyPooledBean(entityBean);
                    object = invocationTargetException.getTargetException();
                    EJBRuntimeUtils.throwInternalException("Exception in ejbCreate()", (Throwable)object);
                }
                catch (Throwable throwable) {
                    this.destroyPooledBean(entityBean);
                    this.handleMethodException(method, null, throwable);
                }
                try {
                    if (object2 == null) {
                        if (!(entityBean instanceof CMPBean)) {
                            throw new RuntimeCheckerException("Your BMP ejbCreate should not be returning null.");
                        }
                        method2.invoke((Object)entityBean, objectArray);
                        bl2 = true;
                        object2 = ((CMPBean)entityBean).__WL_getPrimaryKey();
                    }
                }
                catch (InvocationTargetException invocationTargetException) {
                    this.destroyPooledBean(entityBean);
                    object = invocationTargetException.getTargetException();
                    EJBRuntimeUtils.throwInternalException("Exception in ejbCreate()", (Throwable)object);
                }
                catch (Throwable throwable) {
                    this.destroyPooledBean(entityBean);
                    this.handleMethodException(method2, this.extraPostCreateExceptions, throwable);
                }
                EntityEJBContextImpl entityEJBContextImpl = (EntityEJBContextImpl)((WLEnterpriseBean)entityBean).__WL_getEJBContext();
                entityEJBContextImpl.__WL_setPrimaryKey(object2);
                object = invocationWrapper.getInvokeTxOrThread();
                CacheKey cacheKey = new CacheKey(object2, this);
                try {
                    this.acquireLock(invocationWrapper, object2);
                }
                catch (InternalException internalException) {
                    this.destroyPooledBean(entityBean);
                    throw internalException;
                }
                boolean bl3 = false;
                if (this.orderDatabaseOperations && invocationWrapper.getInvokeTx() != null && (cMPBean = (CMPBean)this.cache.get(cacheKey)) != null && cMPBean.__WL_getIsRemoved()) {
                    bl3 = true;
                    cMPBean.__WL_setBusy(true);
                    cMPBean.__WL_initialize(false);
                    cMPBean.__WL_setIsRemoved(false);
                    if (debugLogger.isDebugEnabled()) {
                        ExclusiveEntityManager.debug("collision occurred, __WL_copyFrom, pk=" + object2 + ", txOrThread=" + object);
                    }
                    cMPBean.__WL_copyFrom((CMPBean)entityBean, false);
                    ((WLEnterpriseBean)entityBean).__WL_setBusy(false);
                    this.releaseBeanToPool(entityBean);
                    entityBean = (EntityBean)cMPBean;
                }
                if (this.remoteHome != null) {
                    eJBObject = this.remoteHome.allocateEO(object2);
                }
                if (this.localHome != null) {
                    baseEJBLocalObjectIntf = this.localHome.allocateELO(object2);
                }
                entityEJBContextImpl.setEJBObject(eJBObject);
                entityEJBContextImpl.setEJBLocalObject(baseEJBLocalObjectIntf);
                if (!bl3) {
                    try {
                        this.cache.put(cacheKey, (EnterpriseBean)entityBean);
                        this.cacheRTMBean.incrementCachedBeansCurrentCount();
                    }
                    catch (CacheFullException cacheFullException) {
                        this.lockManager.unlock(object2, object);
                        this.destroyPooledBean(entityBean);
                        throw new InternalException("Error during create.", cacheFullException);
                    }
                }
                try {
                    if (bl3) {
                        this.registerInsertDeletedBeanAndTxUser(object2, invocationWrapper.getInvokeTx(), (WLEnterpriseBean)entityBean);
                    } else if (this.orderDatabaseOperations && invocationWrapper.getInvokeTx() != null) {
                        this.registerInsertBeanAndTxUser(object2, invocationWrapper.getInvokeTx(), (WLEnterpriseBean)entityBean);
                    } else {
                        this.setupTxListenerAndTxUser(object2, object, (WLEnterpriseBean)entityBean);
                    }
                }
                catch (InternalException internalException) {
                    this.cache.removeOnError(cacheKey);
                    this.lockManager.unlock(object2, object);
                    throw internalException;
                }
                if (!bl2) {
                    try {
                        method2.invoke((Object)entityBean, objectArray);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new AssertionError((Throwable)illegalAccessException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        this.cache.removeOnError(cacheKey);
                        Throwable throwable = invocationTargetException.getTargetException();
                        this.handleMethodException(method2, this.extraPostCreateExceptions, throwable);
                    }
                }
                ((WLEnterpriseBean)entityBean).__WL_setBusy(false);
                if (!invocationWrapper.isLocal()) break block31;
                Object var19_32 = null;
                if (!bl) return baseEJBLocalObjectIntf;
            }
            catch (Throwable throwable) {
                Object var19_34 = null;
                if (!bl) throw throwable;
                InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_2, (DiagnosticMonitor)_WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Create_Around_Medium, diagnosticActionArray, diagnosticActionStateArray);
                throw throwable;
            }
            InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_2, (DiagnosticMonitor)_WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Create_Around_Medium, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
            return baseEJBLocalObjectIntf;
        }
        Object var19_33 = null;
        if (!bl) return eJBObject;
        InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_2, (DiagnosticMonitor)_WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Create_Around_Medium, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
        return eJBObject;
    }

    public void remove(InvocationWrapper invocationWrapper) throws InternalException {
        Transaction transaction = invocationWrapper.getInvokeTx();
        Object object = invocationWrapper.getPrimaryKey();
        CacheKey cacheKey = new CacheKey(object, this);
        EntityBean entityBean = null;
        Iterator iterator = null;
        try {
            try {
                entityBean = (EntityBean)this.preInvoke(invocationWrapper);
            }
            catch (Exception exception) {
                throw new NoSuchObjectException("Bean with key: " + invocationWrapper.getPrimaryKey() + " could not be removed." + PlatformConstants.EOL + "The underlying exception was:" + StackTraceUtils.throwable2StackTrace((Throwable)exception));
            }
            iterator = this.cascadeDeleteRemove(invocationWrapper, entityBean);
            if (this.orderDatabaseOperations && invocationWrapper.getInvokeTx() != null) {
                ((CMPBean)entityBean).__WL_superEjbRemove(false);
                ((CMPBean)entityBean).__WL_setIsRemoved(true);
                if (!this.registerDeleteBean(object, invocationWrapper.getInvokeTx())) {
                    if (((CMPBean)entityBean).__WL_getIsRemoved()) {
                        ((CMPBean)entityBean).__WL_initialize();
                        ((CMPBean)entityBean).__WL_setIsRemoved(false);
                    }
                    this.cache.remove(cacheKey);
                }
            } else {
                entityBean.ejbRemove();
                this.cache.remove(cacheKey);
            }
            if (this.timerManager != null) {
                this.timerManager.removeTimersForPK(object);
            }
        }
        catch (Throwable throwable) {
            this.cache.removeOnError(cacheKey);
            EJBRuntimeUtils.throwInternalException("Exception during remove.", throwable);
        }
        this.cascadeDeleteRemove(invocationWrapper, entityBean, iterator);
    }

    public void remove(InvocationWrapper invocationWrapper, EntityBean entityBean, boolean bl) throws InternalException {
        Transaction transaction = invocationWrapper.getInvokeTx();
        Object object = ((CMPBean)entityBean).__WL_getPrimaryKey();
        CacheKey cacheKey = new CacheKey(object, this);
        this.checkForReentrant(entityBean, object);
        ((WLEnterpriseBean)entityBean).__WL_setBusy(true);
        try {
            if (bl) {
                ((CMPBean)entityBean).__WL_superEjbRemove(true);
                this.cache.remove(cacheKey);
            } else if (this.orderDatabaseOperations && invocationWrapper.getInvokeTx() != null) {
                ((CMPBean)entityBean).__WL_superEjbRemove(false);
                ((CMPBean)entityBean).__WL_setIsRemoved(true);
                if (!this.registerDeleteBean(object, invocationWrapper.getInvokeTx())) {
                    if (((CMPBean)entityBean).__WL_getIsRemoved()) {
                        ((CMPBean)entityBean).__WL_initialize();
                        ((CMPBean)entityBean).__WL_setIsRemoved(false);
                    }
                    this.cache.remove(cacheKey);
                }
            } else {
                entityBean.ejbRemove();
                this.cache.remove(cacheKey);
            }
            if (this.timerManager != null) {
                this.timerManager.removeTimersForPK(object);
            }
        }
        catch (Throwable throwable) {
            this.cache.removeOnError(cacheKey);
            EJBRuntimeUtils.throwInternalException("Exception in remove:", throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnterpriseBean lookup(Object object) throws InternalException {
        if (debugLogger.isDebugEnabled()) {
            ExclusiveEntityManager.debug("lookup called(pk=" + object + ")");
        }
        assert (object != null);
        try {
            EntityBean entityBean;
            this.ejbHome.pushEnvironment();
            Object object2 = EJBRuntimeUtils.getInvokeTxOrThread();
            int n = 5000;
            EntityBean entityBean2 = entityBean = this.getReadyBean(object, object2, n);
            Object var7_6 = null;
            this.ejbHome.popEnvironment();
            return entityBean2;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.ejbHome.popEnvironment();
            throw throwable;
        }
    }

    public EntityBean getBeanFromRS(Object object, Object object2, RSInfo rSInfo) throws InternalException {
        EntityBean entityBean = null;
        entityBean = this.getBeanFromCache(object2, object, 0);
        if (entityBean != null) {
            this.cacheRTMBean.incrementCacheHitCount();
        } else {
            entityBean = this.getBeanFromPool();
            ((CMPBean)entityBean).__WL_initialize();
            this.persistence.loadBeanFromRS(entityBean, rSInfo);
            if (!this.finderCacheInsert(entityBean)) {
                return null;
            }
        }
        return entityBean;
    }

    private EntityBean getBeanFromCache(Object object, Object object2, int n) throws InternalException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean finderCacheInsert(Object object, Object object2, EJBObject eJBObject, EJBLocalObject eJBLocalObject, EntityBean entityBean) throws InternalException {
        if (debugLogger.isDebugEnabled()) {
            ExclusiveEntityManager.debug("called finderCacheInsert...");
        }
        assert (eJBObject != null || eJBLocalObject != null);
        boolean bl = false;
        try {
            if (debugLogger.isDebugEnabled()) {
                ExclusiveEntityManager.debug("\tprimary key=" + object2);
            }
            assert (object2 != null);
            bl = this.acquireLock(object2, object, 0);
            if (debugLogger.isDebugEnabled()) {
                ExclusiveEntityManager.debug("\tafter acquireLock: alreadyLoaded=" + (bl ? "true" : "false"));
            }
        }
        catch (Exception exception) {
            this.releaseBeanToPool(entityBean);
            return false;
        }
        CacheKey cacheKey = new CacheKey(object2, this);
        try {
            try {
                this.ejbHome.pushEnvironment();
                EntityBean entityBean2 = (EntityBean)this.cache.get(cacheKey);
                if (entityBean2 == null) {
                    if (debugLogger.isDebugEnabled()) {
                        ExclusiveEntityManager.debug("beanFromCache == null, pk=" + object2 + ", txOrThread=" + object);
                    }
                    EJBContext eJBContext = ((WLEnterpriseBean)entityBean).__WL_getEJBContext();
                    ((WLEJBContext)eJBContext).setEJBObject(eJBObject);
                    ((WLEJBContext)eJBContext).setEJBLocalObject(eJBLocalObject);
                    try {
                        this.cache.put(cacheKey, (EnterpriseBean)entityBean);
                    }
                    catch (CacheFullException cacheFullException) {
                        this.releaseBeanToPool(entityBean);
                        this.lockManager.unlock(object2, object);
                        boolean bl2 = false;
                        Object var13_20 = null;
                        this.ejbHome.popEnvironment();
                        return bl2;
                    }
                    this.cacheRTMBean.incrementCachedBeansCurrentCount();
                    this.initLastRead(object2);
                    try {
                        entityBean.ejbActivate();
                        this.cacheRTMBean.incrementActivationCount();
                    }
                    catch (Throwable throwable) {
                        EJBLogger.logErrorDuringActivate((String)StackTraceUtils.throwable2StackTrace((Throwable)throwable));
                        this.destroyPooledBean(entityBean);
                        EJBRuntimeUtils.throwInternalException("Exception in ejbActivate:", throwable);
                        throw new AssertionError("does not reach");
                    }
                    try {
                        ((CMPBean)entityBean).__WL_superEjbLoad();
                    }
                    catch (Throwable throwable) {
                        EJBLogger.logErrorFromLoad((Throwable)throwable);
                        this.destroyPooledBean(entityBean);
                        EJBRuntimeUtils.throwInternalException("Exception in ejbLoad:", throwable);
                        throw new AssertionError("does not reach");
                    }
                    if (!bl) {
                        this.setupTxListenerAndTxUser(object2, object, (WLEnterpriseBean)entityBean);
                    }
                } else {
                    boolean bl3;
                    if (debugLogger.isDebugEnabled()) {
                        ExclusiveEntityManager.debug("__WL_copyFrom, pk=" + object2 + ", txOrThread=" + object);
                    }
                    if (bl3 = this.shouldLoad(object2, this.cacheBetweenTransactions, bl)) {
                        ((CMPBean)entityBean2).__WL_initialize();
                    }
                    if (this.uses20CMP || bl3) {
                        ((CMPBean)entityBean2).__WL_copyFrom((CMPBean)entityBean, true);
                    }
                    this.releaseBeanToPool(entityBean);
                    if (bl3) {
                        if (debugLogger.isDebugEnabled()) {
                            ExclusiveEntityManager.debug("\tloading cached bean");
                        }
                        try {
                            ((CMPBean)entityBean2).__WL_superEjbLoad();
                        }
                        catch (Throwable throwable) {
                            EJBLogger.logErrorFromLoad((Throwable)throwable);
                            EJBRuntimeUtils.throwInternalException("Exception in ejbLoad:", throwable);
                            throw new AssertionError("does not reach");
                        }
                    }
                    if (!bl) {
                        this.setupTxListenerAndTxUser(object2, object, (WLEnterpriseBean)entityBean2);
                    }
                }
                boolean bl4 = entityBean2 == null;
                Object var13_21 = null;
                this.ejbHome.popEnvironment();
                return bl4;
            }
            catch (Throwable throwable) {
                if (debugLogger.isDebugEnabled()) {
                    ExclusiveEntityManager.debug("\texception thrown in finderCacheInsert: ", throwable);
                }
                this.cache.removeOnError(cacheKey);
                this.lockManager.unlock(object2, object);
                boolean bl5 = false;
                Object var13_22 = null;
                this.ejbHome.popEnvironment();
                return bl5;
            }
        }
        catch (Throwable throwable) {
            Object var13_23 = null;
            this.ejbHome.popEnvironment();
            throw throwable;
        }
    }

    protected void cacheRemoveBean(Transaction transaction, Object object) {
        this.cache.remove(new CacheKey(object, this));
    }

    protected void cacheRemoveBeanOnError(Transaction transaction, Object object) {
        this.cache.removeOnError(new CacheKey(object, this));
    }

    protected EntityBean alreadyCached(Object object, Object object2) throws InternalException {
        EntityBean entityBean = null;
        Object object3 = this.lockManager.getOwner(object2);
        if ((this.cacheBetweenTransactions || object3 == object) && (entityBean = (EntityBean)this.cache.get(new CacheKey(object2, this), false)) != null && !this.isBeanManagedPersistence && ((CMPBean)entityBean).__WL_getIsRemoved()) {
            Loggable loggable = EJBLogger.lognoSuchEntityExceptionLoggable((String)object2.toString());
            EJBRuntimeUtils.throwInternalException("EJB Exception: ", (Throwable)new ObjectNotFoundException(loggable.getMessage()));
            entityBean = null;
        }
        return entityBean;
    }

    protected void initLastRead(Object object) {
    }

    public void beanImplClassChangeNotification() {
        super.beanImplClassChangeNotification();
        this.cache.beanImplClassChangeNotification();
    }

    public void updateMaxBeansInCache(int n) {
        this.cache.updateMaxBeansInCache(n);
    }

    public void updateIdleTimeoutSecondsCache(int n) {
        this.cache.updateIdleTimeoutSeconds(n);
    }

    public void releaseBean(InvocationWrapper invocationWrapper) {
        Object object = invocationWrapper.getPrimaryKey();
        CacheKey cacheKey = new CacheKey(object, this);
        this.cache.release(cacheKey);
        this.lockManager.unlock(object, invocationWrapper.getInvokeTxOrThread());
    }

    public int getIdleTimeoutSeconds() {
        return this.idleTimeoutSeconds;
    }

    public void reInitializeCacheAndPool() {
        this.cache.reInitializeCacheAndPools();
    }

    public boolean getVerifyReads() {
        return false;
    }

    public void passivateAndRelease(CacheKey cacheKey, EntityBean entityBean) {
    }

    public boolean hasBeansEnrolledInTx(Transaction transaction) {
        return false;
    }

    public PartialOrderSet getEnrolledInTxKeys(Transaction transaction) {
        return null;
    }

    public boolean isFlushPending(Transaction transaction, Object object) {
        return false;
    }

    public boolean isPassivatible(Transaction transaction, Object object, boolean bl, boolean bl2) {
        return false;
    }

    public int cachePassivateModifiedBean(Transaction transaction, Object object, boolean bl) {
        return 0;
    }

    public int cachePassivateUnModifiedBean(Transaction transaction, Object object) {
        return 0;
    }

    public boolean passivateModifiedBean(Transaction transaction, Object object, boolean bl, EntityBean entityBean) {
        return false;
    }

    public boolean passivateUnModifiedBean(Transaction transaction, Object object, EntityBean entityBean) {
        return false;
    }

    public void postFinderCleanup(Object object, Collection collection, boolean bl, boolean bl2) {
    }

    public void unpin(Object object, Object object2) {
    }

    public void flushModified(Collection collection, Transaction transaction, boolean bl, Collection collection2) {
    }

    public void operationsComplete(Transaction transaction, Object object) {
        EntityBean entityBean = null;
        try {
            entityBean = this.getReadyBean(object, transaction, 0);
        }
        catch (InternalException internalException) {
            // empty catch block
        }
        if (entityBean == null) {
            return;
        }
        ((WLEntityBean)entityBean).__WL_setOperationsComplete(true);
    }

    public boolean beanIsOpsComplete(Transaction transaction, Object object) {
        EntityBean entityBean = null;
        try {
            entityBean = this.getReadyBean(object, transaction, 0);
        }
        catch (InternalException internalException) {
            // empty catch block
        }
        if (entityBean == null) {
            return true;
        }
        return ((WLEntityBean)entityBean).__WL_getOperationsComplete();
    }

    private static void debug(String string) {
        debugLogger.debug("[ExclusiveEntityManager] " + string);
    }

    private static void debug(String string, Throwable throwable) {
        debugLogger.debug("[ExclusiveEntityManager] " + string, throwable);
    }

    public void undeploy() {
        super.undeploy();
        if (this.scrubberStarted) {
            Debug.assertion((boolean)(this.cache instanceof ScrubbedCache), (String)"expected ScrubbedCache");
            this.cache.stopScrubber();
        }
    }

    public void passivateAndBacktoPool(CacheKey cacheKey, EntityBean entityBean) {
    }

    static {
        _WLDF$INST_FLD_class = Class.forName("weblogic.ejb.container.manager.ExclusiveEntityManager");
        _WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Preinvoke_Entity_After_Medium = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"EJB_Diagnostic_Pool_Manager_Preinvoke_Entity_After_Medium");
        _WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Postinvoke_Entity_Before_Medium = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"EJB_Diagnostic_Pool_Manager_Postinvoke_Entity_Before_Medium");
        _WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Create_Around_Medium = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"EJB_Diagnostic_Pool_Manager_Create_Around_Medium");
        _WLDF$INST_JPFLD_0 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"ExclusiveEntityManager.java", (String)"weblogic.ejb.container.manager.ExclusiveEntityManager", (String)"preInvoke", (String)"(Lweblogic/ejb/container/internal/InvocationWrapper;)Ljavax/ejb/EnterpriseBean;", (int)252, (Map)InstrumentationSupport.makeMap((String[])new String[]{"EJB_Diagnostic_Pool_Manager_Preinvoke_Entity_After_Medium"}, (PointcutHandlingInfo[])new PointcutHandlingInfo[]{InstrumentationSupport.createPointcutHandlingInfo(null, null, (ValueHandlingInfo[])new ValueHandlingInfo[]{InstrumentationSupport.createValueHandlingInfo((String)"wrap", (String)"weblogic.diagnostics.instrumentation.gathering.EJBInvocationWrapperRenderer", (boolean)false, (boolean)true)})}), (boolean)false);
        _WLDF$INST_JPFLD_1 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"ExclusiveEntityManager.java", (String)"weblogic.ejb.container.manager.ExclusiveEntityManager", (String)"postInvoke", (String)"(Lweblogic/ejb/container/internal/InvocationWrapper;)V", (int)482, (Map)InstrumentationSupport.makeMap((String[])new String[]{"EJB_Diagnostic_Pool_Manager_Postinvoke_Entity_Before_Medium"}, (PointcutHandlingInfo[])new PointcutHandlingInfo[]{InstrumentationSupport.createPointcutHandlingInfo(null, null, (ValueHandlingInfo[])new ValueHandlingInfo[]{InstrumentationSupport.createValueHandlingInfo((String)"wrap", (String)"weblogic.diagnostics.instrumentation.gathering.EJBInvocationWrapperRenderer", (boolean)false, (boolean)true)})}), (boolean)false);
        _WLDF$INST_JPFLD_2 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"ExclusiveEntityManager.java", (String)"weblogic.ejb.container.manager.ExclusiveEntityManager", (String)"create", (String)"(Lweblogic/ejb/container/internal/InvocationWrapper;Ljava/lang/reflect/Method;Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/lang/Object;", (int)789, (Map)InstrumentationSupport.makeMap((String[])new String[]{"EJB_Diagnostic_Pool_Manager_Create_Around_Medium"}, (PointcutHandlingInfo[])new PointcutHandlingInfo[]{InstrumentationSupport.createPointcutHandlingInfo(null, null, (ValueHandlingInfo[])new ValueHandlingInfo[]{InstrumentationSupport.createValueHandlingInfo((String)"wrap", (String)"weblogic.diagnostics.instrumentation.gathering.EJBInvocationWrapperRenderer", (boolean)false, (boolean)true), null, null, null})}), (boolean)false);
        staticChecks = true;
    }
}

