/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.manager;

import com.oracle.pitchfork.interfaces.inject.LifecycleEvent;
import com.oracle.pitchfork.interfaces.intercept.__ProxyControl;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import javax.ejb.EJBContext;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.EnterpriseBean;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.naming.Context;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import weblogic.application.ApplicationAccess;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.cluster.migration.Migratable;
import weblogic.cluster.migration.MigratableMDB;
import weblogic.cluster.migration.MigrationException;
import weblogic.cluster.migration.MigrationManager;
import weblogic.diagnostics.instrumentation.DelegatingMonitor;
import weblogic.diagnostics.instrumentation.DiagnosticAction;
import weblogic.diagnostics.instrumentation.DiagnosticMonitor;
import weblogic.diagnostics.instrumentation.DynamicJoinPoint;
import weblogic.diagnostics.instrumentation.InstrumentationSupport;
import weblogic.diagnostics.instrumentation.JoinPoint;
import weblogic.diagnostics.instrumentation.PointcutHandlingInfo;
import weblogic.diagnostics.instrumentation.ValueHandlingInfo;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.InternalException;
import weblogic.ejb.container.dd.DDConstants;
import weblogic.ejb.container.interfaces.BaseEJBLocalHomeIntf;
import weblogic.ejb.container.interfaces.BaseEJBRemoteHomeIntf;
import weblogic.ejb.container.interfaces.BeanInfo;
import weblogic.ejb.container.interfaces.BeanManager;
import weblogic.ejb.container.interfaces.MessageDrivenBeanInfo;
import weblogic.ejb.container.interfaces.MessageDrivenManagerIntf;
import weblogic.ejb.container.interfaces.PoolIntf;
import weblogic.ejb.container.internal.EJBComponentRuntimeMBeanImpl;
import weblogic.ejb.container.internal.EJBRuntimeUtils;
import weblogic.ejb.container.internal.InvocationWrapper;
import weblogic.ejb.container.internal.JCABindingManager;
import weblogic.ejb.container.internal.JMSConnectionPoller;
import weblogic.ejb.container.internal.MDConnectionManager;
import weblogic.ejb.container.internal.MessageDrivenEJBContextImpl;
import weblogic.ejb.container.internal.MessageDrivenLocalObject;
import weblogic.ejb.container.manager.BaseEJBManager;
import weblogic.ejb.container.monitoring.MessageDrivenEJBRuntimeMBeanImpl;
import weblogic.ejb.container.pool.MessageDrivenPool;
import weblogic.ejb.spi.WLDeploymentException;
import weblogic.jms.extensions.DestinationDetail;
import weblogic.logging.Loggable;
import weblogic.management.ManagementException;
import weblogic.management.configuration.MigratableTargetMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.runtime.ApplicationRuntimeMBean;
import weblogic.management.runtime.ComponentRuntimeMBean;
import weblogic.management.runtime.EJBComponentRuntimeMBean;
import weblogic.management.runtime.EJBRuntimeMBean;
import weblogic.management.runtime.EJBTimerRuntimeMBean;
import weblogic.management.runtime.MessageDrivenEJBRuntimeMBean;
import weblogic.utils.AssertionError;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;

public final class MessageDrivenManager
extends BaseEJBManager
implements BeanManager,
MessageDrivenManagerIntf,
Migratable,
MigratableMDB {
    private Method createMethod;
    private PoolIntf pool = null;
    private MessageDrivenBeanInfo info = null;
    private MessageDrivenEJBRuntimeMBeanImpl runtimeMBean;
    private Class mdoClass;
    private DestinationDetail destinationInfo;
    private MessageDrivenContext messageDrivenContext;
    private static final DebugCategory DEBUG_APP_VERSION;
    private boolean started = false;
    private String destinationName = null;
    private String jmsClientID = "";
    private String uniqueGlobalID = "";
    private String messageSelector;
    private boolean isDurableSubscriptionDeletion;
    private int topicMessagesDistributionMode;
    private String domainName;
    private String currServerName;
    private String jmsClientIDBase;
    private String connectionFacortyJNDIName;
    private String providerURL;
    private String resourceAdapterJndiName;
    private TargetMBean targetMBean = null;
    private MDConnectionManager mdConnManager = null;
    static final long serialVersionUID = -1423676407120807163L;
    public static final String _WLDF$INST_VERSION = "9.0.0";
    static /* synthetic */ Class _WLDF$INST_FLD_class;
    public static final DelegatingMonitor _WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Preinvoke_After_Medium;
    public static final DelegatingMonitor _WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Postinvoke_Before_Medium;
    public static final JoinPoint _WLDF$INST_JPFLD_0;
    public static final JoinPoint _WLDF$INST_JPFLD_1;

    public MessageDrivenManager(EJBComponentRuntimeMBeanImpl eJBComponentRuntimeMBeanImpl) {
        super(eJBComponentRuntimeMBeanImpl);
    }

    public String toString() {
        return "[MessageDrivenManager] home: " + this.ejbHome + "pool: " + this.pool + " debug: " + debugLogger.isDebugEnabled();
    }

    public void setup(BaseEJBRemoteHomeIntf baseEJBRemoteHomeIntf, BaseEJBLocalHomeIntf baseEJBLocalHomeIntf, BeanInfo beanInfo, Context context) throws WLDeploymentException {
        this.info = (MessageDrivenBeanInfo)beanInfo;
        super.setup(baseEJBRemoteHomeIntf, baseEJBLocalHomeIntf, beanInfo, context);
        this.resourceAdapterJndiName = this.info.getResourceAdapterJndiName();
        this.beanClass = beanInfo.isEJB30() && !this.info.getMessagingTypeInterfaceClass().isAssignableFrom(beanInfo.getBeanClass()) ? ((MessageDrivenBeanInfo)beanInfo).getGeneratedBeanClass() : beanInfo.getBeanClass();
        this.mdoClass = this.info.getMessageDrivenLocalObjectClass();
        this.setCreateMethod();
        this.suspendActiveVersion();
        this.initialize();
        this.messageDrivenContext = new MessageDrivenEJBContextImpl(this);
        if (debugLogger.isDebugEnabled()) {
            MessageDrivenManager.debug("In setup for :" + this);
        }
    }

    protected void createEJBTimerManager() {
        if (this.info.getTimerManagerFactory() != null) {
            this.timerManager = this.info.getTimerManagerFactory().createEJBTimerManager(this);
        }
    }

    public void setup(MessageDrivenBeanInfo messageDrivenBeanInfo, Context context, String string, String string2, String string3, String string4, TargetMBean targetMBean, DestinationDetail destinationDetail) throws WLDeploymentException {
        this.destinationName = string;
        this.targetMBean = targetMBean;
        this.domainName = string2;
        this.currServerName = string3;
        this.jmsClientIDBase = string4;
        this.destinationInfo = destinationDetail;
        this.info = messageDrivenBeanInfo;
        this.setup(null, null, messageDrivenBeanInfo, context);
    }

    public MessageDrivenContext getMessageDrivenContext() {
        return this.messageDrivenContext;
    }

    public PoolIntf getPool() {
        return this.pool;
    }

    public Method getCreateMethod() {
        return this.createMethod;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EnterpriseBean preInvoke(InvocationWrapper invocationWrapper) throws InternalException {
        EnterpriseBean enterpriseBean;
        try {
            super.preInvoke();
            int n = invocationWrapper.getMethodDescriptor().getTxTimeoutMS();
            if (debugLogger.isDebugEnabled()) {
                MessageDrivenManager.debug("In preInvoke with timeout:" + n + " on manager: " + this);
            }
            enterpriseBean = this.pool.getBean(n);
            Object var7_4 = null;
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            if (!_WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Preinvoke_After_Medium.isEnabledAndNotDyeFiltered()) throw throwable;
            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Preinvoke_After_Medium;
            InstrumentationSupport.process((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
            throw throwable;
        }
        if (!_WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Preinvoke_After_Medium.isEnabledAndNotDyeFiltered()) return enterpriseBean;
        DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Preinvoke_After_Medium;
        InstrumentationSupport.process((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
        return enterpriseBean;
    }

    public void postInvoke(InvocationWrapper invocationWrapper) throws InternalException {
        if (_WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Postinvoke_Before_Medium.isEnabledAndNotDyeFiltered()) {
            Object[] objectArray = null;
            if (_WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Postinvoke_Before_Medium.isArgumentsCaptureNeeded()) {
                objectArray = new Object[]{this, invocationWrapper};
            }
            DynamicJoinPoint dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_1, (Object[])objectArray, null);
            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Postinvoke_Before_Medium;
            InstrumentationSupport.process((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
        }
        if (debugLogger.isDebugEnabled()) {
            MessageDrivenManager.debug("In postInvoke on " + this);
        }
        if (invocationWrapper.isLocal()) {
            this.pool.releaseBean(invocationWrapper.getBean());
        }
    }

    public EnterpriseBean preHomeInvoke(InvocationWrapper invocationWrapper) throws InternalException {
        throw new AssertionError("message driven beans cannot have home methods");
    }

    public void postHomeInvoke(InvocationWrapper invocationWrapper) throws InternalException {
        throw new AssertionError("message driven beans cannot have home methods");
    }

    public void destroyPooledInstance(InvocationWrapper invocationWrapper, Throwable throwable) throws InternalException {
        throw new AssertionError("message driven beans cannot have home methods");
    }

    public void destroyInstance(InvocationWrapper invocationWrapper, Throwable throwable) throws InternalException {
        if (debugLogger.isDebugEnabled()) {
            MessageDrivenManager.debug("In destroyInstance for manager: " + this);
        }
        this.pool.destroyBean(null);
    }

    public void beforeCompletion(InvocationWrapper invocationWrapper) throws InternalException {
    }

    public void beforeCompletion(Object object) throws InternalException {
    }

    public void beforeCompletion(Collection collection, Transaction transaction) throws InternalException {
        if (debugLogger.isDebugEnabled()) {
            MessageDrivenManager.debug("In beforeCompletion for manager: " + this);
        }
    }

    public void afterCompletion(InvocationWrapper invocationWrapper) {
    }

    public void afterCompletion(Object object) {
    }

    public void afterCompletion(Collection collection, Transaction transaction, int n, Object object) {
        if (debugLogger.isDebugEnabled()) {
            MessageDrivenManager.debug("In afterCompletion for manager: " + this);
        }
    }

    public EJBContext allocateContext(EnterpriseBean enterpriseBean, Object object) {
        throw new AssertionError("message driven beans cannot have a key");
    }

    public EJBContext allocateContext(EnterpriseBean enterpriseBean, EJBObject eJBObject, EJBLocalObject eJBLocalObject) {
        throw new AssertionError("message driven beans cannot have a eo");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageDrivenBean createBean() throws InternalException {
        MessageDrivenBean messageDrivenBean = null;
        if (null == this.createMethod) {
            this.setCreateMethod();
        }
        try {
            messageDrivenBean = (MessageDrivenBean)this.allocateBean();
            messageDrivenBean.setMessageDrivenContext(this.messageDrivenContext);
            ClassLoader classLoader = this.beanInfo.getModuleClassLoader();
            Thread thread2 = Thread.currentThread();
            ClassLoader classLoader2 = thread2.getContextClassLoader();
            thread2.setContextClassLoader(classLoader);
            try {
                if (this.beanInfo.isEJB30() && messageDrivenBean instanceof __ProxyControl) {
                    ((__ProxyControl)messageDrivenBean).invokeLifecycleMethod(LifecycleEvent.POST_CONSTRUCT);
                }
                if (null != this.createMethod) {
                    this.createMethod.invoke((Object)messageDrivenBean, (Object[])null);
                }
                Object var6_7 = null;
                if (classLoader2 != null) {
                    thread2.setContextClassLoader(classLoader2);
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (classLoader2 != null) {
                    thread2.setContextClassLoader(classLoader2);
                }
                throw throwable;
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            EJBLogger.logStackTrace((Throwable)illegalAccessException);
            EJBRuntimeUtils.throwInternalException("Error in the bean's constructor : ", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            EJBLogger.logStackTrace((Throwable)invocationTargetException);
            EJBRuntimeUtils.throwInternalException("Error in the bean's constructor : ", invocationTargetException);
        }
        return messageDrivenBean;
    }

    public MessageDrivenLocalObject allocateMDO(XAResource xAResource) {
        MessageDrivenLocalObject messageDrivenLocalObject;
        try {
            messageDrivenLocalObject = (MessageDrivenLocalObject)this.mdoClass.newInstance();
            messageDrivenLocalObject.setBeanManager(this);
            messageDrivenLocalObject.setBeanInfo(this.beanInfo);
            if (xAResource != null) {
                messageDrivenLocalObject.setXAResource(xAResource);
            }
        }
        catch (Exception exception) {
            throw new AssertionError((Throwable)exception);
        }
        return messageDrivenLocalObject;
    }

    public EJBObject remoteCreate(InvocationWrapper invocationWrapper, Method method, Method method2, Object[] objectArray) throws InternalException {
        throw new AssertionError("message driven beans cannot allocateEO");
    }

    public EJBLocalObject localCreate(InvocationWrapper invocationWrapper, Method method, Method method2, Object[] objectArray) throws InternalException {
        throw new AssertionError("message driven beans cannot allocateEO");
    }

    public void remove(InvocationWrapper invocationWrapper) throws InternalException {
        if (debugLogger.isDebugEnabled()) {
            MessageDrivenManager.debug("In remove for manager: " + this);
        }
    }

    public EJBObject remoteFindByPrimaryKey(InvocationWrapper invocationWrapper, Object object) throws InternalException {
        throw new AssertionError("Finds do not apply to message driven beans");
    }

    public Object localFindByPrimaryKey(InvocationWrapper invocationWrapper, Object object) throws InternalException {
        throw new AssertionError("Finds do not apply to message driven beans");
    }

    public EJBObject remoteScalarFinder(InvocationWrapper invocationWrapper, Method method, Object[] objectArray) throws InternalException {
        throw new AssertionError("Finds do not apply to message driven beans");
    }

    public EJBLocalObject localScalarFinder(InvocationWrapper invocationWrapper, Method method, Object[] objectArray) throws InternalException {
        throw new AssertionError("Finds do not apply to message driven beans");
    }

    public Enumeration enumFinder(InvocationWrapper invocationWrapper, Method method, Object[] objectArray) throws InternalException {
        throw new AssertionError("Finds do not apply to message driven beans");
    }

    public Collection collectionFinder(InvocationWrapper invocationWrapper, Method method, Object[] objectArray) throws InternalException {
        throw new AssertionError("Finds do not apply to message driven beans");
    }

    public void beanImplClassChangeNotification() {
        this.beanClass = this.info.isEJB30() && !this.info.getMessagingTypeInterfaceClass().isAssignableFrom(this.info.getBeanClass()) ? this.info.getGeneratedBeanClass() : this.info.getBeanClass();
        this.pool.reset();
    }

    public void releaseBean(InvocationWrapper invocationWrapper) {
        EnterpriseBean enterpriseBean = invocationWrapper.getBean();
        this.pool.releaseBean(enterpriseBean);
    }

    private void setCreateMethod() {
        block3: {
            if (this.info.isEJB30()) {
                return;
            }
            try {
                this.createMethod = this.beanClass.getMethod("ejbCreate", null);
            }
            catch (Exception exception) {
                if (this.info.isEJB30()) break block3;
                throw new AssertionError("Could not find ejbCreate()", (Throwable)exception);
            }
        }
    }

    public synchronized void updateImplCL() {
        this.beanClass = this.info.isEJB30() && !this.info.getMessagingTypeInterfaceClass().isAssignableFrom(this.info.getBeanClass()) ? this.info.getGeneratedBeanClass() : this.info.getBeanClass();
        this.setCreateMethod();
    }

    public void reInitializeCacheAndPool() {
        this.reInitializePool();
    }

    public void reInitializePool() {
        this.pool.reInitializePool();
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public String getDDMemberName() {
        return this.destinationInfo == null ? this.destinationName : this.destinationInfo.getMemberConfigName();
    }

    public String getJMSClientID() {
        return this.jmsClientID;
    }

    public String getUniqueGlobalID() {
        return this.uniqueGlobalID;
    }

    public String getMessageSelector() {
        return this.messageSelector;
    }

    public boolean isDurableSubscriptionDeletion() {
        return this.isDurableSubscriptionDeletion;
    }

    public int getTopicMessagesDistributionMode() {
        return this.topicMessagesDistributionMode;
    }

    public TargetMBean getTargetMBean() {
        return this.targetMBean;
    }

    public String getName() {
        return this.info.getEJBName();
    }

    private String getRuntimeMBeanName() {
        if (this.info.getIsWeblogicJMS()) {
            if (this.isNoneDDMD()) {
                return this.info.getEJBName() + "_" + this.destinationName;
            }
            return this.info.getEJBName() + "_" + this.getDDMemberName();
        }
        return this.info.getEJBName();
    }

    private void initialize() throws WLDeploymentException {
        this.resetConnValues();
        if (this.runtimeMBean == null) {
            String string = this.getRuntimeMBeanName();
            try {
                this.runtimeMBean = new MessageDrivenEJBRuntimeMBeanImpl(string, this.info.getEJBName(), this.getEJBComponentRuntime(), this.destinationName, this.getTimerManager());
                this.setEJBRuntimeMBean(this.runtimeMBean);
                this.addEJBRuntimeMBean(this.runtimeMBean);
            }
            catch (ManagementException managementException) {
                Loggable loggable = EJBLogger.logFailedToCreateRuntimeMBeanLoggable((Exception)((Object)managementException));
                throw new WLDeploymentException(loggable.getMessage(), managementException);
            }
        }
        this.perhapsSetupTimerManager(this.runtimeMBean.getTimerRuntime());
        this.pool = new MessageDrivenPool(this, (BeanInfo)this.info, this.runtimeMBean.getPoolRuntime());
        this.mdConnManager = this.info.getIsWeblogicJMS() ? new JMSConnectionPoller(this.info, this.environmentContext, this.runtimeMBean) : new JCABindingManager(this.info, this.environmentContext, this.runtimeMBean);
    }

    private void unInitialize() {
        block3: {
            try {
                if (this.runtimeMBean != null) {
                    this.runtimeMBean.unregister();
                    this.removeEJBRuntimeMBean(this.runtimeMBean);
                }
            }
            catch (ManagementException managementException) {
                if (!debugLogger.isDebugEnabled()) break block3;
                MessageDrivenManager.debug("Couldn't unregister MBean: ", managementException);
            }
        }
        this.runtimeMBean = null;
        this.pool = null;
    }

    private boolean runtimeValidation() {
        if (this.runtimeMBean.getMDBStatus() != null && this.runtimeMBean.getMDBStatus().equals(DDConstants.MDBStatus[0])) {
            this.runtimeMBean.setLastException(new WLDeploymentException("The ejb " + this.info.getDisplayName() + " could not be activated because the destionation " + this.destinationName + " is not available now!"));
            return false;
        }
        if (this.destinationInfo == null) {
            this.runtimeMBean.setMDBStatus(DDConstants.MDBStatus[4]);
            this.runtimeMBean.setLastException(new AssertionError("Illegal status for MDB " + this.info.getDisplayName()));
            return false;
        }
        if (this.destinationInfo.getType() == 6) {
            if (this.topicMessagesDistributionMode == 0) {
                this.runtimeMBean.setMDBStatus(DDConstants.MDBStatus[4]);
                String string = EJBLogger.logIllegalPermutationOnPDTAndComp((String)this.info.getDisplayName());
                this.runtimeMBean.setLastException(new WLDeploymentException(string));
                return false;
            }
        } else if ((this.destinationInfo.getType() == 4 || this.destinationInfo.getType() == 2 || this.destinationInfo.getType() == 0) && this.topicMessagesDistributionMode > 0) {
            this.runtimeMBean.setMDBStatus(DDConstants.MDBStatus[4] + ":" + EJBLogger.logInvalidConfigurationForTopicMessagesDistributionModeLoggable((String)this.info.getDisplayName()).getMessage());
            return false;
        }
        return true;
    }

    public synchronized void start() throws WLDeploymentException {
        if (!this.info.getIsWeblogicJMS() && this.info.getIsInactive()) {
            this.setMDBStatus(DDConstants.MDBStatus[5]);
            return;
        }
        if (this.info.getIsWeblogicJMS() && !this.runtimeValidation()) {
            this.runtimeMBean.setJMSConnectionAlive(false);
            return;
        }
        if (!this.started) {
            this.pool.createInitialBeans();
            if (this.mdConnManager != null) {
                this.mdConnManager.startConnectionPolling();
                this.started = true;
            }
        }
    }

    public void stop() {
        if (this.runtimeMBean != null && this.mdConnManager != null && this.pool != null) {
            this.mdConnManager.cancelConnectionPolling();
            this.pool.cleanup();
        }
    }

    public void undeploy() {
        super.undeploy();
        if (this.isNoneDDMD() && this.targetMBean instanceof MigratableTargetMBean) {
            try {
                MigrationManager.singleton().unregister(this, (MigratableTargetMBean)this.targetMBean);
            }
            catch (MigrationException migrationException) {
                EJBLogger.logErrorUndeploying((String)this.getDestinationName(), (Exception)migrationException);
            }
        }
        this.info.getMDManagerList().remove(this);
        if (this.mdConnManager != null) {
            this.mdConnManager.cancelConnectionPolling();
        }
        if (this.pool != null) {
            this.pool.cleanup();
        }
        this.unInitialize();
    }

    protected void undeployTimerManager() {
        if (this.info.getTimerManagerFactory() != null) {
            this.info.getTimerManagerFactory().undeploy(this);
        }
    }

    public void remove() {
        if (this.mdConnManager != null) {
            this.mdConnManager.deleteDurableSubscriber();
        }
        this.mdConnManager = null;
    }

    public void onRAUndeploy() {
        if (this.mdConnManager != null) {
            ((JCABindingManager)this.mdConnManager).onRAUndeploy();
        }
    }

    public void updateJMSPollingIntervalSeconds(int n) {
        this.mdConnManager.updateJMSPollingIntervalSeconds(n);
    }

    public void resetMessageConsumer(boolean bl) {
        if (this.info.isDurableSubscriber() && bl && bl) {
            this.mdConnManager.deleteDurableSubscriber();
        }
        this.resetConnValues();
        try {
            this.mdConnManager.startConnectionPolling();
        }
        catch (WLDeploymentException wLDeploymentException) {
            MessageDrivenManager.debug(": resetMessageConsumer failed to start connection polling", wLDeploymentException);
        }
    }

    public void migratableInitialize() throws MigrationException {
    }

    public void migratableActivate() throws MigrationException {
        try {
            this.start();
        }
        catch (WLDeploymentException wLDeploymentException) {
            throw new MigrationException(wLDeploymentException.getErrorMessage());
        }
    }

    public void migratableDeactivate() throws MigrationException {
        this.stop();
    }

    private static void debug(String string) {
        debugLogger.debug("[MessageDrivenManager] " + string);
    }

    private static void debug(String string, Throwable throwable) {
        debugLogger.debug("[MessageDrivenManager] " + string, throwable);
    }

    private void suspendActiveVersion() {
        debugLogger.debug("[MessageDrivenManager] suspendActiveVersion");
        String string = ApplicationAccess.getApplicationAccess().getCurrentApplicationName();
        String string2 = ApplicationVersionUtils.getVersionId(string);
        if (string2 == null) {
            return;
        }
        String string3 = ApplicationVersionUtils.getApplicationName(string);
        ApplicationRuntimeMBean applicationRuntimeMBean = ApplicationVersionUtils.getActiveApplicationRuntime(string3);
        if (applicationRuntimeMBean == null) {
            return;
        }
        String string4 = applicationRuntimeMBean.getApplicationVersion();
        if (DEBUG_APP_VERSION.isEnabled()) {
            Debug.say((String)("*** Active version of app: " + applicationRuntimeMBean.getName() + applicationRuntimeMBean.getApplicationVersion()));
        }
        if (this.isAppScopedJMSDestination()) {
            return;
        }
        ComponentRuntimeMBean[] componentRuntimeMBeanArray = applicationRuntimeMBean.getComponentRuntimes();
        if (componentRuntimeMBeanArray == null) {
            return;
        }
        for (int i = 0; i < componentRuntimeMBeanArray.length; ++i) {
            if (!this.isSameEJBComponent(componentRuntimeMBeanArray[i], string4, string2)) continue;
            EJBRuntimeMBean[] eJBRuntimeMBeanArray = ((EJBComponentRuntimeMBean)componentRuntimeMBeanArray[i]).getEJBRuntimes();
            if (eJBRuntimeMBeanArray == null) {
                return;
            }
            for (int j = 0; j < eJBRuntimeMBeanArray.length; ++j) {
                if (!this.isSameMDB(eJBRuntimeMBeanArray[j], string4, string2)) continue;
                MessageDrivenEJBRuntimeMBean messageDrivenEJBRuntimeMBean = (MessageDrivenEJBRuntimeMBean)eJBRuntimeMBeanArray[j];
                if (this.info.isDestinationQueue() || this.info.isDurableSubscriber()) {
                    EJBLogger.logSuspendMDB((String)this.info.getEJBName(), (String)ApplicationVersionUtils.getDisplayName(string3, string4), (String)this.info.getDestinationName(), (String)string2);
                } else {
                    EJBLogger.logSuspendNonDurableSubscriber((String)this.info.getEJBName(), (String)ApplicationVersionUtils.getDisplayName(string3, string4), (String)this.info.getDestinationName(), (String)string2);
                }
                try {
                    messageDrivenEJBRuntimeMBean.suspend();
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    private boolean isAppScopedJMSDestination() {
        String string = this.info.getDestinationResourceLink();
        return string != null && string.length() > 0;
    }

    private boolean isSameEJBComponent(ComponentRuntimeMBean componentRuntimeMBean, String string, String string2) {
        if (!(componentRuntimeMBean instanceof EJBComponentRuntimeMBean)) {
            return false;
        }
        EJBComponentRuntimeMBeanImpl eJBComponentRuntimeMBeanImpl = this.getEJBComponentRuntime();
        if (DEBUG_APP_VERSION.isEnabled()) {
            Debug.say((String)("*** isSameEJBComponent: " + componentRuntimeMBean.getName() + " " + eJBComponentRuntimeMBeanImpl.getName() + " " + ApplicationVersionUtils.isSameComponent(componentRuntimeMBean.getName(), string, eJBComponentRuntimeMBeanImpl.getName(), string2)));
        }
        if (eJBComponentRuntimeMBeanImpl == null) {
            return false;
        }
        return ApplicationVersionUtils.isSameComponent(componentRuntimeMBean.getName(), string, eJBComponentRuntimeMBeanImpl.getName(), string2);
    }

    private boolean isSameMDB(EJBRuntimeMBean eJBRuntimeMBean, String string, String string2) {
        if (!(eJBRuntimeMBean instanceof MessageDrivenEJBRuntimeMBean)) {
            return false;
        }
        if (DEBUG_APP_VERSION.isEnabled()) {
            Debug.say((String)("*** isSameMDB: " + eJBRuntimeMBean.getName() + " " + this.getRuntimeMBeanName() + " " + ApplicationVersionUtils.isSameComponent(eJBRuntimeMBean.getName(), string, this.getRuntimeMBeanName(), string2)));
        }
        return ApplicationVersionUtils.isSameComponent(eJBRuntimeMBean.getName(), string, this.getRuntimeMBeanName(), string2);
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public boolean isNoneDDMD() {
        if (this.info.getIsWeblogicJMS() && this.destinationInfo != null) {
            return this.destinationInfo.getType() != 6 && this.destinationInfo.getType() != 5 && this.destinationInfo.getType() != 4;
        }
        return false;
    }

    public boolean subscriptionDeletionRequired() {
        return this.isDurableSubscriptionDeletion && this.info.isDestinationTopic() && this.info.isDurableSubscriber();
    }

    private void removeEJBRuntimeMBean(EJBRuntimeMBean eJBRuntimeMBean) {
        EJBComponentRuntimeMBeanImpl eJBComponentRuntimeMBeanImpl = this.getEJBComponentRuntime();
        eJBComponentRuntimeMBeanImpl.removeEJBRuntimeMBean(eJBRuntimeMBean);
    }

    public boolean isAdvancedTopicSupported() {
        return this.destinationInfo.isAdvancedTopicSupported();
    }

    public boolean supportMultipleConncitons() {
        if (this.destinationInfo == null) {
            return false;
        }
        int n = this.destinationInfo.getType();
        if (n == 6 || n == 1 || n == 5) {
            return this.info.getTopicMessagesDistributionMode() == 2 || this.info.getTopicMessagesDistributionMode() == 1;
        }
        return false;
    }

    public int getDestinationType() {
        return this.destinationInfo.getType();
    }

    public String getCreateDestinationArgument() {
        return this.destinationInfo.getCreateDestinationArgument();
    }

    public boolean needsSetForwardFilter() {
        return this.info.getDistributedDestinationConnection() == 1 && this.getDestinationType() == 5 || this.info.getTopicMessagesDistributionMode() == 2 && this.getDestinationType() == 5;
    }

    public boolean isStarted() {
        return this.started;
    }

    public String getDDJNDIName() {
        return this.destinationInfo == null ? this.destinationName : this.destinationInfo.getJNDIName();
    }

    private void resetConnValues() {
        this.messageSelector = this.info.getMessageSelector();
        this.isDurableSubscriptionDeletion = this.info.isDurableSubscriptionDeletion();
        this.topicMessagesDistributionMode = this.info.getTopicMessagesDistributionMode();
        this.connectionFacortyJNDIName = this.info.getConnectionFactoryJNDIName();
        this.providerURL = this.info.getProviderURL();
        switch (this.topicMessagesDistributionMode) {
            case 0: {
                if (this.info.isGenerateUniqueJmsClientId()) {
                    String string = this.domainName + "_" + (this.targetMBean == null ? this.currServerName : this.targetMBean.getName()) + "_" + this.info.getIsIdenticalKey();
                    if (this.info.getDistributedDestinationConnection() == 1) {
                        string = string + "_" + this.getDDMemberName();
                    }
                    this.jmsClientID = this.jmsClientIDBase + "_" + string;
                    break;
                }
                this.jmsClientID = this.info.getJMSClientID();
                break;
            }
            case 2: {
                this.jmsClientID = this.jmsClientIDBase;
                break;
            }
            case 1: {
                this.jmsClientID = this.jmsClientIDBase + "_" + this.domainName + "_" + this.currServerName;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        if (debugLogger.isDebugEnabled()) {
            MessageDrivenManager.debug("jmsClientID: " + this.jmsClientID);
        }
    }

    public String getConnectionFactoryJNDIName() {
        return this.connectionFacortyJNDIName;
    }

    public String getProviderURL() {
        return this.providerURL;
    }

    public DestinationDetail getDestination() {
        return this.destinationInfo;
    }

    public void enableDestination(DestinationDetail destinationDetail) throws WLDeploymentException {
        this.destinationInfo = destinationDetail;
        this.targetMBean = this.info.getMtMBean(destinationDetail.getMigratableTargetName());
        if (this.targetMBean != null) {
            this.unInitialize();
            this.initialize();
        }
    }

    public void setMDBStatus(String string) {
        this.runtimeMBean.setMDBStatus(string);
    }

    public String getResourceAdapterJndiName() {
        return this.resourceAdapterJndiName;
    }

    protected void perhapsSetupTimerManager(EJBTimerRuntimeMBean eJBTimerRuntimeMBean) throws WLDeploymentException {
        assert (this.runtimeMBean != null);
        if (this.info != null && this.info.getTimerManagerFactory() != null) {
            this.info.getTimerManagerFactory().setup(this, eJBTimerRuntimeMBean);
        }
    }

    static {
        _WLDF$INST_FLD_class = Class.forName("weblogic.ejb.container.manager.MessageDrivenManager");
        _WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Preinvoke_After_Medium = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"EJB_Diagnostic_Pool_Manager_Preinvoke_After_Medium");
        _WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Postinvoke_Before_Medium = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"EJB_Diagnostic_Pool_Manager_Postinvoke_Before_Medium");
        _WLDF$INST_JPFLD_0 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"MessageDrivenManager.java", (String)"weblogic.ejb.container.manager.MessageDrivenManager", (String)"preInvoke", (String)"(Lweblogic/ejb/container/internal/InvocationWrapper;)Ljavax/ejb/EnterpriseBean;", (int)186, (Map)InstrumentationSupport.makeMap((String[])new String[]{"EJB_Diagnostic_Pool_Manager_Preinvoke_After_Medium"}, (PointcutHandlingInfo[])new PointcutHandlingInfo[]{InstrumentationSupport.createPointcutHandlingInfo(null, null, (ValueHandlingInfo[])new ValueHandlingInfo[]{InstrumentationSupport.createValueHandlingInfo((String)"wrap", (String)"weblogic.diagnostics.instrumentation.gathering.EJBInvocationWrapperRenderer", (boolean)false, (boolean)true)})}), (boolean)false);
        _WLDF$INST_JPFLD_1 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"MessageDrivenManager.java", (String)"weblogic.ejb.container.manager.MessageDrivenManager", (String)"postInvoke", (String)"(Lweblogic/ejb/container/internal/InvocationWrapper;)V", (int)210, (Map)InstrumentationSupport.makeMap((String[])new String[]{"EJB_Diagnostic_Pool_Manager_Postinvoke_Before_Medium"}, (PointcutHandlingInfo[])new PointcutHandlingInfo[]{InstrumentationSupport.createPointcutHandlingInfo(null, null, (ValueHandlingInfo[])new ValueHandlingInfo[]{InstrumentationSupport.createValueHandlingInfo((String)"wrap", (String)"weblogic.diagnostics.instrumentation.gathering.EJBInvocationWrapperRenderer", (boolean)false, (boolean)true)})}), (boolean)false);
        DEBUG_APP_VERSION = Debug.getCategory((String)"weblogic.AppVersion");
    }
}

