/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.manager;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.ejb.EntityBean;
import javax.naming.Context;
import javax.transaction.Transaction;
import weblogic.cluster.ClusterService;
import weblogic.cluster.GroupMessage;
import weblogic.cluster.MulticastSession;
import weblogic.cluster.RecoverListener;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.InternalException;
import weblogic.ejb.container.cache.CacheKey;
import weblogic.ejb.container.cache.PassivationListener;
import weblogic.ejb.container.interfaces.BaseEJBLocalHomeIntf;
import weblogic.ejb.container.interfaces.BaseEJBRemoteHomeIntf;
import weblogic.ejb.container.interfaces.BeanInfo;
import weblogic.ejb.container.interfaces.EntityBeanInfo;
import weblogic.ejb.container.interfaces.InvalidationBeanManager;
import weblogic.ejb.container.interfaces.ReadOnlyManager;
import weblogic.ejb.container.internal.EJBComponentRuntimeMBeanImpl;
import weblogic.ejb.container.internal.InvocationWrapper;
import weblogic.ejb.container.manager.ExclusiveEntityManager;
import weblogic.ejb.spi.EJBCache;
import weblogic.ejb.spi.InvalidationMessage;
import weblogic.ejb.spi.WLDeploymentException;
import weblogic.kernel.Kernel;
import weblogic.logging.Loggable;
import weblogic.management.configuration.ServerMBean;

public final class ReadOnlyEntityManager
extends ExclusiveEntityManager
implements PassivationListener,
InvalidationBeanManager,
RecoverListener,
ReadOnlyManager {
    private long readTimeoutMS;
    private Map lastReadMap = Collections.synchronizedMap(new HashMap());
    private boolean inCluster;
    private MulticastSession multicastSession;

    public ReadOnlyEntityManager(EJBComponentRuntimeMBeanImpl eJBComponentRuntimeMBeanImpl) {
        super(eJBComponentRuntimeMBeanImpl);
    }

    public void setup(BaseEJBRemoteHomeIntf baseEJBRemoteHomeIntf, BaseEJBLocalHomeIntf baseEJBLocalHomeIntf, BeanInfo beanInfo, Context context, EJBCache eJBCache) throws WLDeploymentException {
        super.setup(baseEJBRemoteHomeIntf, baseEJBLocalHomeIntf, beanInfo, context, eJBCache);
        EntityBeanInfo entityBeanInfo = (EntityBeanInfo)beanInfo;
        this.readTimeoutMS = (long)entityBeanInfo.getCachingDescriptor().getReadTimeoutSeconds() * 1000L;
        boolean bl = this.inCluster = ((ServerMBean)Kernel.getConfig()).getCluster() != null;
        if (this.inCluster) {
            this.multicastSession = ClusterService.getServices().createMulticastSession(this, -1);
        }
    }

    public void passivated(Object object) {
        this.lastReadMap.remove(object);
    }

    public void remove(InvocationWrapper invocationWrapper) throws InternalException {
        this.lastReadMap.remove(invocationWrapper.getPrimaryKey());
        super.remove(invocationWrapper);
    }

    protected EntityBean alreadyCached(Transaction transaction, Object object) {
        return (EntityBean)this.cache.get(new CacheKey(object, this));
    }

    protected boolean shouldLoad(Object object, boolean bl, boolean bl2) {
        if (bl2) {
            return false;
        }
        long l = System.currentTimeMillis();
        Long l2 = (Long)this.lastReadMap.get(object);
        if (l2 != null) {
            if (this.readTimeoutMS == 0L) {
                return false;
            }
            if (Math.abs(l2 - l) < this.readTimeoutMS) {
                return false;
            }
        }
        this.lastReadMap.put(object, new Long(l));
        return true;
    }

    protected void initLastRead(Object object) {
        long l = System.currentTimeMillis();
        this.lastReadMap.put(object, new Long(l));
    }

    protected boolean shouldStoreAfterMethod(InvocationWrapper invocationWrapper) {
        return false;
    }

    protected boolean shouldStore(EntityBean entityBean) {
        return false;
    }

    public GroupMessage createRecoverMessage() {
        return new InvalidationMessage(this.info.getDeploymentInfo().getApplicationName(), this.info.getDeploymentInfo().getEJBComponentName(), this.info.getEJBName());
    }

    private void sendInvalidate(Object object) throws InternalException {
        InvalidationMessage invalidationMessage = object == null ? new InvalidationMessage(this.info.getDeploymentInfo().getApplicationName(), this.info.getDeploymentInfo().getEJBComponentName(), this.info.getEJBName()) : (object instanceof Collection ? new InvalidationMessage(this.info.getDeploymentInfo().getApplicationName(), this.info.getDeploymentInfo().getEJBComponentName(), this.info.getEJBName(), (Collection)object) : new InvalidationMessage(this.info.getDeploymentInfo().getApplicationName(), this.info.getDeploymentInfo().getEJBComponentName(), this.info.getEJBName(), object));
        try {
            this.multicastSession.send(invalidationMessage);
        }
        catch (IOException iOException) {
            Loggable loggable = EJBLogger.logErrorWhileMulticastingInvalidationLoggable((String)this.ejbHome.getDisplayName(), (Exception)iOException);
            throw new InternalException(loggable.getMessage(), iOException);
        }
    }

    public void invalidate(Object object, Object object2) throws InternalException {
        this.lastReadMap.remove(object2);
        if (this.inCluster) {
            this.sendInvalidate(object2);
        }
    }

    public void invalidate(Object object, Collection collection) throws InternalException {
        for (Object e : collection) {
            this.lastReadMap.remove(e);
        }
        if (this.inCluster) {
            this.sendInvalidate(collection);
        }
    }

    public void invalidateAll(Object object) throws InternalException {
        this.lastReadMap.clear();
        if (this.inCluster) {
            this.sendInvalidate(null);
        }
    }

    public void invalidateLocalServer(Object object, Object object2) {
        this.lastReadMap.remove(object2);
    }

    public void invalidateLocalServer(Object object, Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.lastReadMap.remove(iterator.next());
        }
    }

    public void invalidateAllLocalServer(Object object) {
        this.lastReadMap.clear();
    }

    public void updateReadTimeoutSeconds(int n) {
        this.readTimeoutMS = (long)n * 1000L;
    }
}

