/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.manager;

import com.oracle.pitchfork.interfaces.EnterpriseBeanProxy;
import com.oracle.pitchfork.interfaces.TargetWrapper;
import com.oracle.pitchfork.interfaces.inject.LifecycleEvent;
import com.oracle.pitchfork.interfaces.intercept.__ProxyControl;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.ejb.ConcurrentAccessException;
import javax.ejb.EJBContext;
import javax.ejb.EJBException;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.EnterpriseBean;
import javax.ejb.EntityBean;
import javax.ejb.NoSuchEJBException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.ejb.SessionSynchronization;
import javax.naming.Context;
import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionSynchronizationRegistry;
import weblogic.deployment.PersistenceUnitInfoImpl;
import weblogic.diagnostics.instrumentation.DelegatingMonitor;
import weblogic.diagnostics.instrumentation.DiagnosticAction;
import weblogic.diagnostics.instrumentation.DiagnosticActionState;
import weblogic.diagnostics.instrumentation.DiagnosticMonitor;
import weblogic.diagnostics.instrumentation.DynamicJoinPoint;
import weblogic.diagnostics.instrumentation.InstrumentationSupport;
import weblogic.diagnostics.instrumentation.JoinPoint;
import weblogic.diagnostics.instrumentation.PointcutHandlingInfo;
import weblogic.diagnostics.instrumentation.ValueHandlingInfo;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.InternalException;
import weblogic.ejb.container.cache.BaseCache;
import weblogic.ejb.container.cache.CacheKey;
import weblogic.ejb.container.cache.LRUCache;
import weblogic.ejb.container.cache.NRUCache;
import weblogic.ejb.container.interfaces.BaseEJBLocalHomeIntf;
import weblogic.ejb.container.interfaces.BaseEJBLocalObjectIntf;
import weblogic.ejb.container.interfaces.BaseEJBRemoteHomeIntf;
import weblogic.ejb.container.interfaces.BeanInfo;
import weblogic.ejb.container.interfaces.BeanManager;
import weblogic.ejb.container.interfaces.CachingDescriptor;
import weblogic.ejb.container.interfaces.CachingManager;
import weblogic.ejb.container.interfaces.Ejb3SessionBeanInfo;
import weblogic.ejb.container.interfaces.SessionBeanInfo;
import weblogic.ejb.container.interfaces.SingleInstanceCache;
import weblogic.ejb.container.interfaces.WLEnterpriseBean;
import weblogic.ejb.container.interfaces.WLSessionBean;
import weblogic.ejb.container.interfaces.WLSessionEJBContext;
import weblogic.ejb.container.internal.AllowedMethodsHelper;
import weblogic.ejb.container.internal.BaseEJBContext;
import weblogic.ejb.container.internal.EJBComponentRuntimeMBeanImpl;
import weblogic.ejb.container.internal.EJBContextManager;
import weblogic.ejb.container.internal.EJBRuntimeUtils;
import weblogic.ejb.container.internal.ExtendedPersistenceContextManager;
import weblogic.ejb.container.internal.ExtendedPersistenceContextWrapper;
import weblogic.ejb.container.internal.InvocationWrapper;
import weblogic.ejb.container.internal.MethodDescriptor;
import weblogic.ejb.container.internal.PoolHelper;
import weblogic.ejb.container.internal.SessionEJBContextImpl;
import weblogic.ejb.container.internal.StatefulEJBHome;
import weblogic.ejb.container.internal.StatefulEJBHomeImpl;
import weblogic.ejb.container.internal.StatefulEJBLocalHome;
import weblogic.ejb.container.internal.StatefulEJBLocalObject;
import weblogic.ejb.container.internal.StatefulEJBObject;
import weblogic.ejb.container.internal.StatefulRemoteObject;
import weblogic.ejb.container.internal.TxManager;
import weblogic.ejb.container.locks.ExclusiveLockManager;
import weblogic.ejb.container.locks.LockManager;
import weblogic.ejb.container.manager.BaseEJBManager;
import weblogic.ejb.container.manager.KeyGenerator;
import weblogic.ejb.container.manager.SimpleKeyGenerator;
import weblogic.ejb.container.monitoring.EJBCacheRuntimeMBeanImpl;
import weblogic.ejb.container.monitoring.StatefulEJBRuntimeMBeanImpl;
import weblogic.ejb.container.persistence.spi.RSInfo;
import weblogic.ejb.container.swap.DiskSwap;
import weblogic.ejb.container.swap.EJBSwap;
import weblogic.ejb.container.swap.ReplicatedMemorySwap;
import weblogic.ejb.container.utils.PartialOrderSet;
import weblogic.ejb.spi.EJBCache;
import weblogic.ejb.spi.ReInitializableCache;
import weblogic.ejb.spi.ScrubbedCache;
import weblogic.ejb.spi.WLDeploymentException;
import weblogic.ejb20.cache.CacheFullException;
import weblogic.ejb20.locks.LockTimedOutException;
import weblogic.kernel.Kernel;
import weblogic.logging.Loggable;
import weblogic.management.DomainDir;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.StatefulEJBRuntimeMBean;
import weblogic.rmi.extensions.activation.Activator;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.transaction.TransactionHelper;
import weblogic.transaction.TxHelper;
import weblogic.utils.AssertionError;
import weblogic.utils.Debug;
import weblogic.utils.StackTraceUtils;
import weblogic.utils.StringUtils;
import weblogic.utils.collections.PartitionedStackPool;

public class StatefulSessionManager
extends BaseEJBManager
implements BeanManager,
CachingManager {
    private static final boolean ENABLE_PROXY_POOL;
    private static final AuthenticatedSubject kernelId;
    private SingleInstanceCache cache;
    private LockManager lockManager;
    private boolean isInMemoryReplication = false;
    private boolean implementsSessionSynchronization = false;
    private int idleTimeoutSeconds;
    protected EJBSwap swapper;
    protected SessionBeanInfo beanInfo;
    private StatefulEJBHome remoteHome = null;
    private StatefulEJBLocalHome localHome = null;
    protected KeyGenerator keyGenerator;
    protected boolean serializeCalls;
    private int defaultTransactionTimeoutMS;
    private StatefulEJBRuntimeMBean runtimeMBean;
    private EJBCacheRuntimeMBeanImpl cacheRTMBean;
    private AuthenticatedSubject fileDesc;
    private AuthenticatedSubject fileSector;
    private String dirName;
    private String sectorName;
    private Map extendedPersistenceContextMap = null;
    private PartitionedStackPool proxyPool = null;
    private Object bmTxLockClient = new Object();
    static final long serialVersionUID = -6964093428947732392L;
    public static final String _WLDF$INST_VERSION = "9.0.0";
    static /* synthetic */ Class _WLDF$INST_FLD_class;
    public static final DelegatingMonitor _WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Remove_Around_High;
    public static final DelegatingMonitor _WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Preinvoke_After_Medium;
    public static final DelegatingMonitor _WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Postinvoke_Before_Medium;
    public static final DelegatingMonitor _WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Create_Around_Medium;
    public static final JoinPoint _WLDF$INST_JPFLD_0;
    public static final JoinPoint _WLDF$INST_JPFLD_1;
    public static final JoinPoint _WLDF$INST_JPFLD_2;
    public static final JoinPoint _WLDF$INST_JPFLD_3;
    public static final JoinPoint _WLDF$INST_JPFLD_4;

    public StatefulSessionManager(EJBComponentRuntimeMBeanImpl eJBComponentRuntimeMBeanImpl) {
        super(eJBComponentRuntimeMBeanImpl);
    }

    protected final EJBCacheRuntimeMBeanImpl getCacheRuntime() {
        return this.cacheRTMBean;
    }

    public void setup(BaseEJBRemoteHomeIntf baseEJBRemoteHomeIntf, BaseEJBLocalHomeIntf baseEJBLocalHomeIntf, BeanInfo beanInfo, Context context) throws WLDeploymentException {
        throw new AssertionError("BeanManager.setup() should never be called on StatefulSessionManager.");
    }

    public void setup(BaseEJBRemoteHomeIntf baseEJBRemoteHomeIntf, BaseEJBLocalHomeIntf baseEJBLocalHomeIntf, BeanInfo beanInfo, Context context, EJBCache eJBCache) throws WLDeploymentException {
        super.setup(baseEJBRemoteHomeIntf, baseEJBLocalHomeIntf, beanInfo, context);
        this.beanInfo = (SessionBeanInfo)beanInfo;
        this.remoteHome = (StatefulEJBHome)baseEJBRemoteHomeIntf;
        this.localHome = (StatefulEJBLocalHome)baseEJBLocalHomeIntf;
        this.beanClass = this.beanInfo.getGeneratedBeanClass();
        try {
            this.runtimeMBean = new StatefulEJBRuntimeMBeanImpl(beanInfo.getEJBName(), beanInfo.getEJBName(), this.getEJBComponentRuntime());
            this.setEJBRuntimeMBean(this.runtimeMBean);
            this.addEJBRuntimeMBean(this.runtimeMBean);
        }
        catch (ManagementException managementException) {
            Loggable loggable = EJBLogger.logFailedToCreateRuntimeMBeanLoggable((Exception)((Object)managementException));
            throw new WLDeploymentException(loggable.getMessage(), managementException);
        }
        this.txManager = new TxManager(this);
        this.cacheRTMBean = (EJBCacheRuntimeMBeanImpl)this.runtimeMBean.getCacheRuntime();
        this.keyGenerator = new SimpleKeyGenerator();
        this.keyGenerator.setup(beanInfo);
        this.swapper = new DiskSwap(new File(this.getSwapDirectoryName()), this.beanInfo.getIdleTimeoutMS(), this.beanInfo.getSessionTimeoutMS());
        this.swapper.setup(beanInfo, this, beanInfo.getClassLoader());
        this.initializeCache();
        if (ENABLE_PROXY_POOL) {
            this.proxyPool = new PartitionedStackPool(beanInfo.getCachingDescriptor().getMaxBeansInCache(), 20);
        }
        this.implementsSessionSynchronization = this.beanInfo.implementsSessionSynchronization();
        this.serializeCalls = this.beanInfo.statefulSessionSerializesConcurrentCalls();
        this.defaultTransactionTimeoutMS = this.beanInfo.getTransactionTimeoutMS();
        this.lockManager = new ExclusiveLockManager(this.runtimeMBean.getLockingRuntime());
        this.lockManager.setup(beanInfo);
        int n = this.beanInfo.getReplicationType();
        this.isInMemoryReplication = n == 2 && this.inCluster();
        this.sectorName = beanInfo.getPassivateAsPrincipalName();
        this.dirName = beanInfo.getRunAsPrincipalName();
        if (this.sectorName != null || this.dirName != null) {
            PoolHelper poolHelper = new PoolHelper(beanInfo.getDeploymentInfo().getSecurityRealmName(), beanInfo.getJACCPolicyConfig(), beanInfo.getJACCPolicyContextId(), beanInfo.getJACCCodeSource(), beanInfo.getJACCRoleMapper());
            try {
                if (this.sectorName != null) {
                    this.fileSector = poolHelper.getFileDesc(this.sectorName);
                }
                if (this.dirName != null) {
                    this.fileDesc = poolHelper.getFileDesc(this.dirName);
                }
            }
            catch (Exception exception) {
                throw new WLDeploymentException(exception.toString());
            }
            poolHelper = null;
        }
    }

    private void initializeCache() throws WLDeploymentException {
        assert (this.cache == null);
        CachingDescriptor cachingDescriptor = this.beanInfo.getCachingDescriptor();
        String string = System.getProperty("weblogic.ejb.stateful.cache");
        if (string != null) {
            try {
                Class<?> clazz = Class.forName(string);
                Constructor<?> constructor = clazz.getConstructor(String.class, Integer.TYPE);
                this.cache = (SingleInstanceCache)constructor.newInstance(this.ejbHome.getDisplayName(), cachingDescriptor.getMaxBeansInCache());
            }
            catch (Exception exception) {
                throw new WLDeploymentException("Exception instantiating custom Stateful Session Bean cache: " + string, exception);
            }
        } else {
            this.cache = cachingDescriptor.getCacheType().equalsIgnoreCase("LRU") ? new LRUCache(this.ejbHome.getDisplayName(), cachingDescriptor.getMaxBeansInCache()) : new NRUCache(this.ejbHome.getDisplayName(), cachingDescriptor.getMaxBeansInCache());
        }
        this.cache.register(this);
        this.cacheRTMBean.setReInitializableCache((ReInitializableCache)((Object)this.cache));
        this.idleTimeoutSeconds = cachingDescriptor.getIdleTimeoutSecondsCache();
        ((ScrubbedCache)((Object)this.cache)).setScrubInterval(this.idleTimeoutSeconds);
        ((ScrubbedCache)((Object)this.cache)).startScrubber();
    }

    public void setExtendedPersistenceContextMap(Map map) {
        this.extendedPersistenceContextMap = map;
    }

    private Object getLockClient(Object object) {
        if (object == null) {
            if (this.usesBeanManagedTx()) {
                return this.bmTxLockClient;
            }
            return Thread.currentThread();
        }
        return object;
    }

    private int getLockTimeout(InvocationWrapper invocationWrapper) {
        if (this.serializeCalls) {
            MethodDescriptor methodDescriptor = invocationWrapper.getMethodDescriptor();
            return methodDescriptor != null ? methodDescriptor.getTxTimeoutMS() : this.defaultTransactionTimeoutMS;
        }
        return 0;
    }

    private boolean acquireLock(InvocationWrapper invocationWrapper) throws InternalException {
        Object object = invocationWrapper.getPrimaryKey();
        return this.acquireLock(invocationWrapper, object);
    }

    private boolean acquireLock(InvocationWrapper invocationWrapper, Object object) throws InternalException {
        Transaction transaction = invocationWrapper.getInvokeTx();
        try {
            return this.lockManager.lock(object, this.getLockClient(transaction), this.getLockTimeout(invocationWrapper));
        }
        catch (LockTimedOutException lockTimedOutException) {
            Loggable loggable = EJBLogger.logNoExecuteSFSBMethodInDifferentTxLoggable();
            throw new InternalException(loggable.getMessage(), lockTimedOutException);
        }
    }

    protected EnterpriseBean getBean(Object object) throws InternalException {
        CacheKey cacheKey = new CacheKey(object, this);
        this.getCacheRuntime().incrementCacheAccessCount();
        EnterpriseBean enterpriseBean = this.cache.get(cacheKey);
        if (enterpriseBean == null) {
            enterpriseBean = this.swapper.read(object);
            if (enterpriseBean != null) {
                if (debugLogger.isDebugEnabled()) {
                    StatefulSessionManager.debug("Found key: " + object + " in swap.");
                }
                try {
                    this.cache.put(cacheKey, enterpriseBean);
                    this.getCacheRuntime().incrementCachedBeansCurrentCount();
                }
                catch (CacheFullException cacheFullException) {
                    EJBRuntimeUtils.throwInternalException("Exception in remote create", cacheFullException);
                }
                try {
                    ((SessionBean)enterpriseBean).ejbActivate();
                    this.getCacheRuntime().incrementActivationCount();
                }
                catch (Exception exception) {
                    EJBLogger.logExcepInActivate((String)StackTraceUtils.throwable2StackTrace((Throwable)exception));
                    this.removeBean(cacheKey, enterpriseBean);
                    EJBRuntimeUtils.throwInternalException("Exception in ejbActivate:", exception);
                }
            } else {
                EJBRuntimeUtils.throwInternalException("Error calling get bean.", (Throwable)new NoSuchEJBException("Stateful session bean has been deleted."));
            }
        } else {
            if (debugLogger.isDebugEnabled()) {
                StatefulSessionManager.debug("** Found key: " + object + " in the EJB Cache.");
            }
            this.getCacheRuntime().incrementCacheHitCount();
        }
        return enterpriseBean;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EnterpriseBean preInvoke(InvocationWrapper invocationWrapper) throws InternalException {
        EnterpriseBean enterpriseBean;
        try {
            Set set;
            block27: {
                super.preInvoke();
                Object object = invocationWrapper.getPrimaryKey();
                Transaction transaction = invocationWrapper.getInvokeTx();
                enterpriseBean = null;
                boolean bl = !this.acquireLock(invocationWrapper);
                try {
                    enterpriseBean = this.getBean(object);
                    if (this.extendedPersistenceContextMap != null && transaction != null && !this.usesBeanManagedTx()) {
                        set = ((WLSessionBean)enterpriseBean).getExtendedPersistenceContexts();
                        for (ExtendedPersistenceContextWrapper extendedPersistenceContextWrapper : set) {
                            String string = extendedPersistenceContextWrapper.getPersistenceUnitName();
                            TransactionSynchronizationRegistry transactionSynchronizationRegistry = (TransactionSynchronizationRegistry)TransactionHelper.getTransactionHelper().getTransactionManager();
                            Object object2 = transactionSynchronizationRegistry.getResource((Object)string);
                            if (object2 != null) {
                                if (object2.equals(extendedPersistenceContextWrapper.getEntityManager())) continue;
                                EJBRuntimeUtils.throwInternalException("Error invoking EJB:", (Throwable)new EJBException("Error, the EJB " + this.ejbHome.getDisplayName() + " has an Extended Persistence Context and was invoked " + " in the context of a transaction that is already " + " associated with a different Persistence Context"));
                                continue;
                            }
                            transactionSynchronizationRegistry.putResource((Object)string, (Object)extendedPersistenceContextWrapper.getEntityManager());
                            extendedPersistenceContextWrapper.getEntityManager().joinTransaction();
                        }
                    }
                    if (this.usesBeanManagedTx()) {
                        if (bl) {
                            ((WLEnterpriseBean)enterpriseBean).__WL_setBeanManagedTransaction(null);
                        } else {
                            set = ((WLEnterpriseBean)enterpriseBean).__WL_getBeanManagedTransaction();
                            if (set != null) {
                                if (debugLogger.isDebugEnabled()) {
                                    StatefulSessionManager.debug("** Resuming transaction on key: " + object);
                                }
                                try {
                                    TxHelper.getTransactionManager().resume((Transaction)set);
                                }
                                catch (InvalidTransactionException invalidTransactionException) {
                                    ((WLEnterpriseBean)enterpriseBean).__WL_setBeanManagedTransaction(null);
                                    this.cache.remove(new CacheKey(object, this));
                                    this.lockManager.unlock(object, this.getLockClient(null));
                                    throw invalidTransactionException;
                                }
                                catch (SystemException systemException) {
                                    EJBLogger.logExcepResumingTx((Exception)((Object)systemException));
                                    ((WLEnterpriseBean)enterpriseBean).__WL_setBeanManagedTransaction(null);
                                    this.removeBean(new CacheKey(object, this), enterpriseBean);
                                    try {
                                        if (transaction instanceof weblogic.transaction.Transaction) {
                                            ((weblogic.transaction.Transaction)transaction).setRollbackOnly("Couldn't resume transaction " + set, (Throwable)systemException);
                                        } else {
                                            transaction.setRollbackOnly();
                                        }
                                    }
                                    catch (SystemException systemException2) {
                                        // empty catch block
                                    }
                                    this.lockManager.unlock(object, this.getLockClient(null));
                                    throw new InternalException("Exception trying to resume transaction", systemException);
                                }
                            }
                        }
                    }
                    if (transaction != null && bl) {
                        try {
                            this.setupTxListener(invocationWrapper);
                        }
                        catch (InternalException internalException) {
                            this.removeBean(new CacheKey(object, this), enterpriseBean);
                            throw internalException;
                        }
                    }
                    if (!bl || !this.implementsSessionSynchronization) break block27;
                    try {
                        if (transaction != null) {
                            ((SessionSynchronization)enterpriseBean).afterBegin();
                        }
                    }
                    catch (Throwable throwable) {
                        EJBLogger.logExcepInAfterBegin((String)StackTraceUtils.throwable2StackTrace((Throwable)throwable));
                        this.removeBean(new CacheKey(object, this), enterpriseBean);
                        EJBRuntimeUtils.throwInternalException("Exception in afterBegin", throwable);
                    }
                }
                catch (Throwable throwable) {
                    if (bl) {
                        this.lockManager.unlock(object, this.getLockClient(transaction));
                    }
                    EJBRuntimeUtils.throwInternalException("Stateful Session Exception:", throwable);
                }
            }
            if (((WLEnterpriseBean)enterpriseBean).__WL_isBusy()) {
                set = EJBLogger.logIllegalMakeReentrantCallSFSBLoggable((String)this.beanInfo.getDisplayName());
                ConcurrentAccessException concurrentAccessException = new ConcurrentAccessException(set.getMessageText());
                set = EJBLogger.logIllegalMakeReentrantCallSFSBFromHomeLoggable((String)this.ejbHome.getDisplayName());
                throw new InternalException(set.getMessageText(), (Throwable)concurrentAccessException);
            }
            ((WLEnterpriseBean)enterpriseBean).__WL_setBusy(true);
            Object var15_18 = null;
        }
        catch (Throwable throwable) {
            Object var15_19 = null;
            if (!_WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Preinvoke_After_Medium.isEnabledAndNotDyeFiltered()) throw throwable;
            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Preinvoke_After_Medium;
            InstrumentationSupport.process((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
            throw throwable;
        }
        if (!_WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Preinvoke_After_Medium.isEnabledAndNotDyeFiltered()) return enterpriseBean;
        DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Preinvoke_After_Medium;
        InstrumentationSupport.process((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
        return enterpriseBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postInvoke(InvocationWrapper invocationWrapper) throws InternalException {
        block28: {
            WLEnterpriseBean wLEnterpriseBean;
            CacheKey cacheKey;
            Object object;
            Transaction transaction;
            block32: {
                block31: {
                    if (_WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Postinvoke_Before_Medium.isEnabledAndNotDyeFiltered()) {
                        Object[] objectArray = null;
                        if (_WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Postinvoke_Before_Medium.isArgumentsCaptureNeeded()) {
                            objectArray = new Object[]{this, invocationWrapper};
                        }
                        DynamicJoinPoint dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_1, (Object[])objectArray, null);
                        DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Postinvoke_Before_Medium;
                        InstrumentationSupport.process((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
                    }
                    assert (invocationWrapper != null);
                    assert (invocationWrapper.getPrimaryKey() != null);
                    transaction = invocationWrapper.getInvokeTx();
                    object = invocationWrapper.getPrimaryKey();
                    cacheKey = new CacheKey(object, this);
                    wLEnterpriseBean = (WLEnterpriseBean)invocationWrapper.getBean();
                    wLEnterpriseBean.__WL_setBusy(false);
                    if (!this.usesBeanManagedTx()) break block31;
                    transaction = TxHelper.getTransaction();
                    if (transaction == null) {
                        if (debugLogger.isDebugEnabled()) {
                            StatefulSessionManager.debug("** releasing key because BM has no associated tx:" + object);
                        }
                        wLEnterpriseBean.__WL_setBeanManagedTransaction(null);
                        this.replicateAndRelease(cacheKey, (EnterpriseBean)wLEnterpriseBean);
                        this.lockManager.unlock(object, this.getLockClient(null));
                    } else {
                        if (debugLogger.isDebugEnabled()) {
                            StatefulSessionManager.debug("** keeping lock and associating tx for:" + object);
                        }
                        try {
                            if (transaction.getStatus() == 0) {
                                TxHelper.getTransactionManager().suspend();
                                wLEnterpriseBean.__WL_setBeanManagedTransaction(transaction);
                                break block28;
                            }
                            if (transaction.getStatus() == 1 && transaction instanceof weblogic.transaction.Transaction) {
                                weblogic.transaction.Transaction transaction2 = (weblogic.transaction.Transaction)transaction;
                                transaction2.setProperty("DISABLE_TX_STATUS_CHECK", (Serializable)((Object)"true"));
                                TxHelper.getTransactionManager().suspend();
                                wLEnterpriseBean.__WL_setBeanManagedTransaction(transaction);
                                break block28;
                            }
                            wLEnterpriseBean.__WL_setBeanManagedTransaction(null);
                        }
                        catch (SystemException systemException) {
                            wLEnterpriseBean.__WL_setBeanManagedTransaction(null);
                        }
                    }
                    break block28;
                }
                if (transaction != null) break block32;
                if (debugLogger.isDebugEnabled()) {
                    StatefulSessionManager.debug("** releasing non BM tx: " + object);
                }
                this.replicateAndRelease(cacheKey, (EnterpriseBean)wLEnterpriseBean);
                this.lockManager.unlock(object, this.getLockClient(transaction));
                break block28;
            }
            WLEnterpriseBean wLEnterpriseBean2 = wLEnterpriseBean;
            synchronized (wLEnterpriseBean2) {
                try {
                    if (wLEnterpriseBean.__WL_needsRemove() && this.implementsSessionSynchronization) {
                        if (debugLogger.isDebugEnabled()) {
                            StatefulSessionManager.debug("*** postInvoke called after afterCompletion****");
                        }
                        SessionSynchronization sessionSynchronization = (SessionSynchronization)this.cache.get(cacheKey);
                        try {
                            block29: {
                                try {
                                    this.ejbHome.pushEnvironment();
                                    if (!((WLSessionBean)wLEnterpriseBean).__WL_needsSessionSynchronization()) break block29;
                                    sessionSynchronization.afterCompletion(transaction.getStatus() == 3);
                                }
                                catch (Throwable throwable) {
                                    EJBLogger.logExcepInAfterCompletion((String)StackTraceUtils.throwable2StackTrace((Throwable)throwable));
                                    this.removeBean(cacheKey, sessionSynchronization);
                                    Object var10_13 = null;
                                    this.ejbHome.popEnvironment();
                                }
                            }
                            Object var10_12 = null;
                            this.ejbHome.popEnvironment();
                        }
                        catch (Throwable throwable) {
                            Object var10_14 = null;
                            this.ejbHome.popEnvironment();
                            throw throwable;
                        }
                    }
                    Object var12_17 = null;
                }
                catch (Throwable throwable) {
                    Object var12_18 = null;
                    if (debugLogger.isDebugEnabled()) {
                        StatefulSessionManager.debug("****releasing the bean inside postInvoke****");
                    }
                    if (wLEnterpriseBean.__WL_needsRemove()) {
                        wLEnterpriseBean.__WL_setNeedsRemove(false);
                        this.replicateAndRelease(cacheKey, (EnterpriseBean)wLEnterpriseBean);
                        this.lockManager.unlock(object, this.getLockClient(transaction));
                    }
                    throw throwable;
                }
                if (debugLogger.isDebugEnabled()) {
                    StatefulSessionManager.debug("****releasing the bean inside postInvoke****");
                }
                if (wLEnterpriseBean.__WL_needsRemove()) {
                    wLEnterpriseBean.__WL_setNeedsRemove(false);
                    this.replicateAndRelease(cacheKey, (EnterpriseBean)wLEnterpriseBean);
                    this.lockManager.unlock(object, this.getLockClient(transaction));
                }
            }
        }
    }

    public EnterpriseBean preHomeInvoke(InvocationWrapper invocationWrapper) throws InternalException {
        throw new AssertionError("Stateful session beans cannot have home methods");
    }

    public void postHomeInvoke(InvocationWrapper invocationWrapper) throws InternalException {
        throw new AssertionError("Stateful session beans cannot have home methods");
    }

    public void destroyPooledInstance(InvocationWrapper invocationWrapper, Throwable throwable) throws InternalException {
        throw new AssertionError("Stateful session beans cannot have home methods");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void destroyInstance(InvocationWrapper invocationWrapper, Throwable throwable) {
        boolean bl = _WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Remove_Around_High.isEnabledAndNotDyeFiltered();
        DiagnosticAction[] diagnosticActionArray = null;
        DiagnosticActionState[] diagnosticActionStateArray = null;
        Object var11_6 = null;
        if (bl) {
            Object[] objectArray = null;
            if (_WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Remove_Around_High.isArgumentsCaptureNeeded()) {
                objectArray = new Object[]{this, invocationWrapper, throwable};
            }
            DynamicJoinPoint dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_2, (Object[])objectArray, null);
            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Remove_Around_High;
            diagnosticActionArray = delegatingMonitor.getActions();
            diagnosticActionStateArray = InstrumentationSupport.getActionStates((DiagnosticAction[])diagnosticActionArray);
            InstrumentationSupport.preProcess((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
        }
        try {
            Object object = invocationWrapper.getPrimaryKey();
            CacheKey cacheKey = new CacheKey(object, this);
            assert (object != null);
            WLEnterpriseBean wLEnterpriseBean = (WLEnterpriseBean)invocationWrapper.getBean();
            wLEnterpriseBean.__WL_setBusy(false);
            this.removeBean(cacheKey, wLEnterpriseBean);
            if (invocationWrapper.getInvokeTx() == null || wLEnterpriseBean.__WL_needsRemove()) {
                this.lockManager.unlock(object, this.getLockClient(null));
            }
            Object var9_13 = null;
            if (!bl) return;
        }
        catch (Throwable throwable2) {
            Object var9_14 = null;
            if (!bl) throw throwable2;
            InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_2, (DiagnosticMonitor)_WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Remove_Around_High, diagnosticActionArray, diagnosticActionStateArray);
            throw throwable2;
        }
        InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_2, (DiagnosticMonitor)_WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Remove_Around_High, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
    }

    private void removeBean(CacheKey cacheKey, Object object) {
        this.cache.remove(cacheKey);
        if (object != null) {
            ((WLSessionBean)object).closeExtendedPersistenceContexts();
        }
    }

    private void releaseProxy(Object object) {
        if (ENABLE_PROXY_POOL && this.beanInfo.isEJB30()) {
            EnterpriseBeanProxy enterpriseBeanProxy = (EnterpriseBeanProxy)object;
            TargetWrapper targetWrapper = (TargetWrapper)enterpriseBeanProxy.getTarget();
            targetWrapper.removeTarget();
            this.proxyPool.add((Object)enterpriseBeanProxy);
        }
    }

    public void beforeCompletion(InvocationWrapper invocationWrapper) throws InternalException {
    }

    public void beforeCompletion(Object object) throws InternalException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeCompletion(Collection collection, Transaction transaction) throws InternalException {
        for (Object e : collection) {
            Object var10_9;
            SessionSynchronization sessionSynchronization;
            CacheKey cacheKey = new CacheKey(e, this);
            if (!this.implementsSessionSynchronization || (sessionSynchronization = (SessionSynchronization)this.cache.get(cacheKey)) == null) continue;
            try {
                block9: {
                    try {
                        this.ejbHome.pushEnvironment();
                        if (!((WLSessionBean)sessionSynchronization).__WL_needsSessionSynchronization()) break block9;
                        sessionSynchronization.beforeCompletion();
                    }
                    catch (Throwable throwable) {
                        EJBLogger.logExcepInBeforeCompletion((String)StackTraceUtils.throwable2StackTrace((Throwable)throwable));
                        this.removeBean(cacheKey, sessionSynchronization);
                        try {
                            if (transaction instanceof weblogic.transaction.Transaction) {
                                ((weblogic.transaction.Transaction)transaction).setRollbackOnly("beforeCompletion() threw an exception", throwable);
                            } else {
                                transaction.setRollbackOnly();
                            }
                        }
                        catch (SystemException systemException) {
                            EJBLogger.logExcepDuringSetRollbackOnly((Exception)((Object)systemException));
                        }
                        EJBRuntimeUtils.throwInternalException("Exception in beforeCompletion:", throwable);
                        var10_9 = null;
                        this.ejbHome.popEnvironment();
                        continue;
                    }
                }
                var10_9 = null;
                this.ejbHome.popEnvironment();
            }
            catch (Throwable throwable) {
                var10_9 = null;
                this.ejbHome.popEnvironment();
                throw throwable;
            }
        }
    }

    public void afterCompletion(InvocationWrapper invocationWrapper) {
    }

    public void afterCompletion(Object object) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCompletion(Collection collection, Transaction transaction, int n, Object object) {
        for (Object e : collection) {
            Object var18_15;
            CacheKey cacheKey = new CacheKey(e, this);
            boolean bl = true;
            WLEnterpriseBean wLEnterpriseBean = null;
            try {
                EnterpriseBean enterpriseBean = this.cache.get(cacheKey);
                wLEnterpriseBean = (WLEnterpriseBean)enterpriseBean;
                if (wLEnterpriseBean != null) {
                    WLEnterpriseBean wLEnterpriseBean2 = wLEnterpriseBean;
                    synchronized (wLEnterpriseBean2) {
                        if (!wLEnterpriseBean.__WL_isBusy()) {
                            if (this.implementsSessionSynchronization) {
                                Object var15_14;
                                SessionSynchronization sessionSynchronization = (SessionSynchronization)enterpriseBean;
                                try {
                                    block16: {
                                        try {
                                            this.ejbHome.pushEnvironment();
                                            if (!((WLSessionBean)sessionSynchronization).__WL_needsSessionSynchronization()) break block16;
                                            sessionSynchronization.afterCompletion(n == 3);
                                        }
                                        catch (Throwable throwable) {
                                            EJBLogger.logExcepInAfterCompletion((String)StackTraceUtils.throwable2StackTrace((Throwable)throwable));
                                            this.removeBean(cacheKey, sessionSynchronization);
                                            var15_14 = null;
                                            this.ejbHome.popEnvironment();
                                        }
                                    }
                                    var15_14 = null;
                                    this.ejbHome.popEnvironment();
                                }
                                catch (Throwable throwable) {
                                    var15_14 = null;
                                    this.ejbHome.popEnvironment();
                                    throw throwable;
                                }
                            }
                        } else {
                            if (debugLogger.isDebugEnabled()) {
                                StatefulSessionManager.debug("******afterCompletion called before postInvoke ******");
                            }
                            bl = false;
                            wLEnterpriseBean.__WL_setNeedsRemove(true);
                        }
                    }
                }
                var18_15 = null;
                if (!bl) continue;
                this.replicateAndRelease(cacheKey, (EnterpriseBean)wLEnterpriseBean);
                this.lockManager.unlock(e, this.getLockClient(transaction));
            }
            catch (Throwable throwable) {
                var18_15 = null;
                if (bl) {
                    this.replicateAndRelease(cacheKey, (EnterpriseBean)wLEnterpriseBean);
                    this.lockManager.unlock(e, this.getLockClient(transaction));
                }
                throw throwable;
            }
        }
    }

    public EJBContext allocateContext(EnterpriseBean enterpriseBean, EJBObject eJBObject, EJBLocalObject eJBLocalObject) {
        return new SessionEJBContextImpl(enterpriseBean, this, this.remoteHome, this.localHome, eJBObject, eJBLocalObject);
    }

    public EJBContext allocateContext(EnterpriseBean enterpriseBean, Object object) {
        EJBObject eJBObject = null;
        BaseEJBLocalObjectIntf baseEJBLocalObjectIntf = null;
        if (this.beanInfo.hasDeclaredRemoteHome()) {
            eJBObject = this.remoteHome.allocateEO(object);
        }
        if (this.beanInfo.hasDeclaredLocalHome()) {
            baseEJBLocalObjectIntf = this.localHome.allocateELO(object);
        }
        return this.allocateContext(enterpriseBean, eJBObject, baseEJBLocalObjectIntf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EnterpriseBean createNewBeanInstance() throws IllegalAccessException, InstantiationException {
        EnterpriseBeanProxy enterpriseBeanProxy;
        if (ENABLE_PROXY_POOL && this.beanInfo.isEJB30() && (enterpriseBeanProxy = (EnterpriseBeanProxy)this.proxyPool.remove()) != null) {
            ClassLoader classLoader = this.beanInfo.getClassLoader();
            Thread thread2 = Thread.currentThread();
            ClassLoader classLoader2 = thread2.getContextClassLoader();
            try {
                thread2.setContextClassLoader(classLoader);
                Object object = this.ejbComponentCreator.getBean(this.beanInfo.getEJBName(), this.beanClass, false);
                ((TargetWrapper)enterpriseBeanProxy.getTarget()).resetTarget(object);
                EnterpriseBean enterpriseBean = (EnterpriseBean)enterpriseBeanProxy;
                Object var8_7 = null;
                thread2.setContextClassLoader(classLoader2);
                return enterpriseBean;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                thread2.setContextClassLoader(classLoader2);
                throw throwable;
            }
        }
        return super.createNewBeanInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void create(EJBObject eJBObject, EJBLocalObject eJBLocalObject, Object object, InvocationWrapper invocationWrapper, Method method, Method method2, Object[] objectArray) throws InternalException {
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        SessionBean sessionBean;
        block22: {
            sessionBean = null;
            HashSet<String> hashSet = null;
            HashSet<ExtendedPersistenceContextWrapper> hashSet2 = null;
            if (this.extendedPersistenceContextMap != null) {
                hashSet = new HashSet<String>();
                hashSet2 = new HashSet<ExtendedPersistenceContextWrapper>();
                object5 = this.extendedPersistenceContextMap.keySet();
                object4 = object5.iterator();
                while (object4.hasNext()) {
                    object3 = (String)object4.next();
                    object2 = (PersistenceUnitInfoImpl)this.extendedPersistenceContextMap.get(object3);
                    String string = ((PersistenceUnitInfoImpl)object2).getPersistenceUnitId();
                    ExtendedPersistenceContextWrapper extendedPersistenceContextWrapper = ExtendedPersistenceContextManager.getExtendedPersistenceContext(string);
                    if (extendedPersistenceContextWrapper != null) {
                        extendedPersistenceContextWrapper.incrementReferenceCount();
                    } else {
                        extendedPersistenceContextWrapper = new ExtendedPersistenceContextWrapper((PersistenceUnitInfoImpl)object2);
                        ExtendedPersistenceContextManager.setExtendedPersistenceContext(string, extendedPersistenceContextWrapper);
                        hashSet.add(string);
                    }
                    hashSet2.add(extendedPersistenceContextWrapper);
                }
            }
            try {
                sessionBean = (SessionBean)this.createBean(object, eJBObject, eJBLocalObject, null);
                Object var18_20 = null;
                if (this.extendedPersistenceContextMap == null) break block22;
                Set set = ((WLSessionBean)sessionBean).getExtendedPersistenceContexts();
                set.addAll(hashSet2);
            }
            catch (Throwable throwable) {
                Object var18_21 = null;
                if (this.extendedPersistenceContextMap != null) {
                    Set set = ((WLSessionBean)sessionBean).getExtendedPersistenceContexts();
                    set.addAll(hashSet2);
                    for (String string : hashSet) {
                        ExtendedPersistenceContextManager.removeExtendedPersistenceContext(string);
                    }
                }
                throw throwable;
            }
            for (String string : hashSet) {
                ExtendedPersistenceContextManager.removeExtendedPersistenceContext(string);
            }
        }
        assert (invocationWrapper.getInvokeTx() == null);
        this.acquireLock(invocationWrapper, object);
        object5 = new CacheKey(object, this);
        try {
            try {
                Debug.assertion((sessionBean != null ? 1 : 0) != 0);
                if (this.beanInfo.isEJB30() && sessionBean instanceof __ProxyControl) {
                    object4 = this.beanInfo.getClassLoader();
                    object3 = Thread.currentThread();
                    object2 = ((Thread)object3).getContextClassLoader();
                    try {
                        this.ejbHome.pushEnvironment();
                        ((Thread)object3).setContextClassLoader((ClassLoader)object4);
                        EJBContextManager.pushEjbContext(((WLSessionBean)sessionBean).__WL_getEJBContext());
                        AllowedMethodsHelper.pushMethodInvocationState(new Integer(4));
                        ((__ProxyControl)sessionBean).invokeLifecycleMethod(LifecycleEvent.POST_CONSTRUCT);
                        Object var23_29 = null;
                    }
                    catch (Throwable throwable) {
                        Object var23_30 = null;
                        AllowedMethodsHelper.popMethodInvocationState();
                        ((Thread)object3).setContextClassLoader((ClassLoader)object2);
                        EJBContextManager.popEjbContext();
                        this.ejbHome.popEnvironment();
                        throw throwable;
                    }
                    AllowedMethodsHelper.popMethodInvocationState();
                    ((Thread)object3).setContextClassLoader((ClassLoader)object2);
                    EJBContextManager.popEjbContext();
                    this.ejbHome.popEnvironment();
                    {
                    }
                }
                if (method != null) {
                    Debug.assertion((objectArray != null ? 1 : 0) != 0);
                    method.invoke((Object)sessionBean, objectArray);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Throwable)illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                object3 = invocationTargetException.getTargetException();
                if (debugLogger.isDebugEnabled()) {
                    StatefulSessionManager.debug("Error during create: ", (Throwable)object3);
                }
                this.handleMethodException(method, null, (Throwable)object3);
            }
            try {
                this.cache.put((CacheKey)object5, (EnterpriseBean)sessionBean);
                this.getCacheRuntime().incrementCachedBeansCurrentCount();
            }
            catch (CacheFullException cacheFullException) {
                EJBRuntimeUtils.throwInternalException("Exception in remote create", cacheFullException);
            }
            this.replicateAndRelease((CacheKey)object5, (EnterpriseBean)sessionBean);
            Object var25_32 = null;
            this.lockManager.unlock(object, this.getLockClient(null));
        }
        catch (Throwable throwable) {
            Object var25_33 = null;
            this.lockManager.unlock(object, this.getLockClient(null));
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EnterpriseBean createBean(Object object, EJBObject eJBObject, EJBLocalObject eJBLocalObject, EnterpriseBean enterpriseBean) throws InternalException {
        try {
            WLSessionEJBContext wLSessionEJBContext;
            this.ejbHome.pushEnvironment();
            EJBContext eJBContext = this.allocateContext(enterpriseBean, eJBObject, eJBLocalObject);
            if (this.beanInfo instanceof Ejb3SessionBeanInfo) {
                wLSessionEJBContext = (WLSessionEJBContext)eJBContext;
                wLSessionEJBContext.setPrimaryKey(object);
            }
            try {
                EJBContextManager.pushEjbContext(eJBContext);
                AllowedMethodsHelper.pushMethodInvocationState(new Integer(1));
                if (enterpriseBean == null) {
                    enterpriseBean = this.allocateBean();
                }
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                EJBContextManager.popEjbContext();
                AllowedMethodsHelper.popMethodInvocationState();
                throw throwable;
            }
            EJBContextManager.popEjbContext();
            AllowedMethodsHelper.popMethodInvocationState();
            ((BaseEJBContext)eJBContext).setBean(enterpriseBean);
            try {
                try {
                    AllowedMethodsHelper.pushMethodInvocationState(new Integer(1));
                    ((SessionBean)enterpriseBean).setSessionContext((SessionContext)eJBContext);
                }
                catch (Exception exception) {
                    throw new InternalException("Error during setXXXContext: ", exception);
                }
                Object var10_11 = null;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                AllowedMethodsHelper.popMethodInvocationState();
                throw throwable;
            }
            AllowedMethodsHelper.popMethodInvocationState();
            ((WLEnterpriseBean)enterpriseBean).__WL_setEJBContext(eJBContext);
            wLSessionEJBContext = enterpriseBean;
            Object var12_14 = null;
            this.ejbHome.popEnvironment();
            return wLSessionEJBContext;
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            this.ejbHome.popEnvironment();
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object createBean() throws InternalException {
        Object object;
        boolean bl = _WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Create_Around_Medium.isEnabledAndNotDyeFiltered();
        DiagnosticAction[] diagnosticActionArray = null;
        DiagnosticActionState[] diagnosticActionStateArray = null;
        Object var10_4 = null;
        if (bl) {
            Object[] objectArray = null;
            if (_WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Create_Around_Medium.isArgumentsCaptureNeeded()) {
                objectArray = InstrumentationSupport.toSensitive((int)1);
            }
            DynamicJoinPoint dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_3, (Object[])objectArray, null);
            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Create_Around_Medium;
            diagnosticActionArray = delegatingMonitor.getActions();
            diagnosticActionStateArray = InstrumentationSupport.getActionStates((DiagnosticAction[])diagnosticActionArray);
            InstrumentationSupport.preProcess((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
        }
        try {
            if (debugLogger.isDebugEnabled()) {
                StatefulSessionManager.debug("calling getReferent(...) in StatefulSessionManager");
            }
            object = this.keyGenerator.nextKey();
            InvocationWrapper invocationWrapper = EJBRuntimeUtils.createWrap();
            EJBObject eJBObject = null;
            BaseEJBLocalObjectIntf baseEJBLocalObjectIntf = null;
            if (this.beanInfo.hasDeclaredRemoteHome()) {
                eJBObject = this.remoteHome.allocateEO(object);
            }
            if (this.beanInfo.hasDeclaredLocalHome()) {
                baseEJBLocalObjectIntf = this.localHome.allocateELO(object);
            }
            this.create(eJBObject, baseEJBLocalObjectIntf, object, invocationWrapper, null, null, null);
            Object var8_12 = null;
            if (!bl) return object;
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            if (!bl) throw throwable;
            InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_3, (DiagnosticMonitor)_WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Create_Around_Medium, diagnosticActionArray, diagnosticActionStateArray);
            throw throwable;
        }
        InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_3, (DiagnosticMonitor)_WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Create_Around_Medium, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
        return object;
    }

    public StatefulRemoteObject remoteCreateForBI(Object object, Class clazz, Activator activator, Class clazz2) throws InternalException {
        if (activator == null) {
            throw new AssertionError();
        }
        if (object == null) {
            object = this.createBean();
        }
        return (StatefulRemoteObject)((Object)((StatefulEJBHomeImpl)this.remoteHome).allocateBI(object, clazz, clazz2, activator));
    }

    public EJBObject remoteCreate(InvocationWrapper invocationWrapper, Method method, Method method2, Object[] objectArray) throws InternalException {
        Object object = this.keyGenerator.nextKey();
        EJBObject eJBObject = null;
        BaseEJBLocalObjectIntf baseEJBLocalObjectIntf = null;
        if (this.remoteHome != null) {
            eJBObject = this.remoteHome.allocateEO(object);
        }
        if (this.localHome != null && this.beanInfo.hasDeclaredLocalHome()) {
            baseEJBLocalObjectIntf = this.localHome.allocateELO(object);
        }
        this.create(eJBObject, baseEJBLocalObjectIntf, object, invocationWrapper, method, method2, objectArray);
        return eJBObject;
    }

    public EJBLocalObject localCreate(InvocationWrapper invocationWrapper, Method method, Method method2, Object[] objectArray) throws InternalException {
        Object object = this.keyGenerator.nextKey();
        StatefulEJBObject statefulEJBObject = null;
        StatefulEJBLocalObject statefulEJBLocalObject = null;
        if (this.remoteHome != null && this.beanInfo.hasDeclaredRemoteHome()) {
            statefulEJBObject = (StatefulEJBObject)this.remoteHome.allocateEO(object);
        }
        if (this.localHome != null) {
            statefulEJBLocalObject = (StatefulEJBLocalObject)this.localHome.allocateELO(object);
        }
        this.create(statefulEJBObject, statefulEJBLocalObject, object, invocationWrapper, method, method2, objectArray);
        return statefulEJBLocalObject;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void remove(InvocationWrapper invocationWrapper) throws InternalException {
        boolean bl = _WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Remove_Around_High.isEnabledAndNotDyeFiltered();
        DiagnosticAction[] diagnosticActionArray = null;
        DiagnosticActionState[] diagnosticActionStateArray = null;
        Object var17_5 = null;
        if (bl) {
            Object[] objectArray = null;
            if (_WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Remove_Around_High.isArgumentsCaptureNeeded()) {
                objectArray = new Object[]{this, invocationWrapper};
            }
            DynamicJoinPoint dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_4, (Object[])objectArray, null);
            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Remove_Around_High;
            diagnosticActionArray = delegatingMonitor.getActions();
            diagnosticActionStateArray = InstrumentationSupport.getActionStates((DiagnosticAction[])diagnosticActionArray);
            InstrumentationSupport.preProcess((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
        }
        try {
            Object object;
            assert (invocationWrapper.getMethodDescriptor().getTXAttribute() == 2 || invocationWrapper.getInvokeTx() == null);
            Object object2 = invocationWrapper.getPrimaryKey();
            CacheKey cacheKey = new CacheKey(object2, this);
            assert (object2 != null);
            if (!this.beanInfo.isAllowRemoveDuringTx() && (object = this.lockManager.getOwner(object2)) != null && object instanceof Transaction) {
                throw new InternalException("", (Throwable)new RemoveException("Illegal attempt to remove a stateful session bean while it is participating in a transaction"));
            }
            boolean bl2 = false;
            SessionBean sessionBean = null;
            boolean bl3 = false;
            Transaction transaction = invocationWrapper.getInvokeTx();
            if (transaction != null && !this.ejbHome.usesBeanManagedTx()) {
                bl3 = true;
            }
            boolean bl4 = false;
            try {
                try {
                    sessionBean = (SessionBean)this.preInvoke(invocationWrapper);
                    bl2 = true;
                    assert (sessionBean != null);
                    this.removeBean(cacheKey, sessionBean);
                    sessionBean.ejbRemove();
                }
                catch (Throwable throwable) {
                    bl4 = true;
                    this.handleMethodException(invocationWrapper.getMethodDescriptor().getMethod(), null, throwable);
                    throw new AssertionError("Should not reach");
                }
                Object var11_17 = null;
                if (sessionBean != null) {
                    ((WLEnterpriseBean)sessionBean).__WL_setBusy(false);
                    if (!bl4) {
                        this.releaseProxy(sessionBean);
                    }
                }
                if (bl2 && !bl3) {
                    this.lockManager.unlock(object2, this.getLockClient(null));
                }
            }
            catch (Throwable throwable) {
                Object var11_18 = null;
                if (sessionBean != null) {
                    ((WLEnterpriseBean)sessionBean).__WL_setBusy(false);
                    if (!bl4) {
                        this.releaseProxy(sessionBean);
                    }
                }
                if (!bl2 || bl3) throw throwable;
                this.lockManager.unlock(object2, this.getLockClient(null));
                throw throwable;
            }
            Object var15_21 = null;
            if (!bl) return;
        }
        catch (Throwable throwable) {
            Object var15_22 = null;
            if (!bl) throw throwable;
            InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_4, (DiagnosticMonitor)_WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Remove_Around_High, diagnosticActionArray, diagnosticActionStateArray);
            throw throwable;
        }
        InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_4, (DiagnosticMonitor)_WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Remove_Around_High, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void removeForRemoveAnnotation(InvocationWrapper invocationWrapper) throws InternalException {
        block23: {
            Object object = invocationWrapper.getPrimaryKey();
            CacheKey cacheKey = new CacheKey(object, this);
            assert (object != null);
            SessionBean sessionBean = null;
            if (invocationWrapper.getInvokeTx() == null || invocationWrapper.getInvokeTx().getStatus() != 0 && invocationWrapper.getInvokeTx().getStatus() != 1) {
                this.lockManager.lock(object, this.getLockClient(null), this.getLockTimeout(invocationWrapper));
            }
            sessionBean = (SessionBean)this.getBean(object);
            assert (sessionBean != null);
            this.removeBean(cacheKey, sessionBean);
            sessionBean.ejbRemove();
            this.releaseProxy(sessionBean);
            Object var7_5 = null;
            try {
                if (invocationWrapper.getInvokeTx() == null || invocationWrapper.getInvokeTx().getStatus() != 0 && invocationWrapper.getInvokeTx().getStatus() != 1) {
                    this.lockManager.unlock(object, this.getLockClient(null));
                }
                if (this.remoteHome != null && (this.remoteHome.getIsNoObjectActivation() || this.remoteHome.getIsInMemoryReplication())) {
                    EJBObject eJBObject = this.remoteHome.getEJBObject(object);
                    if (eJBObject != null) {
                        this.remoteHome.releaseEO(object);
                    }
                    if (this.remoteHome instanceof StatefulEJBHomeImpl) {
                        ((StatefulEJBHomeImpl)this.remoteHome).releaseBOs(object);
                    }
                }
                break block23;
            }
            catch (Throwable throwable) {
                EJBRuntimeUtils.throwInternalException("EJB Exception:", throwable);
            }
            break block23;
            {
                catch (Throwable throwable) {
                    EJBRuntimeUtils.throwInternalException("EJB Exception:", throwable);
                    Object var7_6 = null;
                    try {
                        if (invocationWrapper.getInvokeTx() == null || invocationWrapper.getInvokeTx().getStatus() != 0 && invocationWrapper.getInvokeTx().getStatus() != 1) {
                            this.lockManager.unlock(object, this.getLockClient(null));
                        }
                        if (this.remoteHome != null && (this.remoteHome.getIsNoObjectActivation() || this.remoteHome.getIsInMemoryReplication())) {
                            EJBObject eJBObject = this.remoteHome.getEJBObject(object);
                            if (eJBObject != null) {
                                this.remoteHome.releaseEO(object);
                            }
                            if (this.remoteHome instanceof StatefulEJBHomeImpl) {
                                ((StatefulEJBHomeImpl)this.remoteHome).releaseBOs(object);
                            }
                        }
                        break block23;
                    }
                    catch (Throwable throwable2) {
                        EJBRuntimeUtils.throwInternalException("EJB Exception:", throwable2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                try {
                    if (invocationWrapper.getInvokeTx() == null || invocationWrapper.getInvokeTx().getStatus() != 0 && invocationWrapper.getInvokeTx().getStatus() != 1) {
                        this.lockManager.unlock(object, this.getLockClient(null));
                    }
                    if (this.remoteHome != null && (this.remoteHome.getIsNoObjectActivation() || this.remoteHome.getIsInMemoryReplication())) {
                        EJBObject eJBObject = this.remoteHome.getEJBObject(object);
                        if (eJBObject != null) {
                            this.remoteHome.releaseEO(object);
                        }
                        if (this.remoteHome instanceof StatefulEJBHomeImpl) {
                            ((StatefulEJBHomeImpl)this.remoteHome).releaseBOs(object);
                        }
                    }
                }
                catch (Throwable throwable3) {
                    EJBRuntimeUtils.throwInternalException("EJB Exception:", throwable3);
                }
                throw throwable;
            }
        }
    }

    public int getBeanSize() {
        return 1;
    }

    public boolean isEntityManager() {
        return false;
    }

    public void enrollInTransaction(Transaction transaction, CacheKey cacheKey, EntityBean entityBean, RSInfo rSInfo) throws InternalException {
        throw new AssertionError("method 'enrollInTransaction' not valid for StatefulSessionManager");
    }

    public void selectedForReplacement(CacheKey cacheKey, EntityBean entityBean) {
        throw new AssertionError("method 'selectedForReplacement' not valid for StatefulSessionManager");
    }

    public void loadBeanFromRS(CacheKey cacheKey, EntityBean entityBean, RSInfo rSInfo) {
        throw new AssertionError("method 'copy' not valid for StatefulSessionManager");
    }

    public void removedFromCache(CacheKey cacheKey, EnterpriseBean enterpriseBean) {
        this.getCacheRuntime().decrementCachedBeansCurrentCount();
    }

    public void removedOnError(CacheKey cacheKey, EnterpriseBean enterpriseBean) {
        throw new AssertionError("removedOnError in StatefulSessionManager");
    }

    public void swapIn(CacheKey cacheKey, EnterpriseBean enterpriseBean) {
        if (debugLogger.isDebugEnabled()) {
            StatefulSessionManager.debug("Activating key: " + cacheKey);
        }
        assert (enterpriseBean instanceof SessionBean);
        Object object = cacheKey.getPrimaryKey();
        if (!(this.swapper instanceof ReplicatedMemorySwap)) {
            this.swapper.remove(object);
        }
        try {
            ((SessionBean)enterpriseBean).ejbActivate();
            this.getCacheRuntime().incrementActivationCount();
        }
        catch (Exception exception) {
            this.removeBean(cacheKey, enterpriseBean);
            this.getCacheRuntime().decrementCachedBeansCurrentCount();
            EJBLogger.logExceptionDuringEJBActivate((Exception)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void swapOut(CacheKey cacheKey, EnterpriseBean enterpriseBean) {
        if (debugLogger.isDebugEnabled()) {
            StatefulSessionManager.debug("swapOut key: " + cacheKey);
        }
        assert (enterpriseBean instanceof SessionBean);
        Object object = cacheKey.getPrimaryKey();
        boolean bl = PoolHelper.setFile(this.fileSector, this.fileDesc);
        try {
            try {
                this.cacheRTMBean.incrementPassivationCount();
                ((SessionBean)enterpriseBean).ejbPassivate();
                this.swapper.write(object, enterpriseBean);
            }
            catch (Exception exception) {
                EJBLogger.logErrorDuringPassivation((String)StackTraceUtils.throwable2StackTrace((Throwable)exception));
                Object var7_6 = null;
                if (!bl) return;
                PoolHelper.resetFile();
                return;
            }
            Object var7_5 = null;
            if (!bl) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (!bl) throw throwable;
            PoolHelper.resetFile();
            throw throwable;
        }
        PoolHelper.resetFile();
    }

    public void replicate(CacheKey cacheKey, EnterpriseBean enterpriseBean) {
        if (this.isInMemoryReplication) {
            try {
                if (this.beanInfo.getPassivateDuringReplication()) {
                    ((SessionBean)enterpriseBean).ejbPassivate();
                }
                ((ReplicatedMemorySwap)this.swapper).sendUpdate(cacheKey.getPrimaryKey(), enterpriseBean);
            }
            catch (Exception exception) {
                EJBLogger.logErrorDuringPassivation((String)StackTraceUtils.throwable2StackTrace((Throwable)exception));
            }
            try {
                if (this.beanInfo.getPassivateDuringReplication()) {
                    ((SessionBean)enterpriseBean).ejbActivate();
                }
            }
            catch (RemoteException remoteException) {
                this.removeBean(cacheKey, enterpriseBean);
                EJBLogger.logExceptionDuringEJBActivate((Exception)remoteException);
            }
        }
    }

    public boolean needsRemoval(EnterpriseBean enterpriseBean) {
        return false;
    }

    public EJBObject remoteFindByPrimaryKey(InvocationWrapper invocationWrapper, Object object) throws InternalException {
        throw new AssertionError("No finders for stateful session beans");
    }

    public Object localFindByPrimaryKey(InvocationWrapper invocationWrapper, Object object) throws InternalException {
        throw new AssertionError("No finders for stateful session beans");
    }

    public EJBObject remoteScalarFinder(InvocationWrapper invocationWrapper, Method method, Object[] objectArray) throws InternalException {
        throw new AssertionError("No finders for stateful session beans");
    }

    public EJBLocalObject localScalarFinder(InvocationWrapper invocationWrapper, Method method, Object[] objectArray) throws InternalException {
        throw new AssertionError("No finders for stateful session beans");
    }

    public Enumeration enumFinder(InvocationWrapper invocationWrapper, Method method, Object[] objectArray) throws InternalException {
        throw new AssertionError("No finders for stateful session beans");
    }

    public Collection collectionFinder(InvocationWrapper invocationWrapper, Method method, Object[] objectArray) throws InternalException {
        throw new AssertionError("No finders for stateful session beans");
    }

    private String getServerRelativePath() {
        return DomainDir.getTempDirForServer((String)ManagementService.getRuntimeAccess(kernelId).getServerName());
    }

    public String getSwapDirectoryName() {
        return this.getServerRelativePath() + File.separatorChar + this.beanInfo.getSwapDirectoryName() + File.separatorChar + StringUtils.mangle((String)this.ejbHome.getIsIdenticalKey());
    }

    public void undeploy() {
        super.undeploy();
        this.cache.clear();
        this.cache.stopScrubber();
        this.swapper.cancelTrigger();
    }

    private boolean inCluster() {
        return ((ServerMBean)Kernel.getConfig()).getCluster() != null;
    }

    public synchronized void beanImplClassChangeNotification() {
        this.beanClass = this.beanInfo.getGeneratedBeanClass();
        this.swapper.updateClassLoader(this.beanInfo.getClassLoader());
    }

    public void updateMaxBeansInCache(int n) {
        this.cache.updateMaxBeansInCache(n);
    }

    public void updateIdleTimeoutSecondsCache(int n) {
        this.swapper.updateIdleTimeoutMS((long)n * 1000L);
        ((BaseCache)this.cache).updateIdleTimeoutSeconds(n);
    }

    public void releaseBean(InvocationWrapper invocationWrapper) {
    }

    public boolean isInMemoryReplication() {
        return this.beanInfo.getReplicationType() == 2;
    }

    private void replicateAndRelease(CacheKey cacheKey, EnterpriseBean enterpriseBean) {
        if (enterpriseBean != null) {
            this.replicate(cacheKey, enterpriseBean);
        }
        this.cache.release(cacheKey);
    }

    public int getIdleTimeoutSeconds() {
        return this.idleTimeoutSeconds;
    }

    public void reInitializeCacheAndPool() {
        this.cache.reInitializeCacheAndPools();
    }

    public void reInitializePool() {
    }

    public void passivateAndRelease(CacheKey cacheKey, EntityBean entityBean) {
    }

    public boolean hasBeansEnrolledInTx(Transaction transaction) {
        return false;
    }

    public PartialOrderSet getEnrolledInTxKeys(Transaction transaction) {
        return null;
    }

    public boolean isFlushPending(Transaction transaction, Object object) {
        return false;
    }

    public boolean beanIsOpsComplete(Transaction transaction, Object object) {
        return false;
    }

    public int passivateModifiedBean(Transaction transaction, Object object, boolean bl) {
        return 0;
    }

    public int passivateUnModifiedBean(Transaction transaction, Object object) {
        return 0;
    }

    public int cachePassivateModifiedBean(Transaction transaction, Object object, boolean bl) {
        return 0;
    }

    public int cachePassivateUnModifiedBean(Transaction transaction, Object object) {
        return 0;
    }

    public boolean passivateLockedModifiedBean(Transaction transaction, Object object, boolean bl, EntityBean entityBean) {
        return false;
    }

    public boolean passivateLockedUnModifiedBean(Transaction transaction, Object object, EntityBean entityBean) {
        return false;
    }

    public void operationsComplete(Transaction transaction, Object object) {
    }

    private static void debug(String string) {
        debugLogger.debug("[StatefulSessionManager] " + string);
    }

    private static void debug(String string, Throwable throwable) {
        debugLogger.debug("[StatefulSessionManager] " + string, throwable);
    }

    public Object assembleEJB3Proxy(Object object, BeanInfo beanInfo) {
        if (beanInfo instanceof Ejb3SessionBeanInfo) {
            return this.ejbComponentCreator.assembleEJB3Proxy(object, beanInfo.getEJBName());
        }
        return object;
    }

    public void passivateAndBacktoPool(CacheKey cacheKey, EntityBean entityBean) {
    }

    static {
        _WLDF$INST_FLD_class = Class.forName("weblogic.ejb.container.manager.StatefulSessionManager");
        _WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Remove_Around_High = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"EJB_Diagnostic_Pool_Manager_Remove_Around_High");
        _WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Preinvoke_After_Medium = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"EJB_Diagnostic_Pool_Manager_Preinvoke_After_Medium");
        _WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Postinvoke_Before_Medium = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"EJB_Diagnostic_Pool_Manager_Postinvoke_Before_Medium");
        _WLDF$INST_FLD_EJB_Diagnostic_Pool_Manager_Create_Around_Medium = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"EJB_Diagnostic_Pool_Manager_Create_Around_Medium");
        _WLDF$INST_JPFLD_0 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"StatefulSessionManager.java", (String)"weblogic.ejb.container.manager.StatefulSessionManager", (String)"preInvoke", (String)"(Lweblogic/ejb/container/internal/InvocationWrapper;)Ljavax/ejb/EnterpriseBean;", (int)477, (Map)InstrumentationSupport.makeMap((String[])new String[]{"EJB_Diagnostic_Pool_Manager_Preinvoke_After_Medium"}, (PointcutHandlingInfo[])new PointcutHandlingInfo[]{InstrumentationSupport.createPointcutHandlingInfo(null, null, (ValueHandlingInfo[])new ValueHandlingInfo[]{InstrumentationSupport.createValueHandlingInfo((String)"wrap", (String)"weblogic.diagnostics.instrumentation.gathering.EJBInvocationWrapperRenderer", (boolean)false, (boolean)true)})}), (boolean)false);
        _WLDF$INST_JPFLD_1 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"StatefulSessionManager.java", (String)"weblogic.ejb.container.manager.StatefulSessionManager", (String)"postInvoke", (String)"(Lweblogic/ejb/container/internal/InvocationWrapper;)V", (int)634, (Map)InstrumentationSupport.makeMap((String[])new String[]{"EJB_Diagnostic_Pool_Manager_Postinvoke_Before_Medium"}, (PointcutHandlingInfo[])new PointcutHandlingInfo[]{InstrumentationSupport.createPointcutHandlingInfo(null, null, (ValueHandlingInfo[])new ValueHandlingInfo[]{InstrumentationSupport.createValueHandlingInfo((String)"wrap", (String)"weblogic.diagnostics.instrumentation.gathering.EJBInvocationWrapperRenderer", (boolean)false, (boolean)true)})}), (boolean)false);
        _WLDF$INST_JPFLD_2 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"StatefulSessionManager.java", (String)"weblogic.ejb.container.manager.StatefulSessionManager", (String)"destroyInstance", (String)"(Lweblogic/ejb/container/internal/InvocationWrapper;Ljava/lang/Throwable;)V", (int)783, (Map)InstrumentationSupport.makeMap((String[])new String[]{"EJB_Diagnostic_Pool_Manager_Remove_Around_High"}, (PointcutHandlingInfo[])new PointcutHandlingInfo[]{InstrumentationSupport.createPointcutHandlingInfo(null, null, (ValueHandlingInfo[])new ValueHandlingInfo[]{InstrumentationSupport.createValueHandlingInfo((String)"wrap", (String)"weblogic.diagnostics.instrumentation.gathering.EJBInvocationWrapperRenderer", (boolean)false, (boolean)true), null})}), (boolean)false);
        _WLDF$INST_JPFLD_3 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"StatefulSessionManager.java", (String)"weblogic.ejb.container.manager.StatefulSessionManager", (String)"createBean", (String)"()Ljava/lang/Object;", (int)1178, null, (boolean)false);
        _WLDF$INST_JPFLD_4 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"StatefulSessionManager.java", (String)"weblogic.ejb.container.manager.StatefulSessionManager", (String)"remove", (String)"(Lweblogic/ejb/container/internal/InvocationWrapper;)V", (int)1269, (Map)InstrumentationSupport.makeMap((String[])new String[]{"EJB_Diagnostic_Pool_Manager_Remove_Around_High"}, (PointcutHandlingInfo[])new PointcutHandlingInfo[]{InstrumentationSupport.createPointcutHandlingInfo(null, null, (ValueHandlingInfo[])new ValueHandlingInfo[]{InstrumentationSupport.createValueHandlingInfo((String)"wrap", (String)"weblogic.diagnostics.instrumentation.gathering.EJBInvocationWrapperRenderer", (boolean)false, (boolean)true)})}), (boolean)false);
        ENABLE_PROXY_POOL = Boolean.getBoolean("weblogic.ejb30.enableproxypool");
        kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    }
}

