/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.manager;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import javax.ejb.EntityBean;
import javax.ejb.ObjectNotFoundException;
import javax.naming.Context;
import javax.transaction.Transaction;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.InternalException;
import weblogic.ejb.container.cache.CacheKey;
import weblogic.ejb.container.cache.QueryCacheElement;
import weblogic.ejb.container.cache.QueryCacheKey;
import weblogic.ejb.container.interfaces.BaseEJBLocalHomeIntf;
import weblogic.ejb.container.interfaces.BaseEJBRemoteHomeIntf;
import weblogic.ejb.container.interfaces.BeanInfo;
import weblogic.ejb.container.interfaces.EntityBeanInfo;
import weblogic.ejb.container.interfaces.QueryCache;
import weblogic.ejb.container.interfaces.ReadOnlyManager;
import weblogic.ejb.container.interfaces.WLEnterpriseBean;
import weblogic.ejb.container.interfaces.WLEntityBean;
import weblogic.ejb.container.internal.EJBComponentRuntimeMBeanImpl;
import weblogic.ejb.container.internal.EJBRuntimeUtils;
import weblogic.ejb.container.internal.InvocationWrapper;
import weblogic.ejb.container.internal.SecurityHelper;
import weblogic.ejb.container.manager.BaseEJBManager;
import weblogic.ejb.container.manager.DBManager;
import weblogic.ejb.container.persistence.spi.CMPBean;
import weblogic.ejb.container.persistence.spi.RSInfo;
import weblogic.ejb.spi.EJBCache;
import weblogic.ejb.spi.EJBCacheFactory;
import weblogic.ejb.spi.WLDeploymentException;
import weblogic.ejb20.interfaces.PrincipalNotFoundException;
import weblogic.logging.Loggable;
import weblogic.management.runtime.EntityEJBRuntimeMBean;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManager;
import weblogic.timers.TimerManagerFactory;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;

public final class TTLManager
extends DBManager
implements ReadOnlyManager {
    private EntityBeanInfo info;
    private QueryCache queryCache;
    private int readTimeoutMillis;
    private Method findByCategoryMethod;
    private Random readRand = new Random();
    private WorkManager workManager;
    private Map<String, Method> eagerRefreshMethodMap;
    private Map<EagerRefreshInfo, Long> eagerRefreshJobs;
    private EagerRefreshListener eagerRefreshListener;
    private TimerManager timerManager;
    private final Map categories = Collections.synchronizedMap(new HashMap());

    public TTLManager(EJBComponentRuntimeMBeanImpl eJBComponentRuntimeMBeanImpl) {
        super(eJBComponentRuntimeMBeanImpl);
    }

    public void setup(BaseEJBRemoteHomeIntf baseEJBRemoteHomeIntf, BaseEJBLocalHomeIntf baseEJBLocalHomeIntf, BeanInfo beanInfo, Context context, EJBCache eJBCache, QueryCache queryCache) throws WLDeploymentException {
        super.setup(baseEJBRemoteHomeIntf, baseEJBLocalHomeIntf, beanInfo, context, eJBCache);
        this.info = (EntityBeanInfo)beanInfo;
        int n = this.info.getCachingDescriptor().getReadTimeoutSeconds();
        if (this.isReadOnly()) {
            if (queryCache == null) {
                int n2 = this.info.getMaxQueriesInCache();
                this.queryCache = (QueryCache)EJBCacheFactory.createQueryCache(this.info.getEJBName(), n2);
                this.queryCache.setRuntimeMBean(((EntityEJBRuntimeMBean)this.getEJBRuntimeMBean()).getQueryCacheRuntime());
            } else {
                this.queryCache = queryCache;
            }
            if (!this.isBeanManagedPersistence && this.info.getCategoryCmpField() != null) {
                for (Method method : this.info.getGeneratedBeanClass().getMethods()) {
                    if (!method.getName().equals("ejbFindByCategory__WL_")) continue;
                    this.findByCategoryMethod = method;
                    break;
                }
                if (this.findByCategoryMethod == null) {
                    throw new AssertionError((Object)"null findByCategoryMethod");
                }
                TimerManagerFactory timerManagerFactory = TimerManagerFactory.getTimerManagerFactory();
                this.timerManager = timerManagerFactory.getDefaultTimerManager();
            }
        }
        this.updateReadTimeoutSeconds(n);
    }

    public boolean isCategoryEnabled() {
        return this.findByCategoryMethod != null;
    }

    public Object getCategoryValue(CMPBean cMPBean) {
        return cMPBean._WL__getCategoryValue();
    }

    public void registerCategoryTimer(Object object, long l) {
        if (!this.categories.containsKey(object)) {
            this.categories.put(object, l);
            if (debugLogger.isDebugEnabled()) {
                TTLManager.debug("adding " + object + " to categories with lastLoadTime: " + l);
            }
            CategoryTimerListener categoryTimerListener = new CategoryTimerListener(this, object);
            long l2 = l + (long)(0.9f * (float)this.readTimeoutMillis) - System.currentTimeMillis();
            if (debugLogger.isDebugEnabled()) {
                TTLManager.debug("scheduling timer: " + object + " delay: " + l2 + " lastLoadTime: " + l);
            }
            if (l2 < 0L) {
                l2 = 0L;
            }
            this.timerManager.schedule((TimerListener)categoryTimerListener, l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeFindByCategory(Object object) throws InternalException {
        block6: {
            InvocationWrapper invocationWrapper = EJBRuntimeUtils.createWrap();
            invocationWrapper.setIsLocal(this.info.hasLocalClientView());
            Collection collection = null;
            try {
                if (debugLogger.isDebugEnabled()) {
                    TTLManager.debug("Invoking findByCategory with categoryValue: " + object);
                }
                EJBRuntimeUtils.pushEnvironment(this.getEnvironmentContext());
                SecurityHelper.pushCallerPrincipal();
                SecurityHelper.pushRunAsSubject(SecurityHelper.getAnonymousUser());
                collection = this.collectionFinder(invocationWrapper, this.findByCategoryMethod, new Object[]{object});
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                SecurityHelper.popRunAsSubject();
                try {
                    SecurityHelper.popCallerPrincipal();
                }
                catch (PrincipalNotFoundException principalNotFoundException) {
                    TTLManager.debug("PrincipalNotFoundException is thrown when invoking findByCategory: " + (Object)((Object)principalNotFoundException));
                }
                EJBRuntimeUtils.popEnvironment();
                throw throwable;
            }
            SecurityHelper.popRunAsSubject();
            try {
                SecurityHelper.popCallerPrincipal();
                break block6;
            }
            catch (PrincipalNotFoundException principalNotFoundException) {
                TTLManager.debug("PrincipalNotFoundException is thrown when invoking findByCategory: " + (Object)((Object)principalNotFoundException));
            }
            {
            }
        }
        EJBRuntimeUtils.popEnvironment();
    }

    public QueryCache getQueryCache() {
        return this.queryCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadBean(Object object, EntityBean entityBean, RSInfo rSInfo, boolean bl) throws Throwable {
        if (debugLogger.isDebugEnabled()) {
            TTLManager.debug("loadBean called, EJB= " + this.info.getEJBName() + ", pk= " + object);
        }
        boolean bl2 = ((WLEntityBean)entityBean).__WL_isBeanStateValid();
        if (rSInfo == null) {
            if (bl || !bl2) {
                EntityBean entityBean2 = entityBean;
                synchronized (entityBean2) {
                    entityBean.ejbLoad();
                }
            }
        } else if (!bl2) {
            EntityBean entityBean3 = entityBean;
            synchronized (entityBean3) {
                CMPBean cMPBean = (CMPBean)entityBean;
                cMPBean.__WL_initialize();
                this.persistence.loadBeanFromRS(entityBean, rSInfo);
                cMPBean.__WL_superEjbLoad();
                cMPBean.__WL_setLastLoadTime(System.currentTimeMillis());
            }
        }
    }

    public boolean supportsCopy() {
        return this.isReadOnly() && !this.isBeanManagedPersistence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCopy(CMPBean cMPBean, CMPBean cMPBean2) throws InternalException {
        CMPBean cMPBean3 = cMPBean;
        synchronized (cMPBean3) {
            try {
                cMPBean2.__WL_initialize();
                cMPBean2.__WL_copyFrom(cMPBean, true);
                cMPBean2.__WL_superEjbLoad();
                cMPBean2.__WL_setLastLoadTime(cMPBean.__WL_getLastLoadTime());
            }
            catch (Throwable throwable) {
                EJBLogger.logErrorFromLoad((Throwable)throwable);
                EJBRuntimeUtils.throwInternalException("Exception in ejbLoad:", throwable);
            }
        }
    }

    public void perhapsCopy(Object object, EntityBean entityBean) throws InternalException {
        assert (this.supportsCopy());
        CMPBean cMPBean = this.getCache().getLastLoadedValidInstance(new CacheKey(object, this));
        if (cMPBean != null) {
            this.doCopy(cMPBean, (CMPBean)entityBean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadBeanFromRS(CacheKey cacheKey, EntityBean entityBean, RSInfo rSInfo) throws InternalException {
        if (this.uses20CMP) {
            EntityBean entityBean2 = entityBean;
            synchronized (entityBean2) {
                this.persistence.loadBeanFromRS(entityBean, rSInfo);
            }
        }
    }

    protected boolean shouldStore(EntityBean entityBean) throws Throwable {
        return !this.isReadOnly();
    }

    protected void initLastLoad(Object object, EntityBean entityBean) {
        long l = System.currentTimeMillis();
        ((WLEntityBean)entityBean).__WL_setLastLoadTime(l);
    }

    protected EntityBean alreadyCached(Object object, Object object2) throws InternalException {
        EntityBean entityBean = this.getCache().getIfNotTimedOut(object, new CacheKey(object2, this), false);
        if (entityBean != null && !this.isBeanManagedPersistence && ((CMPBean)entityBean).__WL_getIsRemoved()) {
            Loggable loggable = EJBLogger.lognoSuchEntityExceptionLoggable((String)object2.toString());
            EJBRuntimeUtils.throwInternalException("EJB Exception: ", (Throwable)new ObjectNotFoundException(loggable.getMessage()));
            entityBean = null;
        }
        return entityBean;
    }

    public void enrollNotTimedOutBean(Transaction transaction, CacheKey cacheKey, EntityBean entityBean) throws InternalException {
        Object object = cacheKey.getPrimaryKey();
        if (debugLogger.isDebugEnabled()) {
            TTLManager.debug("enrollNotTimedOut called, EJB= " + this.info.getEJBName() + ", pk= " + object);
        }
        if (this.isReadOnly()) {
            this.setupTxListener(object, transaction);
        } else {
            this.setupTxListenerAndTxUser(object, transaction, (WLEnterpriseBean)entityBean);
        }
    }

    public void updateReadTimeoutSeconds(int n) {
        this.readTimeoutMillis = n * 1000;
        Class clazz = this.info.getGeneratedBeanClass();
        try {
            Field field = clazz.getField("__WL_readTimeoutMS");
            field.setInt(clazz, this.readTimeoutMillis);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new AssertionError((Object)noSuchFieldException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
    }

    public void beforeCompletion(Collection collection, Object object) throws InternalException {
        if (!this.isReadOnly()) {
            super.beforeCompletion(collection, object);
        }
    }

    public Object getFromQueryCache(String string, int n, boolean bl) throws InternalException {
        Object object = EJBRuntimeUtils.getInvokeTxOrThread();
        QueryCacheKey queryCacheKey = new QueryCacheKey(string, n, this, 0);
        Object object2 = this.queryCache.get(object, queryCacheKey, bl, false);
        if (debugLogger.isDebugEnabled() && object2 == null) {
            TTLManager.debug("Cache miss: " + queryCacheKey);
        }
        return object2;
    }

    public Object getFromQueryCache(String string, Object[] objectArray, boolean bl) throws InternalException {
        Object object = EJBRuntimeUtils.getInvokeTxOrThread();
        QueryCacheKey queryCacheKey = new QueryCacheKey(string, objectArray, this, 0);
        Object object2 = this.queryCache.get(object, queryCacheKey, bl, false);
        if (debugLogger.isDebugEnabled() && object2 == null) {
            TTLManager.debug("Cache miss: " + queryCacheKey);
        }
        return object2;
    }

    public Object getFromQueryCache(String string, Object[] objectArray, boolean bl, boolean bl2) throws InternalException {
        Object object = EJBRuntimeUtils.getInvokeTxOrThread();
        return this.queryCache.get(object, new QueryCacheKey(string, objectArray, this, 1), bl, bl2);
    }

    public void putInQueryCache(QueryCacheKey queryCacheKey, Collection collection) {
        Method method;
        queryCacheKey.setTimeoutMillis(this.readTimeoutMillis);
        if (this.eagerRefreshMethodMap != null && (method = this.eagerRefreshMethodMap.get(queryCacheKey.getMethodId())) != null) {
            Object[] objectArray = queryCacheKey.getArguments();
            long l = (int)((this.readRand.nextDouble() * 0.25 + 0.75) * (double)this.readTimeoutMillis);
            this.registerEagerRefreshJob(method, objectArray, l);
        }
        boolean bl = this.queryCache.put(queryCacheKey, collection);
        if (debugLogger.isDebugEnabled()) {
            TTLManager.debug("Cache put: " + queryCacheKey + ": " + bl);
        }
    }

    public void putInQueryCache(QueryCacheKey queryCacheKey, QueryCacheElement queryCacheElement) {
        queryCacheKey.setTimeoutMillis(this.readTimeoutMillis);
        boolean bl = this.queryCache.put(queryCacheKey, queryCacheElement);
        if (debugLogger.isDebugEnabled()) {
            TTLManager.debug("Cache put: " + queryCacheKey + ": " + bl);
        }
    }

    public void invalidateLocalServer(Object object, Object object2) {
        if (this.isReadOnly()) {
            this.invalidateQueryCache(new CacheKey(object2, this));
        }
        super.invalidateLocalServer(object, object2);
    }

    public void invalidateLocalServer(Object object, Collection collection) {
        ArrayList<CacheKey> arrayList = new ArrayList<CacheKey>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            CacheKey cacheKey = new CacheKey(iterator.next(), this);
            if (this.isReadOnly()) {
                this.invalidateQueryCache(cacheKey);
            }
            arrayList.add(cacheKey);
        }
        this.getCache().invalidate(object, arrayList);
        if (this.invalidationTargetBM != null) {
            this.invalidationTargetBM.invalidateLocalServer(object, collection);
        }
    }

    public void invalidateAllLocalServer(Object object) {
        if (this.isReadOnly()) {
            this.queryCache.invalidateAll();
        }
        super.invalidateAllLocalServer(object);
    }

    public EntityBean enrollIfNotTimedOut(Object object, CacheKey cacheKey) throws InternalException {
        assert (cacheKey.getCallback() == this);
        EntityBean entityBean = this.getCache().getIfNotTimedOut(object, cacheKey, false);
        if (entityBean != null && ((CMPBean)entityBean).__WL_getIsRemoved()) {
            return null;
        }
        return entityBean;
    }

    public void selectedForReplacement(CacheKey cacheKey, EntityBean entityBean) {
        if (this.isReadOnly()) {
            this.invalidateQueryCache(cacheKey);
        }
        super.selectedForReplacement(cacheKey, entityBean);
    }

    private void invalidateQueryCache(CacheKey cacheKey) {
        this.queryCache.invalidate(cacheKey);
    }

    private static void debug(String string) {
        debugLogger.debug("[TTLManager] " + string);
    }

    private QueryCache createQueryCache(int n) {
        try {
            Class<?> clazz = Class.forName("weblogic.ejb.container.cache.QueryCache");
            Constructor<?> constructor = clazz.getConstructor(Integer.TYPE);
            return (QueryCache)constructor.newInstance(new Integer(n));
        }
        catch (Exception exception) {
            throw new weblogic.utils.AssertionError("Error creating query cache", (Throwable)exception);
        }
    }

    public Map getCategories() {
        return this.categories;
    }

    public EntityBean getBeanFromRS(Object object, Object object2, RSInfo rSInfo) throws InternalException {
        EntityBean entityBean = null;
        assert (object != null);
        CacheKey cacheKey = new CacheKey(object2, this);
        entityBean = this.getCache().get(object, cacheKey, rSInfo, true);
        this.cacheRTMBean.incrementCacheAccessCount();
        if (entityBean != null) {
            this.cacheRTMBean.incrementCacheHitCount();
            if ((this.isCategoryEnabled() || this.isEagerRefreshEnabled()) && rSInfo != null) {
                if (debugLogger.isDebugEnabled()) {
                    TTLManager.debug("persistence.loadBeanFromRS() called for " + entityBean);
                }
                ((CMPBean)entityBean).__WL_initialize();
                this.persistence.loadBeanFromRS(entityBean, rSInfo);
                ((CMPBean)entityBean).__WL_setLastLoadTime(System.currentTimeMillis());
                ((WLEntityBean)entityBean).__WL_setOperationsComplete(false);
                if (entityBean instanceof CMPBean) {
                    ((CMPBean)entityBean).__WL_setNonFKHolderRelationChange(false);
                    ((CMPBean)entityBean).__WL_setM2NInsert(false);
                }
                this.getCache().release(object, cacheKey);
            }
        } else {
            if (debugLogger.isDebugEnabled()) {
                TTLManager.debug("Didn't find the bean in entity cache");
            }
            entityBean = this.getBeanFromPool();
            ((CMPBean)entityBean).__WL_initialize();
            this.persistence.loadBeanFromRS(entityBean, rSInfo);
            if (!this.finderCacheInsert(entityBean)) {
                return null;
            }
        }
        return entityBean;
    }

    public void addEagerRefreshMethod(Method method, String string) {
        if (this.eagerRefreshMethodMap == null) {
            this.eagerRefreshMethodMap = new HashMap<String, Method>();
            this.eagerRefreshJobs = Collections.synchronizedMap(new HashMap());
            this.eagerRefreshListener = new EagerRefreshListener(this, this.eagerRefreshJobs);
            this.workManager = WorkManagerFactory.getInstance().getDefault();
            this.workManager.schedule((Runnable)this.eagerRefreshListener);
        }
        this.eagerRefreshMethodMap.put(string, method);
    }

    private boolean isEagerRefreshEnabled() {
        return this.eagerRefreshListener != null;
    }

    private void registerEagerRefreshJob(Method method, Object[] objectArray, long l) {
        EagerRefreshInfo eagerRefreshInfo = new EagerRefreshInfo(method, objectArray);
        if (!this.eagerRefreshJobs.containsKey(eagerRefreshInfo)) {
            this.eagerRefreshJobs.put(eagerRefreshInfo, System.currentTimeMillis() + l);
            if (debugLogger.isDebugEnabled()) {
                TTLManager.debug("adding " + eagerRefreshInfo + " eager refresh job with timeoutDelay: " + l);
            }
        } else if (debugLogger.isDebugEnabled()) {
            TTLManager.debug("eager refresh job " + eagerRefreshInfo + " already scheduled - skipping new job registration");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeEagerRefreshQuery(EagerRefreshInfo eagerRefreshInfo) throws InternalException {
        block6: {
            InvocationWrapper invocationWrapper = EJBRuntimeUtils.createWrap();
            invocationWrapper.setIsLocal(this.info.hasLocalClientView());
            Collection collection = null;
            try {
                if (debugLogger.isDebugEnabled()) {
                    TTLManager.debug("Invoking eagerRefreshQuery: " + eagerRefreshInfo);
                }
                EJBRuntimeUtils.pushEnvironment(this.getEnvironmentContext());
                SecurityHelper.pushCallerPrincipal();
                SecurityHelper.pushRunAsSubject(SecurityHelper.getAnonymousUser());
                collection = this.collectionFinder(invocationWrapper, eagerRefreshInfo.getMethod(), eagerRefreshInfo.getArgs());
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                SecurityHelper.popRunAsSubject();
                try {
                    SecurityHelper.popCallerPrincipal();
                }
                catch (PrincipalNotFoundException principalNotFoundException) {
                    TTLManager.debug("PrincipalNotFoundException thrown when invoking eager refresh query: " + (Object)((Object)principalNotFoundException));
                }
                EJBRuntimeUtils.popEnvironment();
                throw throwable;
            }
            SecurityHelper.popRunAsSubject();
            try {
                SecurityHelper.popCallerPrincipal();
                break block6;
            }
            catch (PrincipalNotFoundException principalNotFoundException) {
                TTLManager.debug("PrincipalNotFoundException thrown when invoking eager refresh query: " + (Object)((Object)principalNotFoundException));
            }
            {
            }
        }
        EJBRuntimeUtils.popEnvironment();
    }

    private class CategoryTimerListener
    implements TimerListener {
        final TTLManager beanManager;
        final Object categoryValue;

        public CategoryTimerListener(TTLManager tTLManager2, Object object) {
            this.beanManager = tTLManager2;
            this.categoryValue = object;
        }

        public void timerExpired(Timer timer) {
            try {
                this.beanManager.invokeFindByCategory(this.categoryValue);
                this.beanManager.getCategories().remove(this.categoryValue);
            }
            catch (InternalException internalException) {
                if (BaseEJBManager.debugLogger.isDebugEnabled()) {
                    TTLManager.debug("category finder invocation failed. later the data will be loaded from database.");
                }
                this.beanManager.getCategories().remove(this.categoryValue);
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EagerRefreshListener
    implements Runnable {
        private final TTLManager beanManager;
        private final Map<EagerRefreshInfo, Long> eagerRefreshJobs;

        private EagerRefreshListener(TTLManager tTLManager2, Map<EagerRefreshInfo, Long> map) {
            this.beanManager = tTLManager2;
            this.eagerRefreshJobs = map;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList<EagerRefreshInfo> arrayList = new ArrayList<EagerRefreshInfo>();
            while (true) {
                long l = System.currentTimeMillis();
                arrayList.clear();
                Map<EagerRefreshInfo, Long> map = this.eagerRefreshJobs;
                synchronized (map) {
                    for (EagerRefreshInfo eagerRefreshInfo : this.eagerRefreshJobs.keySet()) {
                        if (this.eagerRefreshJobs.get(eagerRefreshInfo) > l + 10000L) continue;
                        arrayList.add(eagerRefreshInfo);
                    }
                }
                for (EagerRefreshInfo eagerRefreshInfo : arrayList) {
                    try {
                        this.beanManager.invokeEagerRefreshQuery(eagerRefreshInfo);
                        this.eagerRefreshJobs.remove(eagerRefreshInfo);
                    }
                    catch (InternalException internalException) {
                        if (!BaseEJBManager.debugLogger.isDebugEnabled()) continue;
                        TTLManager.debug("eager refresh query invoke failed: " + internalException);
                    }
                }
                try {
                    Thread.sleep(10000L);
                    continue;
                }
                catch (Exception exception) {
                    if (!BaseEJBManager.debugLogger.isDebugEnabled()) continue;
                    TTLManager.debug("Thread sleep - threw exception.");
                    continue;
                }
                break;
            }
        }
    }

    private class EagerRefreshInfo {
        private final Method method;
        private final Object[] args;

        EagerRefreshInfo(Method method, Object[] objectArray) {
            this.method = method;
            this.args = objectArray;
        }

        Method getMethod() {
            return this.method;
        }

        Object[] getArgs() {
            return this.args;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.method.getName());
            stringBuffer.append('(');
            for (int i = 0; i < this.args.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.args[i]);
            }
            stringBuffer.append(')');
            return stringBuffer.toString();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            EagerRefreshInfo eagerRefreshInfo = (EagerRefreshInfo)object;
            if (!Arrays.equals(this.args, eagerRefreshInfo.args)) {
                return false;
            }
            return !(this.method != null ? !this.method.equals(eagerRefreshInfo.method) : eagerRefreshInfo.method != null);
        }

        public int hashCode() {
            int n = this.method != null ? this.method.hashCode() : 0;
            n = 31 * n + (this.args != null ? Arrays.hashCode(this.args) : 0);
            return n;
        }
    }
}

