/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.monitoring;

import java.security.AccessController;
import java.util.HashSet;
import java.util.Set;
import weblogic.management.ManagementException;
import weblogic.management.provider.DomainAccess;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.ApplicationRuntimeMBean;
import weblogic.management.runtime.ComponentRuntimeMBean;
import weblogic.management.runtime.DomainRuntimeMBeanDelegate;
import weblogic.management.runtime.MessageDrivenControlEJBRuntimeMBean;
import weblogic.management.runtime.MessageDrivenEJBRuntimeMBean;
import weblogic.management.runtime.ServerRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.Debug;

public final class MessageDrivenControlEJBRuntimeMBeanImpl
extends DomainRuntimeMBeanDelegate
implements MessageDrivenControlEJBRuntimeMBean {
    boolean verbose = false;
    boolean debug = false;
    long CACHING_STUB_SVUID = 8673161367344012623L;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public MessageDrivenControlEJBRuntimeMBeanImpl() throws ManagementException {
        super("MessageDrivenControlEJBRuntime");
    }

    public boolean suspendMDBs(String string, String string2) {
        boolean bl = true;
        DomainAccess domainAccess = ManagementService.getDomainAccess(kernelId);
        ServerRuntimeMBean[] serverRuntimeMBeanArray = domainAccess.getDomainRuntimeService().getServerRuntimes();
        for (int i = 0; i < serverRuntimeMBeanArray.length; ++i) {
            ServerRuntimeMBean serverRuntimeMBean = serverRuntimeMBeanArray[i];
            Set set = this.getAllMessageDrivenEJBRuntimeMBeans(serverRuntimeMBean);
            for (MessageDrivenEJBRuntimeMBean messageDrivenEJBRuntimeMBean : set) {
                if (!string.equals(messageDrivenEJBRuntimeMBean.getEJBName()) || !string2.equals(messageDrivenEJBRuntimeMBean.getApplicationName())) continue;
                try {
                    bl &= messageDrivenEJBRuntimeMBean.suspend();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (!this.verbose) continue;
                Debug.say((String)("suspendMDBs ejbName=" + messageDrivenEJBRuntimeMBean.getEJBName() + "; MDBStatus=" + messageDrivenEJBRuntimeMBean.getMDBStatus()));
            }
        }
        return bl;
    }

    public boolean resumeMDBs(String string, String string2) {
        boolean bl = true;
        DomainAccess domainAccess = ManagementService.getDomainAccess(kernelId);
        ServerRuntimeMBean[] serverRuntimeMBeanArray = domainAccess.getDomainRuntimeService().getServerRuntimes();
        for (int i = 0; i < serverRuntimeMBeanArray.length; ++i) {
            ServerRuntimeMBean serverRuntimeMBean = serverRuntimeMBeanArray[i];
            Set set = this.getAllMessageDrivenEJBRuntimeMBeans(serverRuntimeMBean);
            for (MessageDrivenEJBRuntimeMBean messageDrivenEJBRuntimeMBean : set) {
                if (!string.equals(messageDrivenEJBRuntimeMBean.getEJBName()) || !string2.equals(messageDrivenEJBRuntimeMBean.getApplicationName())) continue;
                try {
                    bl &= messageDrivenEJBRuntimeMBean.resume();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (!this.verbose) continue;
                Debug.say((String)("resumeMDBs ejbName=" + messageDrivenEJBRuntimeMBean.getEJBName() + "; MDBStatus=" + messageDrivenEJBRuntimeMBean.getMDBStatus()));
            }
        }
        return bl;
    }

    public boolean printMDBStatus(String string, String string2) {
        boolean bl = true;
        DomainAccess domainAccess = ManagementService.getDomainAccess(kernelId);
        ServerRuntimeMBean[] serverRuntimeMBeanArray = domainAccess.getDomainRuntimeService().getServerRuntimes();
        for (int i = 0; i < serverRuntimeMBeanArray.length; ++i) {
            ServerRuntimeMBean serverRuntimeMBean = serverRuntimeMBeanArray[i];
            Set set = this.getAllMessageDrivenEJBRuntimeMBeans(serverRuntimeMBean);
            for (MessageDrivenEJBRuntimeMBean messageDrivenEJBRuntimeMBean : set) {
                if (string.equals(messageDrivenEJBRuntimeMBean.getEJBName()) && string2.equals(messageDrivenEJBRuntimeMBean.getApplicationName()) && this.verbose) {
                    Debug.say((String)("printMDBStatus ejbName=" + messageDrivenEJBRuntimeMBean.getEJBName() + "; MDBStatus=" + messageDrivenEJBRuntimeMBean.getMDBStatus()));
                }
                if (!this.debug) continue;
                Debug.say((String)("printMDBStatus ejbName=" + messageDrivenEJBRuntimeMBean.getEJBName() + "; MDBStatus=" + messageDrivenEJBRuntimeMBean.getMDBStatus()));
            }
        }
        return bl;
    }

    private Set getAllMessageDrivenEJBRuntimeMBeans(ServerRuntimeMBean serverRuntimeMBean) {
        HashSet<MessageDrivenEJBRuntimeMBean> hashSet = new HashSet<MessageDrivenEJBRuntimeMBean>(5);
        ApplicationRuntimeMBean[] applicationRuntimeMBeanArray = serverRuntimeMBean.getApplicationRuntimes();
        if (applicationRuntimeMBeanArray != null && applicationRuntimeMBeanArray.length > 0) {
            for (int i = 0; i < applicationRuntimeMBeanArray.length; ++i) {
                ApplicationRuntimeMBean applicationRuntimeMBean = applicationRuntimeMBeanArray[i];
                ComponentRuntimeMBean[] componentRuntimeMBeanArray = applicationRuntimeMBean.getComponentRuntimes();
                if (componentRuntimeMBeanArray == null || componentRuntimeMBeanArray.length <= 0) continue;
                for (int j = 0; j < componentRuntimeMBeanArray.length; ++j) {
                    ComponentRuntimeMBean componentRuntimeMBean = componentRuntimeMBeanArray[j];
                    if (!(componentRuntimeMBean instanceof MessageDrivenEJBRuntimeMBean)) continue;
                    MessageDrivenEJBRuntimeMBean messageDrivenEJBRuntimeMBean = (MessageDrivenEJBRuntimeMBean)((Object)componentRuntimeMBean);
                    hashSet.add(messageDrivenEJBRuntimeMBean);
                }
            }
        }
        return hashSet;
    }
}

