/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.monitoring;

import java.util.concurrent.atomic.AtomicInteger;
import weblogic.ejb.container.interfaces.TimerManager;
import weblogic.ejb.container.internal.MDConnectionManager;
import weblogic.ejb.container.monitoring.EJBPoolRuntimeMBeanImpl;
import weblogic.ejb.container.monitoring.EJBRuntimeMBeanImpl;
import weblogic.ejb.container.monitoring.EJBTimerRuntimeMBeanImpl;
import weblogic.health.HealthMonitorService;
import weblogic.health.HealthState;
import weblogic.management.ManagementException;
import weblogic.management.runtime.ApplicationRuntimeMBean;
import weblogic.management.runtime.EJBComponentRuntimeMBean;
import weblogic.management.runtime.EJBPoolRuntimeMBean;
import weblogic.management.runtime.EJBTimerRuntimeMBean;
import weblogic.management.runtime.MessageDrivenEJBRuntimeMBean;

public final class MessageDrivenEJBRuntimeMBeanImpl
extends EJBRuntimeMBeanImpl
implements MessageDrivenEJBRuntimeMBean {
    private EJBPoolRuntimeMBean poolRtMBean;
    private EJBTimerRuntimeMBean timerRtMBean;
    private boolean isJMSConnectionAlive;
    private String connectionStatus;
    private String destination;
    private String jmsClientID;
    private String mdbStatus;
    private AtomicInteger suspendCount;
    private Throwable lastException;
    private MDConnectionManager mdConnManager;
    private String applicationName;

    public MessageDrivenEJBRuntimeMBeanImpl(String string, String string2, EJBComponentRuntimeMBean eJBComponentRuntimeMBean, String string3, TimerManager timerManager) throws ManagementException {
        super(string, string2, eJBComponentRuntimeMBean);
        this.poolRtMBean = new EJBPoolRuntimeMBeanImpl(string, this);
        if (timerManager != null) {
            this.timerRtMBean = new EJBTimerRuntimeMBeanImpl(string, this, timerManager);
        }
        this.isJMSConnectionAlive = false;
        this.connectionStatus = "disconnected";
        this.destination = string3;
        this.jmsClientID = "";
        this.mdbStatus = "initializing";
        this.suspendCount = new AtomicInteger(0);
        ApplicationRuntimeMBean applicationRuntimeMBean = (ApplicationRuntimeMBean)eJBComponentRuntimeMBean.getParent();
        this.applicationName = applicationRuntimeMBean.getApplicationName();
        HealthMonitorService.register("MDB" + this.applicationName, this, false);
    }

    public void unregister() throws ManagementException {
        super.unregister();
        HealthMonitorService.unregister("MDB" + this.applicationName);
    }

    public HealthState getHealthState() {
        String string;
        int n;
        if (this.isJMSConnectionAlive()) {
            n = 0;
            string = "MDB application " + this.applicationName + " is connected to messaging system.";
        } else {
            n = 1;
            string = "MDB application " + this.applicationName + " is NOT connected to messaging system.";
        }
        return new HealthState(n, string);
    }

    public EJBPoolRuntimeMBean getPoolRuntime() {
        return this.poolRtMBean;
    }

    public EJBTimerRuntimeMBean getTimerRuntime() {
        return this.timerRtMBean;
    }

    public boolean isJMSConnectionAlive() {
        return this.isJMSConnectionAlive;
    }

    public void setJMSConnectionAlive(boolean bl) {
        this.isJMSConnectionAlive = bl;
    }

    public String getConnectionStatus() {
        return this.connectionStatus;
    }

    public void setConnectionStatus(String string) {
        this.connectionStatus = string;
    }

    public String getJmsClientID() {
        return this.jmsClientID;
    }

    public void setJmsClientID(String string) {
        this.jmsClientID = string;
    }

    public String getDestination() {
        return this.destination;
    }

    public String getMDBStatus() {
        return this.mdbStatus;
    }

    public void setMDBStatus(String string) {
        this.mdbStatus = string;
    }

    public long getProcessedMessageCount() {
        return this.getPoolRuntime().getAccessTotalCount();
    }

    public int getSuspendCount() {
        return this.suspendCount.get();
    }

    public void incrementSuspendCount() {
        this.suspendCount.incrementAndGet();
    }

    public Throwable getLastException() {
        return this.lastException;
    }

    public String getLastExceptionAsString() {
        if (this.lastException != null) {
            return this.lastException.toString();
        }
        return "";
    }

    public void setLastException(Throwable throwable) {
        this.lastException = throwable;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setMDConnManager(MDConnectionManager mDConnectionManager) {
        this.mdConnManager = mDConnectionManager;
    }

    public boolean suspend() throws ManagementException {
        if (this.mdConnManager == null) {
            throw new ManagementException("the destination is not available");
        }
        return this.mdConnManager.suspend(true);
    }

    public boolean resume() throws ManagementException {
        if (this.mdConnManager == null) {
            throw new ManagementException("the destination is not available");
        }
        return this.mdConnManager.resume(true);
    }
}

