/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.persistence;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.naming.Name;
import weblogic.ejb.container.cmp.rdbms.RDBMSUtils;
import weblogic.ejb.container.deployer.DeploymentDescriptorException;
import weblogic.ejb.container.interfaces.CMPInfo;
import weblogic.ejb.container.interfaces.EntityBeanInfo;
import weblogic.ejb.container.persistence.PersistenceUtils;
import weblogic.ejb.container.persistence.spi.CMPBeanDescriptor;
import weblogic.ejb.container.utils.ClassUtils;
import weblogic.ejb.spi.EjbDescriptorBean;
import weblogic.ejb20.dd.DescriptorErrorInfo;
import weblogic.j2ee.validation.IDescriptorErrorInfo;
import weblogic.utils.Debug;

public class CMPBeanDescriptorImpl
implements CMPBeanDescriptor {
    private static final boolean debug = System.getProperty("weblogic.ejb.container.persistence.debug") != null;
    private static final boolean verbose = System.getProperty("weblogic.ejb.container.persistence.verbose") != null;
    private Class beanClass;
    private Class homeClass;
    private Class remoteClass;
    private Class localHomeClass;
    private Class localClass;
    private String homeInterfaceName;
    private String remoteInterfaceName;
    private String localHomeInterfaceName;
    private String localInterfaceName;
    private String abstractSchemaName;
    private String javaClassName;
    private final Name jndiName;
    private final Name localJndiName;
    private final String ejbName;
    private final boolean cacheBetweenTransactions;
    private final boolean boxCarUpdates;
    private final Set containerFieldSet;
    private final String primaryKeyFieldName;
    private Class primaryKeyClass = null;
    private boolean hasComplexPrimaryKey = false;
    private final boolean isReentrant;
    private final String isModifiedMethodName;
    private final boolean findersLoadBean;
    private final Collection allQueries;
    private String genBeanClassName;
    private String genBeanInterfaceName;
    private int concurrencyStrategy;
    private boolean isDynamicQueriesEnabled;
    private EjbDescriptorBean desc = null;
    private List primaryKeyFieldList = null;
    private Set primaryKeyFieldNameSet = null;
    private Hashtable CMFieldTable;
    private String primaryKeyClassName = null;
    private boolean hasLocalClientView = false;
    private boolean hasRemoteClientView = false;
    private EntityBeanInfo ebi = null;

    public CMPBeanDescriptorImpl(EntityBeanInfo entityBeanInfo, EjbDescriptorBean ejbDescriptorBean) throws DeploymentDescriptorException {
        Field[] fieldArray;
        this.ebi = entityBeanInfo;
        this.desc = ejbDescriptorBean;
        if (entityBeanInfo.hasLocalClientView()) {
            this.localHomeInterfaceName = entityBeanInfo.getLocalHomeInterfaceName();
            this.localInterfaceName = entityBeanInfo.getLocalInterfaceName();
        }
        if (entityBeanInfo.hasRemoteClientView()) {
            this.homeInterfaceName = entityBeanInfo.getHomeInterfaceName();
            this.remoteInterfaceName = entityBeanInfo.getRemoteInterfaceName();
        }
        if (this.isEJB30()) {
            this.javaClassName = entityBeanInfo.getBeanClassName();
        }
        this.hasLocalClientView = entityBeanInfo.hasLocalClientView();
        this.hasRemoteClientView = entityBeanInfo.hasRemoteClientView();
        this.beanClass = entityBeanInfo.getBeanClass();
        if (debug) {
            Debug.assertion((this.beanClass != null ? 1 : 0) != 0);
        }
        this.jndiName = entityBeanInfo.getJNDIName();
        this.localJndiName = entityBeanInfo.getLocalJNDIName();
        this.ejbName = entityBeanInfo.getEJBName();
        CMPInfo cMPInfo = entityBeanInfo.getCMPInfo();
        this.genBeanClassName = cMPInfo.getGeneratedBeanClassName();
        this.genBeanInterfaceName = entityBeanInfo.getGeneratedBeanInterfaceName();
        this.concurrencyStrategy = entityBeanInfo.getConcurrencyStrategy();
        this.containerFieldSet = new HashSet();
        this.CMFieldTable = new Hashtable();
        Collection collection = cMPInfo.getAllContainerManagedFieldNames();
        for (Object object : collection) {
            this.containerFieldSet.add(object);
            if (entityBeanInfo.getCMPInfo().uses20CMP()) {
                Method method = PersistenceUtils.getMethodIncludeSuper(this.beanClass, RDBMSUtils.getterMethodName((String)object), null);
                if (method == null) {
                    throw new DeploymentDescriptorException("For cmp-field '" + (String)object + "' of bean '" + this.ejbName + "', we expected to find a corresponding '" + RDBMSUtils.getterMethodName((String)object) + "' method in the abstract bean class.  " + "Compilation cannot continue without this 'get' method", (IDescriptorErrorInfo)new DescriptorErrorInfo("<cmp-field>", (Object)this.ejbName, object));
                }
                fieldArray = method.getReturnType();
            } else {
                try {
                    fieldArray = this.beanClass.getField((String)object).getType();
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    throw new DeploymentDescriptorException("Unable to find public field '" + (String)object + "' on bean class: " + this.beanClass.getName(), (IDescriptorErrorInfo)new DescriptorErrorInfo("<cmp-field>", (Object)this.ejbName, object));
                }
            }
            this.CMFieldTable.put(object, fieldArray);
        }
        this.primaryKeyClassName = entityBeanInfo.getPrimaryKeyClassName();
        this.primaryKeyClass = entityBeanInfo.getPrimaryKeyClass();
        this.primaryKeyFieldList = new LinkedList();
        this.primaryKeyFieldNameSet = new TreeSet();
        this.primaryKeyFieldName = cMPInfo.getCMPrimaryKeyFieldName();
        if (this.primaryKeyFieldName == null && !entityBeanInfo.isUnknownPrimaryKey()) {
            Object object;
            object = null;
            if (this.primaryKeyClassName != null) {
                this.hasComplexPrimaryKey = true;
                object = this.primaryKeyClass;
                if (debug) {
                    Debug.assertion((object != null ? 1 : 0) != 0, (String)("Could not find PK class. " + this.primaryKeyClassName));
                }
                if (object != null) {
                    fieldArray = ((Class)object).getFields();
                    for (int i = 0; i < fieldArray.length; ++i) {
                        Class<?> clazz;
                        Field field = fieldArray[i];
                        if (field.getName().equals("serialVersionUID") || (clazz = field.getDeclaringClass()).equals(Object.class)) continue;
                        this.primaryKeyFieldList.add(field);
                        this.primaryKeyFieldNameSet.add(field.getName());
                    }
                }
            }
        } else {
            this.hasComplexPrimaryKey = false;
            if (this.primaryKeyFieldName != null) {
                this.primaryKeyFieldNameSet.add(this.primaryKeyFieldName);
            }
        }
        this.cacheBetweenTransactions = entityBeanInfo.getCacheBetweenTransactions();
        this.boxCarUpdates = entityBeanInfo.getBoxCarUpdates();
        this.isReentrant = entityBeanInfo.isReentrant();
        this.isModifiedMethodName = entityBeanInfo.getIsModifiedMethodName();
        this.findersLoadBean = cMPInfo.findersLoadBean();
        this.abstractSchemaName = cMPInfo.getAbstractSchemaName();
        this.allQueries = entityBeanInfo.getAllQueries();
        this.isDynamicQueriesEnabled = entityBeanInfo.isDynamicQueriesEnabled();
    }

    public Method getGetterMethod(Class clazz, String string) {
        Method method = null;
        if (this.ebi.getCMPInfo().uses20CMP()) {
            method = PersistenceUtils.getMethodIncludeSuper(clazz, RDBMSUtils.getterMethodName(string), null);
        }
        return method;
    }

    public Method getSetterMethod(Class clazz, String string) {
        Method method = null;
        if (this.ebi.getCMPInfo().uses20CMP()) {
            method = PersistenceUtils.getMethodIncludeSuper(clazz, RDBMSUtils.setterMethodName(string), new Class[]{this.getFieldClass(string)});
        }
        return method;
    }

    public String getAbstractSchemaName() {
        return this.abstractSchemaName;
    }

    public String getEJBName() {
        return this.ejbName;
    }

    public boolean hasLocalClientView() {
        return this.hasLocalClientView;
    }

    public boolean hasRemoteClientView() {
        return this.hasRemoteClientView;
    }

    public boolean isEJB30() {
        return false;
    }

    public Class getLocalHomeClass() {
        if (this.localHomeClass == null) {
            this.localHomeClass = this.ebi.getLocalHomeClass();
        }
        return this.localHomeClass;
    }

    public String getLocalHomeInterfaceName() {
        return this.localHomeInterfaceName;
    }

    public Class getLocalHomeInterfaceClass() {
        return this.ebi.getLocalHomeInterfaceClass();
    }

    public Class getHomeClass() {
        if (this.homeClass == null) {
            this.homeClass = this.ebi.getHomeClass();
        }
        return this.homeClass;
    }

    public String getHomeInterfaceName() {
        return this.homeInterfaceName;
    }

    public Class getHomeInterfaceClass() {
        return this.ebi.getHomeInterfaceClass();
    }

    public Class getLocalClass() {
        if (this.localClass == null) {
            this.localClass = this.ebi.getLocalClass();
        }
        return this.localClass;
    }

    public String getLocalInterfaceName() {
        return this.localInterfaceName;
    }

    public Class getLocalInterfaceClass() {
        return this.ebi.getLocalInterfaceClass();
    }

    public Class getRemoteClass() {
        if (this.remoteClass == null) {
            this.remoteClass = this.ebi.getRemoteClass();
        }
        return this.remoteClass;
    }

    public String getRemoteInterfaceName() {
        return this.remoteInterfaceName;
    }

    public Class getRemoteInterfaceClass() {
        return this.ebi.getRemoteInterfaceClass();
    }

    public Class getJavaClass() {
        return this.beanClass;
    }

    public String getJavaClassName() {
        return this.javaClassName;
    }

    public Class getBeanClass() {
        return this.beanClass;
    }

    public String getGeneratedBeanClassName() {
        return this.genBeanClassName;
    }

    public String getGeneratedBeanInterfaceName() {
        return this.genBeanInterfaceName;
    }

    public Name getJNDIName() {
        return this.jndiName;
    }

    public Name getLocalJNDIName() {
        return this.localJndiName;
    }

    public boolean getCacheBetweenTransactions() {
        return this.cacheBetweenTransactions;
    }

    public boolean getBoxCarUpdates() {
        return this.boxCarUpdates;
    }

    public int getTransactionTimeoutMS() {
        return this.ebi.getTransactionTimeoutMS();
    }

    public boolean isReadOnly() {
        return this.ebi.isReadOnly();
    }

    public boolean isOptimistic() {
        return this.ebi.isOptimistic();
    }

    public boolean hasComplexPrimaryKey() {
        return this.hasComplexPrimaryKey;
    }

    public Class getPrimaryKeyClass() {
        return this.primaryKeyClass;
    }

    public String getPrimaryKeyClassName() {
        return this.primaryKeyClassName;
    }

    public Set getPrimaryKeyFieldNames() {
        return this.primaryKeyFieldNameSet;
    }

    public void setPrimaryKeyField(String string) {
        assert (this.primaryKeyFieldNameSet.isEmpty());
        this.primaryKeyFieldNameSet.add(string);
        if (this.containerFieldSet.contains(string)) {
            this.primaryKeyClass = this.getFieldClass(string);
        } else {
            this.primaryKeyClass = Long.class;
            this.containerFieldSet.add(string);
            this.CMFieldTable.put(string, this.primaryKeyClass);
        }
        this.primaryKeyClassName = ClassUtils.getCanonicalName(this.primaryKeyClass);
    }

    public Set getCMFieldNames() {
        return this.containerFieldSet;
    }

    public Class getFieldClass(String string) {
        return (Class)this.CMFieldTable.get(string);
    }

    public ClassLoader getClassLoader() {
        return this.ebi.getClassLoader();
    }

    public boolean getIsReentrant() {
        return this.isReentrant;
    }

    public String getIsModifiedMethodName() {
        return this.isModifiedMethodName;
    }

    public boolean getFindersLoadBean() {
        return this.findersLoadBean;
    }

    public Collection getAllQueries() {
        return this.allQueries;
    }

    public int getConcurrencyStrategy() {
        return this.concurrencyStrategy;
    }

    public EjbDescriptorBean getEjbDescriptorBean() {
        return this.desc;
    }

    public void beanImplClassChangeNotification() {
        this.beanClass = this.ebi.getBeanClass();
    }

    public boolean getIsDynamicQueriesEnabled() {
        return this.isDynamicQueriesEnabled;
    }

    public boolean isBeanClassAbstract() {
        int n = this.beanClass.getModifiers();
        return Modifier.isAbstract(n);
    }

    public int getMaxQueriesInCache() {
        return this.ebi.getMaxQueriesInCache();
    }

    public void dump() {
        String string = " -------  CMPBeanDescriptorImpl: ";
        Debug.say((String)(string + "HomeClass: " + this.getHomeClass()));
        Debug.say((String)(string + "HomeInterfaceName: " + this.getHomeInterfaceName()));
        Debug.say((String)(string + "LocalHomeClass: " + this.getLocalHomeClass()));
        Debug.say((String)(string + "LocalHomeInterfaceName: " + this.getLocalHomeInterfaceName()));
        Debug.say((String)(string + "BeanClass: " + this.getBeanClass()));
        Debug.say((String)(string + "RemoteClass: " + this.getRemoteClass()));
        Debug.say((String)(string + "RemoteInterfaceName: " + this.getRemoteInterfaceName()));
        Debug.say((String)(string + "LocalClass: " + this.getLocalClass()));
        Debug.say((String)(string + "LocalInterfaceName: " + this.getLocalInterfaceName()));
        Debug.say((String)(string + "JNDIName: " + this.getJNDIName()));
        Debug.say((String)(string + "LocalJNDIName: " + this.getLocalJNDIName()));
        Debug.say((String)(string + "CacheBetweenTransactions: " + this.getCacheBetweenTransactions()));
        Debug.say((String)(string + "BoxCarUpdates: " + this.getBoxCarUpdates()));
        Debug.say((String)(string + "ComplexPrimaryKey: " + this.hasComplexPrimaryKey()));
        Debug.say((String)(string + "PrimaryKeyClass: " + this.getPrimaryKeyClass()));
        Debug.say((String)(string + "PrimaryKeyFieldNames: " + this.getPrimaryKeyFieldNames()));
        Debug.say((String)(string + "CMFieldNames: " + this.getCMFieldNames()));
        Debug.say((String)(string + "IsReentrant: " + this.getIsReentrant()));
        Debug.say((String)(string + "IsModifiedMethodName: " + this.getIsModifiedMethodName()));
        Debug.say((String)(string + "FindersLoadBean: " + this.getFindersLoadBean()));
        Debug.say((String)(string + "IsDynamicQueriesEnabled: " + this.getIsDynamicQueriesEnabled()));
    }
}

