/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.persistence;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import weblogic.Home;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.persistence.PersistenceException;
import weblogic.ejb.container.persistence.PersistenceType;
import weblogic.ejb.container.persistence.PersistenceUtils;
import weblogic.ejb.container.persistence.PersistenceVendorProcessor;
import weblogic.logging.Loggable;
import weblogic.utils.AssertionError;
import weblogic.utils.Debug;
import weblogic.utils.StackTraceUtils;
import weblogic.xml.process.ProcessorFactory;
import weblogic.xml.process.ProcessorFactoryException;
import weblogic.xml.process.XMLParsingException;
import weblogic.xml.process.XMLProcessingException;

public class InstalledPersistence {
    private static final boolean debug = System.getProperty("weblogic.ejb.container.persistence.debug") != null;
    private static final boolean verbose = System.getProperty("weblogic.ejb.container.persistence.verbose") != null;
    private static String PERSISTENCE_INSTALL_FILE = "persistence.install";
    private String installationLocation = null;
    private Set installedTypes = null;
    private boolean initialized = false;

    public synchronized Set getInstalledTypes() throws PersistenceException {
        if (!this.initialized) {
            this.initialize();
        }
        return this.installedTypes;
    }

    public synchronized PersistenceType getInstalledType(String string, String string2) throws PersistenceException {
        if (!this.initialized) {
            this.initialize();
        }
        for (PersistenceType persistenceType : this.installedTypes) {
            if (!persistenceType.getIdentifier().equals(string) || !persistenceType.getVersion().equals(string2)) continue;
            return persistenceType;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void initialize() throws PersistenceException {
        Object object;
        block37: {
            this.setInstallationLocation();
            File file = new File(this.installationLocation, PERSISTENCE_INSTALL_FILE);
            if (!file.exists()) {
                Loggable loggable = EJBLogger.logInstalledPersistFileNotExistLoggable((String)file.getAbsolutePath());
                throw new PersistenceException(loggable.getMessage());
            }
            if (!file.canRead()) {
                Loggable loggable = EJBLogger.logInstalledPersistFileNotReadableLoggable((String)file.getAbsolutePath());
                throw new PersistenceException(loggable.getMessage());
            }
            BufferedReader bufferedReader = null;
            try {
                try {
                    bufferedReader = new BufferedReader(new FileReader(file));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Loggable loggable = EJBLogger.logInstalledPersistFileCouldNotOpenLoggable((String)file.getAbsolutePath());
                    throw new PersistenceException(loggable.getMessage());
                }
                try {
                    Object object2;
                    if (verbose) {
                        if (!bufferedReader.ready()) {
                            Debug.say((String)("Found no CMP descriptors in '" + file.getAbsolutePath() + "'."));
                        } else {
                            Debug.say((String)("Loading CMP Installation from '" + file + "'."));
                        }
                    }
                    object = new HashSet<Object>();
                    while (bufferedReader.ready()) {
                        object2 = bufferedReader.readLine();
                        if (verbose) {
                            Debug.say((String)("found resource name: " + (String)object2));
                        }
                        if (object2 == null || ((String)object2).trim().equals("")) continue;
                        object.add(object2);
                    }
                    object.add(PersistenceUtils.RDBMS_CMP_RESOURCE_NAME);
                    this.installedTypes = new HashSet();
                    object2 = new ProcessorFactory();
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        IOException iOException2;
                        Object var12_20;
                        Object object3;
                        String string = (String)iterator.next();
                        InputStream inputStream = null;
                        inputStream = this.getClass().getResourceAsStream(string);
                        if (inputStream == null) {
                            inputStream = this.getClass().getResourceAsStream('/' + string);
                        }
                        if (verbose) {
                            if (inputStream == null) {
                                Debug.say((String)("xmlStream for resource '" + string + "' is null."));
                            } else {
                                Debug.say((String)("xmlStream for resource '" + string + "' is not null."));
                            }
                        }
                        if (inputStream == null) {
                            object3 = EJBLogger.logInstalledPersistErrorLoadingResourceLoggable((String)string);
                            throw new PersistenceException(object3.getMessage());
                        }
                        object3 = null;
                        try {
                            try {
                                object3 = new BufferedInputStream(inputStream);
                                PersistenceVendorProcessor persistenceVendorProcessor = (PersistenceVendorProcessor)((Object)((ProcessorFactory)object2).getProcessor((InputStream)object3, true, PersistenceUtils.validPersistencePublicIds));
                                if (persistenceVendorProcessor == null) {
                                    Loggable loggable = EJBLogger.logInstalledPersistNoXMLProcessorLoggable((String)string);
                                    throw new PersistenceException(loggable.getMessage());
                                }
                                persistenceVendorProcessor.process((InputStream)object3);
                                this.installedTypes.addAll(persistenceVendorProcessor.getInstalledTypes());
                                var12_20 = null;
                            }
                            catch (XMLParsingException xMLParsingException) {
                                throw new PersistenceException(xMLParsingException.getMessage() + ": " + StackTraceUtils.throwable2StackTrace((Throwable)((Object)xMLParsingException)));
                            }
                            catch (XMLProcessingException xMLProcessingException) {
                                throw new PersistenceException(xMLProcessingException.getMessage());
                            }
                            catch (ProcessorFactoryException processorFactoryException) {
                                Loggable loggable = EJBLogger.logInstalledPersistNoXMLProcessorLoggable((String)string);
                                throw new PersistenceException(loggable.getMessage());
                            }
                        }
                        catch (Throwable throwable) {
                            var12_20 = null;
                            try {
                                ((BufferedInputStream)object3).close();
                                throw throwable;
                            }
                            catch (IOException iOException2) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                        try {}
                        catch (IOException iOException2) {}
                        ((BufferedInputStream)object3).close();
                    }
                }
                catch (IOException iOException) {
                    throw new PersistenceException(StackTraceUtils.throwable2StackTrace((Throwable)iOException));
                }
                catch (PersistenceException persistenceException) {
                    throw persistenceException;
                }
                catch (Exception exception) {
                    throw new AssertionError("Error while reading CMP Installation file '" + file.getAbsolutePath() + "': " + StackTraceUtils.throwable2StackTrace((Throwable)exception));
                }
                Object var15_25 = null;
                if (bufferedReader == null) break block37;
            }
            catch (Throwable throwable) {
                Object var15_26 = null;
                if (bufferedReader == null) throw throwable;
                try {
                    bufferedReader.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            bufferedReader.close();
        }
        if (verbose) {
            Debug.say((String)"Installed persistence types:");
            object = this.installedTypes.iterator();
            while (object.hasNext()) {
                Debug.say((String)object.next().toString());
            }
        }
        this.initialized = true;
    }

    private synchronized void setInstallationLocation() {
        String string;
        String string2 = Home.getPath();
        if (null == string2) {
            if (verbose) {
                Debug.say((String)"weblogic.Home not found. There must be a problem with the classpath. Unable to find any Persistence Types.");
            }
            throw new AssertionError("weblogic.home not found.  There must be a problem with the classpath.");
        }
        this.installationLocation = string2 + File.separator + "lib" + File.separator + "persistence";
        File file = new File(this.installationLocation);
        if (!file.exists() && (file = new File(string = string2 + File.separator + "server" + File.separator + "lib" + File.separator + "persistence")).exists()) {
            this.installationLocation = string;
        }
        if (verbose) {
            Debug.say((String)("Set installation location to " + this.installationLocation));
        }
    }

    public static void main(String[] stringArray) {
        InstalledPersistence installedPersistence = new InstalledPersistence();
        System.out.println("Thank you for invoking this tool. It initialized successfully.");
        try {
            for (PersistenceType persistenceType : installedPersistence.getInstalledTypes()) {
                System.out.println("\n---------------------------------------------");
                System.out.println("Found PersistenceType:");
                System.out.println("" + persistenceType);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

