/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.persistence;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.SAXParseException;
import weblogic.deployment.descriptors.IllegalValueException;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.cmp.rdbms.Deployer;
import weblogic.ejb.container.cmp.rdbms.EJBQLParsingException;
import weblogic.ejb.container.deployer.NamingConvention;
import weblogic.ejb.container.interfaces.BeanManager;
import weblogic.ejb.container.interfaces.CMPInfo;
import weblogic.ejb.container.interfaces.EntityBeanInfo;
import weblogic.ejb.container.persistence.PersistenceVendor;
import weblogic.ejb.container.persistence.spi.CMPBeanDescriptor;
import weblogic.ejb.container.persistence.spi.CMPCodeGenerator;
import weblogic.ejb.container.persistence.spi.CMPDeployer;
import weblogic.ejb.container.persistence.spi.JarDeployment;
import weblogic.ejb.container.persistence.spi.PersistenceManager;
import weblogic.ejb.spi.WLDeploymentException;
import weblogic.logging.Loggable;
import weblogic.utils.AssertionError;
import weblogic.utils.Debug;
import weblogic.utils.Getopt2;
import weblogic.utils.StackTraceUtils;
import weblogic.utils.jars.VirtualJarFactory;
import weblogic.utils.jars.VirtualJarFile;
import weblogic.xml.process.XMLParsingException;

public final class PersistenceType {
    private static final boolean debug = System.getProperty("weblogic.ejb.container.persistence.debug") != null;
    private static final boolean verbose = System.getProperty("weblogic.ejb.container.persistence.verbose") != null;
    private VirtualJarFile sourceJarFile;
    private PersistenceVendor vendor = null;
    private String typeIdentifier = null;
    private String typeVersion = null;
    private String weblogicVersion = null;
    private String cmpVersion = null;
    private String cmpDeployerClassName = null;
    private String persistenceManagerClassName = null;
    private String exclusiveManagerClassName = null;
    private String databaseManagerClassName = null;
    private String readonlyManagerClassName = null;
    private String jarDeploymentClassName = null;
    private String codeGeneratorClassName = null;
    private JarDeployment jarDeployment = null;
    private Class codeGeneratorClass;
    private Constructor codeGeneratorConstructor;
    private Getopt2 options;

    public PersistenceVendor getVendor() {
        return this.vendor;
    }

    public void setVendor(PersistenceVendor persistenceVendor) {
        if (debug) {
            Debug.assertion((null != persistenceVendor ? 1 : 0) != 0);
        }
        this.vendor = persistenceVendor;
    }

    public String getIdentifier() {
        return this.typeIdentifier;
    }

    public void setIdentifier(String string) {
        if (debug) {
            Debug.assertion((null != string ? 1 : 0) != 0);
        }
        this.typeIdentifier = string;
    }

    public String getVersion() {
        return this.typeVersion;
    }

    public void setVersion(String string) {
        if (debug) {
            Debug.assertion((null != string ? 1 : 0) != 0);
        }
        this.typeVersion = string;
    }

    public String getWeblogicVersion() {
        return this.weblogicVersion;
    }

    public void setWeblogicVersion(String string) {
        this.weblogicVersion = string;
    }

    public String getCmpVersion() {
        return this.cmpVersion;
    }

    public void setCmpVersion(String string) {
        this.cmpVersion = string;
    }

    public void setCmpDeployerClassName(String string) {
        this.cmpDeployerClassName = string;
    }

    public CMPDeployer getCmpDeployer() {
        return (CMPDeployer)this.newInstance(this.cmpDeployerClassName);
    }

    public void setPersistenceManagerClassName(String string) {
        this.persistenceManagerClassName = string;
    }

    public PersistenceManager getPersistenceManager() {
        return (PersistenceManager)this.newInstance(this.persistenceManagerClassName);
    }

    public void setExclusiveManagerClassName(String string) {
        this.exclusiveManagerClassName = string;
    }

    public BeanManager getExclusiveManager() {
        return (BeanManager)this.newInstance(this.exclusiveManagerClassName);
    }

    public boolean hasExclusiveManager() {
        return this.exclusiveManagerClassName != null;
    }

    public void setDatabaseManagerClassName(String string) {
        this.databaseManagerClassName = string;
    }

    public BeanManager getDatabaseManager() {
        return (BeanManager)this.newInstance(this.databaseManagerClassName);
    }

    public boolean hasDatabaseManager() {
        return this.databaseManagerClassName != null;
    }

    public void setReadonlyManagerClassName(String string) {
        this.readonlyManagerClassName = string;
    }

    public BeanManager getReadonlyManager() {
        return (BeanManager)this.newInstance(this.readonlyManagerClassName);
    }

    public boolean hasReadonlyManager() {
        return this.readonlyManagerClassName != null;
    }

    public boolean hasJarDeployment() {
        return this.jarDeploymentClassName != null;
    }

    public void setJarDeploymentClassName(String string) {
        this.jarDeploymentClassName = string;
    }

    public JarDeployment getJarDeployment() {
        if (this.jarDeployment == null) {
            this.jarDeployment = (JarDeployment)this.newInstance(this.jarDeploymentClassName);
        }
        return this.jarDeployment;
    }

    public void setOptions(Getopt2 getopt2) {
        this.options = getopt2;
    }

    public boolean hasCodeGenerator() {
        return this.codeGeneratorClassName != null;
    }

    public void setCodeGeneratorClassName(String string) {
        this.codeGeneratorClassName = string;
        this.codeGeneratorClass = this.loadClass(this.codeGeneratorClassName);
        this.codeGeneratorConstructor = this.getConstructor(this.codeGeneratorClass, Getopt2.class);
    }

    public CMPCodeGenerator getCodeGenerator() {
        if (this.codeGeneratorConstructor != null) {
            return (CMPCodeGenerator)((Object)this.invokeConstructor(this.codeGeneratorConstructor, this.options));
        }
        return (CMPCodeGenerator)((Object)this.newInstance(this.codeGeneratorClassName));
    }

    private Constructor getConstructor(Class clazz, Class clazz2) {
        try {
            return clazz.getConstructor(clazz2);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        catch (Exception exception) {
            throw new AssertionError("should not reach.", (Throwable)exception);
        }
    }

    private Object invokeConstructor(Constructor constructor, Object object) {
        try {
            return constructor.newInstance(object);
        }
        catch (Exception exception) {
            throw new AssertionError("Should not reach.", (Throwable)exception);
        }
    }

    private Object newInstance(String string) {
        try {
            return this.loadClass(string).newInstance();
        }
        catch (Exception exception) {
            throw new AssertionError("Could not create an instance of class '" + string + "': " + StackTraceUtils.throwable2StackTrace((Throwable)exception));
        }
    }

    private Class loadClass(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError("Could not load class '" + string + "': " + StackTraceUtils.throwable2StackTrace((Throwable)classNotFoundException));
        }
    }

    private Map createPersistenceParameters(EntityBeanInfo entityBeanInfo, File file, Getopt2 getopt2) throws IllegalValueException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        NamingConvention namingConvention = new NamingConvention(entityBeanInfo.getBeanClassName(), entityBeanInfo.getEJBName());
        CMPInfo cMPInfo = entityBeanInfo.getCMPInfo();
        if (debug) {
            Debug.assertion((cMPInfo != null ? 1 : 0) != 0);
        }
        Boolean bl = new Boolean(entityBeanInfo.getCacheBetweenTransactions());
        hashMap.put(new String("bean.cacheBetweenTransactions"), bl);
        Boolean bl2 = new Boolean(cMPInfo.findersLoadBean());
        hashMap.put(new String("bean.findersLoadBean"), bl2);
        String string = new String(namingConvention.getBeanPackageName());
        hashMap.put(new String("codegen.packageName"), string);
        String string2 = new String(namingConvention.getSimpleCmpBeanClassName(this.getIdentifier()));
        hashMap.put(new String("codegen.beanClassName"), string2);
        String string3 = new String(string2 + ".java");
        if (string != null && !string.trim().equals("")) {
            string3 = string.replace('.', File.separatorChar) + File.separator + string3;
        }
        File file2 = null;
        file2 = file.isDirectory() ? new File(file, string3) : new File(string3);
        hashMap.put(new String("codegen.targetFile"), file2);
        hashMap.put(new String("codegen.opts"), getopt2 != null ? getopt2.asCommandArray() : null);
        return hashMap;
    }

    public CMPDeployer setupDeployer(EntityBeanInfo entityBeanInfo, File file, Getopt2 getopt2, VirtualJarFile virtualJarFile) throws WLDeploymentException {
        this.sourceJarFile = virtualJarFile;
        CMPDeployer cMPDeployer = this.getCmpDeployer();
        try {
            if (this.hasJarDeployment()) {
                cMPDeployer.setup(this.getJarDeployment());
            } else {
                cMPDeployer.setup(null);
            }
            Map map = entityBeanInfo.getCMPInfo().getAllBeanMap();
            CMPBeanDescriptor cMPBeanDescriptor = (CMPBeanDescriptor)map.get(entityBeanInfo.getEJBName());
            cMPDeployer.setCMPBeanDescriptor(cMPBeanDescriptor);
            if (entityBeanInfo.getCMPInfo().uses20CMP()) {
                cMPDeployer.setBeanMap(entityBeanInfo.getCMPInfo().getBeanMap());
                cMPDeployer.setRelationships(entityBeanInfo.getCMPInfo().getRelationships());
                cMPDeployer.setDependentMap(entityBeanInfo.getCMPInfo().getDependentMap());
            }
            Map map2 = this.createPersistenceParameters(entityBeanInfo, file, getopt2);
            cMPDeployer.setParameters(map2);
            this.setTypeSpecificFile(entityBeanInfo, cMPDeployer);
            return cMPDeployer;
        }
        catch (WLDeploymentException wLDeploymentException) {
            throw wLDeploymentException;
        }
        catch (Exception exception) {
            Loggable loggable = EJBLogger.logPersistenceTypeSetupErrorLoggable((Exception)exception);
            throw new WLDeploymentException(loggable.getMessage(), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTypeSpecificFile(EntityBeanInfo entityBeanInfo, CMPDeployer cMPDeployer) throws Exception {
        block16: {
            VirtualJarFile virtualJarFile;
            if (debug) {
                Debug.assertion((entityBeanInfo != null ? 1 : 0) != 0);
                Debug.assertion((entityBeanInfo.getCMPInfo() != null ? 1 : 0) != 0);
                Debug.assertion((cMPDeployer != null ? 1 : 0) != 0);
            }
            if (entityBeanInfo.getPersistenceUseStorage() == null) {
                throw new RuntimeException("Couldn't find the CMP description for your Entity Bean.\nPlease make sure you specified a <persistence-type> tag in weblogic-ejb-jar.xml.");
            }
            String string = entityBeanInfo.getPersistenceUseStorage();
            if (debug) {
                Debug.assertion((string != null ? 1 : 0) != 0);
            }
            boolean bl = false;
            try {
                if (this.sourceJarFile == null) {
                    this.sourceJarFile = VirtualJarFactory.createVirtualJar((File)new File(entityBeanInfo.getJarFileName()));
                    bl = true;
                }
                try {
                    cMPDeployer.readTypeSpecificData(this.sourceJarFile, string);
                    if (cMPDeployer instanceof Deployer) {
                        entityBeanInfo.setCategoryCmpField(((Deployer)cMPDeployer).getTypeSpecificData().getCategoryCmpField());
                    }
                }
                catch (XMLParsingException xMLParsingException) {
                    String string2 = xMLParsingException.getMessage();
                    if (string2 == null || debug) {
                        string2 = StackTraceUtils.throwable2StackTrace((Throwable)((Object)xMLParsingException));
                        Loggable loggable = EJBLogger.logPersistenceTypeSetupErrorWithFileNameLoggable((String)string2, (String)string);
                        throw new WLDeploymentException(loggable.getMessage(), (Throwable)((Object)xMLParsingException));
                    }
                    Throwable throwable = xMLParsingException.getNestedException();
                    if (throwable instanceof SAXParseException) {
                        int n = ((SAXParseException)throwable).getLineNumber();
                        Loggable loggable = EJBLogger.logPersistenceTypeSetupErrorWithFileNameAndLineNumberLoggable((String)string2, (String)string, (int)n);
                        throw new WLDeploymentException(loggable.getMessage(), (Throwable)((Object)xMLParsingException));
                    }
                    Loggable loggable = EJBLogger.logPersistenceTypeSetupErrorWithFileNameLoggable((String)string2, (String)string);
                    throw new WLDeploymentException(loggable.getMessage(), (Throwable)((Object)xMLParsingException));
                }
                catch (EJBQLParsingException eJBQLParsingException) {
                    String string3 = eJBQLParsingException.getMessage();
                    if (string3 == null || debug) {
                        string3 = StackTraceUtils.throwable2StackTrace((Throwable)((Object)eJBQLParsingException));
                    }
                    Loggable loggable = EJBLogger.logPersistenceTypeSetupEjbqlParsingErrorLoggable((String)string3, (String)string);
                    throw new WLDeploymentException(loggable.getMessage(), (Throwable)((Object)eJBQLParsingException));
                }
                catch (Exception exception) {
                    String string4 = exception.getMessage();
                    if (string4 == null || !debug) {
                        // empty if block
                    }
                    string4 = StackTraceUtils.throwable2StackTrace((Throwable)exception);
                    Loggable loggable = EJBLogger.logPersistenceTypeSetupErrorWithFileNameLoggable((String)string4, (String)string);
                    throw new WLDeploymentException(loggable.getMessage(), exception);
                }
                Object var11_18 = null;
                if (!bl) break block16;
                virtualJarFile = this.sourceJarFile;
                this.sourceJarFile = null;
            }
            catch (Throwable throwable) {
                Object var11_19 = null;
                if (bl) {
                    VirtualJarFile virtualJarFile2 = this.sourceJarFile;
                    this.sourceJarFile = null;
                    virtualJarFile2.close();
                }
                throw throwable;
            }
            virtualJarFile.close();
            {
            }
        }
    }

    private String jarNormalize(String string) {
        if (string.indexOf(File.separatorChar) != -1) {
            string = string.replace(File.separatorChar, '/');
        }
        return string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append("PersistenceType: {");
        stringBuffer.append("\n\tProvided by Vendor: " + this.vendor.getName());
        stringBuffer.append("\n\ttypeIdentifier: " + this.typeIdentifier);
        stringBuffer.append("\n\tversionNumber: " + this.typeVersion);
        stringBuffer.append("\n\tweblogicVersion: " + this.weblogicVersion);
        stringBuffer.append("\n\tcmpVersion: " + this.cmpVersion);
        stringBuffer.append("\n\tpersistenceManager: " + this.persistenceManagerClassName);
        stringBuffer.append("\n\texclusiveManagerClassName: " + this.exclusiveManagerClassName);
        stringBuffer.append("\n\tdatabaseManagerClassName: " + this.databaseManagerClassName);
        stringBuffer.append("\n\treadonlyManagerClassName: " + this.readonlyManagerClassName);
        stringBuffer.append("\n\tjarDeploymentClassName: " + this.jarDeploymentClassName);
        stringBuffer.append("\n\tcodeGeneratorClassName: " + this.codeGeneratorClassName);
        stringBuffer.append("\n} end PersistenceType\n");
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (!(object instanceof PersistenceType)) {
            return false;
        }
        PersistenceType persistenceType = (PersistenceType)object;
        if (!this.getVersion().equals(persistenceType.getVersion())) {
            return false;
        }
        return this.getIdentifier().equals(persistenceType.getIdentifier());
    }

    public int hashCode() {
        return this.typeVersion.hashCode() ^ this.typeIdentifier.hashCode();
    }
}

