/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.persistence;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import weblogic.ejb.container.dd.xml.DDUtils;

public final class PersistenceUtils {
    public static final String PERSISTENCE_VERBOSE_PROP = "weblogic.ejb.container.persistence.verbose";
    public static final String PERSISTENCE_DEBUG_PROP = "weblogic.ejb.container.persistence.debug";
    private static final boolean debug = System.getProperty("weblogic.ejb.container.persistence.debug") != null;
    private static final boolean verbose = System.getProperty("weblogic.ejb.container.persistence.verbose") != null;
    public static final String PARSER_NAME = "com.sun.xml.parser.ValidatingParser";
    public static final String[] validPersistencePublicIds = new String[]{"-//BEA Systems, Inc.//DTD WebLogic 6.0.0 Persistence Vendor//EN"};
    public static String RDBMS_CMP_RESOURCE_NAME = "WebLogic_CMP_RDBMS.xml";

    public static Map getAccessorMethodMap(Class clazz) {
        HashMap<String, Method> hashMap = new HashMap<String, Method>();
        for (Class clazz2 = clazz; clazz2 != null && clazz2 != Object.class; clazz2 = clazz2.getSuperclass()) {
            Method[] methodArray = clazz2.getMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                int n;
                String string = methodArray[i].getName();
                if (!string.startsWith("get") && !string.startsWith("set") || !Modifier.isAbstract(n = methodArray[i].getModifiers()) || clazz2 != clazz && !Modifier.isPublic(n) && !Modifier.isProtected(n)) continue;
                hashMap.put(methodArray[i].getName(), methodArray[i]);
            }
        }
        return hashMap;
    }

    public static Collection getAbstractMethodCollection(Class clazz) {
        ArrayList<Method> arrayList = new ArrayList<Method>();
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        HashSet<Object> hashSet3 = new HashSet<Object>();
        for (Class clazz2 = clazz; clazz2 != null && clazz2 != Object.class; clazz2 = clazz2.getSuperclass()) {
            hashSet3.addAll(Arrays.asList((Object[])clazz2.getDeclaredMethods()));
            if (clazz2 == clazz) {
                hashSet3.addAll(Arrays.asList((Object[])clazz2.getMethods()));
            }
            for (Method method : hashSet3) {
                String string;
                int n = method.getModifiers();
                if (Modifier.isAbstract(n) && (clazz2 == clazz || Modifier.isPublic(n) || Modifier.isProtected(n))) {
                    string = DDUtils.getMethodSignature(method);
                    if (hashSet2.contains(string) || hashSet.contains(string)) continue;
                    arrayList.add(method);
                    hashSet.add(string);
                    continue;
                }
                string = DDUtils.getMethodSignature(method);
                hashSet2.add(string);
            }
            hashSet3.clear();
        }
        return arrayList;
    }

    public static Method getMethodIncludeSuper(Class clazz, String string, Class[] classArray) {
        boolean bl = false;
        Method method = null;
        for (Class clazz2 = clazz; clazz2 != null && !bl; clazz2 = clazz2.getSuperclass()) {
            try {
                method = clazz2.getMethod(string, classArray);
                int n = method.getModifiers();
                if (clazz2 != clazz && !Modifier.isPublic(n) && !Modifier.isProtected(n)) continue;
                bl = true;
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return bl ? method : null;
    }
}

