/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.persistence;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.InputSource;
import weblogic.ejb.container.persistence.PersistenceType;
import weblogic.ejb.container.persistence.PersistenceVendor;
import weblogic.ejb.container.persistence.PersistenceVendorProcessor;
import weblogic.utils.AssertionError;
import weblogic.utils.Debug;
import weblogic.xml.process.Functions;
import weblogic.xml.process.InProcessor;
import weblogic.xml.process.ProcessingContext;
import weblogic.xml.process.ProcessorDriver;
import weblogic.xml.process.SAXProcessorException;
import weblogic.xml.process.SAXValidationException;
import weblogic.xml.process.XMLParsingException;
import weblogic.xml.process.XMLProcessingException;
import weblogic.xml.process.XMLProcessor;

public final class WeblogicPersistenceVendorProcessor
extends PersistenceVendorProcessor
implements XMLProcessor,
InProcessor {
    private static final boolean debug = true;
    private static final boolean verbose = true;
    private static final Map paths = new HashMap();
    private ProcessorDriver driver;
    private static final String publicId = "-//BEA Systems, Inc.//DTD WebLogic 6.0.0 Persistence Vendor//EN";
    private static final String localDTDResourceName = "/weblogic/ejb/container/persistence/spi/weblogic-persistence-vendor.dtd";

    public ProcessorDriver getDriver() {
        return this.driver;
    }

    public WeblogicPersistenceVendorProcessor() {
        this(true);
    }

    public WeblogicPersistenceVendorProcessor(boolean bl) {
        this.driver = new ProcessorDriver(this, publicId, localDTDResourceName, bl);
    }

    public void process(String string) throws IOException, XMLParsingException, XMLProcessingException {
        this.driver.process(string);
    }

    public void process(File file) throws IOException, XMLParsingException, XMLProcessingException {
        this.driver.process(file);
    }

    public void process(Reader reader) throws IOException, XMLParsingException, XMLProcessingException {
        this.driver.process(reader);
    }

    public void process(InputSource inputSource) throws IOException, XMLParsingException, XMLProcessingException {
        this.driver.process(inputSource);
    }

    public void process(InputStream inputStream) throws IOException, XMLParsingException, XMLProcessingException {
        this.driver.process(inputStream);
    }

    public void preProc(ProcessingContext processingContext) throws SAXProcessorException {
        Debug.assertion((processingContext != null ? 1 : 0) != 0);
        String string = processingContext.getPath();
        Debug.assertion((string != null ? 1 : 0) != 0);
        Integer n = (Integer)paths.get(string);
        if (n == null) {
            return;
        }
        switch (n) {
            case 137: {
                this.__pre_137(processingContext);
                break;
            }
            case 136: {
                this.__pre_136(processingContext);
                break;
            }
            case 139: {
                this.__pre_139(processingContext);
                break;
            }
            case 138: {
                this.__pre_138(processingContext);
                break;
            }
            case 141: {
                this.__pre_141(processingContext);
                break;
            }
            case 140: {
                this.__pre_140(processingContext);
                break;
            }
            case 129: {
                this.__pre_129(processingContext);
                break;
            }
            case 128: {
                this.__pre_128(processingContext);
                break;
            }
            case 131: {
                this.__pre_131(processingContext);
                break;
            }
            case 130: {
                this.__pre_130(processingContext);
                break;
            }
            case 133: {
                this.__pre_133(processingContext);
                break;
            }
            case 132: {
                this.__pre_132(processingContext);
                break;
            }
            case 135: {
                this.__pre_135(processingContext);
                break;
            }
            case 134: {
                this.__pre_134(processingContext);
                break;
            }
            default: {
                throw new AssertionError(n.toString());
            }
        }
    }

    public void postProc(ProcessingContext processingContext) throws SAXProcessorException {
        Debug.assertion((processingContext != null ? 1 : 0) != 0);
        String string = processingContext.getPath();
        Debug.assertion((string != null ? 1 : 0) != 0);
        Integer n = (Integer)paths.get(string);
        if (n == null) {
            return;
        }
        switch (n) {
            case 137: {
                this.__post_137(processingContext);
                break;
            }
            case 136: {
                this.__post_136(processingContext);
                break;
            }
            case 139: {
                this.__post_139(processingContext);
                break;
            }
            case 138: {
                this.__post_138(processingContext);
                break;
            }
            case 141: {
                this.__post_141(processingContext);
                break;
            }
            case 140: {
                this.__post_140(processingContext);
                break;
            }
            case 129: {
                this.__post_129(processingContext);
                break;
            }
            case 128: {
                this.__post_128(processingContext);
                break;
            }
            case 131: {
                this.__post_131(processingContext);
                break;
            }
            case 130: {
                this.__post_130(processingContext);
                break;
            }
            case 133: {
                this.__post_133(processingContext);
                break;
            }
            case 132: {
                this.__post_132(processingContext);
                break;
            }
            case 135: {
                this.__post_135(processingContext);
                break;
            }
            case 134: {
                this.__post_134(processingContext);
                break;
            }
            default: {
                throw new AssertionError(n.toString());
            }
        }
    }

    private void __pre_135(ProcessingContext processingContext) {
    }

    private void __post_135(ProcessingContext processingContext) throws SAXProcessorException {
        String string = Functions.value(processingContext);
        PersistenceType persistenceType = (PersistenceType)processingContext.getBoundObject("curType");
        PersistenceVendor persistenceVendor = (PersistenceVendor)processingContext.getBoundObject("vendor");
        persistenceType.setCmpDeployerClassName(string);
    }

    private void __pre_134(ProcessingContext processingContext) {
    }

    private void __post_134(ProcessingContext processingContext) throws SAXProcessorException, SAXValidationException {
        String string = Functions.value(processingContext);
        PersistenceType persistenceType = (PersistenceType)processingContext.getBoundObject("curType");
        PersistenceVendor persistenceVendor = (PersistenceVendor)processingContext.getBoundObject("vendor");
        if (string.length() == 0) {
            throw new SAXValidationException("PAction[5920512](.weblogic-persistence-vendor.weblogic-persistence-type.cmp-version.) must be a non-empty string");
        }
        if (!"1.x".equals(string) && !"2.x".equals(string)) {
            throw new SAXValidationException("PAction[5920512](.weblogic-persistence-vendor.weblogic-persistence-type.cmp-version.) must be one of the values: 1.x,2.x");
        }
        persistenceType.setCmpVersion(string);
    }

    private void __pre_131(ProcessingContext processingContext) {
    }

    private void __post_131(ProcessingContext processingContext) throws SAXProcessorException {
        String string = Functions.value(processingContext);
        PersistenceType persistenceType = (PersistenceType)processingContext.getBoundObject("curType");
        PersistenceVendor persistenceVendor = (PersistenceVendor)processingContext.getBoundObject("vendor");
        persistenceType.setIdentifier(string);
    }

    private void __pre_141(ProcessingContext processingContext) {
    }

    private void __post_141(ProcessingContext processingContext) throws SAXProcessorException {
        String string = Functions.value(processingContext);
        PersistenceType persistenceType = (PersistenceType)processingContext.getBoundObject("curType");
        PersistenceVendor persistenceVendor = (PersistenceVendor)processingContext.getBoundObject("vendor");
        persistenceType.setCodeGeneratorClassName(string);
    }

    private void __pre_129(ProcessingContext processingContext) {
    }

    private void __post_129(ProcessingContext processingContext) throws SAXProcessorException {
        String string = Functions.value(processingContext);
        PersistenceVendor persistenceVendor = (PersistenceVendor)processingContext.getBoundObject("vendor");
        persistenceVendor.setName(string);
    }

    private void __pre_130(ProcessingContext processingContext) {
        PersistenceType persistenceType = new PersistenceType();
        processingContext.addBoundObject(persistenceType, "curType");
    }

    private void __post_130(ProcessingContext processingContext) throws SAXProcessorException {
        PersistenceType persistenceType = (PersistenceType)processingContext.getBoundObject("curType");
        PersistenceVendor persistenceVendor = (PersistenceVendor)processingContext.getBoundObject("vendor");
        persistenceType.setVendor(persistenceVendor);
        this.addType(persistenceType);
    }

    private void __pre_136(ProcessingContext processingContext) {
    }

    private void __post_136(ProcessingContext processingContext) throws SAXProcessorException {
        String string = Functions.value(processingContext);
        PersistenceType persistenceType = (PersistenceType)processingContext.getBoundObject("curType");
        PersistenceVendor persistenceVendor = (PersistenceVendor)processingContext.getBoundObject("vendor");
        persistenceType.setPersistenceManagerClassName(string);
    }

    private void __pre_139(ProcessingContext processingContext) {
    }

    private void __post_139(ProcessingContext processingContext) throws SAXProcessorException {
        String string = Functions.value(processingContext);
        PersistenceType persistenceType = (PersistenceType)processingContext.getBoundObject("curType");
        PersistenceVendor persistenceVendor = (PersistenceVendor)processingContext.getBoundObject("vendor");
        persistenceType.setReadonlyManagerClassName(string);
    }

    private void __pre_128(ProcessingContext processingContext) {
        PersistenceVendor persistenceVendor = new PersistenceVendor();
        processingContext.addBoundObject(persistenceVendor, "vendor");
    }

    private void __post_128(ProcessingContext processingContext) throws SAXProcessorException {
        PersistenceVendor persistenceVendor = (PersistenceVendor)processingContext.getBoundObject("vendor");
    }

    private void __pre_138(ProcessingContext processingContext) {
    }

    private void __post_138(ProcessingContext processingContext) throws SAXProcessorException {
        String string = Functions.value(processingContext);
        PersistenceType persistenceType = (PersistenceType)processingContext.getBoundObject("curType");
        PersistenceVendor persistenceVendor = (PersistenceVendor)processingContext.getBoundObject("vendor");
        persistenceType.setDatabaseManagerClassName(string);
    }

    private void __pre_137(ProcessingContext processingContext) {
    }

    private void __post_137(ProcessingContext processingContext) throws SAXProcessorException {
        String string = Functions.value(processingContext);
        PersistenceType persistenceType = (PersistenceType)processingContext.getBoundObject("curType");
        PersistenceVendor persistenceVendor = (PersistenceVendor)processingContext.getBoundObject("vendor");
        persistenceType.setExclusiveManagerClassName(string);
    }

    private void __pre_133(ProcessingContext processingContext) {
    }

    private void __post_133(ProcessingContext processingContext) throws SAXProcessorException {
        String string = Functions.value(processingContext);
        PersistenceType persistenceType = (PersistenceType)processingContext.getBoundObject("curType");
        PersistenceVendor persistenceVendor = (PersistenceVendor)processingContext.getBoundObject("vendor");
        persistenceType.setWeblogicVersion(string);
    }

    private void __pre_132(ProcessingContext processingContext) {
    }

    private void __post_132(ProcessingContext processingContext) throws SAXProcessorException {
        String string = Functions.value(processingContext);
        PersistenceType persistenceType = (PersistenceType)processingContext.getBoundObject("curType");
        PersistenceVendor persistenceVendor = (PersistenceVendor)processingContext.getBoundObject("vendor");
        persistenceType.setVersion(string);
    }

    private void __pre_140(ProcessingContext processingContext) {
    }

    private void __post_140(ProcessingContext processingContext) throws SAXProcessorException {
        String string = Functions.value(processingContext);
        PersistenceType persistenceType = (PersistenceType)processingContext.getBoundObject("curType");
        PersistenceVendor persistenceVendor = (PersistenceVendor)processingContext.getBoundObject("vendor");
        persistenceType.setJarDeploymentClassName(string);
    }

    public void addBoundObject(Object object, String string) {
        this.driver.currentNode().addBoundObject(object, string);
    }

    static {
        paths.put(".weblogic-persistence-vendor.weblogic-persistence-type.class-information.cmp-deployer-class.", new Integer(135));
        paths.put(".weblogic-persistence-vendor.weblogic-persistence-type.cmp-version.", new Integer(134));
        paths.put(".weblogic-persistence-vendor.weblogic-persistence-type.persistence-type-identifier.", new Integer(131));
        paths.put(".weblogic-persistence-vendor.weblogic-persistence-type.class-information.code-generator-class.", new Integer(141));
        paths.put(".weblogic-persistence-vendor.vendor-name.", new Integer(129));
        paths.put(".weblogic-persistence-vendor.weblogic-persistence-type.", new Integer(130));
        paths.put(".weblogic-persistence-vendor.weblogic-persistence-type.class-information.persistence-manager-class.", new Integer(136));
        paths.put(".weblogic-persistence-vendor.weblogic-persistence-type.class-information.readonly-concurrency-bean-manager-class.", new Integer(139));
        paths.put(".weblogic-persistence-vendor.", new Integer(128));
        paths.put(".weblogic-persistence-vendor.weblogic-persistence-type.class-information.database-concurrency-bean-manager-class.", new Integer(138));
        paths.put(".weblogic-persistence-vendor.weblogic-persistence-type.class-information.exclusive-concurrency-bean-manager-class.", new Integer(137));
        paths.put(".weblogic-persistence-vendor.weblogic-persistence-type.weblogic-major-version.", new Integer(133));
        paths.put(".weblogic-persistence-vendor.weblogic-persistence-type.persistence-type-version.", new Integer(132));
        paths.put(".weblogic-persistence-vendor.weblogic-persistence-type.class-information.jar-deployment-class.", new Integer(140));
    }
}

