/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.persistence.spi;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import weblogic.ejb.container.deployer.NamingConvention;
import weblogic.ejb.container.ejbc.EJBCException;
import weblogic.ejb.container.ejbc.EjbCodeGenerator;
import weblogic.ejb.container.ejbc.codegen.MethodSignature;
import weblogic.ejb.container.interfaces.BeanInfo;
import weblogic.ejb.container.interfaces.EntityBeanInfo;
import weblogic.ejb.container.persistence.PersistenceType;
import weblogic.ejb.container.persistence.spi.CMPBeanDescriptor;
import weblogic.utils.AssertionError;
import weblogic.utils.Getopt2;
import weblogic.utils.compiler.CodeGenerator;

public abstract class CMPCodeGenerator
extends EjbCodeGenerator {
    private static final boolean debug = false;
    private static final boolean verbose = false;
    protected CMPBeanDescriptor bd = null;
    private PersistenceType associatedType;
    protected Hashtable finderMethods;

    public CMPCodeGenerator() {
    }

    public CMPCodeGenerator(Getopt2 getopt2) {
        super(getopt2);
    }

    public void setAssociatedType(PersistenceType persistenceType) {
        this.associatedType = persistenceType;
    }

    public void setCMPBeanDescriptor(CMPBeanDescriptor cMPBeanDescriptor) {
        this.bd = cMPBeanDescriptor;
    }

    protected void addOutputs(Vector vector, BeanInfo beanInfo, NamingConvention namingConvention) throws EJBCException {
        Output output;
        if (!(beanInfo instanceof EntityBeanInfo)) {
            throw new AssertionError("Can only generate container managed persistence code for EntityBeans.");
        }
        EntityBeanInfo entityBeanInfo = (EntityBeanInfo)beanInfo;
        if (entityBeanInfo.hasRemoteClientView() || entityBeanInfo.hasLocalClientView()) {
            output = new Output(this);
            output.setBeanInfo(beanInfo);
            output.setNamingConvention(namingConvention);
            output.setPackage(namingConvention.getBeanPackageName());
            output.setCMPBeanDescriptor(this.bd);
            output.setPersistenceType(this.associatedType);
            List list = this.typeSpecificTemplates();
            Iterator iterator = list.iterator();
            boolean bl = true;
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (bl) {
                    output.setTemplate(string);
                    bl = false;
                    continue;
                }
                output.addExtraTemplate(string);
            }
            output.setOutputFile(namingConvention.getSimpleCmpBeanClassName(this.ejbStoreType()) + ".java");
            vector.addElement(output);
        }
        output = new Output(this);
        output.setBeanInfo(beanInfo);
        output.setNamingConvention(namingConvention);
        output.setPackage(namingConvention.getBeanPackageName());
        output.setCMPBeanDescriptor(this.bd);
        output.setPersistenceType(this.associatedType);
        output.setTemplate("weblogic/ejb/container/ejbc/ejbBeanIntf.j");
        output.setOutputFile(namingConvention.getSimpleGeneratedBeanInterfaceName() + ".java");
        vector.addElement(output);
    }

    protected void prepare(CodeGenerator.Output output) throws EJBCException, ClassNotFoundException {
        super.prepare(output);
        this.finderMethods = new Hashtable();
        Method[] methodArray = null;
        methodArray = this.hasLocalClientView ? this.localFindMethods : this.findMethods;
        if (methodArray != null) {
            for (int i = 0; i < methodArray.length; ++i) {
                MethodSignature methodSignature = new MethodSignature(methodArray[i]);
                methodSignature.setAbstract(false);
                this.finderMethods.put(methodSignature.asNameAndParamTypesKey(), methodSignature);
            }
        }
    }

    private String ejbStoreType() {
        return this.associatedType.getIdentifier();
    }

    protected abstract List typeSpecificTemplates();

    public List listGenerate() throws Exception {
        String[] stringArray = this.generate();
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.set(i, stringArray[i]);
        }
        return arrayList;
    }

    public String cmpBeanClassName() {
        return this.nc.getSimpleCmpBeanClassName(this.ejbStoreType());
    }

    public static void addToHashtable(Hashtable hashtable, Hashtable hashtable2) {
        if (hashtable == null) {
            return;
        }
        Enumeration enumeration = hashtable.keys();
        if (enumeration == null) {
            return;
        }
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            hashtable2.put(k, hashtable.get(k));
        }
    }

    public static class Output
    extends EjbCodeGenerator.Output {
        private PersistenceType associatedType = null;
        private CMPCodeGenerator owningGenerator = null;
        private CMPBeanDescriptor beanDesc = null;

        public Output(CMPCodeGenerator cMPCodeGenerator) {
            this.owningGenerator = cMPCodeGenerator;
        }

        public InputStream getTemplateStream(String string) throws IOException {
            return this.getClass().getResourceAsStream("/" + string);
        }

        public void setPersistenceType(PersistenceType persistenceType) {
            this.associatedType = persistenceType;
        }

        public CMPBeanDescriptor getCMPBeanDescriptor() {
            return this.beanDesc;
        }

        public void setCMPBeanDescriptor(CMPBeanDescriptor cMPBeanDescriptor) {
            this.beanDesc = cMPBeanDescriptor;
        }
    }
}

