/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.pool;

import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.EnterpriseBean;
import javax.ejb.EntityBean;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.InternalException;
import weblogic.ejb.container.interfaces.BaseEJBHomeIntf;
import weblogic.ejb.container.interfaces.BeanInfo;
import weblogic.ejb.container.interfaces.EntityBeanInfo;
import weblogic.ejb.container.internal.EntityEJBHome;
import weblogic.ejb.container.internal.EntityEJBLocalHome;
import weblogic.ejb.container.manager.BaseEntityManager;
import weblogic.ejb.container.pool.Pool;
import weblogic.ejb.spi.WLDeploymentException;
import weblogic.j2ee.MethodInvocationHelper;
import weblogic.management.runtime.EJBPoolRuntimeMBean;
import weblogic.utils.AssertionError;
import weblogic.utils.StackTraceUtils;

public final class EntityPool
extends Pool {
    private static final Object DUMMY_PK = new Object();
    private final BaseEJBHomeIntf ejbHome;
    private final EntityEJBHome remoteHome;
    private final EntityEJBLocalHome localHome;
    private final BaseEntityManager beanManager;
    private EJBObject eo;
    private EJBLocalObject elo;

    public EntityPool(EntityEJBHome entityEJBHome, EntityEJBLocalHome entityEJBLocalHome, BaseEntityManager baseEntityManager, BeanInfo beanInfo, EJBPoolRuntimeMBean eJBPoolRuntimeMBean) throws WLDeploymentException {
        super(baseEntityManager, beanInfo, eJBPoolRuntimeMBean);
        this.beanClass = ((EntityBeanInfo)this.beanInfo).getGeneratedBeanClass();
        this.remoteHome = entityEJBHome;
        this.localHome = entityEJBLocalHome;
        this.beanManager = baseEntityManager;
        this.ejbHome = null == entityEJBHome ? entityEJBLocalHome : entityEJBHome;
        if (null != entityEJBHome) {
            this.eo = entityEJBHome.allocateEO(DUMMY_PK);
        }
        if (null != entityEJBLocalHome) {
            this.elo = entityEJBLocalHome.allocateELO(DUMMY_PK);
        }
        if (debugLogger.isDebugEnabled()) {
            EntityPool.debug("created: '" + this + "'");
        }
    }

    public EnterpriseBean getBean() throws InternalException {
        EnterpriseBean enterpriseBean = super.getBean();
        if (null == enterpriseBean) {
            enterpriseBean = this.createBean();
            if (debugLogger.isDebugEnabled()) {
                EntityPool.debug("Allocate new: '" + enterpriseBean + "'");
            }
        }
        this.getPoolRuntime().incrementBeansInUseCount();
        return enterpriseBean;
    }

    public EnterpriseBean getBean(long l) {
        throw new AssertionError("getBean() with timeout not supported for Entity beans");
    }

    protected void removeBean(EnterpriseBean enterpriseBean) {
        try {
            ((EntityBean)enterpriseBean).unsetEntityContext();
        }
        catch (Throwable throwable) {
            EJBLogger.logExceptionDuringEJBUnsetEntityContext((String)this.beanInfo.getEJBName(), (String)StackTraceUtils.throwable2StackTrace((Throwable)throwable));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnterpriseBean createBean() throws InternalException {
        EntityBean entityBean;
        Thread thread2 = Thread.currentThread();
        ClassLoader classLoader = thread2.getContextClassLoader();
        MethodInvocationHelper.pushMethodObject(this.beanInfo);
        this.setFile2();
        try {
            this.pushEnvironment();
            ClassLoader classLoader2 = this.beanInfo.getModuleClassLoader();
            thread2.setContextClassLoader(classLoader2);
            entityBean = (EntityBean)this.beanManager.createBean(this.eo, this.elo);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.popEnvironment();
            thread2.setContextClassLoader(classLoader);
            this.resetFile2();
            MethodInvocationHelper.popMethodObject(this.beanInfo);
            throw throwable;
        }
        this.popEnvironment();
        thread2.setContextClassLoader(classLoader);
        this.resetFile2();
        MethodInvocationHelper.popMethodObject(this.beanInfo);
        return entityBean;
    }

    public void reset() {
        this.beanClass = ((EntityBeanInfo)this.beanInfo).getGeneratedBeanClass();
        this.cleanup();
    }

    private static void debug(String string) {
        debugLogger.debug("[EntityPool] " + string);
    }
}

