/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.pool;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.ejb.EnterpriseBean;
import javax.ejb.MessageDrivenBean;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.InternalException;
import weblogic.ejb.container.interfaces.BeanInfo;
import weblogic.ejb.container.manager.MessageDrivenManager;
import weblogic.ejb.container.pool.Pool;
import weblogic.ejb.spi.WLDeploymentException;
import weblogic.j2ee.MethodInvocationHelper;
import weblogic.management.runtime.EJBPoolRuntimeMBean;
import weblogic.utils.AssertionError;

public final class MessageDrivenPool
extends Pool {
    private final MessageDrivenManager beanManager;
    private AtomicInteger currentSize = new AtomicInteger(0);
    private long timeouts;
    private final Lock sizeLock = new ReentrantLock();
    private final Condition notEmpty = this.sizeLock.newCondition();

    public MessageDrivenPool(MessageDrivenManager messageDrivenManager, BeanInfo beanInfo, EJBPoolRuntimeMBean eJBPoolRuntimeMBean) throws WLDeploymentException {
        super(messageDrivenManager, beanInfo, eJBPoolRuntimeMBean);
        this.beanClass = this.beanInfo.getBeanClass();
        this.beanManager = messageDrivenManager;
        if (debugLogger.isDebugEnabled()) {
            MessageDrivenPool.debug("Created: " + this + " with initialSize: '" + this.initialSize + "', maximumSize: '" + this.maximumSize + "'");
        }
    }

    public EnterpriseBean getBean() throws InternalException {
        throw new AssertionError("MessageDrivenPool.getBean() must be called with mustWait=true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnterpriseBean getBean(long l) throws InternalException {
        EnterpriseBean enterpriseBean = null;
        if (this.getMaxBeansInFreePool() > 0 && null == (enterpriseBean = super.getBean())) {
            try {
                this.sizeLock.lock();
                if (this.getMaxBeansInFreePool() <= this.currentSize.get()) {
                    enterpriseBean = this.waitForBean(l);
                }
                Object var5_3 = null;
                this.sizeLock.unlock();
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                this.sizeLock.unlock();
                throw throwable;
            }
        }
        if (null == enterpriseBean) {
            enterpriseBean = this.createBean();
            this.incrementCurrentSize();
            if (debugLogger.isDebugEnabled()) {
                MessageDrivenPool.debug("allocate new: '" + enterpriseBean + "'");
            }
        }
        this.getPoolRuntime().incrementBeansInUseCount();
        return enterpriseBean;
    }

    private EnterpriseBean waitForBean(long l) throws InternalException {
        EnterpriseBean enterpriseBean;
        if (debugLogger.isDebugEnabled()) {
            MessageDrivenPool.debug("Waiting for an instance in pool: '" + this + "'");
        }
        TimeUnit timeUnit = TimeUnit.MILLISECONDS;
        this.getPoolRuntime().incrementWaiterCount();
        long l2 = System.currentTimeMillis() + l;
        do {
            try {
                this.notEmpty.await(l2 - System.currentTimeMillis(), timeUnit);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (System.currentTimeMillis() < l2) continue;
            this.getPoolRuntime().decrementWaiterCount();
            this.getPoolRuntime().incrementTotalTimeoutCount();
            ++this.timeouts;
            throw new RuntimeException("An invocation of EJB " + this.beanInfo.getDisplayName() + " timed out while waiting to get an instance from the free pool.");
        } while (null == (enterpriseBean = super.getBean()));
        this.getPoolRuntime().decrementWaiterCount();
        return enterpriseBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void removeBean(EnterpriseBean enterpriseBean) {
        this.decrementCurrentSize();
        boolean bl = this.setSegment();
        try {
            try {
                ((MessageDrivenBean)enterpriseBean).ejbRemove();
            }
            catch (Exception exception) {
                EJBLogger.logExceptionDuringEJBRemove((Throwable)exception);
                Object var5_4 = null;
                if (!bl) return;
                this.resetFile();
                return;
            }
            Object var5_3 = null;
            if (!bl) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!bl) throw throwable;
            this.resetFile();
            throw throwable;
        }
        this.resetFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EnterpriseBean createBean() throws InternalException {
        MessageDrivenBean messageDrivenBean;
        MethodInvocationHelper.pushMethodObject(this.beanInfo);
        boolean bl = this.setFile();
        try {
            MessageDrivenBean messageDrivenBean2;
            this.pushEnvironment();
            messageDrivenBean = messageDrivenBean2 = this.beanManager.createBean();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.popEnvironment();
            if (bl) {
                this.resetFile();
            }
            MethodInvocationHelper.popMethodObject(this.beanInfo);
            throw throwable;
        }
        this.popEnvironment();
        if (bl) {
            this.resetFile();
        }
        MethodInvocationHelper.popMethodObject(this.beanInfo);
        return messageDrivenBean;
    }

    public void destroyBean(EnterpriseBean enterpriseBean) {
        if (debugLogger.isDebugEnabled()) {
            MessageDrivenPool.debug("Destroying a bean in: '" + this + "'");
        }
        this.decrementCurrentSize();
        super.destroyBean(enterpriseBean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseBean(EnterpriseBean enterpriseBean) {
        try {
            this.sizeLock.lock();
            super.releaseBean(enterpriseBean);
            this.notEmpty.signal();
            Object var3_2 = null;
            this.sizeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.sizeLock.unlock();
            throw throwable;
        }
    }

    public void reset() {
        this.beanClass = this.beanInfo.getBeanClass();
        this.cleanup();
    }

    private static void debug(String string) {
        debugLogger.debug("[MessageDrivenPool] " + string);
    }

    private void decrementCurrentSize() {
        this.currentSize.decrementAndGet();
    }

    protected void incrementCurrentSize() {
        this.currentSize.incrementAndGet();
    }
}

