/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.pool;

import java.util.Collection;
import java.util.Iterator;
import weblogic.ejb.container.pool.ShrinkablePool;
import weblogic.utils.collections.Pool;
import weblogic.utils.concurrent.atomic.AtomicFactory;
import weblogic.utils.concurrent.atomic.AtomicLong;

public final class MonitoredPool
implements Collection,
Pool {
    private final ShrinkablePool delegate;
    private final AtomicLong accesses = AtomicFactory.createAtomicLong();
    private final AtomicLong misses = AtomicFactory.createAtomicLong();

    public MonitoredPool(ShrinkablePool shrinkablePool) {
        this.delegate = shrinkablePool;
    }

    public int getFreeCount() {
        return this.size();
    }

    public long getAccessCount() {
        return this.accesses.get();
    }

    public long getMissCount() {
        return this.misses.get();
    }

    public Object remove() {
        this.accesses.incrementAndGet();
        Object object = this.delegate.remove();
        if (object == null) {
            this.misses.incrementAndGet();
        }
        return object;
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean contains(Object object) {
        return this.delegate.contains(object);
    }

    public Object[] toArray() {
        return this.delegate.toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        return this.delegate.toArray(objectArray);
    }

    public boolean add(Object object) {
        return this.delegate.add(object);
    }

    public boolean remove(Object object) {
        return this.delegate.remove(object);
    }

    public boolean containsAll(Collection collection) {
        return this.delegate.containsAll(collection);
    }

    public boolean addAll(Collection collection) {
        return this.delegate.addAll(collection);
    }

    public boolean removeAll(Collection collection) {
        return this.delegate.removeAll(collection);
    }

    public boolean retainAll(Collection collection) {
        return this.delegate.retainAll(collection);
    }

    public void clear() {
        this.delegate.clear();
    }

    public int size() {
        return this.delegate.size();
    }

    public Iterator iterator() {
        return this.delegate.iterator();
    }

    public Collection trim(boolean bl) {
        return this.delegate.trim(bl);
    }
}

