/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.pool;

import java.util.Collection;
import weblogic.ejb.container.pool.NewShrinkablePool;
import weblogic.utils.concurrent.atomic.AtomicFactory;
import weblogic.utils.concurrent.atomic.AtomicLong;

public final class NewMonitoredPool {
    private final NewShrinkablePool delegate;
    private final AtomicLong accesses = AtomicFactory.createAtomicLong();
    private final AtomicLong misses = AtomicFactory.createAtomicLong();

    public NewMonitoredPool(NewShrinkablePool newShrinkablePool) {
        this.delegate = newShrinkablePool;
    }

    public int getFreeCount() {
        return this.size();
    }

    public long getAccessCount() {
        return this.accesses.get();
    }

    public long getMissCount() {
        return this.misses.get();
    }

    public void setCapacity(int n) {
        this.delegate.setCapacity(n);
    }

    public int getCapacity() {
        return this.delegate.getCapacity();
    }

    public Object remove() {
        this.accesses.incrementAndGet();
        Object object = this.delegate.remove();
        if (object == null) {
            this.misses.incrementAndGet();
        }
        return object;
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean add(Object object) {
        return this.delegate.add(object);
    }

    public int size() {
        return this.delegate.size();
    }

    public Collection trim(boolean bl) {
        return this.delegate.trim(bl);
    }

    public Collection trim(int n) {
        return this.delegate.trim(n);
    }
}

