/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.pool;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.ejb.container.EJBDebugService;

public class NewShrinkablePool {
    private static final DebugLogger debugLogger = EJBDebugService.poolingLogger;
    private AtomicReference head = new AtomicReference();
    private final int initialObjectsInPool;
    private AtomicInteger capacity;
    private AtomicInteger currentSize;
    private AtomicInteger watermark;

    public NewShrinkablePool(int n, int n2) {
        this.capacity = new AtomicInteger(n);
        this.initialObjectsInPool = n2;
        this.watermark = new AtomicInteger(n2);
        this.currentSize = new AtomicInteger(0);
    }

    public void setCapacity(int n) {
        this.capacity.set(n);
    }

    public int getCapacity() {
        return this.capacity.get();
    }

    public boolean add(Object object) {
        Node node;
        Node node2 = new Node(object);
        do {
            if (this.currentSize.get() >= this.capacity.get()) {
                return false;
            }
            node2.next = node = (Node)this.head.get();
        } while (!this.head.compareAndSet(node, node2));
        this.currentSize.getAndIncrement();
        return true;
    }

    public Object remove() {
        Node node;
        Node node2;
        do {
            if ((node2 = (Node)this.head.get()) != null) continue;
            return null;
        } while (!this.head.compareAndSet(node2, node = node2.next));
        int n = this.currentSize.decrementAndGet();
        if (n < this.watermark.get()) {
            this.watermark.set(n);
        }
        return node2.item;
    }

    public int size() {
        return this.currentSize.get();
    }

    public Collection trim(int n) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (n > 0) {
            Object object;
            for (int i = 0; i < n && this.currentSize.get() > this.initialObjectsInPool && (object = this.remove()) != null; ++i) {
                arrayList.add(object);
            }
        }
        return arrayList;
    }

    public boolean isEmpty() {
        return this.head.get() == null;
    }

    Collection trim(boolean bl) {
        if (debugLogger.isDebugEnabled()) {
            NewShrinkablePool.debug("trimAndResetMark entered.  initialObjectsInPool = " + this.initialObjectsInPool + ", currentSize = " + this.currentSize.get() + ", watermark = " + this.watermark.get());
        }
        if (this.currentSize.get() <= this.initialObjectsInPool) {
            return null;
        }
        int n = this.currentSize.get();
        int n2 = this.initialObjectsInPool;
        if (bl) {
            n2 = n - this.watermark.get();
        }
        if (n2 < this.initialObjectsInPool) {
            n2 = this.initialObjectsInPool;
        }
        List list = (List)this.trim(n - n2);
        this.watermark.set(n2);
        if (debugLogger.isDebugEnabled()) {
            NewShrinkablePool.debug("trimAndResetMark exiting. new pointer = " + n2);
        }
        return list;
    }

    private static void debug(String string) {
        debugLogger.debug("[FencedPool] " + string);
    }

    static class Node {
        final Object item;
        Node next;

        public Node(Object object) {
            this.item = object;
        }
    }
}

