/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.pool;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.ejb.EnterpriseBean;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.ejb.container.EJBDebugService;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.InternalException;
import weblogic.ejb.container.interfaces.BeanInfo;
import weblogic.ejb.container.interfaces.BeanManager;
import weblogic.ejb.container.interfaces.PoolIntf;
import weblogic.ejb.container.internal.EJBRuntimeUtils;
import weblogic.ejb.container.internal.PoolHelper;
import weblogic.ejb.container.monitoring.EJBPoolRuntimeMBeanImpl;
import weblogic.ejb.container.pool.NewMonitoredPool;
import weblogic.ejb.container.pool.NewShrinkablePool;
import weblogic.ejb.spi.WLDeploymentException;
import weblogic.management.runtime.EJBPoolRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManager;
import weblogic.timers.TimerManagerFactory;
import weblogic.utils.Debug;
import weblogic.utils.StackTraceUtils;

public abstract class Pool
implements PoolIntf,
TimerListener {
    protected static final DebugLogger debugLogger = EJBDebugService.poolingLogger;
    public static final String USE_GENERIC_RESOURCE_POOL_PROP = "weblogic.ejb.pool.InstancePool.useGenericResourcePool";
    private static final boolean useGenericResourcePool = System.getProperty("weblogic.ejb.pool.InstancePool.useGenericResourcePool") != null;
    private BeanManager beanManager;
    protected final BeanInfo beanInfo;
    protected int initialSize;
    protected volatile int maximumSize;
    protected int idleTimeoutSeconds;
    protected Class beanClass;
    protected String ejbName;
    private NewMonitoredPool pool;
    private Timer timer;
    private Lock poolLock;
    private final EJBPoolRuntimeMBeanImpl mbean;
    private PoolHelper helper;
    private String dirName;
    private String fileName;
    private String segmentName;
    private AuthenticatedSubject fileDesc;
    private AuthenticatedSubject filePtr;
    private AuthenticatedSubject fileSegment;
    private boolean doneInitialCreation = false;

    public Pool(BeanManager beanManager, BeanInfo beanInfo, EJBPoolRuntimeMBean eJBPoolRuntimeMBean) throws WLDeploymentException {
        this.mbean = (EJBPoolRuntimeMBeanImpl)eJBPoolRuntimeMBean;
        this.initialSize = beanInfo.getCachingDescriptor().getInitialBeansInFreePool();
        this.maximumSize = beanInfo.getCachingDescriptor().getMaxBeansInFreePool();
        if (this.initialSize > this.maximumSize) {
            this.maximumSize = this.initialSize;
        }
        this.beanInfo = beanInfo;
        this.beanManager = beanManager;
        this.ejbName = beanInfo.getEJBName();
        this.idleTimeoutSeconds = beanInfo.getCachingDescriptor().getIdleTimeoutSecondsPool();
        this.createInitialPool();
        this.mbean.setPool(this);
        this.dirName = beanInfo.getRunAsPrincipalName();
        this.fileName = beanInfo.getCreateAsPrincipalName();
        this.segmentName = beanInfo.getRemoveAsPrincipalName();
        if (this.dirName != null || this.fileName != null || this.segmentName != null) {
            this.helper = new PoolHelper(beanInfo.getDeploymentInfo().getSecurityRealmName(), beanInfo.getJACCPolicyConfig(), beanInfo.getJACCPolicyContextId(), beanInfo.getJACCCodeSource(), beanInfo.getJACCRoleMapper());
            try {
                if (this.dirName != null) {
                    this.fileDesc = this.helper.getFileDesc(this.dirName);
                }
                if (this.fileName != null) {
                    this.filePtr = this.helper.getFileDesc(this.fileName);
                }
                if (this.segmentName != null) {
                    this.fileSegment = this.helper.getFileDesc(this.segmentName);
                }
            }
            catch (Exception exception) {
                throw new WLDeploymentException(exception.toString());
            }
            this.helper = null;
        }
    }

    public String toString() {
        return super.toString() + " - ejb name: '" + this.beanInfo.getEJBName() + "'";
    }

    protected boolean setFile() {
        return PoolHelper.setFile(this.filePtr, this.fileDesc);
    }

    protected boolean setSegment() {
        return PoolHelper.setSegment(this.fileSegment, this.fileDesc);
    }

    protected void resetFile() {
        PoolHelper.resetFile();
    }

    protected void setDir() {
        PoolHelper.setDir();
    }

    protected void resetDir() {
        PoolHelper.resetDir();
    }

    protected void setFile2() {
        if (this.fileDesc != null) {
            PoolHelper.setFile2(this.fileDesc);
        }
    }

    protected void resetFile2() {
        if (this.fileDesc != null) {
            PoolHelper.resetFile2();
        }
    }

    protected EJBPoolRuntimeMBeanImpl getPoolRuntime() {
        return this.mbean;
    }

    private void createInitialPool() {
        this.poolLock = new ReentrantLock();
        if (useGenericResourcePool) {
            Debug.assertion((boolean)false, (String)"GenericResourcePool not hooked up to EJB pools yet");
        } else {
            this.pool = new NewMonitoredPool(new NewShrinkablePool(this.maximumSize, this.initialSize));
        }
    }

    public int getInitialBeansInFreePool() {
        return this.initialSize;
    }

    public void setInitialBeansInFreePool(int n) {
        this.initialSize = n;
        if (debugLogger.isDebugEnabled()) {
            this.debug("setInitialBeansInFreePool(" + n + ")");
        }
        this.createInitialPool();
    }

    public int getMaxBeansInFreePool() {
        return this.maximumSize;
    }

    public void setMaxBeansInFreePool(int n) {
        this.maximumSize = n;
        if (debugLogger.isDebugEnabled()) {
            this.debug("setMaxBeansInFreePool(" + n + ")");
        }
    }

    public void createInitialBeans() throws WLDeploymentException {
        if (!this.doneInitialCreation) {
            if (debugLogger.isDebugEnabled()) {
                this.debug("Creating InitialBeans in pool: '" + this + "' initialSize: '" + this.initialSize + "', maximumSize: '" + this.maximumSize + "'");
            }
            try {
                for (int i = 0; i < this.initialSize; ++i) {
                    this.pool.add(this.createBean());
                    this.incrementCurrentSize();
                }
                this.doneInitialCreation = true;
            }
            catch (InternalException internalException) {
                if (internalException.detail != null) {
                    throw new WLDeploymentException(internalException.detail.getMessage() + StackTraceUtils.throwable2StackTrace((Throwable)internalException.detail));
                }
                throw new WLDeploymentException(internalException.getMessage() + StackTraceUtils.throwable2StackTrace((Throwable)internalException));
            }
        }
        try {
            this.startIdleTimeout(0L);
        }
        catch (Exception exception) {
            EJBLogger.logErrorStartingFreepoolTimer((String)this.ejbName, (String)exception.getMessage());
        }
    }

    protected abstract EnterpriseBean createBean() throws InternalException;

    protected abstract void removeBean(EnterpriseBean var1);

    protected void incrementCurrentSize() {
    }

    public void destroyBean(EnterpriseBean enterpriseBean) {
        this.mbean.decrementBeansInUseCount();
        this.mbean.incrementDestroyedTotalCount();
    }

    public EnterpriseBean getBean() throws InternalException {
        EnterpriseBean enterpriseBean = (EnterpriseBean)this.pool.remove();
        if (debugLogger.isDebugEnabled()) {
            this.debug("Returning bean from the pool: '" + enterpriseBean + "'");
        }
        return enterpriseBean;
    }

    public void releaseBean(EnterpriseBean enterpriseBean) {
        boolean bl;
        this.mbean.decrementBeansInUseCount();
        boolean bl2 = false;
        if (this.beanInfo.isEJB30()) {
            bl = EJBRuntimeUtils.beanEq(this.beanClass, enterpriseBean, this.beanInfo.getDeploymentInfo().getPitchforkContext());
        } else {
            boolean bl3 = bl = enterpriseBean != null && enterpriseBean.getClass() == this.beanClass;
        }
        if (bl) {
            bl2 = this.pool.add(enterpriseBean);
        }
        if (!bl2) {
            this.removeBean(enterpriseBean);
        }
    }

    public void updateMaxBeansInFreePool(int n) {
        for (EnterpriseBean enterpriseBean : this.resizePool(n)) {
            this.removeBean(enterpriseBean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List resizePool(int n) {
        try {
            this.stopIdleTimeout();
        }
        catch (Exception exception) {
            EJBLogger.logErrorStoppingFreepoolTimer((String)this.ejbName, (String)exception.getMessage());
        }
        List list = new ArrayList();
        this.maximumSize = n;
        try {
            this.poolLock.lock();
            int n2 = this.pool.getCapacity();
            this.pool.setCapacity(this.maximumSize);
            list = (List)this.pool.trim(n2 - this.maximumSize);
            Object var5_6 = null;
            this.poolLock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.poolLock.unlock();
            throw throwable;
        }
        try {
            this.startIdleTimeout(0L);
        }
        catch (Exception exception) {
            EJBLogger.logErrorStartingFreepoolTimer((String)this.ejbName, (String)exception.getMessage());
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        try {
            this.stopIdleTimeout();
        }
        catch (Exception exception) {
            EJBLogger.logErrorStoppingFreepoolTimer((String)this.ejbName, (String)exception.getMessage());
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(this.maximumSize);
        while (!this.pool.isEmpty()) {
            arrayList.add(this.pool.remove());
        }
        for (EnterpriseBean enterpriseBean : arrayList) {
            Object var5_5;
            try {
                this.pushEnvironment();
                this.removeBean(enterpriseBean);
                var5_5 = null;
                this.popEnvironment();
            }
            catch (Throwable throwable) {
                var5_5 = null;
                this.popEnvironment();
                throw throwable;
            }
        }
        this.doneInitialCreation = false;
    }

    protected void pushEnvironment() {
        EJBRuntimeUtils.pushEnvironment(this.beanManager.getEnvironmentContext());
    }

    protected void popEnvironment() {
        EJBRuntimeUtils.popEnvironment();
    }

    private void startIdleTimeout(long l) {
        if (debugLogger.isDebugEnabled()) {
            this.debug(this.ejbName + ", entered startIdleTimeout timer with idleTimeoutSeconds = " + this.idleTimeoutSeconds);
        }
        if (this.idleTimeoutSeconds <= 0) {
            return;
        }
        if (debugLogger.isDebugEnabled()) {
            this.debug(this.ejbName + ", startIdleTimeout timer");
        }
        long l2 = this.idleTimeoutSeconds * 1000;
        TimerManagerFactory timerManagerFactory = TimerManagerFactory.getTimerManagerFactory();
        TimerManager timerManager = timerManagerFactory.getDefaultTimerManager();
        this.timer = timerManager.scheduleAtFixedRate((TimerListener)this, l, l2);
    }

    public void stopIdleTimeout() {
        if (this.idleTimeoutSeconds <= 0) {
            return;
        }
        if (debugLogger.isDebugEnabled()) {
            this.debug(this.ejbName + " stopping IdleTimeout timer ");
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    public void updateIdleTimeoutSeconds(int n) {
        long l = 0L;
        if (this.timer != null) {
            long l2 = this.timer.getTimeout();
            this.stopIdleTimeout();
            l = l2 - System.currentTimeMillis();
            if (l < 0L) {
                l = 0L;
            }
            if ((long)(n * 1000) < l) {
                l = n * 1000;
            }
        }
        this.idleTimeoutSeconds = n;
        this.startIdleTimeout(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timerExpired(Timer timer) {
        Collection collection = null;
        try {
            this.poolLock.lock();
            collection = this.pool.trim(true);
            EnterpriseBean enterpriseBean = null;
            this.poolLock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.poolLock.unlock();
            throw throwable;
        }
        if (collection != null) {
            if (debugLogger.isDebugEnabled()) {
                this.debug(this.ejbName + " timerExpired: about to call remove on " + collection.size() + " beans.");
            }
            for (EnterpriseBean enterpriseBean : collection) {
                this.removeBean(enterpriseBean);
            }
        } else if (debugLogger.isDebugEnabled()) {
            this.debug(this.ejbName + " timerExpired: no beans to remove ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reInitializePool() {
        Collection collection;
        try {
            this.poolLock.lock();
            collection = this.pool.trim(false);
            EnterpriseBean enterpriseBean = null;
            this.poolLock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.poolLock.unlock();
            throw throwable;
        }
        if (collection != null) {
            if (debugLogger.isDebugEnabled()) {
                this.debug(this.ejbName + " reInitializePool: about to call remove on " + collection.size() + " beans.");
            }
            for (EnterpriseBean enterpriseBean : collection) {
                this.removeBean(enterpriseBean);
            }
        } else if (debugLogger.isDebugEnabled()) {
            this.debug(this.ejbName + " reInitializePool: no beans to remove ");
        }
    }

    public int getFreeCount() {
        return this.pool.getFreeCount();
    }

    public long getAccessCount() {
        return this.pool.getAccessCount();
    }

    public long getMissCount() {
        return this.pool.getMissCount();
    }

    private void debug(String string) {
        debugLogger.debug("[Pool] " + this.ejbName + " - " + string);
    }
}

