/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.pool;

import java.util.ArrayList;
import java.util.Collection;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.ejb.container.EJBDebugService;
import weblogic.utils.collections.Pool;
import weblogic.utils.collections.StackPool;

public final class ShrinkablePool
extends StackPool
implements Pool {
    private static final DebugLogger debugLogger = EJBDebugService.poolingLogger;
    private int watermark;
    private int initialObjectsInPool;

    public ShrinkablePool(int n, int n2) {
        super(n);
        this.watermark = this.initialObjectsInPool = n2;
    }

    public synchronized Object remove() {
        if (this.getPointer() > 0) {
            Object object = this.decrementPointerAndGetValue();
            int n = this.getPointer();
            this.setValueAt(n, null);
            if (n < this.watermark) {
                this.watermark = n;
            }
            return object;
        }
        return null;
    }

    synchronized Collection trim(boolean bl) {
        if (debugLogger.isDebugEnabled()) {
            ShrinkablePool.debug("trimAndResetMark entered.  initialObjectsInPool = " + this.initialObjectsInPool + ", pointer = " + this.getPointer() + ", watermark = " + this.watermark);
        }
        if (this.getPointer() <= this.initialObjectsInPool) {
            return null;
        }
        int n = this.getPointer();
        int n2 = this.initialObjectsInPool;
        if (bl) {
            n2 = n - this.watermark;
        }
        if (n2 < this.initialObjectsInPool) {
            n2 = this.initialObjectsInPool;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = n2; i < n; ++i) {
            arrayList.add(this.getValueAt(i));
            this.setValueAt(i, null);
        }
        this.setPointer(n2);
        this.watermark = n2;
        if (debugLogger.isDebugEnabled()) {
            ShrinkablePool.debug("trimAndResetMark exiting. new pointer = " + n2);
        }
        return arrayList;
    }

    private static void debug(String string) {
        debugLogger.debug("[FencedPool] " + string);
    }
}

