/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.pool;

import com.oracle.pitchfork.interfaces.inject.LifecycleEvent;
import com.oracle.pitchfork.interfaces.intercept.__ProxyControl;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.ejb.EJBObject;
import javax.ejb.EnterpriseBean;
import javax.ejb.SessionBean;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.InternalException;
import weblogic.ejb.container.interfaces.BaseEJBLocalObjectIntf;
import weblogic.ejb.container.interfaces.BeanInfo;
import weblogic.ejb.container.interfaces.SessionBeanInfo;
import weblogic.ejb.container.interfaces.WLSessionBean;
import weblogic.ejb.container.internal.EJBContextManager;
import weblogic.ejb.container.internal.EJBRuntimeUtils;
import weblogic.ejb.container.internal.StatelessEJBHome;
import weblogic.ejb.container.internal.StatelessEJBLocalHome;
import weblogic.ejb.container.manager.StatelessManager;
import weblogic.ejb.container.pool.Pool;
import weblogic.ejb.spi.WLDeploymentException;
import weblogic.j2ee.MethodInvocationHelper;
import weblogic.management.runtime.EJBPoolRuntimeMBean;
import weblogic.security.subject.SubjectManager;

public final class StatelessSessionPool
extends Pool {
    private final StatelessEJBHome remoteHome;
    private final StatelessEJBLocalHome localHome;
    private final StatelessManager beanManager;
    private AtomicInteger currentSize = new AtomicInteger(0);
    private long timeouts;
    private final Lock sizeLock = new ReentrantLock();
    private final Condition notEmpty = this.sizeLock.newCondition();

    public StatelessSessionPool(StatelessEJBHome statelessEJBHome, StatelessEJBLocalHome statelessEJBLocalHome, StatelessManager statelessManager, BeanInfo beanInfo, EJBPoolRuntimeMBean eJBPoolRuntimeMBean) throws WLDeploymentException {
        super(statelessManager, beanInfo, eJBPoolRuntimeMBean);
        this.beanClass = ((SessionBeanInfo)this.beanInfo).getGeneratedBeanClass();
        this.remoteHome = statelessEJBHome;
        this.localHome = statelessEJBLocalHome;
        this.beanManager = statelessManager;
        if (debugLogger.isDebugEnabled()) {
            StatelessSessionPool.debug("created: '" + this + "'");
        }
    }

    public EnterpriseBean getBean() {
        throw new AssertionError((Object)"StatelessSessionPool.getBean() must be called with mustWait=true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnterpriseBean getBean(long l) throws InternalException {
        EnterpriseBean enterpriseBean = null;
        if (this.getMaxBeansInFreePool() > 0) {
            enterpriseBean = super.getBean();
            if (null == enterpriseBean) {
                try {
                    this.sizeLock.lock();
                    if (this.getMaxBeansInFreePool() <= this.currentSize.get()) {
                        enterpriseBean = super.getBean();
                        if (null == enterpriseBean) {
                            enterpriseBean = this.waitForBean(l);
                        }
                    } else {
                        this.incrementCurrentSize();
                    }
                    Object var5_3 = null;
                    this.sizeLock.unlock();
                }
                catch (Throwable throwable) {
                    Object var5_4 = null;
                    this.sizeLock.unlock();
                    throw throwable;
                }
            }
        } else {
            this.incrementCurrentSize();
        }
        if (null == enterpriseBean) {
            try {
                enterpriseBean = this.createBean();
                if (debugLogger.isDebugEnabled()) {
                    StatelessSessionPool.debug("allocate new: '" + enterpriseBean + "'");
                }
                Object var7_6 = null;
                if (enterpriseBean == null) {
                    this.decrementCurrentSize();
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (enterpriseBean == null) {
                    this.decrementCurrentSize();
                }
                throw throwable;
            }
        }
        this.getPoolRuntime().incrementBeansInUseCount();
        return enterpriseBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void removeBean(EnterpriseBean enterpriseBean) {
        this.decrementCurrentSize();
        boolean bl = this.setSegment();
        try {
            try {
                ((SessionBean)enterpriseBean).ejbRemove();
            }
            catch (RemoteException remoteException) {
                EJBLogger.logExceptionDuringEJBRemove((Throwable)remoteException);
                Object var5_4 = null;
                if (!bl) return;
                this.resetFile();
                return;
            }
            Object var5_3 = null;
            if (!bl) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!bl) throw throwable;
            this.resetFile();
            throw throwable;
        }
        this.resetFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected EnterpriseBean createBean() throws InternalException {
        SessionBean sessionBean = null;
        EJBObject eJBObject = null;
        BaseEJBLocalObjectIntf baseEJBLocalObjectIntf = null;
        Thread thread2 = Thread.currentThread();
        ClassLoader classLoader = thread2.getContextClassLoader();
        MethodInvocationHelper.pushMethodObject(this.beanInfo);
        this.setDir();
        int n = SubjectManager.getSubjectManager().getSize();
        boolean bl = this.setFile();
        try {
            block16: {
                try {
                    Method method;
                    if (this.remoteHome != null) {
                        eJBObject = this.remoteHome.allocateEO();
                    }
                    if (this.localHome != null) {
                        baseEJBLocalObjectIntf = this.localHome.allocateELO();
                    }
                    this.pushEnvironment();
                    ClassLoader classLoader2 = this.beanInfo.getModuleClassLoader();
                    thread2.setContextClassLoader(classLoader2);
                    sessionBean = (SessionBean)this.beanManager.createBean(eJBObject, baseEJBLocalObjectIntf);
                    if (this.beanInfo.isEJB30() && sessionBean instanceof __ProxyControl) {
                        try {
                            EJBContextManager.pushEjbContext(((WLSessionBean)sessionBean).__WL_getEJBContext());
                            ((__ProxyControl)sessionBean).invokeLifecycleMethod(LifecycleEvent.POST_CONSTRUCT);
                            Object var10_11 = null;
                            EJBContextManager.popEjbContext();
                        }
                        catch (Throwable throwable) {
                            Object var10_12 = null;
                            EJBContextManager.popEjbContext();
                            throw throwable;
                        }
                    }
                    if ((method = this.beanManager.getCreateMethod()) == null) break block16;
                    method.invoke((Object)sessionBean, (Object[])null);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new AssertionError((Object)"Stateless session bean threw IllegalAccessException when we invoked its ejbCreate()");
                }
                catch (InvocationTargetException invocationTargetException) {
                    Throwable throwable = invocationTargetException.getTargetException();
                    EJBRuntimeUtils.throwInternalException("Error in ejbCreate:", throwable);
                    Object var12_17 = null;
                    this.popEnvironment();
                    thread2.setContextClassLoader(classLoader);
                    if (bl) {
                        int n4 = SubjectManager.getSubjectManager().getSize();
                        while (n4-- > n) {
                            this.resetFile();
                        }
                    }
                    this.resetDir();
                    if (!MethodInvocationHelper.popMethodObject(this.beanInfo)) return sessionBean;
                    this.beanManager.handleUncommittedLocalTransaction("ejbCreate()", (EnterpriseBean)sessionBean);
                    return sessionBean;
                }
            }
            Object var12_16 = null;
            this.popEnvironment();
            thread2.setContextClassLoader(classLoader);
            if (bl) {
                int n3 = SubjectManager.getSubjectManager().getSize();
                while (n3-- > n) {
                    this.resetFile();
                }
            }
            this.resetDir();
            if (!MethodInvocationHelper.popMethodObject(this.beanInfo)) return sessionBean;
            this.beanManager.handleUncommittedLocalTransaction("ejbCreate()", (EnterpriseBean)sessionBean);
            return sessionBean;
        }
        catch (Throwable throwable) {
            Object var12_18 = null;
            this.popEnvironment();
            thread2.setContextClassLoader(classLoader);
            if (bl) {
                int n2 = SubjectManager.getSubjectManager().getSize();
                while (n2-- > n) {
                    this.resetFile();
                }
            }
            this.resetDir();
            if (!MethodInvocationHelper.popMethodObject(this.beanInfo)) throw throwable;
            this.beanManager.handleUncommittedLocalTransaction("ejbCreate()", (EnterpriseBean)sessionBean);
            throw throwable;
        }
    }

    public void destroyBean(EnterpriseBean enterpriseBean) {
        if (debugLogger.isDebugEnabled()) {
            StatelessSessionPool.debug("Destroying a bean in: '" + this + "'");
        }
        this.decrementCurrentSize();
        super.destroyBean(enterpriseBean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseBean(EnterpriseBean enterpriseBean) {
        try {
            this.sizeLock.lock();
            super.releaseBean(enterpriseBean);
            this.notEmpty.signal();
            Object var3_2 = null;
            this.sizeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.sizeLock.unlock();
            throw throwable;
        }
    }

    private EnterpriseBean waitForBean(long l) throws InternalException {
        EnterpriseBean enterpriseBean;
        if (debugLogger.isDebugEnabled()) {
            StatelessSessionPool.debug("Waiting for an instance in pool: '" + this + "'");
        }
        TimeUnit timeUnit = TimeUnit.MILLISECONDS;
        this.getPoolRuntime().incrementWaiterCount();
        long l2 = System.currentTimeMillis() + l;
        do {
            try {
                this.notEmpty.await(l2 - System.currentTimeMillis(), timeUnit);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (System.currentTimeMillis() < l2) continue;
            this.getPoolRuntime().decrementWaiterCount();
            this.getPoolRuntime().incrementTotalTimeoutCount();
            ++this.timeouts;
            throw new RuntimeException("An invocation of EJB " + this.beanInfo.getDisplayName() + " timed out while waiting to get an instance from the free pool.");
        } while (null == (enterpriseBean = super.getBean()));
        this.getPoolRuntime().decrementWaiterCount();
        return enterpriseBean;
    }

    public void reset() {
        this.beanClass = ((SessionBeanInfo)this.beanInfo).getGeneratedBeanClass();
        this.cleanup();
    }

    public void updateMaxBeansInFreePool(int n) {
        List list = super.resizePool(n);
        for (EnterpriseBean enterpriseBean : list) {
            this.removeBean(enterpriseBean);
        }
    }

    private static void debug(String string) {
        debugLogger.debug("[StatelessSessionPool] " + string);
    }

    private void decrementCurrentSize() {
        this.currentSize.decrementAndGet();
    }

    protected void incrementCurrentSize() {
        this.currentSize.incrementAndGet();
    }
}

