/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.replication;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.ejb.EJBException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.cluster.replication.ApplicationUnavailableException;
import weblogic.cluster.replication.ROID;
import weblogic.cluster.replication.Replicatable;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.replication.ReplicatedHome;
import weblogic.rmi.extensions.PortableRemoteObject;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;
import weblogic.utils.StackTraceUtils;

public class ReplicatedBean
implements Replicatable,
Externalizable {
    private static final long serialVersionUID = 3890747734666769086L;
    private static final DebugCategory DEBUG_APP_VERSION = Debug.getCategory((String)"weblogic.AppVersion");
    private static final boolean debug = DEBUG_APP_VERSION.isEnabled();
    protected String jndiName;
    private transient ReplicatedHome replicatedHome;

    public ReplicatedBean() {
    }

    public ReplicatedBean(String string) {
        this.jndiName = string;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.jndiName);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.jndiName = (String)objectInput.readObject();
    }

    protected ReplicatedHome getHome() {
        if (this.replicatedHome == null) {
            try {
                InitialContext initialContext = new InitialContext();
                Object object = PortableRemoteObject.narrow((Object)initialContext.lookup(this.jndiName), ReplicatedHome.class);
                this.replicatedHome = (ReplicatedHome)object;
            }
            catch (NamingException namingException) {
                EJBLogger.logClustersNotHomogeneous((String)this.jndiName);
                throw new EJBException((Exception)namingException);
            }
        }
        return this.replicatedHome;
    }

    public void becomePrimary(ROID rOID) {
        if (debug) {
            this.debug("** becomePrimary on :" + rOID);
        }
        try {
            this.getHome().becomePrimary(rOID);
        }
        catch (RemoteException remoteException) {
            EJBLogger.logFailureInReplication((String)StackTraceUtils.throwable2StackTrace((Throwable)remoteException));
        }
    }

    public Object becomeSecondary(ROID rOID) {
        if (debug) {
            this.debug("** becomeSecondary " + rOID);
        }
        try {
            return this.getHome().createSecondary(rOID);
        }
        catch (RemoteException remoteException) {
            EJBLogger.logClustersNotHomogeneous((String)this.jndiName.toString());
            throw new ApplicationUnavailableException(remoteException.toString());
        }
    }

    public void becomeUnregistered(ROID rOID) {
        try {
            this.getHome().removeSecondary(rOID);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void update(ROID rOID, Serializable serializable) {
        if (debug) {
            this.debug("*** Received update for key: " + rOID);
        }
        try {
            this.getHome().updateSecondary(rOID, serializable);
        }
        catch (RemoteException remoteException) {
            EJBLogger.logFailedToUpdateSecondaryDuringReplication((String)this.jndiName, (String)StackTraceUtils.throwable2StackTrace((Throwable)remoteException));
        }
    }

    public Object getKey() {
        return DEFAULT_KEY;
    }

    private void debug(String string) {
        HashMap hashMap = ApplicationVersionUtils.getDebugWorkContexts();
        Debug.say((String)(string + (hashMap == null ? "" : ", workCtxs=" + hashMap)));
    }
}

