/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.swap;

import com.oracle.pitchfork.interfaces.EnterpriseBeanProxy;
import com.oracle.pitchfork.spi.TargetWrapperImpl;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import weblogic.ejb.container.swap.BeanState;
import weblogic.utils.Debug;

public class BeanStateDiffChecker {
    private static final boolean debug = System.getProperty("weblogic.ejb.swap.debug") != null;
    private HashMap fields = new HashMap();

    public BeanStateDiffChecker(Class clazz) throws SecurityException {
        ArrayList arrayList = new ArrayList();
        while (clazz != null) {
            arrayList.add(clazz);
            clazz = clazz.getSuperclass();
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            AccessibleObject[] accessibleObjectArray = ((Class)arrayList.get(i)).getDeclaredFields();
            AccessibleObject.setAccessible(accessibleObjectArray, true);
            for (int j = 0; j < accessibleObjectArray.length; ++j) {
                if (Modifier.isTransient(((Field)accessibleObjectArray[j]).getModifiers())) continue;
                Class<?> clazz2 = ((Field)accessibleObjectArray[j]).getType();
                if (this.isValidClassForReplication(clazz2)) {
                    if (debug) {
                        Debug.say((String)("Adding field " + ((Field)accessibleObjectArray[j]).getName() + " of type " + clazz2.getName() + " to fields map"));
                    }
                    this.fields.put(new Key((Field)accessibleObjectArray[j]), accessibleObjectArray[j]);
                    continue;
                }
                if (!debug) continue;
                Debug.say((String)("The field " + ((Field)accessibleObjectArray[j]).getName() + " of type " + clazz2.getName() + " is not Serializable. It will not be replicated"));
            }
        }
    }

    private boolean isValidClassForReplication(Class clazz) {
        return Serializable.class.isAssignableFrom(clazz) || clazz.isPrimitive() || Map.class.isAssignableFrom(clazz) || Set.class.isAssignableFrom(clazz) || List.class.isAssignableFrom(clazz);
    }

    public ArrayList calculateDiff(Object object, BeanState beanState) throws IllegalAccessException, InstantiationException {
        if (object instanceof EnterpriseBeanProxy && (object = ((EnterpriseBeanProxy)object).getTarget()) instanceof TargetWrapperImpl) {
            object = ((TargetWrapperImpl)object).getBeanTarget();
        }
        ArrayList<Diff> arrayList = new ArrayList<Diff>();
        for (Field field : this.fields.values()) {
            Object object2 = beanState.get(field);
            Object object3 = field.get(object);
            if (object2 != null && object3 == null) {
                arrayList.add(new Diff(field, null));
                beanState.update(field, null);
                continue;
            }
            Diff diff = null;
            if (Map.class.isAssignableFrom(field.getType())) {
                diff = MapDiff.calculateDiff(object3, beanState, field);
            } else if (Set.class.isAssignableFrom(field.getType())) {
                diff = SetDiff.calculateDiff(object3, beanState, field);
            } else if (List.class.isAssignableFrom(field.getType())) {
                diff = ListDiff.calculateDiff(object3, beanState, field);
            } else if (!BeanStateDiffChecker.eq(object2, object3)) {
                diff = new Diff(field, object3);
                beanState.update(field, object3);
            }
            if (diff == null || diff.isEmpty()) continue;
            arrayList.add(diff);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList;
    }

    public void mergeDiff(BeanState beanState, ArrayList arrayList) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Key key = new Key();
        for (int i = 0; i < arrayList.size(); ++i) {
            Diff diff = (Diff)arrayList.get(i);
            key.set(diff.getClassName(), diff.getFieldName());
            Field field = (Field)this.fields.get(key);
            Object object = beanState.get(field);
            String string = diff.getFieldType();
            if (string == null) {
                beanState.update(field, null);
                continue;
            }
            diff.merge(beanState, object, field);
        }
    }

    public void setState(Object object, BeanState beanState) throws IllegalAccessException {
        for (Field field : this.fields.values()) {
            Object object2 = beanState.get(field);
            field.set(object, object2);
        }
    }

    private static boolean eq(Object object, Object object2) {
        if (object == null && object2 == null) {
            return true;
        }
        if (object != null) {
            return object.equals(object2);
        }
        return false;
    }

    public static void main(String[] stringArray) {
        try {
            TestClass testClass = new TestClass();
            BeanStateDiffChecker beanStateDiffChecker = new BeanStateDiffChecker(testClass.getClass());
            BeanState beanState = new BeanState();
            ArrayList arrayList = beanStateDiffChecker.calculateDiff(testClass, beanState);
            System.out.println("Diff:");
            for (int i = 0; i < arrayList.size(); ++i) {
                System.out.println(arrayList.get(i));
            }
            System.out.println("Source state:");
            System.out.println(beanState);
            BeanState beanState2 = new BeanState();
            beanStateDiffChecker.mergeDiff(beanState2, arrayList);
            System.out.println("Destination state:");
            System.out.println(beanState2);
            testClass.update();
            System.out.println("************bean updated**************");
            arrayList = beanStateDiffChecker.calculateDiff(testClass, beanState);
            for (int i = 0; i < arrayList.size(); ++i) {
                System.out.println(arrayList.get(i));
            }
            System.out.println("Source state:");
            System.out.println(beanState);
            beanStateDiffChecker.mergeDiff(beanState2, arrayList);
            System.out.println("Destination state:");
            System.out.println(beanState);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static class MyTest {
        String firstName = "UnknownFN";
        String lastName = "UnknownLN";
        int id = 1000;

        public void setFirstName(String string) {
            this.firstName = string;
        }

        public void setLastName(String string) {
            this.lastName = string;
        }

        public void setId(int n) {
            this.id = n;
        }

        public String toString() {
            return this.firstName + " " + this.lastName + " - " + this.id;
        }
    }

    private static class TestClass {
        private int iprim = 0;
        private String string = "string";
        private Integer iobj = new Integer(500);
        private Map map = new HashMap();
        private String string2;
        private Number d;
        private Set set;
        private List list;
        private MyTest test;

        public TestClass() {
            this.map.put("update", "new");
            this.map.put("remove", "remove");
            this.set = new HashSet();
            this.set.add("FirstOneInSet");
            this.set.add("SecondOneInSet");
            this.list = new ArrayList();
            this.list.add("FirstOneInList");
            this.list.add("SecondOneInList");
            this.string2 = "string2";
            this.d = null;
            this.test = new MyTest();
        }

        public void update() {
            this.iprim = 100;
            this.string = "newstring";
            this.map.put("new", "new");
            this.map.put("update", "updated");
            this.map.remove("remove");
            this.set.remove("FirstOneInSet");
            this.set.remove("SecondOneInSet");
            this.list.remove("SecondOneInList");
            this.list.remove("FirstOneInList");
            this.list = null;
            this.string2 = null;
            this.d = new Double(100.056);
            this.test.setId(2000);
            this.test.setFirstName("MyFirstName");
            this.test.setLastName("MyLastName");
            this.test = null;
        }
    }

    private static class Key {
        private String className;
        private String fieldName;

        public Key() {
        }

        public Key(Field field) {
            this.className = field.getDeclaringClass().getName();
            this.fieldName = field.getName();
        }

        public void set(String string, String string2) {
            this.className = string;
            this.fieldName = string2;
        }

        public int hashCode() {
            return this.className.hashCode() ^ this.fieldName.hashCode();
        }

        public boolean equals(Object object) {
            Key key = (Key)object;
            return key.className.equals(this.className) && key.fieldName.equals(this.fieldName);
        }
    }

    private static class ListDiff
    extends Diff
    implements Serializable {
        private int size;
        private HashMap modifiedEntries;

        public ListDiff(Field field, String string) {
            super(field);
            this.setFieldType(string);
        }

        public int getSize() {
            return this.size;
        }

        public HashMap getModifiedEntries() {
            return this.modifiedEntries;
        }

        public void addModified(int n, Object object) {
            if (this.modifiedEntries == null) {
                this.modifiedEntries = new HashMap();
            }
            this.modifiedEntries.put(new Integer(n), object);
        }

        public void setSize(int n) {
            this.size = n;
        }

        public void addAll(List list) {
            for (int i = 0; i < list.size(); ++i) {
                this.addModified(i, list.get(i));
            }
        }

        public boolean isEmpty() {
            return this.modifiedEntries == null || this.size == 0;
        }

        protected void merge(BeanState beanState, Object object, Field field) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
            if (object == null) {
                object = Class.forName(this.getFieldType()).newInstance();
                beanState.update(field, object);
            }
            List list = (List)object;
            if (this.modifiedEntries != null) {
                Set set = this.modifiedEntries.entrySet();
                for (Map.Entry entry : set) {
                    int n = (Integer)entry.getKey();
                    Object v = entry.getValue();
                    int n2 = list.size();
                    if (n2 < n + 1) {
                        for (int i = n2; i <= n; ++i) {
                            list.add(null);
                        }
                    }
                    list.set(n, v);
                }
            }
            for (int i = list.size(); i > this.size; --i) {
                list.remove(i - 1);
            }
        }

        static Diff calculateDiff(Object object, BeanState beanState, Field field) throws InstantiationException, IllegalAccessException {
            Object object2 = beanState.get(field);
            ListDiff listDiff = null;
            if (object2 == null && object != null) {
                int n = ((List)object).size();
                object2 = object.getClass().newInstance();
                beanState.update(field, object2);
                ListDiff listDiff2 = new ListDiff(field, object.getClass().getName());
                listDiff2.addAll((List)object);
                listDiff2.setSize(n);
                ((List)object2).addAll((List)object);
                listDiff = listDiff2;
            } else if (object2 != null && object != null) {
                listDiff = ListDiff.updateFieldStateForList(field, (List)object2, (List)object);
            }
            return listDiff;
        }

        private static ListDiff updateFieldStateForList(Field field, List list, List list2) {
            int n;
            ListDiff listDiff = new ListDiff(field, list2.getClass().getName());
            listDiff.setSize(list2.size());
            if (list.isEmpty()) {
                listDiff.addAll(list2);
                list.addAll(list2);
                return listDiff;
            }
            if (list2.isEmpty()) {
                list.clear();
                return listDiff;
            }
            int n2 = list2.size();
            boolean bl = false;
            if (list.size() < n2) {
                n2 = list.size();
                bl = true;
            }
            for (n = 0; n < n2; ++n) {
                if (BeanStateDiffChecker.eq(list.get(n), list2.get(n))) continue;
                listDiff.addModified(n, list2.get(n));
                list.set(n, list2.get(n));
            }
            if (bl) {
                for (n = n2; n < list2.size(); ++n) {
                    listDiff.addModified(n, list2.get(n));
                    list.add(n, list2.get(n));
                }
            }
            for (n = list.size() - list2.size(); n > 0; --n) {
                list.remove(list.size() - 1);
            }
            return listDiff;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Field: ").append(this.getClassName());
            stringBuffer.append(".").append(this.getFieldName()).append("\n");
            stringBuffer.append("Size : ").append(this.size).append("\n");
            stringBuffer.append("Type:  ").append(this.getFieldType()).append("\n");
            if (this.modifiedEntries != null && this.size > 0) {
                stringBuffer.append("New: ");
                Set set = this.modifiedEntries.entrySet();
                for (Map.Entry entry : set) {
                    stringBuffer.append(entry.getKey() + " : " + entry.getValue() + "\n");
                }
            }
            return stringBuffer.toString();
        }
    }

    private static class SetDiff
    extends Diff
    implements Serializable {
        private ArrayList newEntries;
        private ArrayList removedEntries;

        public SetDiff(Field field, String string) {
            super(field);
            this.setFieldType(string);
        }

        public ArrayList getNewEntries() {
            return this.newEntries;
        }

        public ArrayList getRemovedEntries() {
            return this.removedEntries;
        }

        public void addNew(Object object) {
            if (this.newEntries == null) {
                this.newEntries = new ArrayList();
            }
            this.newEntries.add(object);
        }

        public void addRemoved(Object object) {
            if (this.removedEntries == null) {
                this.removedEntries = new ArrayList();
            }
            this.removedEntries.add(object);
        }

        public void addAll(Set set) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                this.addNew(iterator.next());
            }
        }

        public void removeAll(Set set) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                this.addRemoved(iterator.next());
            }
        }

        public boolean isEmpty() {
            return !(this.newEntries != null && !this.newEntries.isEmpty() || this.removedEntries != null && !this.removedEntries.isEmpty());
        }

        protected void merge(BeanState beanState, Object object, Field field) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
            int n;
            if (object == null) {
                object = Class.forName(this.getFieldType()).newInstance();
                beanState.update(field, object);
            }
            Set set = (Set)object;
            if (this.newEntries != null) {
                for (n = 0; n < this.newEntries.size(); ++n) {
                    Object e = this.newEntries.get(n);
                    set.add(e);
                }
            }
            if (this.removedEntries != null) {
                for (n = 0; n < this.removedEntries.size(); ++n) {
                    set.remove(this.removedEntries.get(n));
                }
            }
        }

        static Diff calculateDiff(Object object, BeanState beanState, Field field) throws InstantiationException, IllegalAccessException {
            Object object2 = beanState.get(field);
            SetDiff setDiff = null;
            if (object2 == null && object != null) {
                object2 = object.getClass().newInstance();
                beanState.update(field, object2);
                SetDiff setDiff2 = new SetDiff(field, object.getClass().getName());
                setDiff2.addAll((Set)object);
                ((Set)object2).addAll((Set)object);
                setDiff = setDiff2;
            } else if (object2 != null && object != null) {
                setDiff = SetDiff.updateFieldStateForSet(field, (Set)object2, (Set)object);
            }
            return setDiff;
        }

        private static SetDiff updateFieldStateForSet(Field field, Set set, Set set2) {
            SetDiff setDiff = new SetDiff(field, set2.getClass().getName());
            if (set.isEmpty()) {
                setDiff.addAll(set2);
                set.addAll(set2);
                return setDiff;
            }
            if (set2.isEmpty()) {
                setDiff.removeAll(set);
                set.clear();
                return setDiff;
            }
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (set2.contains(e)) continue;
                setDiff.addRemoved(e);
                iterator.remove();
            }
            for (Object e : set2) {
                if (set.contains(e)) continue;
                setDiff.addNew(e);
                set.add(e);
            }
            return setDiff;
        }

        public String toString() {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Field: ").append(this.getClassName());
            stringBuffer.append(".").append(this.getFieldName()).append("\n");
            stringBuffer.append("Type:  ").append(this.getFieldType()).append("\n");
            if (this.newEntries != null && !this.newEntries.isEmpty()) {
                stringBuffer.append("New: ");
                for (n = 0; n < this.newEntries.size(); ++n) {
                    Object e = this.newEntries.get(n);
                    stringBuffer.append(e).append("\n");
                }
            }
            if (this.removedEntries != null && !this.removedEntries.isEmpty()) {
                stringBuffer.append("Removed: ");
                for (n = 0; n < this.removedEntries.size(); ++n) {
                    stringBuffer.append(this.removedEntries.get(n)).append("\n");
                }
            }
            return stringBuffer.toString();
        }
    }

    private static class MapDiff
    extends Diff
    implements Serializable {
        private ArrayList newEntries = new ArrayList();
        private ArrayList removedEntries;

        public MapDiff(Field field, String string) {
            super(field);
            this.setFieldType(string);
        }

        public ArrayList getNewEntries() {
            return this.newEntries;
        }

        public ArrayList getRemovedEntries() {
            return this.removedEntries;
        }

        public void addNew(Object object, Object object2) {
            if (this.newEntries == null) {
                this.newEntries = new ArrayList();
            }
            this.newEntries.add(new Object[]{object, object2});
        }

        public void addRemoved(Object object) {
            if (this.removedEntries == null) {
                this.removedEntries = new ArrayList();
            }
            this.removedEntries.add(object);
        }

        public void addAll(Map map) {
            for (Map.Entry entry : map.entrySet()) {
                this.addNew(entry.getKey(), entry.getValue());
            }
        }

        public void removeAll(Map map) {
            for (Map.Entry entry : map.entrySet()) {
                this.addRemoved(entry.getKey());
            }
        }

        public boolean isEmpty() {
            return !(this.newEntries != null && !this.newEntries.isEmpty() || this.removedEntries != null && !this.removedEntries.isEmpty());
        }

        protected void merge(BeanState beanState, Object object, Field field) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
            int n;
            if (object == null) {
                object = Class.forName(this.getFieldType()).newInstance();
                beanState.update(field, object);
            }
            Map map = (Map)object;
            if (this.newEntries != null) {
                for (n = 0; n < this.newEntries.size(); ++n) {
                    Object[] objectArray = (Object[])this.newEntries.get(n);
                    map.put(objectArray[0], objectArray[1]);
                }
            }
            if (this.removedEntries != null) {
                for (n = 0; n < this.removedEntries.size(); ++n) {
                    map.remove(this.removedEntries.get(n));
                }
            }
        }

        static Diff calculateDiff(Object object, BeanState beanState, Field field) throws IllegalAccessException, InstantiationException {
            Object object2 = beanState.get(field);
            MapDiff mapDiff = null;
            if (object2 == null && object != null) {
                object2 = object.getClass().newInstance();
                beanState.update(field, object2);
                MapDiff mapDiff2 = new MapDiff(field, object.getClass().getName());
                mapDiff2.addAll((Map)object);
                ((Map)object2).putAll((Map)object);
                mapDiff = mapDiff2;
            } else if (object2 != null && object != null) {
                mapDiff = MapDiff.updateFieldStateForMap(field, (Map)object2, (Map)object);
            }
            return mapDiff;
        }

        private static MapDiff updateFieldStateForMap(Field field, Map map, Map map2) {
            Object k;
            MapDiff mapDiff = new MapDiff(field, map2.getClass().getName());
            if (map.isEmpty()) {
                mapDiff.addAll(map2);
                map.putAll(map2);
                return mapDiff;
            }
            if (map2.isEmpty()) {
                mapDiff.removeAll(map);
                map.clear();
                return mapDiff;
            }
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                k = entry.getKey();
                if (map2.containsKey(k)) continue;
                mapDiff.addRemoved(k);
                iterator.remove();
            }
            for (Map.Entry entry : map2.entrySet()) {
                k = entry.getKey();
                Object v = entry.getValue();
                if (map.containsKey(k) && BeanStateDiffChecker.eq(v, map.get(k))) continue;
                mapDiff.addNew(entry.getKey(), entry.getValue());
                map.put(entry.getKey(), entry.getValue());
            }
            return mapDiff;
        }

        public String toString() {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Field: ").append(this.getClassName());
            stringBuffer.append(".").append(this.getFieldName()).append("\n");
            stringBuffer.append("Type:  ").append(this.getFieldType()).append("\n");
            if (this.newEntries != null && !this.newEntries.isEmpty()) {
                stringBuffer.append("New: ");
                for (n = 0; n < this.newEntries.size(); ++n) {
                    Object[] objectArray = (Object[])this.newEntries.get(n);
                    stringBuffer.append(objectArray[0]).append("-->").append(objectArray[1]).append("\n");
                }
            }
            if (this.removedEntries != null && !this.removedEntries.isEmpty()) {
                stringBuffer.append("Removed: ");
                for (n = 0; n < this.removedEntries.size(); ++n) {
                    stringBuffer.append(this.removedEntries.get(n)).append("\n");
                }
            }
            return stringBuffer.toString();
        }
    }

    private static class Diff
    implements Serializable {
        private String className;
        private String fieldName;
        private String fieldType;
        private Object value;

        protected Diff(Field field) {
            this.className = field.getDeclaringClass().getName();
            this.fieldName = field.getName();
        }

        public Diff(Field field, Object object) {
            this(field);
            this.value = object;
            if (object != null) {
                this.setFieldType(object.getClass().getName());
            }
        }

        protected void setFieldType(String string) {
            this.fieldType = string;
        }

        protected void merge(BeanState beanState, Object object, Field field) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
            beanState.update(field, this.value);
        }

        public Object get() {
            return this.value;
        }

        public String getClassName() {
            return this.className;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public String getFieldType() {
            return this.fieldType;
        }

        public boolean isEmpty() {
            return false;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Field: ").append(this.getClassName());
            stringBuffer.append(".").append(this.getFieldName()).append("\n");
            stringBuffer.append("Type:  ").append(this.getFieldType()).append("\n");
            stringBuffer.append("Value: ").append(this.get()).append("\n");
            return stringBuffer.toString();
        }
    }
}

