/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.swap;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import javax.ejb.EJBObject;
import javax.ejb.EnterpriseBean;
import javax.ejb.NoSuchEJBException;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.ejb.container.EJBDebugService;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.InternalException;
import weblogic.ejb.container.interfaces.BeanInfo;
import weblogic.ejb.container.interfaces.BeanManager;
import weblogic.ejb.container.interfaces.WLEnterpriseBean;
import weblogic.ejb.container.internal.EJBRuntimeUtils;
import weblogic.ejb.container.internal.SessionEJBContextImpl;
import weblogic.ejb.container.manager.StatefulSessionManager;
import weblogic.ejb.container.swap.EJBReplacer;
import weblogic.ejb.container.swap.EJBSwap;
import weblogic.ejb.container.swap.PassivationUtils;
import weblogic.rmi.extensions.activation.Activatable;
import weblogic.rmi.extensions.server.ServerHelper;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManager;
import weblogic.timers.TimerManagerFactory;
import weblogic.utils.AssertionError;
import weblogic.utils.FileUtils;
import weblogic.utils.collections.NumericValueHashtable;

public final class DiskSwap
implements EJBSwap,
TimerListener {
    private static final boolean debug = false;
    private static final boolean verbose = false;
    protected static final DebugLogger debugLogger = EJBDebugService.swappingLogger;
    private File dir;
    private long idleTimeoutMS;
    private long sessionTimeoutMS;
    private EJBReplacer replacer;
    private BeanManager beanManager;
    private PassivationUtils passivationUtils;
    private Timer timer;
    private NumericValueHashtable fileToOIDTable = new NumericValueHashtable();

    public DiskSwap(File file, long l, long l2) {
        this.dir = file;
        if (debugLogger.isDebugEnabled()) {
            DiskSwap.debug("idleTimeoutMS-" + l);
            DiskSwap.debug("sessionTimeoutMS-" + l2);
        }
        this.idleTimeoutMS = l;
        this.sessionTimeoutMS = l2;
        if (this.sessionTimeoutMS < this.idleTimeoutMS) {
            this.sessionTimeoutMS = l;
        }
        if (!this.dir.exists()) {
            boolean bl = this.dir.mkdirs();
            if (!bl) {
                throw new RuntimeException("Failed to create Stateful Session Persistence Directory: " + this.dir.getAbsolutePath());
            }
        } else {
            FileUtils.remove((File)this.dir, (FileFilter)FileUtils.STAR);
        }
    }

    public void timerExpired(Timer timer) {
        File[] fileArray = this.dir.listFiles();
        long l = System.currentTimeMillis();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file = fileArray[i];
                if (Math.abs(file.lastModified() - l) <= this.sessionTimeoutMS) continue;
                if (debugLogger.isDebugEnabled()) {
                    DiskSwap.debug("timerExpired: removing file from swap-" + file.getName());
                }
                file.delete();
                int n = (int)this.fileToOIDTable.remove((Object)file);
                if (n == 0) continue;
                try {
                    ServerHelper.unexportObject((int)n);
                    continue;
                }
                catch (NoSuchObjectException noSuchObjectException) {
                    // empty catch block
                }
            }
        }
    }

    private String keyToFileName(Object object) {
        return object.toString() + ".db";
    }

    public void setup(BeanInfo beanInfo, BeanManager beanManager, ClassLoader classLoader) {
        this.replacer = new EJBReplacer();
        this.passivationUtils = new PassivationUtils(classLoader);
        this.beanManager = beanManager;
        this.startIdleTimeout(this.idleTimeoutMS);
    }

    private void startIdleTimeout(long l) {
        if (this.idleTimeoutMS > 0L) {
            TimerManagerFactory timerManagerFactory = TimerManagerFactory.getTimerManagerFactory();
            TimerManager timerManager = timerManagerFactory.getDefaultTimerManager();
            this.timer = timerManager.scheduleAtFixedRate((TimerListener)this, this.idleTimeoutMS, l);
        }
    }

    private void stopIdleTimeout() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    public void cancelTrigger() {
        this.stopIdleTimeout();
        if (this.dir.exists()) {
            FileUtils.remove((File)this.dir);
        }
    }

    public void remove(Object object) {
        File file = new File(this.dir, this.keyToFileName(object));
        if (debugLogger.isDebugEnabled()) {
            DiskSwap.debug("removing file from swap-" + file.getName());
        }
        file.delete();
        this.fileToOIDTable.remove((Object)file);
    }

    /*
     * Loose catch block
     */
    public EnterpriseBean read(Object object) throws InternalException {
        EnterpriseBean enterpriseBean;
        String string = this.keyToFileName(object);
        File file = new File(this.dir, string);
        FileInputStream fileInputStream = null;
        if (debugLogger.isDebugEnabled()) {
            DiskSwap.debug("reading file from swap-" + file.getName());
        }
        fileInputStream = new FileInputStream(file);
        EnterpriseBean enterpriseBean2 = enterpriseBean = this.passivationUtils.read(this.beanManager, fileInputStream, object);
        Object var8_9 = null;
        try {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        file.delete();
        this.fileToOIDTable.remove((Object)file);
        return enterpriseBean2;
        catch (IOException iOException) {
            try {
                NoSuchEJBException noSuchEJBException = new NoSuchEJBException("Bean has been deleted.");
                if (debugLogger.isDebugEnabled()) {
                    DiskSwap.debug("key not found in swap-" + object);
                    EJBLogger.logStackTraceAndMessage((String)iOException.getMessage(), (Throwable)iOException);
                }
                EJBRuntimeUtils.throwInternalException("Error during read.", (Throwable)noSuchEJBException);
                throw new AssertionError("Should not reach.");
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                file.delete();
                this.fileToOIDTable.remove((Object)file);
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(Object object, Object object2) throws InternalException {
        String string = this.keyToFileName(object);
        FileOutputStream fileOutputStream = null;
        if (debugLogger.isDebugEnabled()) {
            DiskSwap.debug("writing file to swap-" + string);
        }
        try {
            try {
                File file = new File(this.dir, string);
                fileOutputStream = new FileOutputStream(file);
                this.passivationUtils.write(this.beanManager, fileOutputStream, object, object2);
                this.addToFileToOidTable(file, object2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                EJBRuntimeUtils.throwInternalException("Error in write.", fileNotFoundException);
                throw new AssertionError("Should not reach.");
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                if (fileOutputStream == null) throw throwable;
                fileOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        if (fileOutputStream == null) return;
        fileOutputStream.close();
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToFileToOidTable(File file, Object object) {
        int n = 0;
        try {
            WLEnterpriseBean wLEnterpriseBean = (WLEnterpriseBean)object;
            int n2 = wLEnterpriseBean.__WL_getMethodState();
            wLEnterpriseBean.__WL_setMethodState(128);
            EJBObject eJBObject = null;
            try {
                try {
                    eJBObject = ((SessionEJBContextImpl)wLEnterpriseBean.__WL_getEJBContext()).getEJBObject();
                }
                catch (IllegalStateException illegalStateException) {
                    Object var9_9 = null;
                    wLEnterpriseBean.__WL_setMethodState(n2);
                    return;
                }
                Object var9_8 = null;
                wLEnterpriseBean.__WL_setMethodState(n2);
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                wLEnterpriseBean.__WL_setMethodState(n2);
                throw throwable;
            }
            if (eJBObject != null && ((StatefulSessionManager)this.beanManager).isInMemoryReplication() && !(eJBObject instanceof Activatable)) {
                n = ServerHelper.getObjectId((Remote)eJBObject);
                this.fileToOIDTable.put((Object)file, (long)n);
            }
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
    }

    public void updateClassLoader(ClassLoader classLoader) {
        this.passivationUtils.updateClassLoader(classLoader);
    }

    public void updateIdleTimeoutMS(long l) {
        long l2 = 0L;
        if (this.timer != null) {
            long l3 = this.timer.getTimeout();
            this.stopIdleTimeout();
            l2 = l3 - System.currentTimeMillis();
            if (l2 < 0L) {
                l2 = 0L;
            }
            if (l < l2) {
                l2 = l;
            }
        } else {
            l2 = l;
        }
        this.idleTimeoutMS = l;
        if (this.sessionTimeoutMS < this.idleTimeoutMS) {
            this.sessionTimeoutMS = this.idleTimeoutMS;
        }
        this.startIdleTimeout(l2);
    }

    private static void debug(String string) {
        debugLogger.debug("[DiskSwap] " + string);
    }
}

