/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.swap;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.ejb.EJBContext;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManagerFactory;
import javax.transaction.UserTransaction;
import weblogic.deployment.EntityManagerFactoryProxyImpl;
import weblogic.deployment.EntityManagerInvocationHandlerFactory;
import weblogic.deployment.PersistenceUnitInfoImpl;
import weblogic.deployment.PersistenceUnitRegistry;
import weblogic.deployment.TransactionalEntityManagerProxyImpl;
import weblogic.ejb.container.deployer.EJBModule;
import weblogic.ejb.container.internal.BaseEJBLocalHome;
import weblogic.ejb.container.internal.BaseLocalObject;
import weblogic.ejb.container.swap.TransactionalEntityManagerProxyReplacer;
import weblogic.ejb20.internal.LocalHandleImpl;
import weblogic.ejb20.internal.LocalHomeHandleImpl;
import weblogic.ejb20.swap.EJBReplacer;
import weblogic.ejb20.swap.HandleReplacer;
import weblogic.ejb20.swap.HomeHandleReplacer;
import weblogic.rmi.utils.io.RemoteObjectReplacer;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityManager;
import weblogic.utils.AssertionError;
import weblogic.utils.io.Replacer;

final class EJBReplacer
implements Replacer {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final boolean debug = false;
    private static final boolean verbose = false;
    private static final Replacer remoteReplacer = RemoteObjectReplacer.getReplacer();
    private EJBContext ctx = null;
    private UserTransaction utx = null;

    void setContext(EJBContext eJBContext) {
        this.ctx = eJBContext;
    }

    public Object replaceObject(Object object) throws IOException {
        if (object instanceof EJBObject) {
            final EJBObject eJBObject = (EJBObject)object;
            try {
                return SecurityManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)kernelId, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return new HandleReplacer(eJBObject.getHandle());
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                IOException iOException = new IOException("Exception while replacing EO");
                iOException.initCause(privilegedActionException.getException());
                throw iOException;
            }
        }
        if (object instanceof EJBLocalObject) {
            BaseLocalObject baseLocalObject = (BaseLocalObject)object;
            return baseLocalObject.getLocalHandleObject();
        }
        if (object instanceof EJBHome) {
            final EJBHome eJBHome = (EJBHome)object;
            try {
                return SecurityManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)kernelId, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return new HomeHandleReplacer(eJBHome.getHomeHandle());
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                IOException iOException = new IOException("Exception while replacing Home");
                iOException.initCause(privilegedActionException.getException());
                throw iOException;
            }
        }
        if (object instanceof EJBLocalHome) {
            BaseEJBLocalHome baseEJBLocalHome = (BaseEJBLocalHome)object;
            return baseEJBLocalHome.getLocalHomeHandleObject();
        }
        if (object instanceof EJBContext) {
            return new EJBReplacer.EJBContextReplacement();
        }
        if (object instanceof Context) {
            Context context = (Context)object;
            try {
                String string = context.getNameInNamespace();
                if (string.indexOf("comp/env") > 0 || string.indexOf("comp.env") > 0) {
                    return new EJBReplacer.EnvironmentContextReplacement(string);
                }
                return object;
            }
            catch (NamingException namingException) {
                return object;
            }
        }
        if (object instanceof TransactionalEntityManagerProxyImpl) {
            TransactionalEntityManagerProxyImpl transactionalEntityManagerProxyImpl = (TransactionalEntityManagerProxyImpl)object;
            return new TransactionalEntityManagerProxyReplacer(transactionalEntityManagerProxyImpl.getAppName(), transactionalEntityManagerProxyImpl.getModuleName(), transactionalEntityManagerProxyImpl.getUnqualifiedUnitName());
        }
        if (object instanceof EntityManagerFactoryProxyImpl) {
            EntityManagerFactoryProxyImpl entityManagerFactoryProxyImpl = (EntityManagerFactoryProxyImpl)object;
            return new EntityManagerFactoryReplacement(entityManagerFactoryProxyImpl.getAppName(), entityManagerFactoryProxyImpl.getModuleName(), entityManagerFactoryProxyImpl.getUnitName());
        }
        if (object instanceof UserTransaction) {
            return new EJBReplacer.UserTransactionReplacement();
        }
        return remoteReplacer.replaceObject(remoteReplacer.replaceObject(object));
    }

    public Object resolveObject(Object object) throws IOException {
        if (object instanceof HandleReplacer) {
            HandleReplacer handleReplacer = (HandleReplacer)object;
            return handleReplacer.getHandle().getEJBObject();
        }
        if (object instanceof HomeHandleReplacer) {
            HomeHandleReplacer homeHandleReplacer = (HomeHandleReplacer)object;
            return homeHandleReplacer.getHomeHandle().getEJBHome();
        }
        if (object instanceof LocalHandleImpl) {
            LocalHandleImpl localHandleImpl = (LocalHandleImpl)object;
            return localHandleImpl.getEJBLocalObject();
        }
        if (object instanceof LocalHomeHandleImpl) {
            LocalHomeHandleImpl localHomeHandleImpl = (LocalHomeHandleImpl)object;
            return localHomeHandleImpl.getEJBLocalHome();
        }
        if (object instanceof EJBReplacer.EJBContextReplacement) {
            return this.ctx;
        }
        if (object instanceof EJBReplacer.EnvironmentContextReplacement) {
            EJBReplacer.EnvironmentContextReplacement environmentContextReplacement = (EJBReplacer.EnvironmentContextReplacement)object;
            String string = environmentContextReplacement.getName();
            string = "java:" + string;
            try {
                InitialContext initialContext = new InitialContext();
                return initialContext.lookup(string);
            }
            catch (NamingException namingException) {
                throw new AssertionError("Unexpected Exception during activation: " + namingException);
            }
        }
        if (object instanceof TransactionalEntityManagerProxyReplacer) {
            TransactionalEntityManagerProxyReplacer transactionalEntityManagerProxyReplacer = (TransactionalEntityManagerProxyReplacer)object;
            String string = transactionalEntityManagerProxyReplacer.getAppName();
            String string2 = transactionalEntityManagerProxyReplacer.getModuleName();
            String string3 = transactionalEntityManagerProxyReplacer.getUnitName();
            EJBModule eJBModule = EJBModule.findModule(string, string2);
            return EntityManagerInvocationHandlerFactory.createTransactionalEntityManagerInvocationHandler(string, string2, string3, eJBModule.getPersistenceUnitRegistry());
        }
        if (object instanceof EntityManagerFactoryReplacement) {
            EntityManagerFactoryReplacement entityManagerFactoryReplacement = (EntityManagerFactoryReplacement)object;
            String string = entityManagerFactoryReplacement.getAppName();
            String string4 = entityManagerFactoryReplacement.getModuleName();
            String string5 = entityManagerFactoryReplacement.getUnitName();
            EJBModule eJBModule = EJBModule.findModule(string, string4);
            PersistenceUnitRegistry persistenceUnitRegistry = eJBModule.getPersistenceUnitRegistry();
            PersistenceUnitInfoImpl persistenceUnitInfoImpl = persistenceUnitRegistry.getPersistenceUnit(string5);
            EntityManagerFactory entityManagerFactory = persistenceUnitInfoImpl.getEntityManagerFactory();
            EntityManagerFactoryProxyImpl entityManagerFactoryProxyImpl = (EntityManagerFactoryProxyImpl)Proxy.getInvocationHandler(entityManagerFactory);
            return entityManagerFactoryProxyImpl;
        }
        if (object instanceof EJBReplacer.UserTransactionReplacement) {
            if (this.utx == null) {
                try {
                    InitialContext initialContext = new InitialContext();
                    this.utx = (UserTransaction)initialContext.lookup("javax.transaction.UserTransaction");
                }
                catch (NamingException namingException) {
                    throw new AssertionError("Unexpected Exception during activation: " + namingException);
                }
            }
            return this.utx;
        }
        return remoteReplacer.resolveObject(object);
    }

    public void insertReplacer(Replacer replacer) {
    }

    public static class EntityManagerFactoryReplacement
    implements Serializable {
        private String appName;
        private String moduleName;
        private String unitName;

        public EntityManagerFactoryReplacement(String string, String string2, String string3) {
            this.appName = string;
            this.moduleName = string2;
            this.unitName = string3;
        }

        public String getAppName() {
            return this.appName;
        }

        public String getModuleName() {
            return this.moduleName;
        }

        public String getUnitName() {
            return this.unitName;
        }
    }
}

