/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.swap;

import com.oracle.pitchfork.interfaces.EnterpriseBeanProxy;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.ejb.EJBContext;
import javax.ejb.EnterpriseBean;
import javax.ejb.NoSuchEJBException;
import weblogic.common.internal.ReplacerObjectInputStream;
import weblogic.common.internal.ReplacerObjectOutputStream;
import weblogic.ejb.container.InternalException;
import weblogic.ejb.container.interfaces.BeanInfo;
import weblogic.ejb.container.interfaces.BeanManager;
import weblogic.ejb.container.interfaces.Ejb3SessionBeanInfo;
import weblogic.ejb.container.interfaces.SessionBeanInfo;
import weblogic.ejb.container.interfaces.WLEJBContext;
import weblogic.ejb.container.interfaces.WLSessionEJBContext;
import weblogic.ejb.container.internal.EJBRuntimeUtils;
import weblogic.ejb.container.manager.StatefulSessionManager;
import weblogic.ejb.container.swap.EJBReplacer;
import weblogic.protocol.ServerChannelManager;
import weblogic.utils.AssertionError;
import weblogic.utils.StackTraceUtils;
import weblogic.utils.io.ClassLoaderResolver;
import weblogic.utils.io.Resolver;

final class PassivationUtils {
    private Resolver resolver;

    PassivationUtils(ClassLoader classLoader) {
        this.resolver = new ClassLoaderResolver(classLoader);
    }

    EnterpriseBean read(BeanManager beanManager, InputStream inputStream, Object object) throws InternalException {
        try {
            EJBReplacer eJBReplacer = new EJBReplacer();
            EJBContext eJBContext = beanManager.allocateContext(null, object);
            eJBReplacer.setContext(eJBContext);
            ReplacerObjectInputStream replacerObjectInputStream = new ReplacerObjectInputStream(inputStream, eJBReplacer, this.resolver);
            Object object2 = replacerObjectInputStream.readObject();
            replacerObjectInputStream.close();
            BeanInfo beanInfo = beanManager.getBeanInfo();
            object2 = ((StatefulSessionManager)beanManager).assembleEJB3Proxy(object2, beanInfo);
            if (!(object2 instanceof EnterpriseBean)) {
                throw new AssertionError("Deserialized stateful session bean with key: " + object + " but class was" + object2.getClass().getName());
            }
            ((WLEJBContext)eJBContext).setBean((EnterpriseBean)object2);
            if (beanInfo instanceof Ejb3SessionBeanInfo && beanManager instanceof StatefulSessionManager) {
                ((WLSessionEJBContext)eJBContext).setPrimaryKey(object);
            }
            return (EnterpriseBean)object2;
        }
        catch (IOException iOException) {
            EJBRuntimeUtils.throwInternalException("Error during read.", (Throwable)new NoSuchEJBException("Activation failed with: " + StackTraceUtils.throwable2StackTrace((Throwable)iOException)));
            throw new AssertionError("Should not reach.");
        }
        catch (ClassNotFoundException classNotFoundException) {
            EJBRuntimeUtils.throwInternalException("Error during read.", (Throwable)new NoSuchEJBException("Activation failed with: " + StackTraceUtils.throwable2StackTrace((Throwable)classNotFoundException)));
            throw new AssertionError("Should not reach.");
        }
    }

    void write(BeanManager beanManager, OutputStream outputStream, Object object, Object object2) throws InternalException {
        try {
            SessionBeanInfo sessionBeanInfo = (SessionBeanInfo)beanManager.getBeanInfo();
            if (sessionBeanInfo instanceof Ejb3SessionBeanInfo) {
                object2 = ((EnterpriseBeanProxy)object2).getTarget();
            }
            EJBReplacer eJBReplacer = new EJBReplacer();
            ReplacerObjectOutputStream replacerObjectOutputStream = new ReplacerObjectOutputStream(outputStream, eJBReplacer);
            replacerObjectOutputStream.setServerChannel(ServerChannelManager.findDefaultLocalServerChannel());
            replacerObjectOutputStream.writeObject(object2);
        }
        catch (IOException iOException) {
            EJBRuntimeUtils.throwInternalException("Error during write.", iOException);
        }
    }

    public void updateClassLoader(ClassLoader classLoader) {
        this.resolver = new ClassLoaderResolver(classLoader);
    }
}

