/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.swap;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.ejb.EJBContext;
import javax.ejb.EnterpriseBean;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import weblogic.cluster.replication.ROID;
import weblogic.cluster.replication.Replicatable;
import weblogic.cluster.replication.ReplicationManager;
import weblogic.cluster.replication.ReplicationServices;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.InternalException;
import weblogic.ejb.container.interfaces.BeanInfo;
import weblogic.ejb.container.interfaces.BeanManager;
import weblogic.ejb.container.interfaces.SessionBeanInfo;
import weblogic.ejb.container.interfaces.WLEnterpriseBean;
import weblogic.ejb.container.manager.StatefulSessionManager;
import weblogic.ejb.container.swap.BeanState;
import weblogic.ejb.container.swap.BeanStateDiffChecker;
import weblogic.ejb.container.swap.DiskSwap;
import weblogic.ejb.container.swap.EJBSwap;
import weblogic.ejb.container.swap.PassivationUtils;
import weblogic.rmi.cluster.PrimarySecondaryRemoteObject;
import weblogic.utils.ByteArrayDiff;
import weblogic.utils.ByteArrayDiffChecker;
import weblogic.utils.Debug;
import weblogic.utils.io.UnsyncByteArrayInputStream;

public final class ReplicatedMemorySwap
implements EJBSwap {
    private static final boolean debug = System.getProperty("weblogic.ejb.swap.debug") != null;
    private PassivationUtils passivationUtils;
    private ReplicationServices repServ = null;
    private Map previousVersionMap = new ConcurrentHashMap();
    private Map secondaryBeanMap = new ConcurrentHashMap();
    private Map primaryROMap = new ConcurrentHashMap();
    private Map secondaryROMap = new ConcurrentHashMap();
    private EJBSwap diskSwap;
    private DiffChecker diffChecker;
    private StatefulSessionManager beanManager;
    private SessionBeanInfo beanInfo;

    private ReplicationServices getRepServ() {
        if (this.repServ == null) {
            this.repServ = ReplicationManager.services();
        }
        return this.repServ;
    }

    public void setup(BeanInfo beanInfo, BeanManager beanManager, ClassLoader classLoader) {
        this.beanManager = (StatefulSessionManager)beanManager;
        this.beanInfo = (SessionBeanInfo)beanInfo;
        this.passivationUtils = new PassivationUtils(classLoader);
        this.diskSwap = new DiskSwap(new File(this.beanManager.getSwapDirectoryName()), this.beanInfo.getIdleTimeoutMS(), this.beanInfo.getSessionTimeoutMS());
        this.diskSwap.setup(beanInfo, beanManager, classLoader);
        this.diffChecker = this.getDiffChecker(this.beanInfo);
    }

    public synchronized EnterpriseBean read(Object object) throws InternalException {
        Object v = this.secondaryBeanMap.remove(object);
        if (v == null) {
            return this.diskSwap.read(object);
        }
        return this.diffChecker.read(object, v);
    }

    public void remove(Object object) {
        if (this.secondaryROMap.remove(object) == null) {
            this.getRepServ().unregister((ROID)object, Replicatable.DEFAULT_KEY);
        }
        this.secondaryBeanMap.remove(object);
        this.primaryROMap.remove(object);
        this.previousVersionMap.remove(object);
    }

    public void becomePrimary(Object object) {
        if (debug) {
            Debug.say((String)(" ** becomePrimary with key: " + object));
        }
        if (this.secondaryROMap.get(object) != null) {
            if (debug) {
                Debug.say((String)(" ** becomePrimary on old secondary with key: " + object));
            }
            this.primaryROMap.put(object, this.secondaryROMap.remove(object));
        }
    }

    public void savePrimaryRO(Object object, Object object2) {
        if (debug) {
            Debug.say((String)(" savePrimaryRO " + object));
        }
        this.primaryROMap.put(object, object2);
    }

    public void saveSecondaryRO(Object object, Object object2) {
        this.secondaryROMap.put(object, object2);
    }

    public void receiveUpdate(Object object, Object object2) throws InternalException {
        if (debug) {
            Debug.say((String)("** Received update for pk: " + object));
        }
        this.diffChecker.receiveUpdate(object, object2);
    }

    public void sendUpdate(Object object, Object object2) throws InternalException {
        if (debug) {
            Debug.say((String)("**  Sending an update for : " + object));
        }
        Serializable serializable = this.diffChecker.getDiff(object, object2);
        try {
            Remote remote;
            PrimarySecondaryRemoteObject primarySecondaryRemoteObject = (PrimarySecondaryRemoteObject)this.primaryROMap.get(object);
            Remote remote2 = null;
            if (primarySecondaryRemoteObject != null) {
                remote2 = primarySecondaryRemoteObject.getSecondary();
            }
            if (remote2 != (remote = (Remote)this.getRepServ().updateSecondary((ROID)object, serializable, Replicatable.DEFAULT_KEY))) {
                if (debug) {
                    Debug.say((String)"New secondary created");
                }
                primarySecondaryRemoteObject.changeSecondary(remote);
                this.getRepServ().updateSecondary((ROID)object, this.diffChecker.getCompleteDiff(object, object2), Replicatable.DEFAULT_KEY);
            }
        }
        catch (Exception exception) {
            this.previousVersionMap.remove(object);
            if (this.beanInfo.isEJB30()) {
                EJBLogger.logFailedToUpdateSecondaryFromBusiness((String)this.beanManager.getEJBHome().getDisplayName());
            }
            EJBLogger.logFailedToUpdateSecondary((String)this.beanManager.getEJBHome().getDisplayName());
        }
    }

    public void write(Object object, Object object2) throws InternalException {
        this.secondaryBeanMap.remove(object);
        this.primaryROMap.remove(object);
        this.secondaryROMap.remove(object);
        this.previousVersionMap.remove(object);
        this.diskSwap.write(object, object2);
    }

    public void updateClassLoader(ClassLoader classLoader) {
        this.diskSwap.updateClassLoader(classLoader);
        this.passivationUtils.updateClassLoader(classLoader);
    }

    public void updateIdleTimeoutMS(long l) {
        this.diskSwap.updateIdleTimeoutMS(l);
    }

    public void cancelTrigger() {
    }

    private DiffChecker getDiffChecker(SessionBeanInfo sessionBeanInfo) {
        if (sessionBeanInfo.getCalculateDeltaUsingReflection()) {
            if (debug) {
                Debug.say((String)"Bean changes will be calculated using reflection");
            }
            return new BeanStateChecker(sessionBeanInfo.getBeanClass());
        }
        if (debug) {
            Debug.say((String)"Bean changes will be calculated using byte comparison");
        }
        return new ByteLevelChecker();
    }

    private static interface DiffChecker {
        public EnterpriseBean read(Object var1, Object var2) throws InternalException;

        public void receiveUpdate(Object var1, Object var2) throws InternalException;

        public Serializable getDiff(Object var1, Object var2) throws InternalException;

        public Serializable getCompleteDiff(Object var1, Object var2) throws InternalException;
    }

    private class ByteLevelChecker
    implements DiffChecker {
        private ByteLevelChecker() {
        }

        public EnterpriseBean read(Object object, Object object2) throws InternalException {
            UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream((byte[])object2);
            return ReplicatedMemorySwap.this.passivationUtils.read(ReplicatedMemorySwap.this.beanManager, (InputStream)unsyncByteArrayInputStream, object);
        }

        public void receiveUpdate(Object object, Object object2) {
            byte[] byArray = (byte[])ReplicatedMemorySwap.this.secondaryBeanMap.get(object);
            if (object2 instanceof ByteArrayDiff) {
                ByteArrayDiff byteArrayDiff = (ByteArrayDiff)object2;
                byArray = byteArrayDiff.applyDiff(byArray);
            } else {
                byArray = (byte[])object2;
            }
            ReplicatedMemorySwap.this.secondaryBeanMap.put(object, byArray);
        }

        public Serializable getDiff(Object object, Object object2) throws InternalException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ReplicatedMemorySwap.this.passivationUtils.write(ReplicatedMemorySwap.this.beanManager, byteArrayOutputStream, object, object2);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byte[] byArray2 = ReplicatedMemorySwap.this.previousVersionMap.put(object, byArray);
            return new ByteArrayDiffChecker().diffByteArrays(byArray2, byArray);
        }

        public Serializable getCompleteDiff(Object object, Object object2) throws InternalException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ReplicatedMemorySwap.this.passivationUtils.write(ReplicatedMemorySwap.this.beanManager, byteArrayOutputStream, object, object2);
            return byteArrayOutputStream.toByteArray();
        }
    }

    private class BeanStateChecker
    implements DiffChecker {
        BeanStateDiffChecker delegate;

        BeanStateChecker(Class clazz) {
            this.delegate = new BeanStateDiffChecker(clazz);
        }

        public EnterpriseBean read(Object object, Object object2) throws InternalException {
            try {
                EnterpriseBean enterpriseBean = ReplicatedMemorySwap.this.beanManager.allocateBean();
                EJBContext eJBContext = ReplicatedMemorySwap.this.beanManager.allocateContext(null, object);
                ((SessionBean)enterpriseBean).setSessionContext((SessionContext)eJBContext);
                ((WLEnterpriseBean)enterpriseBean).__WL_setEJBContext(eJBContext);
                this.delegate.setState(enterpriseBean, (BeanState)object2);
                return enterpriseBean;
            }
            catch (Exception exception) {
                throw new InternalException("Error creating replicated bean", exception);
            }
        }

        public void receiveUpdate(Object object, Object object2) throws InternalException {
            try {
                BeanState beanState;
                ArrayList arrayList = (ArrayList)object2;
                if (debug) {
                    Debug.say((String)("Received update with diff " + arrayList));
                }
                if ((beanState = (BeanState)ReplicatedMemorySwap.this.secondaryBeanMap.get(object)) == null) {
                    beanState = new BeanState();
                    ReplicatedMemorySwap.this.secondaryBeanMap.put(object, beanState);
                }
                this.delegate.mergeDiff(beanState, arrayList);
            }
            catch (Exception exception) {
                throw new InternalException("Error while processing bean update", exception);
            }
        }

        public Serializable getDiff(Object object, Object object2) throws InternalException {
            ArrayList arrayList = null;
            try {
                BeanState beanState = (BeanState)ReplicatedMemorySwap.this.previousVersionMap.get(object);
                if (beanState == null) {
                    beanState = new BeanState();
                    ReplicatedMemorySwap.this.previousVersionMap.put(object, beanState);
                }
                arrayList = this.delegate.calculateDiff(object2, beanState);
            }
            catch (Exception exception) {
                throw new InternalException("Error while calculating diff", exception);
            }
            if (debug) {
                Debug.say((String)("Calculated diff " + arrayList));
            }
            return arrayList;
        }

        public Serializable getCompleteDiff(Object object, Object object2) throws InternalException {
            ArrayList arrayList = null;
            BeanState beanState = new BeanState();
            try {
                arrayList = this.delegate.calculateDiff(object2, beanState);
            }
            catch (Exception exception) {
                throw new InternalException("Error while calculating diff", exception);
            }
            return arrayList;
        }
    }
}

