/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.timer;

import java.io.Serializable;
import java.util.Date;
import javax.ejb.Timer;
import javax.ejb.TimerHandle;
import javax.naming.Context;
import javax.naming.NamingException;
import weblogic.application.ApplicationAccess;
import weblogic.application.ApplicationContextInternal;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.ejb.container.EJBDebugService;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.interfaces.BeanInfo;
import weblogic.ejb.container.interfaces.DeploymentInfo;
import weblogic.ejb.container.interfaces.TimerHandler;
import weblogic.ejb.container.interfaces.TimerIntf;
import weblogic.ejb.container.timer.ClusteredTimerHandleImpl;
import weblogic.scheduler.ejb.EJBTimerListener;
import weblogic.transaction.TxHelper;

public final class ClusteredTimerImpl
implements Timer,
TimerIntf,
EJBTimerListener {
    private static final DebugLogger debugLogger = EJBDebugService.timerLogger;
    private Object pk;
    private Serializable info;
    private boolean isTransactional;
    private String appName;
    private String jarName;
    private String ejbName;
    private transient weblogic.scheduler.Timer timer;

    public ClusteredTimerImpl(Object object, Serializable serializable, boolean bl, BeanInfo beanInfo) {
        this.pk = object;
        this.info = serializable;
        this.isTransactional = bl;
        DeploymentInfo deploymentInfo = beanInfo.getDeploymentInfo();
        this.appName = deploymentInfo.getApplicationName();
        this.jarName = deploymentInfo.getModuleURI();
        this.ejbName = beanInfo.getEJBName();
    }

    public void initialize(weblogic.timers.Timer timer) {
        this.timer = (weblogic.scheduler.Timer)timer;
    }

    public void timerExpired(weblogic.timers.Timer timer) {
        block4: {
            this.initialize(timer);
            ApplicationContextInternal applicationContextInternal = ApplicationAccess.getApplicationAccess().getApplicationContext(this.appName);
            Context context = applicationContextInternal.getEnvContext();
            try {
                TimerHandler timerHandler = (TimerHandler)context.lookup("ejb/" + this.jarName + "#" + this.ejbName + "/timerHandler");
                timerHandler.executeTimer(this);
            }
            catch (NamingException namingException) {
                EJBLogger.logClusteredTimerFailedToLookupTimerHandler((String)this.ejbName, (String)this.jarName, (String)this.appName);
                if (!this.isTransactional) break block4;
                try {
                    TxHelper.getTransaction().setRollbackOnly();
                }
                catch (Exception exception) {
                    EJBLogger.logErrorMarkingRollback((Exception)exception);
                }
            }
        }
    }

    public void cancel() {
        this.timer.cancel();
    }

    public TimerHandle getHandle() {
        return new ClusteredTimerHandleImpl(this.timer);
    }

    public Serializable getInfo() {
        return this.info;
    }

    public Date getNextTimeout() {
        return new Date(this.timer.getTimeout());
    }

    public long getTimeRemaining() {
        return this.timer.getTimeout() - System.currentTimeMillis();
    }

    public Object getPrimaryKey() {
        return this.pk;
    }

    public String getGroupName() {
        if (this.pk == null) {
            return null;
        }
        return Integer.toString(this.pk.hashCode());
    }

    public boolean isTransactional() {
        return this.isTransactional;
    }

    public boolean exists() {
        return !this.timer.isCancelled();
    }
}

