/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.timer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.EJBException;
import javax.ejb.Timer;
import javax.naming.Context;
import javax.naming.NamingException;
import weblogic.common.CompletionRequest;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.instrumentation.DelegatingMonitor;
import weblogic.diagnostics.instrumentation.DiagnosticAction;
import weblogic.diagnostics.instrumentation.DiagnosticActionState;
import weblogic.diagnostics.instrumentation.DiagnosticMonitor;
import weblogic.diagnostics.instrumentation.InstrumentationSupport;
import weblogic.diagnostics.instrumentation.JoinPoint;
import weblogic.ejb.WLTimerInfo;
import weblogic.ejb.container.EJBDebugService;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.interfaces.BeanInfo;
import weblogic.ejb.container.interfaces.BeanManager;
import weblogic.ejb.container.interfaces.DeploymentInfo;
import weblogic.ejb.container.interfaces.TimerHelper;
import weblogic.ejb.container.interfaces.TimerManager;
import weblogic.ejb.container.internal.MethodDescriptor;
import weblogic.ejb.container.monitoring.EJBTimerRuntimeMBeanImpl;
import weblogic.ejb.container.timer.EJBTimerStarter;
import weblogic.ejb.container.timer.PrepareRecord;
import weblogic.ejb.container.timer.TimerData;
import weblogic.ejb.container.timer.TimerImpl;
import weblogic.ejb.spi.WLDeploymentException;
import weblogic.management.runtime.EJBTimerRuntimeMBean;
import weblogic.store.PersistentHandle;
import weblogic.store.PersistentStoreConnection;
import weblogic.store.PersistentStoreException;
import weblogic.store.PersistentStoreManager;
import weblogic.store.PersistentStoreRecord;
import weblogic.store.PersistentStoreTransaction;
import weblogic.store.gxa.GXAException;
import weblogic.store.gxa.GXAOperation;
import weblogic.store.gxa.GXAOperationWrapper;
import weblogic.store.gxa.GXAResource;
import weblogic.store.gxa.GXATraceLogger;
import weblogic.store.gxa.GXATransaction;
import weblogic.store.gxa.GXid;
import weblogic.store.xa.PersistentStoreXA;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManagerFactory;

public final class EJBTimerManager
implements TimerManager {
    private static final DebugLogger debugLogger;
    private weblogic.timers.TimerManager timerManager;
    private BeanManager beanManager;
    private EJBTimerRuntimeMBeanImpl timerRtMBean;
    private ClassLoader moduleClassLoader;
    private MethodDescriptor md;
    private Map pk2EJBTimerMap = new HashMap();
    private Map id2EJBTimerMap = new HashMap();
    private Map disabledTimers = new HashMap();
    private PersistentStoreXA persistentStore;
    private PersistentStoreConnection persistentConnection;
    private GXAResource gxa;
    private boolean isTransactional;
    private boolean isInitialized = false;
    long timerIDCounter = 0L;
    Object IDLock = new Object();
    static final long serialVersionUID = 6799463590828290438L;
    public static final String _WLDF$INST_VERSION = "9.0.0";
    static /* synthetic */ Class _WLDF$INST_FLD_class;
    public static final DelegatingMonitor _WLDF$INST_FLD_EJB_Diagnostic_Timer_Manager_Around_High;
    public static final JoinPoint _WLDF$INST_JPFLD_0;
    public static final JoinPoint _WLDF$INST_JPFLD_1;
    public static final JoinPoint _WLDF$INST_JPFLD_2;
    public static final JoinPoint _WLDF$INST_JPFLD_3;
    public static final JoinPoint _WLDF$INST_JPFLD_4;

    public EJBTimerManager(BeanManager beanManager) {
        this.beanManager = beanManager;
    }

    public void setup(EJBTimerRuntimeMBean eJBTimerRuntimeMBean) throws WLDeploymentException {
        this.timerRtMBean = (EJBTimerRuntimeMBeanImpl)eJBTimerRuntimeMBean;
        try {
            TimerManagerFactory timerManagerFactory = TimerManagerFactory.getTimerManagerFactory();
            BeanInfo beanInfo = this.beanManager.getBeanInfo();
            this.timerManager = timerManagerFactory.getTimerManager(beanInfo.getIsIdenticalKey(), beanInfo.getDispatchPolicy());
            this.moduleClassLoader = beanInfo.getModuleClassLoader();
            this.initializePersistentStore(beanInfo);
            this.initializeMethodDescriptor(beanInfo);
            this.initializeTimerHelper(beanInfo);
            this.initializePersistedTimers();
        }
        catch (WLDeploymentException wLDeploymentException) {
            this.undeploy();
            throw wLDeploymentException;
        }
    }

    public EJBTimerRuntimeMBeanImpl getTimerRuntimeMBean() {
        return this.timerRtMBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableTimer(TimerImpl timerImpl) {
        weblogic.timers.Timer timer = timerImpl.getTimer();
        if (timer != null) {
            timer.cancel();
        }
        Map map = this.disabledTimers;
        synchronized (map) {
            this.disabledTimers.put(timerImpl.getID(), timerImpl);
            this.timerRtMBean.incrementDisabledTimerCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableDisabledTimers() {
        if (!this.isInitialized) {
            return;
        }
        Map map = this.disabledTimers;
        synchronized (map) {
            for (TimerImpl timerImpl : this.disabledTimers.values()) {
                if (timerImpl.isCancelled()) continue;
                this.scheduleTimer(timerImpl);
            }
            this.disabledTimers.clear();
            if (this.timerRtMBean != null) {
                this.timerRtMBean.resetDisabledTimerCount();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void scheduleTimer(TimerImpl timerImpl) {
        DiagnosticActionState[] diagnosticActionStateArray;
        DiagnosticAction[] diagnosticActionArray;
        boolean bl;
        block16: {
            block15: {
                bl = _WLDF$INST_FLD_EJB_Diagnostic_Timer_Manager_Around_High.isEnabledAndNotDyeFiltered();
                diagnosticActionArray = null;
                diagnosticActionStateArray = null;
                Object var9_5 = null;
                if (bl) {
                    DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_EJB_Diagnostic_Timer_Manager_Around_High;
                    diagnosticActionArray = delegatingMonitor.getActions();
                    diagnosticActionStateArray = InstrumentationSupport.getActionStates((DiagnosticAction[])diagnosticActionArray);
                    InstrumentationSupport.preProcess((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
                }
                try {
                    Map map;
                    if (!this.isInitialized) {
                        if (debugLogger.isDebugEnabled()) {
                            EJBTimerManager.debug("TimerManager not initialized, adding timer to disabledTimers");
                        }
                        map = this.disabledTimers;
                        synchronized (map) {
                            if (!this.isInitialized) {
                                this.disabledTimers.put(timerImpl.getID(), timerImpl);
                                // MONITOREXIT @DISABLED, blocks:[0, 3, 13, 14] lbl19 : MonitorExitStatement: MONITOREXIT : var2_7
                                Object var7_8 = null;
                                if (!bl) return;
                                break block15;
                            }
                        }
                    }
                    if (!timerImpl.isIntervalTimer()) {
                        if (!$assertionsDisabled && timerImpl.getTimer() != null) {
                            if (timerImpl.getTimer().cancel()) throw new AssertionError((Object)"cancel succeeded unexpectedly");
                        }
                        if (debugLogger.isDebugEnabled()) {
                            EJBTimerManager.debug("Scheduling single expiration Timer: " + timerImpl);
                        }
                        map = this.timerManager.schedule((TimerListener)timerImpl, timerImpl.getNextExpiration());
                        timerImpl.setTimer((weblogic.timers.Timer)map);
                        break block16;
                    } else {
                        if (debugLogger.isDebugEnabled()) {
                            EJBTimerManager.debug("Scheduling interval Timer: " + timerImpl);
                        }
                        if ((map = timerImpl.getTimer()) != null) {
                            map.cancel();
                        }
                        timerImpl.accountForSkippedIntervals();
                        map = this.timerManager.scheduleAtFixedRate((TimerListener)timerImpl, timerImpl.getNextExpiration(), timerImpl.getTimerData().getIntervalDuration());
                        timerImpl.setTimer((weblogic.timers.Timer)map);
                    }
                    break block16;
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    if (!bl) throw throwable;
                    InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)_WLDF$INST_FLD_EJB_Diagnostic_Timer_Manager_Around_High, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
                    throw throwable;
                }
            }
            InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)_WLDF$INST_FLD_EJB_Diagnostic_Timer_Manager_Around_High, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
            return;
        }
        Object var7_9 = null;
        if (!bl) return;
        InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)_WLDF$INST_FLD_EJB_Diagnostic_Timer_Manager_Around_High, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Timer createTimer(Object object, Date date, long l, Serializable serializable, WLTimerInfo wLTimerInfo) {
        TimerImpl timerImpl;
        boolean bl = _WLDF$INST_FLD_EJB_Diagnostic_Timer_Manager_Around_High.isEnabledAndNotDyeFiltered();
        DiagnosticAction[] diagnosticActionArray = null;
        DiagnosticActionState[] diagnosticActionStateArray = null;
        Object var14_9 = null;
        if (bl) {
            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_EJB_Diagnostic_Timer_Manager_Around_High;
            diagnosticActionArray = delegatingMonitor.getActions();
            diagnosticActionStateArray = InstrumentationSupport.getActionStates((DiagnosticAction[])diagnosticActionArray);
            InstrumentationSupport.preProcess((JoinPoint)_WLDF$INST_JPFLD_1, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
        }
        try {
            if (debugLogger.isDebugEnabled()) {
                EJBTimerManager.debug("Creating timer with pk: " + object + " expiration: " + date + " duration: " + l + " info: " + serializable);
            }
            Long l2 = new Long(this.getNextTimerID());
            timerImpl = new TimerImpl(this, this.beanManager, object, serializable, this.isTransactional, date, l, l2, wLTimerInfo);
            this.addNewTimer(timerImpl);
            Object var12_13 = null;
            if (!bl) return timerImpl;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            if (!bl) throw throwable;
            InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_1, (DiagnosticMonitor)_WLDF$INST_FLD_EJB_Diagnostic_Timer_Manager_Around_High, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
            throw throwable;
        }
        InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_1, (DiagnosticMonitor)_WLDF$INST_FLD_EJB_Diagnostic_Timer_Manager_Around_High, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
        return timerImpl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Timer createTimer(Object object, Date date, Serializable serializable, WLTimerInfo wLTimerInfo) {
        TimerImpl timerImpl;
        boolean bl = _WLDF$INST_FLD_EJB_Diagnostic_Timer_Manager_Around_High.isEnabledAndNotDyeFiltered();
        DiagnosticAction[] diagnosticActionArray = null;
        DiagnosticActionState[] diagnosticActionStateArray = null;
        Object var12_8 = null;
        if (bl) {
            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_EJB_Diagnostic_Timer_Manager_Around_High;
            diagnosticActionArray = delegatingMonitor.getActions();
            diagnosticActionStateArray = InstrumentationSupport.getActionStates((DiagnosticAction[])diagnosticActionArray);
            InstrumentationSupport.preProcess((JoinPoint)_WLDF$INST_JPFLD_2, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
        }
        try {
            if (debugLogger.isDebugEnabled()) {
                EJBTimerManager.debug("Creating timer with pk: " + object + " expiration: " + date + " info: " + serializable);
            }
            Long l = new Long(this.getNextTimerID());
            timerImpl = new TimerImpl(this, this.beanManager, object, serializable, this.isTransactional, date, -1L, l, wLTimerInfo);
            this.addNewTimer(timerImpl);
            Object var10_12 = null;
            if (!bl) return timerImpl;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            if (!bl) throw throwable;
            InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_2, (DiagnosticMonitor)_WLDF$INST_FLD_EJB_Diagnostic_Timer_Manager_Around_High, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
            throw throwable;
        }
        InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_2, (DiagnosticMonitor)_WLDF$INST_FLD_EJB_Diagnostic_Timer_Manager_Around_High, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
        return timerImpl;
    }

    /*
     * Unable to fully structure code
     */
    public Timer createTimer(Object var1_1, long var2_2, long var4_3, Serializable var6_4, WLTimerInfo var7_5) {
        var15_6 = EJBTimerManager._WLDF$INST_FLD_EJB_Diagnostic_Timer_Manager_Around_High.isEnabledAndNotDyeFiltered();
        var16_7 = null;
        var17_8 = null;
        var14_9 = null;
        if (var15_6) {
            v0 = EJBTimerManager._WLDF$INST_FLD_EJB_Diagnostic_Timer_Manager_Around_High;
            var16_7 = v0.getActions();
            var17_8 = InstrumentationSupport.getActionStates((DiagnosticAction[])var16_7);
            InstrumentationSupport.preProcess((JoinPoint)EJBTimerManager._WLDF$INST_JPFLD_3, (DiagnosticMonitor)v0, (DiagnosticAction[])var16_7, (DiagnosticActionState[])var17_8);
        }
        try {
            var8_11 = new Date(System.currentTimeMillis() + var2_2);
            v1 = this.createTimer(var1_1, var8_11, var4_3, var6_4, var7_5);
            var12_12 = null;
            ** if (!var15_6) goto lbl17
        }
        catch (Throwable var14_10) {
            var12_13 = null;
            if (var15_6) {
                InstrumentationSupport.postProcess((JoinPoint)EJBTimerManager._WLDF$INST_JPFLD_3, (DiagnosticMonitor)EJBTimerManager._WLDF$INST_FLD_EJB_Diagnostic_Timer_Manager_Around_High, (DiagnosticAction[])var16_7, (DiagnosticActionState[])var17_8);
            }
            throw var14_10;
        }
lbl-1000:
        // 1 sources

        {
            InstrumentationSupport.postProcess((JoinPoint)EJBTimerManager._WLDF$INST_JPFLD_3, (DiagnosticMonitor)EJBTimerManager._WLDF$INST_FLD_EJB_Diagnostic_Timer_Manager_Around_High, (DiagnosticAction[])var16_7, (DiagnosticActionState[])var17_8);
        }
lbl17:
        // 2 sources

        return v1;
    }

    /*
     * Unable to fully structure code
     */
    public Timer createTimer(Object var1_1, long var2_2, Serializable var4_3, WLTimerInfo var5_4) {
        var13_5 = EJBTimerManager._WLDF$INST_FLD_EJB_Diagnostic_Timer_Manager_Around_High.isEnabledAndNotDyeFiltered();
        var14_6 = null;
        var15_7 = null;
        var12_8 = null;
        if (var13_5) {
            v0 = EJBTimerManager._WLDF$INST_FLD_EJB_Diagnostic_Timer_Manager_Around_High;
            var14_6 = v0.getActions();
            var15_7 = InstrumentationSupport.getActionStates((DiagnosticAction[])var14_6);
            InstrumentationSupport.preProcess((JoinPoint)EJBTimerManager._WLDF$INST_JPFLD_4, (DiagnosticMonitor)v0, (DiagnosticAction[])var14_6, (DiagnosticActionState[])var15_7);
        }
        try {
            var6_10 = new Date(System.currentTimeMillis() + var2_2);
            v1 = this.createTimer(var1_1, var6_10, var4_3, var5_4);
            var10_11 = null;
            ** if (!var13_5) goto lbl17
        }
        catch (Throwable var12_9) {
            var10_12 = null;
            if (var13_5) {
                InstrumentationSupport.postProcess((JoinPoint)EJBTimerManager._WLDF$INST_JPFLD_4, (DiagnosticMonitor)EJBTimerManager._WLDF$INST_FLD_EJB_Diagnostic_Timer_Manager_Around_High, (DiagnosticAction[])var14_6, (DiagnosticActionState[])var15_7);
            }
            throw var12_9;
        }
lbl-1000:
        // 1 sources

        {
            InstrumentationSupport.postProcess((JoinPoint)EJBTimerManager._WLDF$INST_JPFLD_4, (DiagnosticMonitor)EJBTimerManager._WLDF$INST_FLD_EJB_Diagnostic_Timer_Manager_Around_High, (DiagnosticAction[])var14_6, (DiagnosticActionState[])var15_7);
        }
lbl17:
        // 2 sources

        return v1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getTimers(Object object) {
        HashSet hashSet = null;
        Map map = this.pk2EJBTimerMap;
        synchronized (map) {
            hashSet = (HashSet)this.pk2EJBTimerMap.get(object);
        }
        hashSet = hashSet == null ? new HashSet() : (HashSet)hashSet.clone();
        return hashSet;
    }

    public void removeTimersForPK(Object object) {
        Collection collection = this.getTimers(object);
        for (TimerImpl timerImpl : collection) {
            timerImpl.remove();
        }
    }

    public static void removeAllTimers(BeanInfo beanInfo) {
        if (debugLogger.isDebugEnabled()) {
            EJBTimerManager.debug("Removing all EJB Timers from store for EJB: " + beanInfo.getDisplayName());
        }
        try {
            PersistentStoreManager persistentStoreManager = PersistentStoreManager.getManager();
            String string = beanInfo.getTimerStoreName();
            PersistentStoreXA persistentStoreXA = null;
            if (string == null) {
                persistentStoreXA = (PersistentStoreXA)persistentStoreManager.getDefaultStore();
            } else {
                if (!persistentStoreManager.storeExistsByLogicalName(string)) {
                    return;
                }
                persistentStoreXA = (PersistentStoreXA)persistentStoreManager.getStoreByLogicalName(string);
            }
            String string2 = EJBTimerManager.getStoreConnectionKey(beanInfo);
            PersistentStoreConnection persistentStoreConnection = persistentStoreXA.createConnection(string2);
            persistentStoreConnection.delete();
        }
        catch (Exception exception) {
            if (debugLogger.isDebugEnabled()) {
                EJBTimerManager.debug("Error removing EJB Timer store objects", exception);
            }
            EJBLogger.logErrorRemovingEJBTimersFromStore((String)beanInfo.getDisplayName(), (Exception)exception);
        }
    }

    public void undeploy() {
        if (debugLogger.isDebugEnabled()) {
            EJBTimerManager.debug("shutting down EJB timer service");
        }
        this.isInitialized = false;
        try {
            this.timerManager.waitForStop(0L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.persistentConnection != null) {
            this.persistentConnection.close();
        }
        this.uninitializeTimerHelper();
    }

    private void addNewTimer(TimerImpl timerImpl) {
        Long l = timerImpl.getID();
        try {
            GXATransaction gXATransaction = this.gxa.enlist();
            if (gXATransaction != null) {
                TimerCreationOperation timerCreationOperation = new TimerCreationOperation(timerImpl, this, this.persistentConnection);
                this.gxa.addNewOperation(gXATransaction, (GXAOperation)timerCreationOperation);
                timerImpl.setState(4);
            } else {
                PersistentStoreTransaction persistentStoreTransaction = this.persistentStore.begin();
                timerImpl.setPersistentHandle(this.persistentConnection.create(persistentStoreTransaction, (Object)timerImpl.getTimerData(), 0));
                persistentStoreTransaction.commit();
                timerImpl.finalizeCreate();
            }
        }
        catch (Exception exception) {
            EJBException eJBException = new EJBException("Error creating Timer.", exception);
            eJBException.initCause((Throwable)exception);
            throw eJBException;
        }
        this.addTimerToMaps(timerImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timer getTimer(Long l) {
        Map map = this.id2EJBTimerMap;
        synchronized (map) {
            return (Timer)this.id2EJBTimerMap.get(l);
        }
    }

    public MethodDescriptor getMethodDescriptor() {
        return this.md;
    }

    public void removePersistentStoreEntry(TimerImpl timerImpl) throws PersistentStoreException {
        PersistentStoreTransaction persistentStoreTransaction = this.persistentStore.begin();
        this.persistentConnection.delete(persistentStoreTransaction, timerImpl.getPersistentHandle(), 0);
        persistentStoreTransaction.commit();
    }

    public void updatePersistentStoreEntry(TimerImpl timerImpl) throws PersistentStoreException {
        PersistentStoreTransaction persistentStoreTransaction = this.persistentStore.begin();
        this.persistentConnection.update(persistentStoreTransaction, timerImpl.getPersistentHandle(), (Object)timerImpl.getTimerData(), 0);
        persistentStoreTransaction.commit();
    }

    public boolean registerTimerExpirationOperation(TimerImpl timerImpl) throws GXAException {
        GXATransaction gXATransaction = this.gxa.enlist();
        if (gXATransaction != null) {
            TimerExpirationOperation timerExpirationOperation = new TimerExpirationOperation(timerImpl, this, this.persistentConnection, this.moduleClassLoader);
            this.gxa.addNewOperation(gXATransaction, (GXAOperation)timerExpirationOperation);
            if (debugLogger.isDebugEnabled()) {
                EJBTimerManager.debug("Created TimerExpirationOperation: " + timerExpirationOperation);
            }
            return true;
        }
        return false;
    }

    public boolean registerTimerCancellationOperation(TimerImpl timerImpl) throws GXAException {
        GXATransaction gXATransaction = this.gxa.enlist();
        if (gXATransaction != null) {
            TimerCancellationOperation timerCancellationOperation = new TimerCancellationOperation(timerImpl, this, this.persistentConnection);
            this.gxa.addNewOperation(gXATransaction, (GXAOperation)timerCancellationOperation);
            return true;
        }
        return false;
    }

    private void initializePersistedTimers() throws WLDeploymentException {
        try {
            PersistentStoreRecord persistentStoreRecord;
            long l = 0L;
            HashSet<TimerData> hashSet = null;
            PersistentStoreConnection.Cursor cursor = this.persistentConnection.createCursor(0);
            boolean bl = false;
            while ((persistentStoreRecord = cursor.next()) != null) {
                Serializable serializable;
                Serializable serializable2;
                Object object;
                Object object2 = null;
                try {
                    object2 = persistentStoreRecord.getData();
                }
                catch (PersistentStoreException persistentStoreException) {
                    if (bl) continue;
                    object = this.beanManager.getBeanInfo();
                    serializable2 = persistentStoreException.getCause();
                    if (serializable2 == null) {
                        serializable2 = persistentStoreException;
                    }
                    EJBLogger.logEJBTimerSerializationError((String)object.getDisplayName(), (String)serializable2.toString());
                    bl = true;
                    continue;
                }
                if (object2 instanceof TimerData) {
                    serializable = (TimerData)object2;
                    object = new TimerImpl(this, this.beanManager, this.isTransactional, (TimerData)serializable);
                    ((TimerImpl)object).setPersistentHandle(persistentStoreRecord.getHandle());
                    ((TimerImpl)object).setState(1);
                    this.addTimerToMaps((TimerImpl)object);
                    serializable2 = ((TimerImpl)object).getID();
                    if (this.disabledTimers.containsKey(serializable2)) {
                        ArrayList<Object> arrayList = new ArrayList<Object>();
                        arrayList.add(this.disabledTimers.get(serializable2));
                        arrayList.add(object);
                        this.disabledTimers.put(serializable2, arrayList);
                    } else {
                        this.disabledTimers.put(serializable2, object);
                    }
                    if (((TimerImpl)object).getID() <= l) continue;
                    l = ((TimerImpl)object).getID();
                    continue;
                }
                if (object2 instanceof PrepareRecord) {
                    serializable = (PrepareRecord)object2;
                    ((PrepareRecord)serializable).handle = persistentStoreRecord.getHandle();
                    if (hashSet == null) {
                        hashSet = new HashSet<TimerData>();
                    }
                    hashSet.add((TimerData)serializable);
                    continue;
                }
                throw new AssertionError((Object)"Unexpected object in EJB timer store!");
            }
            this.timerIDCounter = ++l;
            if (hashSet != null) {
                this.handleRecoveredOperations(hashSet);
            }
        }
        catch (Exception exception) {
            if (debugLogger.isDebugEnabled()) {
                EJBTimerManager.debug("Error initializing TimerService", exception);
            }
            throw new WLDeploymentException("Error starting Timer service", exception);
        }
    }

    private void handleRecoveredOperations(Set set) {
        block5: for (PrepareRecord prepareRecord : set) {
            Long l = prepareRecord.timerID;
            assert (this.disabledTimers.containsKey(l));
            switch (prepareRecord.operation) {
                case 2: {
                    TimerImpl timerImpl = (TimerImpl)this.disabledTimers.remove(l);
                    timerImpl.setState(3);
                    TimerCancellationOperation timerCancellationOperation = new TimerCancellationOperation(timerImpl, this, this.persistentConnection);
                    timerCancellationOperation.recover(prepareRecord.xid, prepareRecord.handle);
                    this.gxa.addRecoveredOperation((GXAOperation)timerCancellationOperation);
                    continue block5;
                }
                case 1: {
                    TimerImpl timerImpl = (TimerImpl)this.disabledTimers.remove(l);
                    if (timerImpl.getState() != 3) {
                        timerImpl.setState(4);
                    }
                    TimerCreationOperation timerCreationOperation = new TimerCreationOperation(timerImpl, this, this.persistentConnection);
                    timerCreationOperation.recover(prepareRecord.xid, prepareRecord.handle);
                    this.gxa.addRecoveredOperation((GXAOperation)timerCreationOperation);
                    continue block5;
                }
                case 3: 
                case 4: {
                    Object object;
                    TimerExpirationOperation timerExpirationOperation = null;
                    Object v = this.disabledTimers.remove(l);
                    if (v instanceof List) {
                        object = (List)v;
                        TimerImpl timerImpl = (TimerImpl)object.get(0);
                        TimerImpl timerImpl2 = (TimerImpl)object.get(1);
                        assert (timerImpl.isIntervalTimer());
                        if (timerImpl.getNextExpiration().getTime() > timerImpl2.getNextExpiration().getTime()) {
                            this.removeTimerFromMaps(timerImpl2);
                            timerImpl.setState(5);
                            timerExpirationOperation = new TimerExpirationOperation(timerImpl, this, this.persistentConnection, this.moduleClassLoader);
                            timerExpirationOperation.recover(prepareRecord.xid, prepareRecord.handle, timerImpl2.getPersistentHandle(), timerImpl.getPersistentHandle());
                        } else {
                            this.removeTimerFromMaps(timerImpl);
                            timerImpl2.setState(5);
                            timerExpirationOperation = new TimerExpirationOperation(timerImpl2, this, this.persistentConnection, this.moduleClassLoader);
                            timerExpirationOperation.recover(prepareRecord.xid, prepareRecord.handle, timerImpl.getPersistentHandle(), timerImpl2.getPersistentHandle());
                        }
                    } else {
                        object = (TimerImpl)v;
                        assert (!((TimerImpl)object).isIntervalTimer());
                        if (prepareRecord.operation == 3) {
                            ((TimerImpl)object).setState(5);
                        } else {
                            ((TimerImpl)object).setState(6);
                        }
                        timerExpirationOperation = new TimerExpirationOperation((TimerImpl)object, this, this.persistentConnection, this.moduleClassLoader);
                        timerExpirationOperation.recover(prepareRecord.xid, prepareRecord.handle, ((TimerImpl)object).getPersistentHandle(), null);
                    }
                    this.gxa.addRecoveredOperation((GXAOperation)timerExpirationOperation);
                    continue block5;
                }
            }
            throw new AssertionError((Object)("Unknown type: " + prepareRecord.operation));
        }
    }

    public void perhapsStart() {
        if (debugLogger.isDebugEnabled()) {
            EJBTimerManager.debug("invoking perhapsStart");
        }
        EJBTimerStarter.addTimerManagerStarter(this);
    }

    public void start() {
        if (debugLogger.isDebugEnabled()) {
            EJBTimerManager.debug("invoking start");
        }
        this.isInitialized = true;
        this.enableDisabledTimers();
    }

    private void initializePersistentStore(BeanInfo beanInfo) throws WLDeploymentException {
        try {
            PersistentStoreManager persistentStoreManager = PersistentStoreManager.getManager();
            String string = beanInfo.getTimerStoreName();
            this.persistentStore = string == null ? (PersistentStoreXA)persistentStoreManager.getDefaultStore() : (PersistentStoreXA)persistentStoreManager.getStoreByLogicalName(string);
            String string2 = EJBTimerManager.getStoreConnectionKey(beanInfo);
            this.persistentConnection = this.persistentStore.createConnection(string2);
            this.gxa = this.persistentStore.getGXAResource();
        }
        catch (Exception exception) {
            if (debugLogger.isDebugEnabled()) {
                EJBTimerManager.debug("Error initializing Timer store", exception);
            }
            throw new WLDeploymentException("Error initializing Timer store", exception);
        }
    }

    private static String getStoreConnectionKey(BeanInfo beanInfo) {
        DeploymentInfo deploymentInfo = beanInfo.getDeploymentInfo();
        return "weblogic.ejb.timer." + deploymentInfo.getApplicationName() + "." + deploymentInfo.getModuleURI() + "." + beanInfo.getEJBName();
    }

    private void initializeMethodDescriptor(BeanInfo beanInfo) throws WLDeploymentException {
        this.md = beanInfo.getEjbTimeoutMethodDescriptor();
        int n = this.md.getTXAttribute();
        this.isTransactional = n == 3 || n == 1;
    }

    private void initializeTimerHelper(BeanInfo beanInfo) throws WLDeploymentException {
        DeploymentInfo deploymentInfo = beanInfo.getDeploymentInfo();
        String string = deploymentInfo.getModuleURI();
        String string2 = beanInfo.getEJBName();
        Context context = this.beanManager.getEnvironmentContext();
        TimerHelperImpl timerHelperImpl = new TimerHelperImpl(this);
        try {
            context.bind("app/ejb/" + string + "#" + string2 + "/timerHelper", (Object)timerHelperImpl);
        }
        catch (NamingException namingException) {
            throw new WLDeploymentException("Error initializing TimerHelper:", namingException);
        }
    }

    private void uninitializeTimerHelper() {
        block2: {
            BeanInfo beanInfo = this.beanManager.getBeanInfo();
            DeploymentInfo deploymentInfo = beanInfo.getDeploymentInfo();
            String string = deploymentInfo.getModuleURI();
            String string2 = beanInfo.getEJBName();
            Context context = this.beanManager.getEnvironmentContext();
            try {
                context.unbind("app/ejb/" + string + "#" + string2 + "/timerHelper");
            }
            catch (NamingException namingException) {
                if (!debugLogger.isDebugEnabled()) break block2;
                EJBTimerManager.debug("Error unbinding TimerHelper", namingException);
            }
        }
    }

    public void cancelTimer(TimerImpl timerImpl) {
        weblogic.timers.Timer timer = timerImpl.getTimer();
        if (timer != null) {
            timer.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTimerToMaps(TimerImpl timerImpl) {
        Object object = timerImpl.getPK();
        Long l = timerImpl.getID();
        Map map = this.id2EJBTimerMap;
        synchronized (map) {
            this.id2EJBTimerMap.put(l, timerImpl);
        }
        map = this.pk2EJBTimerMap;
        synchronized (map) {
            HashSet<TimerImpl> hashSet = (HashSet<TimerImpl>)this.pk2EJBTimerMap.get(object);
            if (hashSet == null) {
                hashSet = new HashSet<TimerImpl>();
                this.pk2EJBTimerMap.put(object, hashSet);
            }
            hashSet.add(timerImpl);
        }
        this.timerRtMBean.incrementActiveTimerCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTimerFromMaps(TimerImpl timerImpl) {
        Object object = timerImpl.getPK();
        Long l = timerImpl.getID();
        Map map = this.id2EJBTimerMap;
        synchronized (map) {
            this.id2EJBTimerMap.remove(l);
        }
        map = this.pk2EJBTimerMap;
        synchronized (map) {
            Set set = (Set)this.pk2EJBTimerMap.get(object);
            if (set == null) {
                return;
            }
            set.remove(timerImpl);
            if (set.isEmpty()) {
                this.pk2EJBTimerMap.remove(object);
            }
        }
        this.timerRtMBean.decrementActiveTimerCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getNextTimerID() {
        Object object = this.IDLock;
        synchronized (object) {
            return ++this.timerIDCounter;
        }
    }

    private static void debug(String string) {
        debugLogger.debug("[EJBTimerManager] " + string);
    }

    private static void debug(String string, Throwable throwable) {
        debugLogger.debug("[EJBTimerManager] " + string, throwable);
    }

    static {
        _WLDF$INST_FLD_class = Class.forName("weblogic.ejb.container.timer.EJBTimerManager");
        _WLDF$INST_FLD_EJB_Diagnostic_Timer_Manager_Around_High = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"EJB_Diagnostic_Timer_Manager_Around_High");
        _WLDF$INST_JPFLD_0 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"EJBTimerManager.java", (String)"weblogic.ejb.container.timer.EJBTimerManager", (String)"scheduleTimer", (String)"(Lweblogic/ejb/container/timer/TimerImpl;)V", (int)175, null, (boolean)false);
        _WLDF$INST_JPFLD_1 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"EJBTimerManager.java", (String)"weblogic.ejb.container.timer.EJBTimerManager", (String)"createTimer", (String)"(Ljava/lang/Object;Ljava/util/Date;JLjava/io/Serializable;Lweblogic/ejb/WLTimerInfo;)Ljavax/ejb/Timer;", (int)228, null, (boolean)false);
        _WLDF$INST_JPFLD_2 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"EJBTimerManager.java", (String)"weblogic.ejb.container.timer.EJBTimerManager", (String)"createTimer", (String)"(Ljava/lang/Object;Ljava/util/Date;Ljava/io/Serializable;Lweblogic/ejb/WLTimerInfo;)Ljavax/ejb/Timer;", (int)247, null, (boolean)false);
        _WLDF$INST_JPFLD_3 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"EJBTimerManager.java", (String)"weblogic.ejb.container.timer.EJBTimerManager", (String)"createTimer", (String)"(Ljava/lang/Object;JJLjava/io/Serializable;Lweblogic/ejb/WLTimerInfo;)Ljavax/ejb/Timer;", (int)263, null, (boolean)false);
        _WLDF$INST_JPFLD_4 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"EJBTimerManager.java", (String)"weblogic.ejb.container.timer.EJBTimerManager", (String)"createTimer", (String)"(Ljava/lang/Object;JLjava/io/Serializable;Lweblogic/ejb/WLTimerInfo;)Ljavax/ejb/Timer;", (int)272, null, (boolean)false);
        debugLogger = EJBDebugService.timerLogger;
    }

    public static class TimerExpirationOperation
    implements GXAOperation {
        private TimerImpl timer;
        private EJBTimerManager timerManager;
        private PersistentStoreConnection pConn;
        private GXATransaction gxaTransaction;
        private GXid xid;
        private PersistentHandle prepareHandle;
        private PersistentHandle newTimerHandle;
        private PersistentHandle oldTimerHandle;
        private TimerData oldTimerState;
        private ClassLoader moduleClassLoader;

        public TimerExpirationOperation(TimerImpl timerImpl, EJBTimerManager eJBTimerManager, PersistentStoreConnection persistentStoreConnection, ClassLoader classLoader) {
            this.timer = timerImpl;
            this.timerManager = eJBTimerManager;
            this.pConn = persistentStoreConnection;
            this.oldTimerHandle = timerImpl.getPersistentHandle();
            this.moduleClassLoader = classLoader;
        }

        public void recover(GXid gXid, PersistentHandle persistentHandle, PersistentHandle persistentHandle2, PersistentHandle persistentHandle3) {
            this.xid = gXid;
            this.prepareHandle = persistentHandle;
            this.oldTimerHandle = persistentHandle2;
            this.newTimerHandle = persistentHandle3;
        }

        public void onInitialize(GXATraceLogger gXATraceLogger, GXATransaction gXATransaction, GXAOperationWrapper gXAOperationWrapper) {
            this.gxaTransaction = gXATransaction;
            this.xid = gXATransaction.getGXid();
            this.timer.setXid(this.xid.getXAXid());
        }

        public boolean onPrepare(int n, boolean bl) {
            Object object;
            if (this.timer.isIntervalTimer() && !this.timer.isCancelled()) {
                if (n == 1) {
                    object = this.gxaTransaction.getStoreTransaction();
                    this.newTimerHandle = this.pConn.create(object, (Object)this.timer.getTimerData(), 0);
                }
                if (n == 3) {
                    this.timer.setPersistentHandle(this.newTimerHandle);
                }
            }
            if (n == 2 && !bl) {
                object = null;
                object = this.timer.isCancelled() && this.timer.isIntervalTimer() ? new PrepareRecord(this.timer.getID(), 4, this.xid) : new PrepareRecord(this.timer.getID(), 3, this.xid);
                PersistentStoreTransaction persistentStoreTransaction = this.gxaTransaction.getStoreTransaction();
                this.prepareHandle = this.pConn.create(persistentStoreTransaction, object, 0);
            }
            return true;
        }

        public void onCommit(int n) {
            if (n == 1) {
                PersistentStoreTransaction persistentStoreTransaction = this.gxaTransaction.getStoreTransaction();
                this.pConn.delete(persistentStoreTransaction, this.oldTimerHandle, 0);
            } else if (n == 2 && this.prepareHandle != null) {
                PersistentStoreTransaction persistentStoreTransaction = this.gxaTransaction.getStoreTransaction();
                this.pConn.delete(persistentStoreTransaction, this.prepareHandle, 0);
            } else if (n == 3) {
                this.timerManager.getTimerRuntimeMBean().incrementTimeoutCount();
                if (this.timer.isIntervalTimer() && !this.timer.isCancelled()) {
                    this.timer.handleTimeoutSuccess();
                } else {
                    if (this.timer.isCancelled()) {
                        this.timerManager.getTimerRuntimeMBean().incrementCancelledTimerCount();
                    }
                    this.timer.setState(7);
                    this.timerManager.removeTimerFromMaps(this.timer);
                }
            }
        }

        public void onRollback(int n) {
            block13: {
                if (n == 1) {
                    PersistentStoreTransaction persistentStoreTransaction = this.gxaTransaction.getStoreTransaction();
                    if (this.newTimerHandle != null) {
                        this.pConn.delete(persistentStoreTransaction, this.newTimerHandle, 0);
                    }
                    if (this.timer.exists()) {
                        CompletionRequest completionRequest = new CompletionRequest();
                        this.pConn.read(persistentStoreTransaction, this.oldTimerHandle, completionRequest);
                        Thread thread2 = Thread.currentThread();
                        ClassLoader classLoader = thread2.getContextClassLoader();
                        thread2.setContextClassLoader(this.moduleClassLoader);
                        try {
                            try {
                                PersistentStoreRecord persistentStoreRecord = (PersistentStoreRecord)completionRequest.getResult();
                                this.oldTimerState = (TimerData)persistentStoreRecord.getData();
                            }
                            catch (Throwable throwable) {
                                throw new AssertionError((Object)("Error reading from persistent store: " + throwable));
                            }
                            Object var8_9 = null;
                            if (classLoader != null) {
                                thread2.setContextClassLoader(classLoader);
                            }
                            break block13;
                        }
                        catch (Throwable throwable) {
                            Object var8_10 = null;
                            if (classLoader != null) {
                                thread2.setContextClassLoader(classLoader);
                            }
                            throw throwable;
                        }
                    }
                    this.pConn.delete(persistentStoreTransaction, this.oldTimerHandle, 0);
                } else if (n == 2 && this.prepareHandle != null) {
                    PersistentStoreTransaction persistentStoreTransaction = this.gxaTransaction.getStoreTransaction();
                    this.pConn.delete(persistentStoreTransaction, this.prepareHandle, 0);
                } else if (n == 3) {
                    this.timer.setPersistentHandle(this.oldTimerHandle);
                    this.timer.handleTimeoutFailure(this.oldTimerState);
                }
            }
        }

        public GXid getGXid() {
            return this.xid;
        }

        public String getDebugPrefix() {
            return "TimerExpiration";
        }
    }

    public static class TimerCancellationOperation
    implements GXAOperation {
        private TimerImpl timer;
        private EJBTimerManager timerManager;
        private PersistentStoreConnection pConn;
        private GXATransaction gxaTransaction;
        private GXid xid;
        private PersistentHandle prepareHandle;

        public TimerCancellationOperation(TimerImpl timerImpl, EJBTimerManager eJBTimerManager, PersistentStoreConnection persistentStoreConnection) {
            this.timer = timerImpl;
            this.timerManager = eJBTimerManager;
            this.pConn = persistentStoreConnection;
        }

        public void recover(GXid gXid, PersistentHandle persistentHandle) {
            this.xid = gXid;
            this.prepareHandle = persistentHandle;
        }

        public void onInitialize(GXATraceLogger gXATraceLogger, GXATransaction gXATransaction, GXAOperationWrapper gXAOperationWrapper) {
            this.gxaTransaction = gXATransaction;
            this.xid = gXATransaction.getGXid();
            this.timer.setXid(this.xid.getXAXid());
        }

        public boolean onPrepare(int n, boolean bl) {
            if (n == 2 && !bl) {
                PrepareRecord prepareRecord = new PrepareRecord(this.timer.getID(), 2, this.xid);
                PersistentStoreTransaction persistentStoreTransaction = this.gxaTransaction.getStoreTransaction();
                this.prepareHandle = this.pConn.create(persistentStoreTransaction, (Object)prepareRecord, 0);
            }
            return true;
        }

        public void onCommit(int n) {
            if (n == 1) {
                PersistentStoreTransaction persistentStoreTransaction = this.gxaTransaction.getStoreTransaction();
                this.pConn.delete(persistentStoreTransaction, this.timer.getPersistentHandle(), 0);
            } else if (n == 2 && this.prepareHandle != null) {
                PersistentStoreTransaction persistentStoreTransaction = this.gxaTransaction.getStoreTransaction();
                this.pConn.delete(persistentStoreTransaction, this.prepareHandle, 0);
            } else if (n == 3) {
                this.timerManager.getTimerRuntimeMBean().incrementCancelledTimerCount();
                this.timer.finalizeCancel();
            }
        }

        public void onRollback(int n) {
            if (n == 2 && this.prepareHandle != null) {
                PersistentStoreTransaction persistentStoreTransaction = this.gxaTransaction.getStoreTransaction();
                this.pConn.delete(persistentStoreTransaction, this.prepareHandle, 0);
            } else if (n == 3) {
                this.timer.undoCancel();
            }
        }

        public GXid getGXid() {
            return this.xid;
        }

        public String getDebugPrefix() {
            return "TimerCancellation";
        }
    }

    public static class TimerCreationOperation
    implements GXAOperation {
        private TimerImpl timer;
        private EJBTimerManager timerManager;
        private PersistentStoreConnection pConn;
        private GXATransaction gxaTransaction;
        private GXid xid;
        private PersistentHandle prepareHandle;

        public TimerCreationOperation(TimerImpl timerImpl, EJBTimerManager eJBTimerManager, PersistentStoreConnection persistentStoreConnection) {
            this.timer = timerImpl;
            this.timerManager = eJBTimerManager;
            this.pConn = persistentStoreConnection;
        }

        public void recover(GXid gXid, PersistentHandle persistentHandle) {
            this.xid = gXid;
            this.prepareHandle = persistentHandle;
        }

        public void onInitialize(GXATraceLogger gXATraceLogger, GXATransaction gXATransaction, GXAOperationWrapper gXAOperationWrapper) {
            this.gxaTransaction = gXATransaction;
            this.xid = gXATransaction.getGXid();
            this.timer.setXid(this.xid.getXAXid());
        }

        public boolean onPrepare(int n, boolean bl) {
            if (n == 1) {
                PersistentStoreTransaction persistentStoreTransaction = this.gxaTransaction.getStoreTransaction();
                PersistentHandle persistentHandle = this.pConn.create(persistentStoreTransaction, (Object)this.timer.getTimerData(), 0);
                this.timer.setPersistentHandle(persistentHandle);
            } else if (n == 2 && !bl) {
                PrepareRecord prepareRecord = new PrepareRecord(this.timer.getID(), 1, this.xid);
                PersistentStoreTransaction persistentStoreTransaction = this.gxaTransaction.getStoreTransaction();
                this.prepareHandle = this.pConn.create(persistentStoreTransaction, (Object)prepareRecord, 0);
            }
            return true;
        }

        public void onCommit(int n) {
            if (n == 2 && this.prepareHandle != null) {
                PersistentStoreTransaction persistentStoreTransaction = this.gxaTransaction.getStoreTransaction();
                this.pConn.delete(persistentStoreTransaction, this.prepareHandle, 0);
            } else if (n == 3) {
                this.timer.finalizeCreate();
            }
        }

        public void onRollback(int n) {
            if (n == 1 && this.timer.getPersistentHandle() != null) {
                PersistentStoreTransaction persistentStoreTransaction = this.gxaTransaction.getStoreTransaction();
                this.pConn.delete(persistentStoreTransaction, this.timer.getPersistentHandle(), 0);
            } else if (n == 2 && this.prepareHandle != null) {
                PersistentStoreTransaction persistentStoreTransaction = this.gxaTransaction.getStoreTransaction();
                this.pConn.delete(persistentStoreTransaction, this.prepareHandle, 0);
            } else if (n == 3) {
                this.timer.undoCreate();
            }
        }

        public GXid getGXid() {
            return this.xid;
        }

        public String getDebugPrefix() {
            return "TimerCreation";
        }
    }

    public static class TimerHelperImpl
    implements TimerHelper {
        private EJBTimerManager timerManager;

        public TimerHelperImpl(EJBTimerManager eJBTimerManager) {
            this.timerManager = eJBTimerManager;
        }

        public Timer getTimer(Long l) {
            return this.timerManager.getTimer(l);
        }
    }
}

