/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.timer;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import weblogic.ejb.container.interfaces.BeanManager;
import weblogic.ejb.container.interfaces.TimerManager;
import weblogic.ejb.container.timer.ClusteredEJBTimerManager;
import weblogic.ejb.container.timer.EJBTimerManager;
import weblogic.ejb.spi.WLDeploymentException;
import weblogic.management.runtime.EJBTimerRuntimeMBean;

public class MDBTimerManagerFactory {
    private HashSet<BeanManager> bms = new HashSet();
    private boolean tmsetupCalled = false;

    public synchronized TimerManager createEJBTimerManager(BeanManager beanManager) {
        if (this.bms.size() > 0) {
            return this.bms.iterator().next().getTimerManager();
        }
        BeanManager beanManager2 = (BeanManager)Proxy.newProxyInstance(beanManager.getClass().getClassLoader(), beanManager.getClass().getInterfaces(), (InvocationHandler)new InterceptingInvocationHandlerImpl());
        TimerManager timerManager = null;
        this.bms.add(beanManager);
        timerManager = beanManager.getBeanInfo().isClusteredTimers() ? new ClusteredEJBTimerManager(beanManager2) : new EJBTimerManager(beanManager2);
        return timerManager;
    }

    public synchronized BeanManager getActiveBeanManager() {
        if (this.bms.size() > 0) {
            return this.bms.iterator().next();
        }
        return null;
    }

    public synchronized void setup(BeanManager beanManager, EJBTimerRuntimeMBean eJBTimerRuntimeMBean) throws WLDeploymentException {
        if (!this.tmsetupCalled && this.bms.size() == 1 && beanManager.getTimerManager() != null) {
            beanManager.getTimerManager().setup(eJBTimerRuntimeMBean);
            this.tmsetupCalled = true;
        }
        this.bms.add(beanManager);
    }

    public synchronized void undeploy(BeanManager beanManager) {
        if (this.bms.size() == 1 && beanManager.getTimerManager() != null) {
            beanManager.getTimerManager().undeploy();
            this.tmsetupCalled = false;
        }
        this.bms.remove(beanManager);
    }

    class InterceptingInvocationHandlerImpl
    implements InvocationHandler {
        InterceptingInvocationHandlerImpl() {
        }

        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            Object object2 = null;
            try {
                object2 = method.invoke((Object)MDBTimerManagerFactory.this.getActiveBeanManager(), objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getCause();
            }
            return object2;
        }
    }
}

