/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.timer;

import java.lang.reflect.InvocationTargetException;
import javax.ejb.EJBException;
import javax.ejb.EnterpriseBean;
import javax.ejb.NoSuchEntityException;
import javax.ejb.TimedObject;
import javax.ejb.Timer;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.interfaces.BeanInfo;
import weblogic.ejb.container.interfaces.BeanManager;
import weblogic.ejb.container.interfaces.MessageDrivenBeanInfo;
import weblogic.ejb.container.interfaces.TimerHandler;
import weblogic.ejb.container.interfaces.WLEnterpriseBean;
import weblogic.ejb.container.internal.EJBContextHandler;
import weblogic.ejb.container.internal.InvocationWrapper;
import weblogic.ejb.container.internal.MethodDescriptor;
import weblogic.ejb.container.internal.TimerDrivenLocalObject;
import weblogic.ejb.container.timer.ClusteredTimerImpl;
import weblogic.ejb.container.timer.TimerWrapper;
import weblogic.transaction.TxHelper;

public final class TimerHandlerImpl
implements TimerHandler {
    private BeanManager beanManager;
    private BeanInfo beanInfo;
    private MethodDescriptor md;

    public TimerHandlerImpl(BeanManager beanManager, BeanInfo beanInfo, MethodDescriptor methodDescriptor) {
        this.beanManager = beanManager;
        this.beanInfo = beanInfo;
        this.md = methodDescriptor;
    }

    public void executeTimer(ClusteredTimerImpl clusteredTimerImpl) {
        TimerObject timerObject = new TimerObject(this.beanManager, this.beanInfo, this.md);
        timerObject.execute(clusteredTimerImpl);
    }

    private class TimerObject
    extends TimerDrivenLocalObject {
        private boolean isMessageDrivenBean = false;
        private MethodDescriptor md;

        public TimerObject(BeanManager beanManager, BeanInfo beanInfo, MethodDescriptor methodDescriptor) {
            super.setBeanManager(beanManager);
            super.setBeanInfo(beanInfo);
            this.md = methodDescriptor;
            if (beanInfo instanceof MessageDrivenBeanInfo) {
                this.isMessageDrivenBean = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(ClusteredTimerImpl clusteredTimerImpl) {
            InvocationWrapper invocationWrapper;
            try {
                invocationWrapper = this.preInvoke(clusteredTimerImpl.getPrimaryKey(), this.md, new EJBContextHandler(this.md, new Object[]{clusteredTimerImpl}));
            }
            catch (Throwable throwable) {
                Exception exception;
                if (throwable instanceof EJBException && (exception = ((EJBException)throwable).getCausedByException()) instanceof NoSuchEntityException) {
                    clusteredTimerImpl.cancel();
                    return;
                }
                EJBLogger.logExceptionBeforeInvokingEJBTimeout((String)this.beanInfo.getDisplayName(), (Throwable)throwable);
                if (clusteredTimerImpl.isTransactional()) {
                    try {
                        TxHelper.getTransaction().setRollbackOnly();
                    }
                    catch (Exception exception2) {
                        EJBLogger.logErrorMarkingRollback((Exception)exception2);
                    }
                }
                return;
            }
            try {
                EnterpriseBean enterpriseBean = invocationWrapper.getBean();
                WLEnterpriseBean wLEnterpriseBean = null;
                if (!this.isMessageDrivenBean) {
                    wLEnterpriseBean = (WLEnterpriseBean)enterpriseBean;
                }
                int n = 0;
                if (wLEnterpriseBean != null) {
                    n = wLEnterpriseBean.__WL_getMethodState();
                }
                Throwable throwable = null;
                try {
                    try {
                        if (wLEnterpriseBean != null) {
                            wLEnterpriseBean.__WL_setMethodState(65536);
                        }
                        ((TimedObject)enterpriseBean).ejbTimeout((Timer)new TimerWrapper(clusteredTimerImpl));
                    }
                    catch (Throwable throwable2) {
                        Throwable throwable3;
                        if (throwable2 instanceof InvocationTargetException) {
                            throwable3 = throwable2.getCause();
                        }
                        throwable = throwable3;
                        Object var9_12 = null;
                        if (wLEnterpriseBean != null) {
                            wLEnterpriseBean.__WL_setMethodState(n);
                        }
                    }
                    Object var9_11 = null;
                    if (wLEnterpriseBean != null) {
                        wLEnterpriseBean.__WL_setMethodState(n);
                    }
                }
                catch (Throwable throwable4) {
                    Object var9_13 = null;
                    if (wLEnterpriseBean != null) {
                        wLEnterpriseBean.__WL_setMethodState(n);
                    }
                    throw throwable4;
                }
                this.postInvoke(invocationWrapper, throwable);
            }
            catch (Throwable throwable) {
                EJBLogger.logExceptionInvokingEJBTimeout((String)this.beanInfo.getDisplayName(), (Throwable)throwable);
            }
        }
    }
}

