/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.timer;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import javax.ejb.EJBException;
import javax.ejb.EnterpriseBean;
import javax.ejb.NoSuchEntityException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.TimedObject;
import javax.ejb.Timer;
import javax.ejb.TimerHandle;
import javax.transaction.xa.Xid;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.ejb.WLTimer;
import weblogic.ejb.WLTimerInfo;
import weblogic.ejb.container.EJBDebugService;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.interfaces.BeanInfo;
import weblogic.ejb.container.interfaces.BeanManager;
import weblogic.ejb.container.interfaces.DeploymentInfo;
import weblogic.ejb.container.interfaces.EntityBeanInfo;
import weblogic.ejb.container.interfaces.MessageDrivenBeanInfo;
import weblogic.ejb.container.interfaces.TimerIntf;
import weblogic.ejb.container.interfaces.WLEnterpriseBean;
import weblogic.ejb.container.internal.AllowedMethodsHelper;
import weblogic.ejb.container.internal.EJBContextHandler;
import weblogic.ejb.container.internal.InvocationWrapper;
import weblogic.ejb.container.internal.MethodDescriptor;
import weblogic.ejb.container.internal.RuntimeHelper;
import weblogic.ejb.container.internal.TimerDrivenLocalObject;
import weblogic.ejb.container.manager.BaseEntityManager;
import weblogic.ejb.container.monitoring.EJBTimerRuntimeMBeanImpl;
import weblogic.ejb.container.persistence.spi.CMPBean;
import weblogic.ejb.container.timer.EJBTimerManager;
import weblogic.ejb.container.timer.TimerData;
import weblogic.ejb20.timer.TimerHandleImpl;
import weblogic.logging.Loggable;
import weblogic.store.PersistentHandle;
import weblogic.store.PersistentStoreException;
import weblogic.store.gxa.GXAException;
import weblogic.timers.NakedTimerListener;
import weblogic.transaction.Transaction;
import weblogic.transaction.TxHelper;

public final class TimerImpl
extends TimerDrivenLocalObject
implements Timer,
NakedTimerListener,
WLTimer,
TimerIntf {
    private static final DebugLogger debugLogger = EJBDebugService.timerLogger;
    public static final int READY_STATE = 1;
    public static final int EJB_TIMEOUT_STATE = 2;
    public static final int CANCEL_PENDING_STATE = 3;
    public static final int CREATE_PENDING_STATE = 4;
    public static final int TIMEOUT_PENDING_STATE = 5;
    public static final int TIMEOUT_CANCEL_STATE = 6;
    public static final int DOES_NOT_EXIST_STATE = 7;
    private EJBTimerManager timerManager;
    private BeanManager beanManager;
    private EJBTimerRuntimeMBeanImpl timerRtMBean;
    private weblogic.timers.Timer timer;
    private PersistentHandle handle;
    private boolean isTransactional;
    private int txTimeout;
    private int retryAttempt = 0;
    private Date retryExpiration;
    private int state;
    private boolean isMessageDrivenBean = false;
    private boolean isEntityBean = false;
    private boolean isCMPBean = false;
    private boolean entityRemovedFromTimeout = false;
    private Xid pendingTx;
    private TimerData data;
    private String lastThrowableText = null;
    private boolean consecutiveThrowable = false;

    public TimerImpl(EJBTimerManager eJBTimerManager, BeanManager beanManager, boolean bl, TimerData timerData) {
        this.initialize(eJBTimerManager, beanManager, bl, timerData);
    }

    public TimerImpl(EJBTimerManager eJBTimerManager, BeanManager beanManager, Object object, Serializable serializable, boolean bl, Date date, long l, Long l2, WLTimerInfo wLTimerInfo) {
        TimerData timerData = new TimerData();
        timerData.setPk(object);
        timerData.setInfo(serializable);
        timerData.setNextExpiration(date);
        timerData.setIntervalDuration(l);
        timerData.setTimerId(l2);
        if (wLTimerInfo != null) {
            timerData.setMaxRetryAttempts(wLTimerInfo.getMaxRetryAttempts());
            timerData.setRetryDelay(wLTimerInfo.getRetryDelay());
            timerData.setFailureAction(wLTimerInfo.getTimeoutFailureAction());
            timerData.setMaxTimeouts(wLTimerInfo.getMaxTimeouts());
        }
        this.initialize(eJBTimerManager, beanManager, bl, timerData);
    }

    public void initialize(EJBTimerManager eJBTimerManager, BeanManager beanManager, boolean bl, TimerData timerData) {
        BeanInfo beanInfo = beanManager.getBeanInfo();
        super.setBeanManager(beanManager);
        super.setBeanInfo(beanInfo);
        this.timerManager = eJBTimerManager;
        this.beanManager = beanManager;
        this.isTransactional = bl;
        this.timerRtMBean = eJBTimerManager.getTimerRuntimeMBean();
        this.txTimeout = beanInfo.getTransactionTimeoutMS();
        if (beanInfo instanceof EntityBeanInfo) {
            this.isEntityBean = true;
            if (!((EntityBeanInfo)beanInfo).getIsBeanManagedPersistence()) {
                this.isCMPBean = true;
            }
        } else if (beanInfo instanceof MessageDrivenBeanInfo) {
            this.isMessageDrivenBean = true;
        }
        this.data = timerData;
        if (debugLogger.isDebugEnabled()) {
            TimerImpl.debug("Initialized EJB timer: " + this);
        }
    }

    public void setTimer(weblogic.timers.Timer timer) {
        this.timer = timer;
    }

    public weblogic.timers.Timer getTimer() {
        return this.timer;
    }

    public void setPersistentHandle(PersistentHandle persistentHandle) {
        this.handle = persistentHandle;
    }

    public PersistentHandle getPersistentHandle() {
        return this.handle;
    }

    public Object getPK() {
        return this.data.getPk();
    }

    public Long getID() {
        return this.data.getTimerId();
    }

    public Date getNextExpiration() {
        if (this.retryExpiration != null) {
            return this.retryExpiration;
        }
        return this.data.getNextExpiration();
    }

    public boolean isIntervalTimer() {
        return this.data.getIntervalDuration() != -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void timerExpired(weblogic.timers.Timer timer) {
        boolean bl;
        block50: {
            if (debugLogger.isDebugEnabled()) {
                TimerImpl.debug("ejbTimeout for Timer: " + this);
            }
            if (!this.ensureReadyState()) {
                if (debugLogger.isDebugEnabled()) {
                    TimerImpl.debug("Unable to get ready states for Timer: " + this);
                }
                if (this.isCancelled()) {
                    return;
                }
                this.handleTimeoutFailure(null);
                return;
            }
            MethodDescriptor methodDescriptor = this.timerManager.getMethodDescriptor();
            bl = true;
            boolean bl2 = false;
            try {
                InvocationWrapper invocationWrapper;
                try {
                    invocationWrapper = this.preInvoke(this.data.getPk(), methodDescriptor, new EJBContextHandler(methodDescriptor, new Object[]{timer}));
                }
                catch (Throwable throwable) {
                    Exception exception;
                    if (throwable instanceof EJBException && (exception = ((EJBException)throwable).getCausedByException()) instanceof NoSuchEntityException) {
                        this.handleNoSuchEntity(false);
                        return;
                    }
                    if (this.shouldLogThrowable(throwable)) {
                        EJBLogger.logExceptionBeforeInvokingEJBTimeout((String)this.beanInfo.getDisplayName(), (Throwable)throwable);
                    }
                    timer.cancel();
                    this.handleTimeoutFailure(null);
                    return;
                }
                invocationWrapper.skipLoggingException();
                EnterpriseBean enterpriseBean = invocationWrapper.getBean();
                WLEnterpriseBean wLEnterpriseBean = null;
                if (!this.isMessageDrivenBean) {
                    wLEnterpriseBean = (WLEnterpriseBean)enterpriseBean;
                }
                int n = 0;
                if (wLEnterpriseBean != null) {
                    n = wLEnterpriseBean.__WL_getMethodState();
                }
                Throwable throwable = null;
                try {
                    block48: {
                        try {
                            if (wLEnterpriseBean != null) {
                                wLEnterpriseBean.__WL_setMethodState(65536);
                            }
                            this.setState(2);
                            bl2 = this.timerManager.registerTimerExpirationOperation(this);
                            assert (bl2 == this.isTransactional);
                            ((TimedObject)enterpriseBean).ejbTimeout((Timer)this);
                            if (!this.isTransactional) {
                                this.timerRtMBean.incrementTimeoutCount();
                            }
                            this.data.incrementSuccessfulTimeouts();
                            if (this.data.getSuccessfulTimeouts() == this.data.getMaxTimeouts()) {
                                this.cancel();
                            }
                            bl = false;
                            if (this.isCancelled()) break block48;
                            if (this.isIntervalTimer()) {
                                this.data.setNextExpiration(new Date(this.data.getNextExpiration().getTime() + this.data.getIntervalDuration()));
                                this.accountForSkippedIntervals();
                                if (!this.isTransactional) {
                                    this.timerManager.updatePersistentStoreEntry(this);
                                }
                                break block48;
                            }
                            if (this.isTransactional) break block48;
                            this.doCancel();
                            this.timerManager.removePersistentStoreEntry(this);
                        }
                        catch (Throwable throwable2) {
                            Throwable throwable3;
                            if (throwable2 instanceof InvocationTargetException) {
                                throwable3 = throwable2.getCause();
                            }
                            if (debugLogger.isDebugEnabled()) {
                                TimerImpl.debug("ejbTimeout failed due to Exception for Timer: " + this, throwable3);
                            }
                            throwable = throwable3;
                            Object var12_14 = null;
                            if (wLEnterpriseBean != null) {
                                wLEnterpriseBean.__WL_setMethodState(n);
                            }
                            if (!this.isCancelled()) {
                                if (this.isTransactional) {
                                    this.setState(5);
                                } else {
                                    this.setState(1);
                                }
                            }
                        }
                    }
                    Object var12_13 = null;
                    if (wLEnterpriseBean != null) {
                        wLEnterpriseBean.__WL_setMethodState(n);
                    }
                    if (!this.isCancelled()) {
                        if (this.isTransactional) {
                            this.setState(5);
                        } else {
                            this.setState(1);
                        }
                    }
                }
                catch (Throwable throwable4) {
                    Object var12_15 = null;
                    if (wLEnterpriseBean != null) {
                        wLEnterpriseBean.__WL_setMethodState(n);
                    }
                    if (!this.isCancelled()) {
                        if (this.isTransactional) {
                            this.setState(5);
                        } else {
                            this.setState(1);
                        }
                    }
                    throw throwable4;
                }
                if (this.isEntityBean && !this.entityRemovedFromTimeout) {
                    try {
                        if (this.isCMPBean) {
                            ((CMPBean)enterpriseBean).__WL_doCheckExistsOnMethod();
                        } else if (throwable != null) {
                            ((BaseEntityManager)this.beanManager).ensureDBExistence(this.data.getPk());
                        }
                    }
                    catch (NoSuchEntityException noSuchEntityException) {
                        this.handleNoSuchEntity(true);
                        throwable = noSuchEntityException;
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                    }
                }
                this.entityRemovedFromTimeout = false;
                this.postInvoke(invocationWrapper, throwable);
                assert (throwable == null);
            }
            catch (Throwable throwable) {
                if (!this.shouldLogThrowable(throwable)) break block50;
                EJBLogger.logExceptionInvokingEJBTimeout((String)this.beanInfo.getDisplayName(), (Throwable)throwable);
            }
        }
        if (!this.isTransactional && !this.isCancelled()) {
            if (bl) {
                this.handleTimeoutFailure(null);
            } else if (this.isIntervalTimer()) {
                this.handleTimeoutSuccess();
            }
        }
    }

    private void handleNoSuchEntity(boolean bl) {
        this.doCancel();
        if (!this.isTransactional || !bl) {
            try {
                this.timerManager.removePersistentStoreEntry(this);
            }
            catch (PersistentStoreException persistentStoreException) {
                EJBLogger.logErrorRemovingTimer((String)this.beanInfo.getDisplayName(), (Throwable)persistentStoreException);
            }
        }
    }

    public void accountForSkippedIntervals() {
        long l;
        assert (this.isIntervalTimer());
        long l2 = this.data.getNextExpiration().getTime();
        if (l2 < (l = System.currentTimeMillis())) {
            long l3 = (l - l2) / this.data.getIntervalDuration();
            this.data.setNextExpiration(new Date(l2 += l3 * this.data.getIntervalDuration()));
        }
    }

    public synchronized void handleTimeoutSuccess() {
        assert (this.isIntervalTimer());
        if (this.isCancelled()) {
            return;
        }
        this.setState(1);
        this.retryAttempt = 0;
        this.resetErrorLogging();
        if (this.retryExpiration != null) {
            if (this.timer != null) {
                this.timer.cancel();
            }
            this.retryExpiration = null;
            this.timer = null;
        }
        if (this.timer == null) {
            this.timerManager.scheduleTimer(this);
        }
    }

    public synchronized void handleTimeoutFailure(TimerData timerData) {
        if (debugLogger.isDebugEnabled()) {
            TimerImpl.debug("Executing handleTimeoutFailure for Timer: " + this);
        }
        if (!this.exists()) {
            return;
        }
        if (timerData != null) {
            this.data.setNextExpiration(timerData.getNextExpiration());
            this.data.setInfo(timerData.getInfo());
        }
        if (this.isCancelled()) {
            this.timer = null;
        }
        this.setState(1);
        int n = this.data.getMaxRetryAttempts();
        if (this.retryAttempt < n || n == -1) {
            if (this.data.getRetryDelay() > 0L) {
                this.retryExpiration = new Date(System.currentTimeMillis() + this.data.getRetryDelay());
                int n2 = this.retryAttempt + 1;
                EJBLogger.logConfiguredEJBTimeoutDelayApplied((String)this.getDisplayString(), (int)n2, (long)this.data.getRetryDelay());
            } else {
                int n3 = this.retryAttempt + 1;
                if (n3 >= 10) {
                    int n4 = n3 - 10;
                    int n5 = 0;
                    n5 = n4 > 3 ? 60 : 5 * (int)StrictMath.pow(2.0, n4);
                    EJBLogger.logEJBTimeoutDelayAutomaticallyApplied((String)this.getDisplayString(), (int)n3, (int)n5);
                    this.retryExpiration = new Date(System.currentTimeMillis() + (long)(n5 * 1000));
                }
            }
            ++this.retryAttempt;
            this.timerManager.scheduleTimer(this);
        } else {
            this.retryAttempt = 0;
            this.retryExpiration = null;
            switch (this.data.getFailureAction()) {
                case 2: {
                    this.timerManager.disableTimer(this);
                    break;
                }
                case 1: {
                    this.doCancel();
                    try {
                        this.timerManager.removePersistentStoreEntry(this);
                    }
                    catch (PersistentStoreException persistentStoreException) {
                        EJBLogger.logErrorRemovingTimer((String)this.beanInfo.getDisplayName(), (Throwable)persistentStoreException);
                    }
                    break;
                }
                case 3: {
                    this.data.setNextExpiration(new Date(this.data.getNextExpiration().getTime() + this.data.getIntervalDuration()));
                    this.accountForSkippedIntervals();
                    this.handleTimeoutSuccess();
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Unknown action");
                }
            }
        }
    }

    public void remove() {
        if (this.state == 2 || this.state == 6) {
            this.entityRemovedFromTimeout = true;
        }
        if (!this.isCancelled()) {
            this.cancel();
        }
    }

    public synchronized void cancel() {
        if (debugLogger.isDebugEnabled()) {
            TimerImpl.debug("cancel called for Timer: " + this);
        }
        this.checkAllowedInvoke();
        if (this.state == 2 && !this.isIntervalTimer()) {
            Loggable loggable = EJBLogger.logSingleExpirationTimerCannotBeCancelledLoggable();
            throw new IllegalStateException(loggable.getMessage());
        }
        if (this.state == 2 && this.isTransactional) {
            this.setState(6);
        } else {
            try {
                if (this.timerManager.registerTimerCancellationOperation(this)) {
                    if (this.state == 2) {
                        this.setState(6);
                    } else {
                        this.setState(3);
                    }
                } else {
                    this.timerManager.removePersistentStoreEntry(this);
                    this.setState(7);
                    this.timerManager.removeTimerFromMaps(this);
                    this.timerRtMBean.incrementCancelledTimerCount();
                }
            }
            catch (GXAException gXAException) {
                if (debugLogger.isDebugEnabled()) {
                    TimerImpl.debug("Error cancelling timer", gXAException);
                }
                Loggable loggable = EJBLogger.logErrorCacelTimerLoggable();
                EJBException eJBException = new EJBException(loggable.getMessage(), (Exception)((Object)gXAException));
                eJBException.initCause((Throwable)gXAException);
                throw eJBException;
            }
            catch (PersistentStoreException persistentStoreException) {
                if (debugLogger.isDebugEnabled()) {
                    TimerImpl.debug("Error cancelling timer", persistentStoreException);
                }
                Loggable loggable = EJBLogger.logErrorCacelTimerLoggable();
                EJBException eJBException = new EJBException(loggable.getMessage(), (Exception)((Object)persistentStoreException));
                eJBException.initCause((Throwable)persistentStoreException);
                throw eJBException;
            }
        }
        this.timerManager.cancelTimer(this);
    }

    public synchronized TimerHandle getHandle() {
        this.checkAllowedInvoke();
        BeanInfo beanInfo = this.beanManager.getBeanInfo();
        DeploymentInfo deploymentInfo = beanInfo.getDeploymentInfo();
        return new TimerHandleImpl(this, this.data.getTimerId(), deploymentInfo.getModuleURI(), beanInfo.getEJBName());
    }

    public synchronized Serializable getInfo() {
        this.checkAllowedInvoke();
        return this.data.getInfo();
    }

    public synchronized Date getNextTimeout() {
        this.checkAllowedInvoke();
        return this.getNextExpiration();
    }

    public synchronized long getTimeRemaining() {
        this.checkAllowedInvoke();
        return this.getNextExpiration().getTime() - System.currentTimeMillis();
    }

    public int getRetryAttemptCount() {
        return this.retryAttempt;
    }

    public int getMaximumRetryAttempts() {
        return this.data.getMaxRetryAttempts();
    }

    public int getCompletedTimeoutCount() {
        return this.data.getSuccessfulTimeouts();
    }

    public TimerData getTimerData() {
        return this.data;
    }

    public String toString() {
        BeanInfo beanInfo = this.beanManager.getBeanInfo();
        return "[EJB Timer] id: " + this.data.getTimerId() + " pk: " + this.data.getPk() + " info: " + this.data.getInfo() + " timer: " + this.timer + " state: " + this.state + " ejb: " + beanInfo.getDisplayName() + " Thread: " + Thread.currentThread();
    }

    private String getDisplayString() {
        BeanInfo beanInfo = this.beanManager.getBeanInfo();
        return "(timer id: " + this.data.getTimerId() + ", info: " + this.data.getInfo() + ", ejb: " + beanInfo.getDisplayName() + ")";
    }

    private void checkAllowedInvoke() {
        WLEnterpriseBean wLEnterpriseBean = AllowedMethodsHelper.getBean();
        int n = RuntimeHelper.getCurrentState(wLEnterpriseBean);
        if (n == 4) {
            Loggable loggable = EJBLogger.logCannotInvokeTimerObjectsFromEjbCreateLoggable();
            throw new IllegalStateException(loggable.getMessage());
        }
        if (n == 16 && !(this.beanManager instanceof BaseEntityManager)) {
            Loggable loggable = EJBLogger.logIllegalInvokeTimerMethodInEJbRemoveOrPreDestroyLoggable();
            throw new IllegalStateException(loggable.getMessage());
        }
        if (n == 32) {
            Loggable loggable = EJBLogger.logIllegalInvokeTimerMethodInEJbRAvitvateOrPostActivateLoggable();
            throw new IllegalStateException(loggable.getMessage());
        }
        if (n == 64) {
            Loggable loggable = EJBLogger.logIllegalInvokeTimerMethodInEjbPassivateOrPrePassivateLoggable();
            throw new IllegalStateException(loggable.getMessage());
        }
        if (n == 1024) {
            Loggable loggable = EJBLogger.logCannotInvokeTimerObjectsFromAfterCompletionLoggable();
            throw new IllegalStateException(loggable.getMessage());
        }
        if (n == 1) {
            Loggable loggable = EJBLogger.logIllegalInvokeTimerMethodDuringDILoggable();
            throw new IllegalStateException(loggable.getMessage());
        }
        if (!this.ensureReadyState()) {
            if (this.isCancelled()) {
                Loggable loggable = EJBLogger.logIllegalAttemptToUseCancelledTimerLoggable();
                throw new NoSuchObjectLocalException(loggable.getMessage());
            }
            Loggable loggable = EJBLogger.logInvovationTimeoutLoggable();
            throw new EJBException(loggable.getMessage());
        }
    }

    private boolean ensureReadyState() {
        if (this.pendingTx == null) {
            return !this.isCancelled();
        }
        Transaction transaction = TxHelper.getTransaction();
        if (transaction != null && this.pendingTx.equals(transaction.getXID())) {
            return !this.isCancelled();
        }
        long l = System.currentTimeMillis() + (long)this.txTimeout;
        boolean bl = false;
        while (this.pendingTx != null && !bl) {
            try {
                if (debugLogger.isDebugEnabled()) {
                    TimerImpl.debug("****Waiting.  State: " + this.state);
                }
                this.wait(this.txTimeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (debugLogger.isDebugEnabled()) {
                TimerImpl.debug("****Done Waiting.  State: " + this.state);
            }
            bl = System.currentTimeMillis() > l;
        }
        return !this.isCancelled() && this.pendingTx == null;
    }

    public synchronized void finalizeCancel() {
        this.setState(7);
        this.timerManager.removeTimerFromMaps(this);
    }

    public synchronized void undoCancel() {
        if (this.state == 7) {
            return;
        }
        if (this.state == 6) {
            this.setState(2);
            this.timer = null;
        } else {
            assert (this.state == 3);
            this.setState(1);
            this.timerManager.scheduleTimer(this);
        }
    }

    public synchronized void finalizeCreate() {
        if (!this.isCancelled()) {
            this.setState(1);
            this.timerManager.scheduleTimer(this);
        }
    }

    public synchronized void undoCreate() {
        this.setState(7);
        this.timerManager.cancelTimer(this);
        this.timerManager.removeTimerFromMaps(this);
    }

    private void doCancel() {
        this.setState(7);
        this.timerManager.cancelTimer(this);
        this.timerManager.removeTimerFromMaps(this);
    }

    public boolean isCancelled() {
        return this.state == 7 || this.state == 3 || this.state == 6;
    }

    public boolean exists() {
        return this.state != 7;
    }

    public void setState(int n) {
        if (this.state == 4 || this.state == 3 || this.state == 5 || this.state == 6) {
            this.pendingTx = null;
            this.notifyAll();
        }
        this.state = n;
    }

    public int getState() {
        return this.state;
    }

    public void setXid(Xid xid) {
        this.pendingTx = xid;
    }

    private boolean shouldLogThrowable(Throwable throwable) {
        String string;
        Throwable throwable2 = throwable.getCause();
        if (throwable2 != null) {
            throwable = throwable2;
        }
        if ((string = throwable.toString()) == null) {
            string = throwable.getClass().getName();
        }
        if (string.equals(this.lastThrowableText)) {
            if (!this.consecutiveThrowable) {
                EJBLogger.logSuppressingEJBTimeoutErrors((String)this.getDisplayString());
                this.consecutiveThrowable = true;
            }
            return false;
        }
        this.lastThrowableText = string;
        this.consecutiveThrowable = false;
        return true;
    }

    private void resetErrorLogging() {
        this.lastThrowableText = null;
        this.consecutiveThrowable = false;
    }

    private static void debug(String string) {
        debugLogger.debug("[TimerImpl] " + string);
    }

    private static void debug(String string, Throwable throwable) {
        debugLogger.debug("[TimerImpl] " + string, throwable);
    }
}

