/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.timer;

import java.io.Serializable;
import java.util.Date;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.Timer;
import javax.ejb.TimerHandle;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.interfaces.TimerIntf;
import weblogic.ejb.container.interfaces.WLEnterpriseBean;
import weblogic.ejb.container.internal.AllowedMethodsHelper;
import weblogic.logging.Loggable;

public final class TimerWrapper
implements Timer {
    private TimerIntf delegate;

    public TimerWrapper(TimerIntf timerIntf) {
        this.delegate = timerIntf;
    }

    public void cancel() {
        this.checkTimerState();
        this.delegate.cancel();
    }

    public TimerHandle getHandle() {
        this.checkTimerState();
        return this.delegate.getHandle();
    }

    public Serializable getInfo() {
        this.checkTimerState();
        return this.delegate.getInfo();
    }

    public Date getNextTimeout() {
        this.checkTimerState();
        return this.delegate.getNextTimeout();
    }

    public long getTimeRemaining() {
        this.checkTimerState();
        return this.delegate.getTimeRemaining();
    }

    private void checkTimerState() {
        if (!this.delegate.exists()) {
            throw new NoSuchObjectLocalException("Timer has expired or has been cancelled");
        }
        WLEnterpriseBean wLEnterpriseBean = AllowedMethodsHelper.getBean();
        if (wLEnterpriseBean != null) {
            int n = wLEnterpriseBean.__WL_getMethodState();
            if (n == 4) {
                Loggable loggable = EJBLogger.logCannotInvokeTimerObjectsFromEjbCreateLoggable();
                throw new IllegalStateException(loggable.getMessage());
            }
            if (n == 1024) {
                Loggable loggable = EJBLogger.logCannotInvokeTimerObjectsFromAfterCompletionLoggable();
                throw new IllegalStateException(loggable.getMessage());
            }
        }
    }
}

