/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.utils;

import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import weblogic.descriptor.DescriptorBean;
import weblogic.ejb.container.deployer.EJBDescriptorMBeanUtils;
import weblogic.ejb.spi.EjbDescriptorBean;
import weblogic.ejb.spi.EjbJarDescriptor;
import weblogic.j2ee.descriptor.AssemblyDescriptorBean;
import weblogic.j2ee.descriptor.EjbJarBean;
import weblogic.j2ee.descriptor.EnterpriseBeansBean;
import weblogic.utils.jars.VirtualJarFile;

public class AutoRefLibHelper {
    public static void mergeEJBJar(EjbJarDescriptor ejbJarDescriptor, VirtualJarFile[] descriptorBean) throws IOException, XMLStreamException {
        if (descriptorBean != null && ((VirtualJarFile[])descriptorBean).length > 0) {
            for (VirtualJarFile virtualJarFile : descriptorBean) {
                AutoRefLibHelper.validateAutoRefLib(virtualJarFile);
            }
            DescriptorBean descriptorBean2 = ejbJarDescriptor.getEjbDescriptorLoader().loadDescriptorBean();
            ejbJarDescriptor.getEjbDescriptorLoader().mergeDescriptors((VirtualJarFile[])descriptorBean);
            descriptorBean2 = ejbJarDescriptor.getEjbDescriptorLoader().loadDescriptorBean();
        }
    }

    private static void validateAutoRefLib(VirtualJarFile virtualJarFile) throws IOException {
        try {
            EjbDescriptorBean ejbDescriptorBean = EJBDescriptorMBeanUtils.createDescriptorFromJarFile(virtualJarFile, true);
            EjbJarBean ejbJarBean = ejbDescriptorBean.getEjbJarBean();
            EnterpriseBeansBean enterpriseBeansBean = ejbJarBean.getEnterpriseBeans();
            if (enterpriseBeansBean != null) {
                throw new IllegalArgumentException("ejb-jar.xml in auto ref lib shouldn't configure enterprise-beans");
            }
            AssemblyDescriptorBean assemblyDescriptorBean = ejbJarBean.getAssemblyDescriptor();
            if (assemblyDescriptorBean == null) {
                throw new IllegalArgumentException("ejb-jar.xml in auto ref lib should configure assembly-descriptor");
            }
            if (assemblyDescriptorBean.getApplicationExceptions() != null && assemblyDescriptorBean.getApplicationExceptions().length > 0) {
                throw new IllegalArgumentException("ejb-jar.xml in auto ref lib shouldn't configure application-exception");
            }
            if (assemblyDescriptorBean.getMessageDestinations() != null && assemblyDescriptorBean.getMessageDestinations().length > 0) {
                throw new IllegalArgumentException("ejb-jar.xml in auto ref lib shouldn't configure message-destination");
            }
            if (assemblyDescriptorBean.getMethodPermissions() != null && assemblyDescriptorBean.getMethodPermissions().length > 0) {
                throw new IllegalArgumentException("ejb-jar.xml in auto ref lib shouldn't configure method-permission");
            }
            if (assemblyDescriptorBean.getSecurityRoles() != null && assemblyDescriptorBean.getSecurityRoles().length > 0) {
                throw new IllegalArgumentException("ejb-jar.xml in auto ref lib shouldn't configure security-role");
            }
            if (assemblyDescriptorBean.getInterceptorBindings() == null || assemblyDescriptorBean.getInterceptorBindings().length == 0) {
                throw new IllegalArgumentException("ejb-jar.xml in auto ref lib should configure interceptor-binding");
            }
            if (ejbJarBean.getInterceptors() == null) {
                throw new IllegalArgumentException("ejb-jar.xml in auto ref lib should configure interceptors");
            }
            if (ejbJarBean.getInterceptors().getInterceptors() == null || ejbJarBean.getInterceptors().getInterceptors().length == 0) {
                throw new IllegalArgumentException("ejb-jar.xml in auto ref lib should configure interceptor");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            IOException iOException = new IOException("Nested exception is: ");
            iOException.initCause(illegalArgumentException);
            throw iOException;
        }
        catch (Exception exception) {
            IOException iOException = new IOException("Nested exception is: ");
            iOException.initCause(exception);
            throw iOException;
        }
    }
}

